<?php
if ( ! defined("_INCLUDED_GLOBAL")) {
	exit;
}        // [Security]Allow_url_fopen = On

/**
 * 유지보수 서버 자동 인증
 *   - 월~금, 오전 8시 5분이후 1회 실행
 *   - 유지보수 만료일 확인후, 점검툴 및 스팸 자동 업데이트 등 기능 유지
 */

$lockFile = $UPLOAD_ROOT_NEW . '/.agent_maintenance_cert';

// 유지보수 서버 인증 직접 실행 - 파일이 있을때 실행 가능 시간 무시하고 실행
$forceExecuteFile = $UPLOAD_ROOT_NEW . '/.agent_maintenance_cert_force';

$isForceExecute = file_exists($forceExecuteFile);
if ($isForceExecute) {
	$message = '유지보수 서버 인증 직접 실행 요청으로 실행됩니다.';
	errorlog('[maintenance_cert] ' . $message, 'DEBUG');
	if ($is_debug) {
		nmail_cli_title($message, false, '');
	}
	unlink($forceExecuteFile);
}

$day = date('N');
if (($day >= 1 && $day <= 5) || $isForceExecute || $is_debug) {       // 월~금(평일)
	$currentTime = date('H:i:s');

	// 오전 8시 5분 ~ 30분 사이 실행되도록 분산
	$hour        = 8;
	$minute      = mt_rand(5, 30);
	$second      = mt_rand(0, 59);
	$executeTime = sprintf('%02d:%02d:%02d', $hour, $minute, $second);
//	vd($currentTime); vd($executeTime); vd($currentTime >= $executeTime);

	if ($currentTime >= $executeTime || $isForceExecute || $is_debug) {
		$mtime = null;
		if (file_exists($lockFile)) {
			clearstatcache();
			$mtime = filemtime($lockFile);
		}

		$today    = date('Y-m-d');
		$fileDate = date('Y-m-d', $mtime);

//		if ($mtime === null || $fileDate !== $today || $is_debug) {
		if ($mtime === null || $fileDate !== $today || $isForceExecute) {
			$message = '유지보수 서버 자동 인증 시작';
			errorlog('[maintenance_cert] ' . $message, 'DEBUG');
			if ($is_debug) {
				nmail_cli_title($message, false, '');
			}
			$certData = get_maintenance_cert_data();
			if ($certData === false || $certData->cert_type === 'AUTO' || $isForceExecute) {
				// 유지보수 서버 자동 인증 API 호출
				$result = agent_maintenance_cert_api();

				if ($result) {
					$message = '유지보수 서버 자동 인증 성공';
				} else {
					$message = '유지보수 서버 자동 인증 실패';
				}
				errorlog('[maintenance_cert] ' . $message, 'DEBUG');
				if ($is_debug) {
					nmail_cli_title($message, false, '');
				}
			}

			// 중복 실행 방지를 위해 실행 시간 기록
			touch($lockFile);
			chmod($lockFile, 0777);
		}
	}
}
