#!/usr/bin/php
<?
chdir(dirname(__FILE__));
require_once('../../nmail/include/global.php');
require_once('../../nmail/include/mail_send_lib.php');
require_once('../../nmail/include/file.php');

// 웹상에서의 실행방지.
if ($_SERVER['DOCUMENT_ROOT'] || $_SERVER['SERVER_SOFTWARE'])
{
	die("Access Denied");
}	// if()

// 중복실행방지
    if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
    {
        $pid = 'NmailAgentChild.pid';
    } else
    {
	    $pid = '/var/run/NmailAgentChild.pid';
    }	// if()

    // 파일이 있을 경우 먼저 실행중인 스크립트가 존재하는지 확인함.
    $pname = basename(__FILE__);
    if (file_exists($pid))
    {
        list($pid_old) = file($pid);
        if (is_numeric($pid_old))
        {
	        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
	        {
		        $cmd = "powershell \"Get-WmiObject Win32_Process -Filter 'ProcessId = ".$pid_old."' | Select-Object CommandLine -ExpandProperty 'CommandLine' | Format-Table -Wrap\"";
	        } else
	        {
		        $cmd = 'ps -fp '.$pid_old;
	        }	// if()

            ob_start();
            system($cmd);
            $ps = ob_get_contents();
            ob_end_clean();

            if (strpos($ps, $pname) !== false)
            {
                echo "\n[경고]엔메일 에이젠트(Child)가 이미 실행중입니다.\n\n";
                echo $ps;
                echo "\n";
                exit;
            }	// if()
        }	// if()
    }	// if()

    // pid
    $fh=fopen($pid,"w");
    fwrite($fh,getmypid());
    fclose($fh);


################################################################################

$check_sleep_time = 5;		// 확인간격.  기본 5초

################################################################################

set_time_limit(0);
ini_set('memory_limit', '512M');

#echo "Start NmailAgent\n";

$is_debug = false;
if (strtoupper($_SERVER['argv'][1]) == 'DEBUG')
{
	echo "[".date('Y-m-d H:i:s')."] NmailAgent Start! (Debug Mode)\n";
	//echo "...Debug Mode...\n";
	$is_debug = true;
}	// if()

$_last_exec_time = 0;
$_last_exec_time_10 = 0;

while(1)
{
	// 실행시간
		$time = time();

	// 10초 간격으로 실행
	if ($_last_exec_time_10 <= ($time-9))
	{
		################################################################################

		// [2012-09-27] 예약발송
		if ($G_SYS['MAIL_SEND_RESERVE_ISUSE']) {
			include('NmailAgentChild_mailreserve.inc.php');
		}

		// [2025-12-19] 서버 설정 변경이 바로 반영되도록 개선
		if (file_exists($UPLOAD_ROOT."/config/nmail_server.php")) {
			include($UPLOAD_ROOT . "/config/nmail_server.php");
		}

		// [2025-12-09] 유지보수 서버 자동 인증
		if (file_exists('NmailAgentChild_maintenance_cert.inc.php') && ! $G_SYS['NM_MAINTERNANCE_CERT_SKIP']) {
			include('NmailAgentChild_maintenance_cert.inc.php');
		}

		// [2025-12-03] 엔메일 점검툴 실행
		if (file_exists('NmailAgentChild_monitor.inc.php')) {
			include('NmailAgentChild_monitor.inc.php');
		}

		// [2025-12-10] 프리미엄 안티스팸 자동 업데이트
		if (file_exists('NmailAgentChild_spam_update.inc.php') && $G_SYS['S_SPAM_UPDATE_AUTO']) {
			include('NmailAgentChild_spam_update.inc.php');
		}

		################################################################################

		$_last_exec_time_10 = $time;
	}

	// 60초 간격(1분)으로 실행
	if ($_last_exec_time <= ($time-59))
	{
		if ($is_debug)
			echo "\n[".date('Y-m-d H:i:s')."]\n";

		################################################################################

		// 대기중/재발송중인 메일 스풀 파일수 기록.  [메일서버관리 - 메일 발송 상태]에서 표시
		if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
			include('NmailAgentChild_spool_count.win.inc.php');
		} else {
			// [2013-09-06] 발송수 제한 모듈에서 현재 발송대기중인 메일수 보여주기
			#if ($G_SYS['NM_SMTP_SEND_LIMIT'])
			include('NmailAgentChild_spool_count.inc.php');
		}

		################################################################################

		$_last_exec_time = $time;
	}	// if()


	// [2010-09-17]상태 확인
	touch(dirname(__FILE__).'/.nmailagent_daemon');

	// 종료 명령 확인
	$_child_shutdown = dirname(__FILE__).'/.child_shutdown';
	if (file_exists($_child_shutdown))
	{
		if ($is_debug)
			echo "[".date('Y-m-d H:i:s')."] NmailAgent Stop!\n";
		unlink($_child_shutdown);
		exit;
	}	// if()

	// [2022-10-31] Windows 작업 스케쥴러로 등록
	if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
	{
		unlink($pid);
		exit;
	}

	// 일정간격 자동반복(sec)
	sleep($check_sleep_time);

}	// while

?>