<?
require_once('include/global.php');
require_once('include/admin_lib.php');
require_once("include/webhard_lib.php");
require_once('sadmin_conf.inc.php');

mail_server_check_limit();		// 메일서버가 동작중인지 확인

// set
	$CFG['TITLE'] = '<b>메일서버관리</b> >> <b>서버 설정</b>';


// get
	$row = array();
	$row['s_id_min_length'] = $G_MB[ID_MIN_LENGTH];
	$row['s_mbr_id_deny'] = @implode(', ', $G_SYS[MBR_ID_DENY]);
	$row['s_forward_domain_deny'] = @implode(', ', $G_SYS[FORWARD_DOMAIN_DENY]);
	$row['s_mail_upload_quota'] = ceil($G_SYS[UPLOAD_MAIL_MAX_SIZE]/1024/1024);
	$row['s_mail_bigfile_quota'] = ceil($G_SYS[UPLOAD_MAIL_BIGFILE_MAX_SIZE]/1024/1024);
	$row['s_mail_bigfile_count'] = $G_SYS[UPLOAD_MAIL_BIGFILE_COUNT];
	$row['s_mail_bigfile_day'] = $G_SYS[UPLOAD_MAIL_BIGFILE_DAY];
	$row['s_webhard_quota'] = ceil($G_SYS[UPLOAD_WEBHARD_MAX_SIZE]/1024/1024);
	$row['s_mail_box_restore_quota'] = ceil($G_SYS[UPLOAD_MAIL_BOX_RESTORE_MAX_SIZE]/1024/1024);
	$row['s_board_upload_quota'] = ceil($UPLOAD_MAX_SIZE/1024/1024);
	$row['s_webhard_use'] = $G_SYS[WEBHARD_USE];
	$row['s_virus_scan'] = $G_SYS[VIRUS_SCAN];
	$row['s_virus_return'] = $G_SYS[VIRUS_RETURN];
	$row['s_spam_rbl'] = @implode(', ', $G_SYS[S_SPAM_RBL]);
	$row['s_dns_direct'] = @implode(', ', $G_SYS[S_DNS_DIRECT]);

	$cfgs = nm_cfgfileget('server.tab');
	$row['s_default_domain'] = nm_cfg_val_get($cfgs, 'RootDomain');
	// [2007-03-09] HELO 도메인 입력
	$row['s_helo_domain'] = nm_cfg_val_get($cfgs, 'HeloDomain');
	$row['s_postmaster'] = nm_cfg_val_get($cfgs, 'PostMaster');
	$row['s_mail_quota'] = ceil(nm_cfg_val_get($cfgs, 'MaxMessageSize')/1024);
    // [2024-09-09] 스팸 차단 RBL
    $row['s_deny_rbl'] = nm_cfg_val_get($cfgs, 'CustMapsList');

	// [2025-11-14] SMTP 보안연결(SSL)
	$row['s_smtp_tls_enable'] = nm_cfg_val_get($cfgs, 'EnableSMTP-TLS');
	// [2025-11-14] POP3 보안연결(SSL)
	$row['s_pop3_tls_enable'] = nm_cfg_val_get($cfgs, 'EnablePOP3-TLS');
	// [2025-11-14] 외부 발송시 SMTP 보안연결(SSL)
	$row['s_smtp_gw_config'] = nm_cfg_val_get($cfgs, 'SmtpGwConfig');
	if ($row['s_smtp_gw_config']) {
		$row['s_smtp_gw_config'] = 1;
	} else {
		$row['s_smtp_gw_config'] = 0;
	}
	// [2025-11-14] SMTP 평문 인증 비활성화
	$row['s_smtp_no_tls_auths'] = (int)(nm_cfg_val_get($cfgs, 'SmtpNoTLSAuths') === '');     // 빈 문자열이면 평문 인증 비활성화, 값이 없으면(false) 평문 인증 허용
	// [2025-12-20] SMTP POP3 before 인증 차단
	$row['s_enable_auth_smtp_pop3'] = nm_cfg_val_get($cfgs, 'EnableAuthSMTP-POP3');
	//   설정이 없거나 1이면 허용 상태
	$row['s_enable_auth_smtp_pop3'] = (int)($row['s_enable_auth_smtp_pop3'] === false || $row['s_enable_auth_smtp_pop3'] === '1');
	// [2025-11-14] 외부 발송시 SMTP Gateway(스팸 서버 등)
	$row['s_default_smtp_gateways'] = nm_cfg_val_get($cfgs, 'DefaultSMTPGateways');
	// [2025-11-14] 외부 발송시 SMTP Multi IP
	$row['s_smtp_out_bind'] = nm_cfg_val_get($cfgs, 'SmtpOutBind');

	// [2025-09-10] 서명 이미지 계정당 할당량
	$row['s_sign_upload_quota'] = ceil($G_SYS[UPLOAD_MAIL_SIGN_MAX_SIZE]/1024/1024);
	// [2025-09-10] 서명 이미지 최대용량
	$row['s_sign_file_upload_quota'] = ceil($G_SYS[UPLOAD_MAIL_SIGN_FILE_MAX_SIZE]/1024);
	// [2025-10-27] 개인별로 보내기 자동 적용
	$row['s_personal_auto_apply_count'] = $G_SYS[PERSONAL_AUTO_APPLY_COUNT];
	// [2025-11-11] 예약발송 사용여부
	$row['s_mail_send_reserve_isuse'] = $G_SYS[MAIL_SEND_RESERVE_ISUSE];
	// [2025-11-11] 예약발송 가능수
	$row['s_mail_send_reserve_limit_send'] = $G_SYS[MAIL_SEND_RESERVE_LIMIT_SEND];
	// [2025-11-11] 예약발송 가능일수
	$row['s_mail_send_reserve_limit_day'] = $G_SYS[MAIL_SEND_RESERVE_LIMIT_DAY];

	// [2025-11-20] 웹메일 로그인 유지 시간
	$row['s_gc_maxlifetime'] = $G_SYS['SESSION_GC_MAXLIFETIME'] / 60 / 60;
	$row['s_gc_maxlifetime_mobile'] = $G_SYS['SESSION_GC_MAXLIFETIME_MOBILE'] / 60 / 60;

	// [2025-12-01] 대표 계정 사용 여부
	$row['s_nm_team_mail'] = $G_SYS['NM_TEAM_MAIL'];

	// [2025-12-02] 스팸메일 신고하기 사용여부
	$row['s_is_spam_report'] = $G_SYS['IS_SPAM_REPORT'];

	// [2026-01-05] 스팸메일 오탐지 신고하기 사용여부
	$row['s_is_not_spam_report'] = $G_SYS['IS_NOT_SPAM_REPORT'];

	// [2025-12-10] 프리미엄 안티스팸 자동 업데이트
	$row['s_spam_update_auto'] = $G_SYS['S_SPAM_UPDATE_AUTO'];

// data
	$view = array();
	// 도메인
	$q = "SELECT d_name FROM ".$TB['DOMAIN']." ORDER BY d_name";
	$dms = db_get_rows($q, true);
	$view['s_default_domain']= select_list_value($row['s_default_domain'], $dms['d_name'], $dms['d_name'], NULL, 0, 1);

	$view['s_helo_domain']= input_value($row['s_helo_domain'], 1);
	$view['s_postmaster']= input_value($row['s_postmaster'], 1);
	$view['s_id_min_length']= input_value($row['s_id_min_length'], 1);
	$view['s_mbr_id_deny']= htmlspecialchars_fix($row['s_mbr_id_deny']);
	$view['s_forward_domain_deny']= htmlspecialchars_fix($row['s_forward_domain_deny']);
	$view['s_mail_quota']= input_value($row['s_mail_quota'], 1);
	$view['s_spam_rbl']= htmlspecialchars_fix($row['s_spam_rbl']);
	$view['s_dns_direct']= htmlspecialchars_fix($row['s_dns_direct']);
	$view['s_mail_upload_quota']= input_value($row['s_mail_upload_quota'], 1);
	$view['s_mail_bigfile_quota']= input_value($row['s_mail_bigfile_quota'], 1);
	$view['s_mail_bigfile_count']= input_value($row['s_mail_bigfile_count'], 1);
	$view['s_mail_bigfile_day']= input_value($row['s_mail_bigfile_day'], 1);
	$view['s_webhard_quota']= input_value($row['s_webhard_quota'], 1);
	$view['s_mail_box_restore_quota']= input_value($row['s_mail_box_restore_quota'], 1);
	$view['s_board_upload_quota']= input_value($row['s_board_upload_quota'], 1);
	// [2025-11-14] SMTP 보안연결(SSL)
	$view['s_smtp_tls_enable'] = radio_value('s_smtp_tls_enable', $row['s_smtp_tls_enable'], array('사용함', '사용안함'), array(1,0), NULL, 0, 1);
	// [2025-11-14] POP3 보안연결(SSL)
	$view['s_pop3_tls_enable'] = radio_value('s_pop3_tls_enable', $row['s_pop3_tls_enable'], array('사용함', '사용안함'), array(1,0), NULL, 0, 1);
	// [2025-11-14] 외부 발송시 SMTP 보안연결(SSL)
	$view['s_smtp_gw_config'] = radio_value('s_smtp_gw_config', $row['s_smtp_gw_config'], array('사용함', '사용안함'), array(1,0), NULL, 0, 1);
	// [2025-11-14] SMTP 평문 인증 비활성화
	$view['s_smtp_no_tls_auths'] = radio_value('s_smtp_no_tls_auths', $row['s_smtp_no_tls_auths'], array('차단(보안 강화)', '허용'), array(1,0), NULL, 0, 1);
	$view['s_enable_auth_smtp_pop3'] = radio_value('s_enable_auth_smtp_pop3', $row['s_enable_auth_smtp_pop3'], array('차단(보안 강화)', '허용'), array(0,1), NULL, 0, 1);
	// [2025-11-14] 외부 발송시 SMTP Gateway(스팸 서버 등)
	$view['s_default_smtp_gateways'] = htmlspecialchars_fix($row['s_default_smtp_gateways']);
	// [2025-11-14] 외부 발송시 SMTP Multi IP
	$view['s_smtp_out_bind'] = htmlspecialchars_fix($row['s_smtp_out_bind']);

	if ($row['s_webhard_use'] === NULL)
		$row['s_webhard_use'] = 0;
	$view['s_webhard_use']= select_list_value($row['s_webhard_use'], array_values($G['ISUSE']), array(1, 0), NULL, 0, 1);

	if ($G_SYS['MAIL_BOX_BACKUP_USE'] === NULL)
		$G_SYS['MAIL_BOX_BACKUP_USE'] = 0;
	$view['s_mail_box_backup_use']= select_list_value($G_SYS['MAIL_BOX_BACKUP_USE'], array_values($G['ISUSE']), array(1, 0), NULL, 0, 1);

	$webhard_demo_limit_f = webhard_demo_check('F');
	$webhard_demo_limit_s = webhard_demo_check('S');


	if ($row['s_virus_scan'] === false)
		$row['s_virus_scan'] = 0;
	$view['s_virus_scan']= select_list_value($row['s_virus_scan'], array_values($G['ISUSE']), array(1, 0), NULL, 0, 1);

	if ($row['s_virus_return'] === false)
		$row['s_virus_return'] = 0;
	$view['s_virus_return']= select_list_value($row['s_virus_return'], array('리턴메일 발송안함', '리턴메일 발송'), array(0, 1), NULL, 0, 1);

	// [2007-03-09] HELO 도메인 입력
	$view['s_helo_domain_sample'] = (preg_match('/[a-z]+/i', $row['s_default_domain'])) ? 'mail.'.$row['s_default_domain'] : 'mail.YourDomain.com';


	// [2009-03-23] 내부주소 위조 스팸 차단
	$view['s_spam_from_fake']= select_list_value($G_SYS['S_SPAM_FROM_FAKE'], array('검사 생략', '[스팸편지함]으로 배달(권장)', '메일을 받지 않고 바로 삭제'), array('SKIP', 'SPAM', 'DEL'), NULL, 0, 1);


// [2008-02-26]용량이 php.ini 설정과 맞지 않을 때 경고창을 띄우도록 함.
	$post_max_size = strtoupper(ini_get('post_max_size'));
	$post_max_size_unit = substr($post_max_size, strlen($post_max_size)-1);
	$post_max_size_int = substr($post_max_size, 0, strlen($post_max_size)-1);

	$upload_max_filesize = strtoupper(ini_get('upload_max_filesize'));
	$upload_max_filesize_unit = substr($upload_max_filesize, strlen($upload_max_filesize)-1);
	$upload_max_filesize_int = substr($upload_max_filesize, 0, strlen($upload_max_filesize)-1);

// [2024-09-03] 발송수 제한 레벨은 일반회원 이상만 되어야 함.
    $level = $G[LEVEL_NAME];
    foreach ($level as $key => $value) {
        if ($key < $G['LEVEL']['user']) {
            unset($level[$key]);
        }
    }

// [2024-09-09] 스팸 차단 RBL
    $view['s_deny_rbl'] = $G_SYS['S_DENY_RBL'];

// [2024-09-10] POP3 이용안내
    if (isset($G_SYS['S_HELP_SMTP']) && $G_SYS['S_HELP_SMTP'] !== null) {
        $view['s_help_smtp'] = $G_SYS['S_HELP_SMTP'];
    }

    if (isset($G_SYS['S_HELP_POP3']) && $G_SYS['S_HELP_POP3'] !== null) {
        $view['s_help_pop3'] = $G_SYS['S_HELP_POP3'];
    }

	// [2025-11-14] 보안연결 사용여부(SMTP)
	if (isset($G_SYS['S_VIEW_HELP_SMTP_TLS'])) {
		$row['s_view_help_smtp_tls'] = $G_SYS['S_VIEW_HELP_SMTP_TLS'];
	} else {
		$row['s_view_help_smtp_tls'] = $row['s_smtp_tls_enable'];
	}
	$view['s_view_help_smtp_tls'] = radio_value('s_view_help_smtp_tls', $row['s_view_help_smtp_tls'], array('SMTP 포트 : 465, 보안연결(SSL) 필요', 'SMTP 포트 : 587, 보안연결(SSL) 없음'), array(1,0), NULL, 0, 1);

	// [2025-11-14] 보안연결 사용여부(POP3)
	if (isset($G_SYS['S_VIEW_HELP_POP3_TLS'])) {
		$row['s_view_help_pop3_tls'] = $G_SYS['S_VIEW_HELP_POP3_TLS'];
	} else {
		$row['s_view_help_pop3_tls'] = $row['s_pop3_tls_enable'];
	}
	$view['s_view_help_pop3_tls'] = radio_value('s_view_help_pop3_tls', $row['s_view_help_pop3_tls'], array('POP3 포트 : 995, 보안연결(SSL) 필요', 'POP3 포트 : 110, 보안연결(SSL) 없음'), array(1,0), NULL, 0, 1);


// [2025-09-10] 서명 이미지 계정당 할당량
		$view['s_sign_upload_quota']= input_value($row['s_sign_upload_quota'], 1);

	// [2025-09-10] 서명 이미지 최대용량
		$view['s_sign_file_upload_quota']= input_value($row['s_sign_file_upload_quota'], 1);

	// [2025-10-27] 개인별로 보내기 자동 적용 인원수
		$view['s_personal_auto_apply_count'] = input_value($row['s_personal_auto_apply_count'], 1);

	// [2025-11-11] 예약발송 사용여부
		if ($row['s_mail_send_reserve_isuse'] === false)
			$row['s_mail_send_reserve_isuse'] = 0;

		$view['s_mail_send_reserve_isuse'] = select_list_value($row['s_mail_send_reserve_isuse'], array_values($G['ISUSE']), array(1, 0), NULL, 0, 1);

	// [2025-11-11] 예약발송 가능수
		$view['s_mail_send_reserve_limit_send'] = input_value($row['s_mail_send_reserve_limit_send'], 1);
	// [2025-11-11] 예약발송 가능일수
		$view['s_mail_send_reserve_limit_day'] = input_value($row['s_mail_send_reserve_limit_day'], 1);

	// [2025-11-20] 웹메일 로그인 유지 시간
	$view['s_gc_maxlifetime'] = input_value($row['s_gc_maxlifetime'], 1);
	$view['s_gc_maxlifetime_mobile'] = input_value($row['s_gc_maxlifetime_mobile'], 1);

	// [2025-12-01] 대표 계정 사용 여부
	$view['s_nm_team_mail'] = radio_value('s_nm_team_mail', $row['s_nm_team_mail'], array('사용함', '사용안함'), array(1,0), NULL, 0, 1);

	// [2025-12-02] 스팸메일 신고하기 사용여부
	$view['s_is_spam_report'] = radio_value('s_is_spam_report', $row['s_is_spam_report'], array('사용함', '사용안함'), array(1,0), NULL, 0, 1);

	// [2026-01-05] 스팸메일 오탐지 신고하기 사용여부
	$view['s_is_not_spam_report'] = radio_value('s_is_not_spam_report', $row['s_is_not_spam_report'], array('사용함', '사용안함'), array(1,0), NULL, 0, 1);

	// [2025-12-10] 프리미엄 안티스팸 자동 업데이트
	$view['s_spam_update_auto'] = radio_value('s_spam_update_auto', $row['s_spam_update_auto'], array('사용함', '사용안함'), array(1,0), NULL, 0, 1);

	// [2025-12-10] 프리미엄 안티스팸 버전 선택

// [2025-12-10] 프리미엄 안티스팸 버전
	$CFG['s_spam_update_version_select'] = array(
		'AUTO'    => '자동 선택 (업데이트후 최신 버전 선택)',
		'DEFAULT' => '기본 버전 (업데이트후 장애시, 배포 초기 버전으로 롤백용)',
	);
	$nmailSpamUpdate = new NmailSpamUpdate;
	foreach ($nmailSpamUpdate->getUpdateFileList() as $updateFile) {
		$CFG['s_spam_update_version_select'][$updateFile] = $updateFile;
	}
	$view['s_spam_update_version_select'] = select_list_value($G_SYS['S_SPAM_UPDATE_VERSION_SELECT']
		, array_values($CFG['s_spam_update_version_select']), array_keys($CFG['s_spam_update_version_select'])
		, NULL, 0, 1);

	// [2025-12-22] 아이디 / 비밀번호 찾기 제한
	$view['s_search_lost_limit_level'] = select_list_value($G_SYS['SEARCH_LOST_LIMIT_LEVEL'], array('제한없음', '관리자 이상 제한', '서버관리자 이상 제한'), array('ALL', 'ADMIN', 'SADMIN'), NULL, 0, 1);

// skin view
	$CFG['ACTION'] = 'sserver_config_ok.php';
	nskinset('sadmin', 'sserver_config.html');
	include($NSKIN['view_layout']);


require_once('include/global_end.php');
?>