<?
require_once('include/global.php');
require_once("include/sdomain_lib.php");
require_once("include/board_lib.php");
require_once('include/pager.php');
require_once('sadmin_conf.inc.php');
require_once('include/webhard_lib.php');


// set
	$CFG['TITLE'] = '<b>메일서버관리</b> >> <b>도메인관리</b>';


// data

	// search
		$q_where = '';
		if ($_GET['s_word'])
		{
			set_q_search($_GET['s_word']);
			$q_where = " AND ( d.d_name LIKE '%" . $_GET['s_word'] . "%' OR d.d_memo LIKE '%" . $_GET['s_word'] . "%' ) ";
			$v_s_word = htmlspecialchars_fix(stripslashes($_GET['s_word']));
		}	// if()

	// sort
		$CFG['SDOMAIN_LIST_FIELD'] = array(
				'd.d_no' => '번호',
				'd.d_name' => '도메인',
				'd.d_site_owner' => '회사/단체명',
				'd.d_is_use' => '사용여부',
				'd.d_quota_mbr_default' => '기본 메일용량',
				'd.d_quota' => '메일용량 할당량',
				'd.d_bigfile_quota' => '대용량첨부 할당량',
				'd.d_webhard_quota' => '웹하드 할당량',
				'd.d_quota_mbr_count' => '메일계정 할당수',
				'd.d_quota_board' => '게시판 첨부 할당량',
				'd.d_saveday' => '보관기간',
				'd.d_regdate' => '등록일자',
				'd.d_modifydate' => '수정일자',
				);
		$order_set = get_order(array_keys($CFG['SDOMAIN_LIST_FIELD']), 'd.d_no', $_GET['s_key'], $_GET['s_key2']);
		$order_img = get_order_img(array_keys($CFG['SDOMAIN_LIST_FIELD']), $_GET['s_key'], $_GET['s_key2'], false, 'common_skin');		// array

	// db - pager
		$DEBUG['db_cnt']['start'] = getmicrotime();
		$pager_params['totalItems'] = db_get_one("
			SELECT 
				COUNT(*) 
			FROM 
				" . $TB['DOMAIN'] . " d
			WHERE 
				1=1
				" . $q_where
			);

		if ($_GET['excel_down'])
		{
			set_time_limit(3600);
			ini_set('memory_limit', '2047M');
			$pager_params['perPage'] = 999999;
		} else {
			$pager_params['perPage'] = 20;
		}

		$DEBUG['db_cnt']['exec'] += getmicrotime() - $DEBUG['db_cnt']['start'];

		// [2016-01-11] PHP 5버전대에서 Ampersand가 DEPRECATED처리되어 &삭제
		#$pager = &new Pager_Sliding($pager_params);
		// [2016-01-11] Ampersand가 DEPRECATED관련하여 PEAR Pager라이브러리 업그레이드 소스적용
		#$pager = new Pager_Sliding($pager_params);
		$pager = Pager::factory($pager_params);
		$pager_links = $pager->getLinks();
		$pager_limit = get_pager_limit($pager->getCurrentPageID(), $pager_params['perPage']);

	// db - select
		$DEBUG['db_select']['start'] = getmicrotime();
		$sql = "
			SELECT
				d.*
			FROM
				" . $TB['DOMAIN'] . " d
			WHERE
				1=1
				" . $q_where . "
			ORDER BY
				" . $order_set['query'] . "
			";
		$rows = db_get_rows($sql, $pager_limit['from'], $pager_limit['count']);
		$DEBUG['db_select']['exec'] += getmicrotime() - $DEBUG['db_select']['start'];

	// process data
		$DEBUG['db_fetch_all']['start'] = getmicrotime();
		for ($i=0; $i<sizeof($rows); $i++)
		{
			$q_hint = ($G_SYS[DB] == 'oracle') ? "/*+ ORDERED index_asc (".$TB['MEMBER']." M_M_QUOTA) */" : "";
			// [2007-07-21] 메일링 리스트 계정은 제외
			//$sql = "SELECT ".$q_hint." COUNT(m_id) m_cnt, SUM(m_quota) m_quota_sum FROM " . $TB['MEMBER'] . " WHERE d_no='" . $rows[$i]['d_no'] . "' AND m_level !='".$G[LEVEL][wait]."'";
			$sql = "SELECT ".$q_hint." COUNT(m_id) m_cnt, SUM(m_quota) m_quota_sum, SUM(m_bigfile_quota) m_bigfile_quota_sum, SUM(m_webhard_quota) m_webhard_quota_sum FROM " . $TB['MEMBER'] . " WHERE d_no='" . $rows[$i]['d_no'] . "' AND m_level !='".$G[LEVEL][wait]."' AND m_usertype IS NULL";
			$mbrg = db_get_row($sql);
			$rows[$i]['m_cnt'] = $mbrg['m_cnt'];
			$rows[$i]['m_quota_sum'] = $mbrg['m_quota_sum'];
			$rows[$i]['m_quota_sum_rate'] = @ceil($rows[$i]['m_quota_sum'] / $rows[$i]['d_quota'] * 100);

			// [2025-11-17] 보이지 않는 그래프 영역의 최대 너비 100으로 제한하기 위해 추가
			$rows[$i]['m_quota_sum_rate_width'] = $rows[$i]['m_quota_sum_rate'];
			if ($rows[$i]['m_quota_sum_rate_width'] > 100) {
				$rows[$i]['m_quota_sum_rate_width'] = 100;
			}

			$rows[$i]['m_cnt_rate'] = ceil($rows[$i]['m_cnt'] / $rows[$i]['d_quota_mbr_count'] * 100);

			// [2025-11-17] 보이지 않는 그래프 영역의 최대 너비 100으로 제한하기 위해 추가
			$rows[$i]['m_cnt_rate_width'] = $rows[$i]['m_cnt_rate'];
			if ($rows[$i]['m_cnt_rate_width'] > 100) {
				$rows[$i]['m_cnt_rate_width'] = 100;
			}

			$rows[$i]['d_quota'] = filesize_human($rows[$i]['d_quota']*1024, 1);
			$rows[$i]['d_quota_mbr_default'] = filesize_human($rows[$i]['d_quota_mbr_default']*1024);
			$rows[$i]['m_quota_sum'] = filesize_human($rows[$i]['m_quota_sum']*1024, 1);
			$rows[$i]['d_quota_mbr_count'] = number_format($rows[$i]['d_quota_mbr_count']);
			$rows[$i]['m_cnt'] = number_format($rows[$i]['m_cnt']);
			$rows[$i]['d_regdate'] = substr($rows[$i]['d_regdate'], 0, 10);
			$rows[$i]['d_modifydate'] = substr($rows[$i]['d_modifydate'], 0, 10);


			// [2007-12-28] 대용량첨부, 웹하드
			$rows[$i]['d_bigfile_quota_sum'] = filesize_human($mbrg['m_bigfile_quota_sum']*1024, 1);
			$rows[$i]['d_bigfile_quota_sum_rate'] = @ceil($mbrg['m_bigfile_quota_sum'] / $rows[$i]['d_bigfile_quota'] * 100);

			// [2025-11-17] 보이지 않는 그래프 영역의 최대 너비 100으로 제한하기 위해 추가
			$rows[$i]['d_bigfile_quota_sum_rate_width'] = $rows[$i]['d_bigfile_quota_sum_rate'];
			if ($rows[$i]['d_bigfile_quota_sum_rate_width'] > 100) {
				$rows[$i]['d_bigfile_quota_sum_rate_width'] = 100;
			}

			$rows[$i]['d_bigfile_quota'] = filesize_human($rows[$i]['d_bigfile_quota']*1024, 1);

			// [2008-02-20] 공용웹하드 용량 합산
			$mbrg['m_webhard_quota_sum'] += get_ws_quota_sum($rows[$i]['d_no']);

			$rows[$i]['d_webhard_quota_sum'] = filesize_human($mbrg['m_webhard_quota_sum']*1024, 1);
			$rows[$i]['d_webhard_quota_sum_rate'] = @ceil($mbrg['m_webhard_quota_sum'] / $rows[$i]['d_webhard_quota'] * 100);

			// [2025-11-17] 보이지 않는 그래프 영역의 최대 너비 100으로 제한하기 위해 추가
			$rows[$i]['d_webhard_quota_sum_rate_width'] = $rows[$i]['d_webhard_quota_sum_rate'];
			if ($rows[$i]['d_webhard_quota_sum_rate_width'] > 100) {
				$rows[$i]['d_webhard_quota_sum_rate_width'] = 100;
			}

			$rows[$i]['d_webhard_quota'] = filesize_human($rows[$i]['d_webhard_quota']*1024, 1);


			// [2025-11-19] 웹메일 주소 미입력시 http://mail.domain.com 으로 기본 표시
			if ($rows[$i]['d_webmail_url'] === '' || $rows[$i]['d_webmail_url'] === null) {
				$rows[$i]['d_webmail_url'] = 'http://mail.' . $rows[$i]['d_name'];
			}


/*

			$rows[$i]['d_quota_board_sum'] = $mbrg['d_quota_board_sum'];
			$rows[$i]['d_quota_board_sum_rate'] = ceil($rows[$i]['d_quota_board_sum'] / $rows[$i]['d_quota_board'] * 100);
			$rows[$i]['d_quota_board'] = filesize_human($rows[$i]['d_quota_board']*1024);

*/




		}	// for()
		$rows = db_rows_fieldtokey($rows);
		$rows_cnt = getarraycount($rows['d_name']);

		for ($i=0; $i<sizeof($rows); $i++)
		{
			// 게시판 첨부 할당량
			$rows['fsize'][$i] = get_board_size_sum($rows['d_no'][$i], $rows['d_quota_board'][$i]);

			// [2025-11-17] 보이지 않는 그래프 영역의 최대 너비 100으로 제한하기 위해 추가
			$rows['fsize'][$i]['rate_width'] = $rows['fsize'][$i]['rate'];
			if ($rows['fsize'][$i]['rate_width'] > 100) {
				$rows['fsize'][$i]['rate_width'] = 100;
			}
		}	// for()

		$DEBUG['db_fetch_all']['exec'] += getmicrotime() - $DEBUG['db_fetch_all']['start'];

	// 도메인관리수
		$sdomain_all_cnt = number_format($pager_params['totalItems']);


	// [2007-12-28] 디스크 사용량
	$sys = array();
	$sys['hdd_sum_total'] = disk_total_space($G_SYS['PAGE_ROOT']);
	$sys['hdd_sum'] = $sys['hdd_sum_total'] - disk_free_space($G_SYS['PAGE_ROOT']);
	$sys['hdd_sum_rate'] = ceil($sys['hdd_sum'] / $sys['hdd_sum_total'] * 100);

	// [2025-11-17] 보이지 않는 그래프 영역의 최대 너비 100으로 제한하기 위해 추가
	$sys['hdd_sum_rate_width'] = $sys['hdd_sum_rate'];
	if ($sys['hdd_sum_rate_width'] > 100) {
		$sys['hdd_sum_rate_width'] = 100;
	}

	$sys['hdd_sum'] = filesize_human($sys['hdd_sum']);
	$sys['hdd_sum_total'] = filesize_human($sys['hdd_sum_total']);

    // [2020-10] 도메인관리 "디스크 사용량" 연관 파티션 출력
    $sys2 = array();
    if (strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN'){
        $exts = $G_SYS['NM_PRINT_REF_HDD_RATE'];
        for ($c=0; $c<count($exts); $c++) {
            if (is_dir($exts[$c])) {
                $tmp = array();
                $tmp['hdd_dir'] = $exts[$c];
                $tmp['hdd_sum_total'] = disk_total_space($exts[$c]);
                $tmp['hdd_sum'] = $tmp['hdd_sum_total'] - disk_free_space($exts[$c]);
                $tmp['hdd_sum_rate'] = ceil($tmp['hdd_sum'] / $tmp['hdd_sum_total'] * 100);
                $tmp['hdd_sum'] = filesize_human($tmp['hdd_sum']);
                $tmp['hdd_sum_total'] = filesize_human($tmp['hdd_sum_total']);
                array_push($sys2, $tmp);
            }
        }
    }

	// [2025-09-01] 도메인관리 "사용중인 계정 합계" 출력 (가입대기만 제외)
	$nm_reg = nm_register_get();

	$nm_reg['user_sum'] = db_get_one("
				SELECT 
					COUNT(*) 
				FROM 
					" . $TB['MEMBER'] . "
				WHERE 
					m_usertype IS NULL AND m_level != '" . $G[LEVEL][wait] . "'  "
	);

	if ($_GET['excel_down'])
	{
		unset($CFG['SDOMAIN_LIST_FIELD']['d.d_no'], $CFG['SDOMAIN_LIST_FIELD']['d.d_quota_mbr_count'], $CFG['SDOMAIN_LIST_FIELD']['d.d_saveday']);

		$excel_down_name = 'NmailSdomainList_' . date('Ymd_His') . '.xls';
		header("Content-type: application/vnd.ms-excel; charset=utf-8");
		header("Content-Disposition: attachment; filename=$excel_down_name");
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");

		include('sadmin/sdomain_list_excel.html');

		exit;
	}

// skin view
	nskinset('sadmin', 'sdomain_list.html');		// 컨텐츠
	include($NSKIN['view_layout']);


require_once('include/global_end.php');
?>