<?
require_once('include/global.php');
require_once('include/mail_lib.php');
require_once('include/file.php');
require_once('conf.inc.php');

if (!$G_SYS['MAIL_BOX_BACKUP_USE'])
	msg("편지함 백업/복구 기능을 사용할 수 없도록 설정되었습니다.\\n\\n관리자에게 문의하여주시기 바랍니다.", 0, true);

set_time_limit(3600);


// check
	$is_select_backup = false;
	if (is_array($_POST['cmf']) && sizeof($_POST['cmf']) > 0)
	{
		if (!$_GET['mb_id'])
			msg('올바른 URL로 접근하여 주십시오');
		$is_select_backup = true;
	} else
	{
        // KVE-2020 sql injection 취약점 개선
        #if (!$_GET['mb_id'] || !$_GET['start'] || !$_GET['end'] || !$_GET['len'])
		if (!$_GET['mb_id'] || !$_GET['start'] || !is_numeric($_GET['start']) || !$_GET['end'] || !is_numeric($_GET['end']) || !$_GET['len'])
			msg('올바른 URL로 접근하여 주십시오');
	}	// if()


// set
	// [2025-11-12] 사용자의 기본 설정 가져오기
	$default_config = get_default_config($AUTH['auth_m_no']);

	if ($G_SYS['MAIL_BOX_BACKUP_NAME_ENG'])
	{
		$mb_name = $_GET['mb_id'];
	} else
	{
		$mb_name = get_mb_name($_GET['mb_id']);
		// UTF-8
		//if (strtoupper($G_SYS[CHARSET]) == 'UTF-8')
		//	$mb_name = iconv_fix('UTF-8', $mb_name, 'CP949');
	}	// if()

	if (!$is_select_backup)
	{
		$from = $_GET['start'] - 1;
		$count = $_GET['end'] - $_GET['start'] + 1;
		if ($count > $G_SYS['MAIL_BOX_BACKUP_LIMIT'])
			msg("편지함 백업은 ".$G_SYS['MAIL_BOX_BACKUP_LIMIT']."통 단위로만 분할될 수 있습니다.");

		$zip_file_realname = $G_SYS['MAIL_BOX_BACKUP_PREFIX'].$AUTH['auth_m_id'].'_'.str_replace(' ', '_', file_name_char_limit($mb_name)).'_'.date('Ymd_Hi').'_'.sprintf('%0'.$_GET['len'].'d', $_GET['start']).'-'.sprintf('%0'.$_GET['len'].'d', $_GET['end']).'.zip';
	} else
	{
		if (sizeof($_POST['cmf']) > 100)
			msg("선택된 메일은 100통까지만 백업이 가능합니다.");
		$zip_file_realname = $G_SYS['MAIL_BOX_BACKUP_PREFIX'].$AUTH['auth_m_id'].'_'.str_replace(' ', '_', file_name_char_limit($mb_name)).'_'.date('Ymd_Hi').'.zip';
	}	// if()

	// [2008-10-22] 일부 UTF-8 환경에서 한글파일명으로 백업/복구가 안되는 문제보완.
	$zip_file = $G_SYS['MAIL_BOX_BACKUP_PREFIX'].md5($zip_file_realname).'.zip';

	// [2008-09-24] 편지함 백업/복구시 사용되는 압축 프로그램 Linux/Windows 구분
		if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
		{
			$zip_bin = dirname($G_SYS[PAGE_ROOT]).'/tools/7-zip/7za.exe';
			if (!file_exists($zip_bin))
				error("서버에서 압축프로그램을 찾을 수 없습니다.\n=> " . $zip_bin, 'FILE');
			$zip_bin .= ' a -tzip';
		} else
		{
			$zip_bin = '/usr/bin/zip';
			if (!file_exists($zip_bin))
				error("서버에서 압축프로그램을 찾을 수 없습니다.\n=> " . $zip_bin, 'FILE');
			$zip_bin .= ' -q';
		}	// if()

	$zip_dir = $UPLOAD_ROOT.'/'.$UPLOAD_DIR[BIGFILE_TMP];
	$list_file = '';

	if (!is_dir($zip_dir))
	{
		$errorMsg = mkdir_parent($UPLOAD_DIR[BIGFILE_TMP]);
		if ($errorMsg != '')
			msg("백업을 위한 임시 디렉토리 생성이 실패하였습니다.\\n\\n원인 : ".$errorMsg);
	}	// if()


// 백업된 파일이 있을 경우 재백업하지 않음.
	if (!file_exists($zip_dir.'/'.$zip_file))
	{
			// data
				$DEBUG['db_select']['start'] = getmicrotime();
				// db - select

					if ($G_SYS['MAIL_BOX_BACKUP_FILENAME_TO_SUBJECT'] || $default_config['m_mail_box_backup_type'] === 'subject')
					{
						$select_field = 'mf_filename, mf_arrival_date, mf_subject, mf_from, mf_to, mb_id';
					} else
					{
						$select_field = 'mf_filename';
					}	// if()

					// [2020-02] KVE SQL Injection 개선
					if (!$is_select_backup)
					{
						$sql = "
							SELECT
								".$select_field."								
							FROM
								".$AUTH[auth_m_mf_table]."
							WHERE
								m_no='" . $AUTH['auth_m_no'] . "'
								AND mb_id='". del_injection_str($_GET['mb_id']). "'
							ORDER BY
								mf_arrival_date
							";
						$rows = db_get_rows($sql, $from, $count);
					} else
					{
						$sql = "
							SELECT
								".$select_field."								
							FROM
								".$AUTH[auth_m_mf_table]."
							WHERE
								m_no='" . $AUTH['auth_m_no'] . "'
								AND mb_id='". del_injection_str($_GET['mb_id']). "'
								AND mf_no IN (".implode_keys($_POST['cmf']).")
							ORDER BY
								mf_arrival_date
							";
						$rows = db_get_rows($sql);
					}	// if()
				if (!$rows)
					msg("메일이 존재하지 않습니다.");

			// db disconnect
				unset_db();

			$DEBUG['db_select']['exec'] += getmicrotime() - $DEBUG['db_select']['start'];


		// zip
			// [2013-02-27] 편지함 백업시 파일명의 확장자가 .eml 이 아닐 경우, .eml을 자동으로 붙이기(기본값은 false)
			if ($G_SYS['MAIL_BOX_BACKUP_FILENAME_EML_AUTOADD'])
			{
				$mail_dir = get_mail_dir().'/'.get_mb_dir($_GET['mb_id']);

				$zip_ext_dir = $G_SYS['MAIL_BOX_BACKUP_PREFIX'].$_GET['mb_id'].'_'.date('Ymd_His').'_'.getmicrotime();
				$errorMsg = mkdir_parent($UPLOAD_DIR[BIGFILE_TMP].'/'.$zip_ext_dir);
				if ($errorMsg != '')
					msg("백업을 위한 임시 디렉토리 생성이 실패하였습니다.\\n\\n원인 : ".$errorMsg);

				if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
				{
					$cmd = $zip_bin.' '.escapeshellarg($zip_dir.'/'.$zip_file);
					$list_file_data = "";
					for ($i=0; $i<sizeof($rows); $i++)
					{
						$_dest_first = $rows[$i]['mf_filename'];
						if (file_name_ext($_dest_first) != 'eml')
							$_dest_first .= '.eml';
						for ($j=0; $j<100; $j++)
						{
							if ($j > 0)
							{
								$_dest = str_replace('.eml', '.'.rand(111,999).'.eml', $_dest_first);
							} else
							{
								$_dest = $_dest_first;
							}	// if()
							if (!file_exists($zip_dir.'/'.$zip_ext_dir.'/'.$_dest))
								break;
						}	// for()
						copy($mail_dir.'/'.$rows[$i]['mf_filename'], $zip_dir.'/'.$zip_ext_dir.'/'.$_dest);
						touch($zip_dir.'/'.$zip_ext_dir.'/'.$_dest, filemtime($mail_dir.'/'.$rows[$i]['mf_filename']));
						$list_file_data .= escapeshellarg($_dest)."\n";
					}	// for()
					$list_file = $zip_dir.'/'.$zip_file.'.txt';
					file_write($list_file, $list_file_data);
					$cmd .= ' @'.$list_file;
				} else
				{
					$cmd = $zip_bin.' '.escapeshellarg($zip_dir.'/'.$zip_file);
					for ($i=0; $i<sizeof($rows); $i++)
					{
						$_dest_first = $rows[$i]['mf_filename'];
						if (file_name_ext($_dest_first) != 'eml')
							$_dest_first .= '.eml';
						for ($j=0; $j<100; $j++)
						{
							if ($j > 0)
							{
								$_dest = str_replace('.eml', '.'.rand(111,999).'.eml', $_dest_first);
							} else
							{
								$_dest = $_dest_first;
							}	// if()
							if (!file_exists($zip_dir.'/'.$zip_ext_dir.'/'.$_dest))
								break;
						}	// for()
						copy($mail_dir.'/'.$rows[$i]['mf_filename'], $zip_dir.'/'.$zip_ext_dir.'/'.$_dest);
						touch($zip_dir.'/'.$zip_ext_dir.'/'.$_dest, filemtime($mail_dir.'/'.$rows[$i]['mf_filename']));
						$cmd .= ' '.escapeshellarg($_dest);
					}	// for()
				}	// if()

				chdir($zip_dir.'/'.$zip_ext_dir);

				ob_start();
				//system($cmd);
				exec($cmd);
				$cmd_result = ob_get_contents();
				ob_end_clean();

				// 완료후 임시 디렉토리 삭제
				if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
				{
					$cmd_rm = 'rmdir/q/s';
				} else
				{
					$cmd_rm = 'rm -rf';
				}
				if ($zip_dir != '' && strpos($zip_ext_dir, $G_SYS['MAIL_BOX_BACKUP_PREFIX']) !== false)		// 프로그램상의 미스로 인하여 / 파티션이 삭제되는 것 예방.
					system($cmd_rm.' '.escapeshellarg(realpath($zip_dir.'/'.$zip_ext_dir.'/')));
			} else if ($G_SYS['MAIL_BOX_BACKUP_FILENAME_TO_SUBJECT'] || $default_config['m_mail_box_backup_type'] === 'subject')		// [2010-09-10] 편지함 백업시 파일명을 메일 제목으로 변경함.(기본값은 false)
			{
				$mail_dir = get_mail_dir().'/'.get_mb_dir($_GET['mb_id']);

				$zip_ext_dir = $G_SYS['MAIL_BOX_BACKUP_PREFIX'].$_GET['mb_id'].'_'.date('Ymd_His').'_'.getmicrotime();
				$errorMsg = mkdir_parent($UPLOAD_DIR[BIGFILE_TMP].'/'.$zip_ext_dir);
				if ($errorMsg != '')
					msg("백업을 위한 임시 디렉토리 생성이 실패하였습니다.\\n\\n원인 : ".$errorMsg);

				if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
				{
					// [2015-11-10] charset관련사항으로 -scsWIN옵션추가
					$cmd = $zip_bin.' -scsWIN '.escapeshellarg($zip_dir.'/'.$zip_file);
					$list_file_data = "";
					for ($i=0; $i<sizeof($rows); $i++)
					{
						for ($j=0; $j<9999999; $j++)
						{
							if ($j > 0)
							{
								$_dest = get_mail_box_backup_filename($rows[$i]['mf_arrival_date'], $rows[$i]['mf_subject'], $rows[$i]['mf_from'], $rows[$i]['mf_to'], $rows[$i]['mb_id']).' ('.$j.').eml';
							} else
							{
								$_dest = get_mail_box_backup_filename($rows[$i]['mf_arrival_date'], $rows[$i]['mf_subject'], $rows[$i]['mf_from'], $rows[$i]['mf_to'], $rows[$i]['mb_id']).'.eml';
							}	// if()

							// [2024-11-21] 메일 제목으로 백업시 윈도우 서버에서 한글 인코딩 변환
							$_dest = file_name_char_limit(iconv_fix('UTF-8', $_dest, 'CP949'));

							if (!file_exists($zip_dir.'/'.$zip_ext_dir.'/'.$_dest))
								break;
						}	// for()
						copy($mail_dir.'/'.$rows[$i]['mf_filename'], $zip_dir.'/'.$zip_ext_dir.'/'.$_dest);
						touch($zip_dir.'/'.$zip_ext_dir.'/'.$_dest, filemtime($mail_dir.'/'.$rows[$i]['mf_filename']));
						$list_file_data .= escapeshellarg($_dest)."\n";
					}	// for()
					$list_file = $zip_dir.'/'.$zip_file.'.txt';
					file_write($list_file, $list_file_data);
					$cmd .= ' @'.$list_file;
				} else
				{
                    // euc-kr 파일명 불필요. 서버 인코딩대로 utf-8 파일명으로 저장.
//                    setlocale(LC_CTYPE, 'ko_KR.eucKR');

					$cmd = $zip_bin.' '.escapeshellarg($zip_dir.'/'.$zip_file);
                    $list_file_data = "";
					for ($i=0; $i<sizeof($rows); $i++)
					{
						// [2015-11-10] charset관련사항 개선
//						$rows[$i]['mf_subject'] = iconv("utf-8","cp949",$rows[$i]['mf_subject']);
//						$rows[$i]['mf_from'] = iconv("utf-8","cp949",$rows[$i]['mf_from']);
//						$rows[$i]['mf_to'] = iconv("utf-8","cp949",$rows[$i]['mf_to']);
						for ($j=0; $j<9999999; $j++)
						{
							if ($j > 0)
							{
								$_dest = get_mail_box_backup_filename($rows[$i]['mf_arrival_date'], $rows[$i]['mf_subject'], $rows[$i]['mf_from'], $rows[$i]['mf_to'], $rows[$i]['mb_id']).' ('.$j.').eml';
							} else
							{
								$_dest = get_mail_box_backup_filename($rows[$i]['mf_arrival_date'], $rows[$i]['mf_subject'], $rows[$i]['mf_from'], $rows[$i]['mf_to'], $rows[$i]['mb_id']).'.eml';
							}	// if()
							if (!file_exists($zip_dir.'/'.$zip_ext_dir.'/'.$_dest))
								break;
						}	// for()
						copy($mail_dir.'/'.$rows[$i]['mf_filename'], $zip_dir.'/'.$zip_ext_dir.'/'.$_dest);
						touch($zip_dir.'/'.$zip_ext_dir.'/'.$_dest, filemtime($mail_dir.'/'.$rows[$i]['mf_filename']));
//						$cmd .= ' '.escapeshellarg($_dest);
//                        $list_file_data .= escapeshellarg($_dest)."\n";
                        $list_file_data .= $_dest.PHP_EOL;
					}	// for()
                    $list_file = $zip_dir.'/'.$zip_file.'.txt';
                    file_write($list_file, $list_file_data);
                    $cmd .= ' -@ < '.$list_file;
				}	// if()

				chdir($zip_dir.'/'.$zip_ext_dir);

				ob_start();
				//system($cmd);
				exec($cmd);
				$cmd_result = ob_get_contents();
				ob_end_clean();

				// 완료후 임시 디렉토리 삭제
				if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
				{
					$cmd_rm = 'rmdir/q/s';
				} else
				{
					$cmd_rm = 'rm -rf';
				}
				if ($zip_dir != '' && strpos($zip_ext_dir, $G_SYS['MAIL_BOX_BACKUP_PREFIX']) !== false)		// 프로그램상의 미스로 인하여 / 파티션이 삭제되는 것 예방.
					system($cmd_rm.' '.escapeshellarg(realpath($zip_dir.'/'.$zip_ext_dir.'/')));
			} else
			{
				$mail_dir = get_mail_dir().'/'.get_mb_dir($_GET['mb_id']);
				chdir($mail_dir);

				if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
				{
					$cmd = $zip_bin.' '.escapeshellarg($zip_dir.'/'.$zip_file);
					$list_file_data = "";
					for ($i=0; $i<sizeof($rows); $i++)
					{
						$list_file_data .= escapeshellarg($rows[$i]['mf_filename'])."\n";
					}	// for()
					$list_file = $zip_dir.'/'.$zip_file.'.txt';
					file_write($list_file, $list_file_data);
					$cmd .= ' @'.$list_file;
				} else
				{
					// [2011-06-07] 2000 limit fix
					/*
					$cmd = $zip_bin.' '.escapeshellarg($zip_dir.'/'.$zip_file);
					for ($i=0; $i<sizeof($rows); $i++)
					{
						$cmd .= ' '.escapeshellarg($rows[$i]['mf_filename']);
					}	// for()
					*/
					$list_file_data = "";
					for ($i=0; $i<sizeof($rows); $i++)
					{
						// zip - -@     Take the list of input files from standard input. Only one filename per line.
						//$list_file_data .= escapeshellarg($rows[$i]['mf_filename'])."\n";
						$list_file_data .= $rows[$i]['mf_filename']."\n";
					}	// for()
					$list_file = $zip_dir.'/'.$zip_file.'.txt';
					file_write($list_file, $list_file_data);
					$cmd = 'cat '.$list_file.'|'.$zip_bin.' '.escapeshellarg($zip_dir.'/'.$zip_file).' -@';
				}	// if()

				ob_start();
				//system($cmd);
				exec($cmd);
				$cmd_result = ob_get_contents();
				ob_end_clean();
			}	// if()
	}	// if()


// download
	$errorMsg = file_down($zip_file, '', $UPLOAD_DIR[BIGFILE_TMP], NULL, $zip_file_realname);
	if ($errorMsg)
		error("메일백업파일의 다운로드가 실패하였습니다.\n=> " . $UPLOAD_ROOT . '/' . $UPLOAD_DIR[BIGFILE_TMP] . '/' . $zip_file . $errorMsg . "\n\n백업 명령 : ".$cmd."\n\n백업 명령 결과 : ".$cmd_result, 'FILE');


	// 다운로드 완료후 삭제
	unlink($zip_dir.'/'.$zip_file);
	if ($list_file != '')
		unlink($list_file);


// 다운로드를 위해 디버깅정보 생략.
//require_once('include/global_end.php');
?>