<?
	require_once('include/global.php');
	require_once('include/mail_lib.php');
	require_once('include/file.php');
	require_once('conf.inc.php');

// check
	if (!$_GET['mf_no'])
		msg('올바른 URL로 접근하여 주십시오');


	// [2008-04-03] 파일 다운로드 시간 제한
	if (isset($G_SYS['DOWNLOAD_TIME_LIMIT']))
		set_time_limit($G_SYS['DOWNLOAD_TIME_LIMIT']);


// data
	$DEBUG['db_select']['start'] = getmicrotime();

	// set data
	$mail_file_table = $AUTH[auth_m_mf_table];

	// [2025-11-12] 사용자의 기본 설정 가져오기
	$default_config = get_default_config($AUTH['auth_m_no']);

	// db - select
	$sql = "
			SELECT
				mf_filename, mf_attach_names, mf_arrival_date, mf_subject, mf_from, mf_to, mb_id
			FROM
				$mail_file_table
			WHERE
				mf_no='" . $_GET['mf_no'] . "'
				AND m_no='" . $AUTH['auth_m_no'] . "'
			";
	$row = db_get_row($sql);

	// [2009-07-01]
	if (!$row)
		msg("존재하지 않는 메일입니다.\\n\\n이미 삭제되었거나 다른 편지함으로 옮겨졌을 수 있습니다.");

	$DEBUG['db_select']['exec'] += getmicrotime() - $DEBUG['db_select']['start'];


// download
	$DEBUG['attach_save']['start'] = getmicrotime();

	$mail_file = get_mail_dir().'/'.get_mb_dir($row['mb_id']).'/'.$row['mf_filename'];
	// [2013-04-30] POP3 등으로 메일파일이 먼저 삭제된 경우, 에러를 정확하게 보여줌.
	//if (!file_exists($mail_file) || !is_readable($mail_file))
	if (!file_exists($mail_file))
	{
		$sql = "
			DELETE
			FROM
				".$AUTH[auth_m_mf_table]."
			WHERE
				mf_no='" . $_GET['mf_no'] . "'
				AND m_no='" . $AUTH['auth_m_no'] . "'
				AND mb_id='". $_GET['mb_id']. "'
			";
		db_query($sql);
		msg("존재하지 않는 메일입니다.\\n\\n아웃룩등의 메일클라이언트에서 POP3 서비스를 통해 메일을 가져갈때\\n\\n[서버에 메시지 복사본 저장]옵션을 체크하지 않아 삭제되었을 가능성이 높습니다.");
	}	// if()

	// db disconnect
	unset_db();

	if (!is_readable($mail_file))
		error("메일 파일이 존재하지 않거나 퍼미션이 잘못되었습니다.\n=> ". $mail_file, 'FILE');

	// [2008-02-26] 파일명이 길어 다운로드가 되지 않는 오류 수정. (파일명을 전달받지 않고 디비에서 바로 가져오기)
	$an = attach_names_toarray($row['mf_attach_names']);

	$zip_dir = $UPLOAD_ROOT.'/'.$UPLOAD_DIR[BIGFILE_TMP];
	$list_file_data = "";
	$list_file = '';
    $list_err_count = 0;
	$save_files = array();
	for ($i=0; $i<sizeof($an['struct']); $i++){
		$file_new = file_name_char_limit($an['name'][$i]);

		$file_info = pathinfo($file_new);
		$file_ext_length = strlen($file_info['extension']);

		$filename_max_length = 250;

		// [2023-01-04] Windows 서버에서는 파일명을 CP949 로 변환후 저장
		if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
		{
			$file_new = iconv_fix('UTF-8', $file_new, 'CP949');

			// [2026-01-07] Windows는 파일 경로 포함 최고 260자이므로 파일명 120자 이내로 제한하도록 수정.
			$filename_max_length = 120;
		}

		// [2026-01-07] 파일명 길이 제한
		if (strlen($file_new) > $filename_max_length) {
			$file_info = pathinfo($file_new);

			// 마지막 글자 한글 깨짐 고려하여 마침표 1개 더 추가
			$file_new = substr($file_info['filename'], 0, $filename_max_length - strlen($file_ext_length) - 1) . '.';
			if ($file_ext_length != '') {
				$file_new .= '.' . $file_info['extension'];
			}
		}

		// [2026-01-07] 파일명 중복 방지
		if (isset($save_files[$file_new])) {
			$save_files[$file_new]++;

			$file_info = pathinfo($file_new);

			// 중복 파일명은 (1), (2) 처럼 파일명뒤에 추가
			$file_new = $file_info['filename'] . ' (' . ($save_files[$file_new] - 1) . ')';
			if ($file_ext_length != '') {
				$file_new .= '.' . $file_info['extension'];
			}
		} else {
			$save_files[$file_new] = 1;
		}
		unset($file_info);

		// 메일 원문에서 첨부 파일 내용 가져오기
		$contents = get_mailparse_attachment($mail_file, $an['struct'][$i]);

		// 임시 첨부 파일 저장
		$write_file = fopen($zip_dir."/".$file_new, "a");
		fwrite($write_file, $contents);
		fclose($write_file);

		// 압축 대상 추가
		$list_file_data .= $file_new."\n";

		// 임시 파일 삭제를 위해 변경된 파일명 저장
		$an['name'][$i] = $file_new;
	}

	// 압축 대상 파일 저장
	$list_file = $zip_dir."/".$row['mf_filename'].'.txt';
	file_write($list_file, $list_file_data);

	// [2008-09-24] 편지함 백업/복구시 사용되는 압축 프로그램 Linux/Windows 구분
	if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
	{
		$zip_bin = dirname($G_SYS[PAGE_ROOT]).'/tools/7-zip/7za.exe';
		if (!file_exists($zip_bin))
			error("서버에서 압축프로그램을 찾을 수 없습니다.\n=> " . $zip_bin, 'FILE');
        $zip_bin .= ' a -tzip -scsWIN';
	} else
	{
		$zip_bin = '/usr/bin/zip';
		if (!file_exists($zip_bin))
			error("서버에서 압축프로그램을 찾을 수 없습니다.\n=> " . $zip_bin, 'FILE');
		$zip_bin .= ' -q';
	}	// if()


	if (!is_dir($zip_dir)){
		$errorMsg = mkdir_parent($UPLOAD_DIR[BIGFILE_TMP]);
		if ($errorMsg != '')
			msg("임시 디렉토리 생성이 실패하였습니다.\\n\\n원인 : ".$errorMsg);
	}	// if()

    $down_filename = $row['mf_filename'].".zip";
	$down_filename_real = $down_filename;       // 실제 다운로드될 파일명

    if ($G_SYS['MAIL_BOX_BACKUP_FILENAME_TO_SUBJECT'] || $default_config['m_mail_box_backup_type'] === 'subject') {        // 첨부파일 전체저장시 파일명을 메일 제목으로 변경함.(기본값은 false)
        $down_filename = get_mail_box_backup_filename($row['mf_arrival_date'], $row['mf_subject'], $row['mf_from'], $row['mf_to'], $row['mb_id']).'.zip';
	    $down_filename_real = $down_filename;
    }

	if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN'){
		if ($G_SYS['MAIL_BOX_BACKUP_FILENAME_TO_SUBJECT'] || $default_config['m_mail_box_backup_type'] === 'subject') {
			// [2024-11-21] 메일 제목으로 백업시 윈도우 서버에서 한글 인코딩 변환
			$down_filename = file_name_char_limit(iconv_fix('UTF-8', $down_filename, 'CP949'));
		}

        $cmd = $zip_bin.' '.escapeshellarg($zip_dir.'/'.$down_filename).' @'.escapeshellarg($list_file);
	} else {
        if ($G_SYS['MAIL_BOX_BACKUP_FILENAME_TO_SUBJECT'] || $default_config['m_mail_box_backup_type'] === 'subject') {
            setlocale(LC_CTYPE, 'ko_KR.utf8');
        }
		$cmd = 'cat '.$list_file.'|'.$zip_bin.' '.escapeshellarg($zip_dir.'/'.$down_filename).' -@';
	}	// if()
	chdir($zip_dir);
	ob_start();
	system($cmd . ' 2>&1', $return_var);
	$cmd_result = ob_get_contents();
	ob_end_clean();
	$DEBUG['attach_save']['exec'] += getmicrotime() - $DEBUG['attach_save']['start'];

	// download
	$errorMsg = file_down($down_filename_real, '', $UPLOAD_DIR[BIGFILE_TMP], NULL, $down_filename_real);
	if ($errorMsg || $return_var !== 0)
		error("첨부파일 일괄 다운로드가 실패하였습니다.\n=> " . $zip_dir.'/'.$down_filename . $errorMsg . "\n\n명령 : ".$cmd."\n\n명령 결과 : ".$cmd_result, 'FILE');

	// 다운로드 완료후 삭제
	//    - 임시 첨부 파일 삭제
	for ($i=0; $i<sizeof($an['struct']); $i++){
        unlink($zip_dir."/".$an['name'][$i]);
	}
	//    - 압축 대상 파일 삭제
	if ($list_file != '')
		unlink($list_file);
	//    - 다운로드 파일 삭제
	unlink($zip_dir.'/'.$down_filename);

// 다운로드를 위해 디버깅정보 생략.
#require_once('include/global_end.php');
?>