<?


###############################################################################




###############################################################################


	/** 회원 정보 가져오기

		ex)
			$mbr = member_info($AUTH[auth_m_no]);		// array

	*/
	function member_info($m_no, $ischk="Y")
	{
		global $db, $TB, $G_SYS, $mode_sadmin;

		if (!$mode_sadmin)
		{
			$q_where = " AND d_no='" . get_d_no($G_SYS['MAIL_DOMAIN']) . "'";
		}	// if()

		$q = "SELECT * FROM $TB[MEMBER] WHERE m_no='$m_no' ".$q_where;
		//echo "<hr>" . $q;
		$mbr = db_get_row($q);

		if ($mbr == NULL) {
			if ($ischk == "Y") {
				msg("존재하지 않는 회원입니다.");
			} else {
				$mbr[m_name] = "탈퇴(" . $m_no . ")";
				$mbr[m_email] = NULL;
			}
		}	// if()

		return $mbr;
	}	// function()


###############################################################################


	/** 회원 정보 가져오기(조건문 직접 사용)

		ex) $mbr = member_info_where("m_id='$m_id'");		// array

	*/
	function member_info_where($q_where)
	{
		global $db, $TB, $G_SYS, $G;

		// [2025-12-22] 아이디 / 비밀번호 찾기 제한 추가
		if ($G_SYS['SEARCH_LOST_LIMIT_LEVEL'] !== 'ALL') {
			switch ($G_SYS['SEARCH_LOST_LIMIT_LEVEL']) {
				case 'ADMIN':
					$q_where .= " and m_level < " . $G['LEVEL']['admin'];
					break;
				case 'SADMIN':
					$q_where .= " and m_level < " . $G['LEVEL']['serveradmin'];
					break;
			}
		}

		// [2007-07-21] 메일링 리스트 계정은 제외
		//$q = "SELECT * FROM $TB[MEMBER] WHERE $q_where AND d_no='" . get_d_no($G_SYS['MAIL_DOMAIN']) . "'";
		$q = "SELECT * FROM $TB[MEMBER] WHERE $q_where AND d_no='" . get_d_no($G_SYS['MAIL_DOMAIN']) . "' AND m_usertype IS NULL";
		$mbr = db_get_row($q);

		if($mbr == NULL) msg("존재하지 않거나 비밀번호 재발급이 제한된 회원입니다.");

		return $mbr;
	}	// function()


###############################################################################


	/** 아이디/비밀번호찾기 - 회원 정보 가져오기

		ex) $mbr = member_lost_search($s_m_name, $s_m_jumin1, $s_m_jumin2, $s_m_email);

	*/
	function member_lost_search($s_m_name, $s_m_jumin1, $s_m_jumin2, $s_m_email)
	{
		global $G, $db, $TB, $G_SYS;

		set_q_search($s_m_name);
		set_q_search($s_m_jumin1);
		set_q_search($s_m_jumin2);
		set_q_search($s_m_email);

		$q_where = NULL;
		if($s_m_name == true) $q_where .= " AND m_name = '" . $s_m_name . "' ";
		if(($s_m_jumin1 == true) && ($s_m_jumin2 == true)) $q_where .= " AND m_jumin = '" . $s_m_jumin1 . "-" . $s_m_jumin2 . "' ";
		if($s_m_email == true) $q_where .= " AND m_email = '" . $s_m_email . "' ";

		// [2025-12-22] 아이디 / 비밀번호 찾기 제한 추가
		if ($G_SYS['SEARCH_LOST_LIMIT_LEVEL'] !== 'ALL') {
			switch ($G_SYS['SEARCH_LOST_LIMIT_LEVEL']) {
				case 'ADMIN':
					$q_where .= " and m_level < " . $G['LEVEL']['admin'];
					break;
				case 'SADMIN':
					$q_where .= " and m_level < " . $G['LEVEL']['serveradmin'];
					break;
			}
		}

		// [2007-07-21] 메일링 리스트 계정은 제외
		//$q = "SELECT count(*) AS cnt FROM $TB[MEMBER] WHERE m_no>0 " . $q_where . " AND d_no='" . get_d_no($G_SYS['MAIL_DOMAIN']) . "'";
		$q = "SELECT count(*) AS cnt FROM $TB[MEMBER] WHERE m_no>0 " . $q_where . " AND d_no='" . get_d_no($G_SYS['MAIL_DOMAIN']) . "' AND m_usertype IS NULL";
		//echo $q;
		$chk_mbr = db_get_row($q);


		if($chk_mbr[cnt] > 1) msg("검색조건을 만족하는 회원이 많습니다.\\n\\n검색조건을 보다 자세하게 입력하여 주시기 바랍니다.\\n\\n찾을 수 없을때에는 관리자에게 문의하여 주시기 바랍니다.");
		if($chk_mbr[cnt] == 0) msg("존재하지 않거나 비밀번호 재발급이 제한된 회원입니다.");

		$mbr = member_info_where(" m_no>0 " . $q_where);		// array

		return $mbr;
	}	// function()


###############################################################################


	/** 아이디/비밀번호찾기 - 새비밀번호 발급

		ex) $new_pwd = member_new_password($m_no, $m_id);

	*/
	function member_new_password($m_no, $m_id)
	{
		global $db, $TB, $G_SYS;

		// [2025-12-22] 비밀번호 재발급시 복잡도 강화 (16자리 대문자 및 특수문자 포함)
		$new_pwd_len = 12;		// 신규 비밀번호 길이
		$new_pwd_special_char_len = 4;		// 신규 비밀번호 특수문자 길이

		$rand_char = array (
			"a", "b", "c", "d", "e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","z","y","z",
			"A", "B", "C", "D", "E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","Z","Y","Z",
			"1","2","3","4","5","6","7","8","9","0",
			);
		$rand_keys = array_rand ($rand_char, $new_pwd_len);
		for($i=0; $i<$new_pwd_len; $i++)
		{
			$new_pwd .=  $rand_char[$rand_keys[$i]];
		}	// for()
		//echo "<HR>" . $new_pwd;

		$rand_char = array ("!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "-", "_", "=", "+", "[", "]", "{", "}", "<", ">", "?", "'", ";");
		$rand_keys = array_rand ($rand_char, $new_pwd_special_char_len);
		for($i=0; $i<$new_pwd_len; $i++)
		{
			$new_pwd .=  $rand_char[$rand_keys[$i]];
		}	// for()

		$new_pwd_enc = pwd_enc($new_pwd, $m_id);
		$q = "UPDATE $TB[MEMBER] SET m_pwd='$new_pwd_enc' WHERE m_no='$m_no' AND d_no='" . get_d_no($G_SYS['MAIL_DOMAIN']) . "'";
		db_query($q);


		return $new_pwd;
	}	// function()


################################################################################

	// [2013-07-08] 비밀번호 안전 레벨
	function member_password_security($m_pwd, $m_id)
	{
		global $G_SYS;
		$error = '';

		$m_pwd = stripslashes($m_pwd);

		if (strlen($m_pwd) > 20)
		{
			$error = "20자 이상은 입력할 수 없습니다.";
		} else if ($m_pwd == $m_id || (trim($m_id) != '' && strpos($m_pwd, $m_id) !== false))
		{
			$error = "아이디 문자열과 같거나 아이디가 포함될수 없습니다.";
		} else
		{
			switch ($G_SYS['S_PASS_EVEL'])
			{
				case 1:
					if (strlen($m_pwd) < 6)
					{
						$error = "6자 이상 입력해야 합니다.";
					} else if (in_array($m_pwd, array('0000', '00000', '000000', '1111', '11111', '111111', '2222', '3333', '4444', '5555', '6666', '7777', '8888', '9999', '1234', '12345', '123456', '1234567', '12345678', '123456789', '1234567890', '123123')))
					{
						$error = "동일하거나 순차적인 숫자로만(1111,1234,...) 사용할 수 없습니다.";
					}	// if()
					break;

				case 2:
					if (strlen($m_pwd) < 6)
					{
						$error = "6자 이상 입력해야 합니다.";
					} else if (!preg_match('/[a-zA-Z]/', $m_pwd) || (!preg_match('/[0-9]/', $m_pwd) && !preg_match("/[~`\!@#\$%\^&\*\(\)_\+\{\}\|\:\"\<\>\?\-\=\[\];\'\/\.,\\\]/", $m_pwd)))
					{
						$error = "영문과 숫자가 1개 이상 포함되어야 합니다.";
					}	// if()
					break;

                case 3:
                    if (strlen($m_pwd) < 8)
                    {
                        $error = "8자 이상 입력해야 합니다.";
                    } else if (!preg_match('/[a-z]/', $m_pwd) || (!preg_match('/[A-Z]/', $m_pwd) && !preg_match("/[~`\!@#\$%\^&\*\(\)_\+\{\}\|\:\"\<\>\?\-\=\[\];\'\/\.,\\\]/", $m_pwd)))
                    {
                        //vd(preg_quote("~`!@#$%^&*()_+{}|:\"<>?-=[]\;'/.,"));  // "~`\!@#\$%\^&\*\(\)_\+\{\}\|\:"\<\>\?-\=\[\]\\;'/\.,"
                        $error = "영문소문자 1개 이상, 영문대문자나 특수문자가 1개 이상 포함되어야 합니다.";
                    }	// if()
                    break;

				default:		// 4
                    $length = $G_SYS['S_PASS_MIN_LENGTH'];

                    if (strlen($m_pwd) < $length)
                    {
                        $error = $length . "자 이상 입력해야 합니다.";
                    } else if (! (preg_match('/[a-zA-Z]/', $m_pwd) && preg_match('/[0-9]/', $m_pwd) && preg_match("/[~`\!@#\$%\^&\*\(\)_\+\{\}\|\:\"\<\>\?\-\=\[\];\'\/\.,\\\]/", $m_pwd)))
                    {
                        $error = "영문 대소문자, 숫자, 특수문자가 모두 포함되어야 합니다.";
                    }	// if()
					break;
			}	// switch()


			if ($error == '')
			{
				if (in_array($m_pwd, array('asdf', 'qwer', 'test', 'abcd', 'admin', 'password', 'abc123', 'qwerty', 'monkey', 'letmein', 'dragon', 'baseball', 'iloveyou', 'sunshine', 'master', 'welcome', 'shadow', 'ashley', 'football', 'jesus', 'michael', 'ninja', 'mustang', 'password1')))
				{
					$error = "유추하기 쉬운 단어로만(test,asdf,...) 사용할 수 없습니다.";
				}	// if()
			}	// if()
		}	// if()

		return $error;
	}	// function()

###############################################################################

	/**
	 * 비밀번호 최소 길이 구하기
	 *
	 * @return int|mixed
	 */
    function member_password_min_length()
    {
        global $G_SYS;
        $m_pwd_min_length = 0;
        if ($G_SYS['S_PASS_EVEL'] == 1) {
            $m_pwd_min_length = 6;
        } else if ($G_SYS['S_PASS_EVEL'] == 2) {
            $m_pwd_min_length = 6;
        } else if ($G_SYS['S_PASS_EVEL'] == 3) {
            $m_pwd_min_length = 8;
        } else if ($G_SYS['S_PASS_EVEL'] == 4) {
            $m_pwd_min_length = $G_SYS['S_PASS_MIN_LENGTH'];        // [서버 설정]에서 입력한 최소 길이 사용
        }

        return $m_pwd_min_length;
    }

###############################################################################


	/* Field table 의 정보가져오기
		ex) $mf = get_member_field();
	*/
	function get_member_field($key_type="NAME")
	{
		global $TB, $db, $G_SYS;

		$q = "SELECT mf.* FROM $TB[MEMBER_FIELD] mf WHERE d_no='".get_d_no($G_SYS['MAIL_DOMAIN'])."' ORDER BY mf.mbf_step, mf.mbf_no";
		//echo $q;
		$_mf = db_get_rows($q, true);

		$mf = NULL;

		switch($key_type)
		{
			case "NAME":
				for($i=0; $i<sizeof($_mf[mbf_no]); $i++)
				{
					$mf[$_mf[mbf_name][$i]][text] = lang_conv($_mf[mbf_text][$i]);
					$mf[$_mf[mbf_name][$i]][isuse] = $_mf[mbf_isuse][$i];
					$mf[$_mf[mbf_name][$i]][isnotnull] = $_mf[mbf_isnotnull][$i];
					$mf[$_mf[mbf_name][$i]][length] = $_mf[mbf_length][$i];
				}	// for()
				break;

			case "NO":
				for($i=0; $i<sizeof($_mf[mbf_no]); $i++)
				{
					$mf[name][$i] = $_mf[mbf_name][$i];
					$mf[text][$i] = $_mf[mbf_text][$i];
					$mf[isuse][$i] = $_mf[mbf_isuse][$i];
					$mf[isnotnull][$i] = $_mf[mbf_isnotnull][$i];
					$mf[length][$i] = $_mf[mbf_length][$i];
				}	// for()
				break;

			default:
				die(__FILE__ . "<br>get_member_field() 에서 [$key_type]은 존재하지 않는 key_type입니다.");
				break;
		}	// switch()

		return $mf;
	}	// function()


###############################################################################


	/**
		폼 설정하기

		ex) $mbr_form = set_form_mbr($mbr);		// array

		[2002-05-29]
		ex) $mbr_form = set_form_mbr();		// array

	*/
	function set_form_mbr($mbr=NULL)
	{
		global $CFG, $mode, $G, $AUTH, $UPLOAD_DIR;

		include_once("include/file.php");

		$mbr_form = NULL;


		// set join
			if ($mode == "JOIN")
			{
				//
			}	// if()


		// set default
			if (!$mbr[m_homepage]) $mbr[m_homepage] = "http://";
			if ($mbr[m_birthday] == "0000-00-00") $mbr[m_birthday] = NULL;
			if ($mbr[m_marrydate] == "0000-00-00") $mbr[m_marrydate] = NULL;

			if ($mbr[m_date1] == "0000-00-00") $mbr[m_date1] = NULL;
			if ($mbr[m_date2] == "0000-00-00") $mbr[m_date2] = NULL;
			if ($mbr[m_date3] == "0000-00-00") $mbr[m_date3] = NULL;
			if ($mbr[m_date4] == "0000-00-00") $mbr[m_date4] = NULL;
			if ($mbr[m_date5] == "0000-00-00") $mbr[m_date5] = NULL;

			if ($mbr[m_regdate] == "0000-00-00 00:00:00") $mbr[m_regdate] = NULL;
			if ($mbr[m_last_logindate] == "0000-00-00 00:00:00") $mbr[m_last_logindate] = NULL;
			if ($mbr[m_last_modifydate] == "0000-00-00 00:00:00") $mbr[m_last_modifydate] = NULL;


		// set all
			$mbr_form = $mbr;
			$mbr_form[m_id] = input_value($mbr[m_id], 1);
			$mbr_form[m_lostpwd_q] = input_value($mbr[m_lostpwd_q], 1);
			$mbr_form[m_lostpwd_a] = input_value($mbr[m_lostpwd_a], 1);
			$_as = array_search($AUTH['auth_m_level'], array_values($G[LEVEL]));
			// [2006-11-02] 관리자모드일때, 관리자는 서버관리자의 정보를 변경할 수 없도록함.
			$_LEVEL_NAME = $G[LEVEL_NAME];
			for ($i=1; $i<(sizeof($G[LEVEL])-$_as); $i++)
			{
				array_pop($_LEVEL_NAME);
			}	// for()
			$mbr_form[m_level] = select_list_value($mbr[m_level], array_values($_LEVEL_NAME), array_keys($_LEVEL_NAME), NULL, 1, 1);
			// [2025-09-08] 사번 항목 추가, MEMBER_FIELD 테이블의 m_emp_no 가져오도록 추가.
			$mbr_form[m_emp_no] = input_value($mbr[m_emp_no], 1);
			$mbr_form[m_name] = input_value($mbr[m_name], 1);
			$mbr_form[m_last_name] = input_value($mbr[m_last_name], 1);
			$mbr_form[m_email] = input_value($mbr[m_email], 1);
			$mbr_form[m_homepage] = input_value($mbr[m_homepage], 1);
			$_ex = explode("-", $mbr[m_jumin]);
			$mbr_form[m_jumin_1] = input_value($_ex[0], 1);
			$mbr_form[m_jumin_2] = input_value($_ex[1], 1);
			$mbr_form[m_jumin_user] = $_ex[0]."-*******";
			$mbr_form[m_sex] = radio_value("m_sex", $mbr[m_sex], array_values($G[SEX]), array_keys($G[SEX]), "defaultNone", 0, 1);
			$_exp_birthday = explode("-", $mbr[m_birthday]);
			$mbr_form[m_birthday_1] = input_value($_exp_birthday[0],1);
			$mbr_form[m_birthday_2] = input_value($_exp_birthday[1],1);
			$mbr_form[m_birthday_3] = input_value($_exp_birthday[2],1);
			$mbr_form[m_birthday_east] = radio_value("m_birthday_east", $mbr[m_birthday_east], array_values($G[BIRTHDAY_EAST]), array_keys($G[BIRTHDAY_EAST]), "defaultNone", 0, 1);
			$_exp_mobile = explode("-", $mbr[m_mobile]);
			$mbr_form[m_mobile_1] = input_value($_exp_mobile[0],1);
			$mbr_form[m_mobile_2] = input_value($_exp_mobile[1],1);
			$mbr_form[m_mobile_3] = input_value($_exp_mobile[2],1);
			$_exp_home_tel = explode("-", $mbr[m_home_tel]);
			$mbr_form[m_home_tel_1] = input_value($_exp_home_tel[0],1);
			$mbr_form[m_home_tel_2] = input_value($_exp_home_tel[1],1);
			$mbr_form[m_home_tel_3] = input_value($_exp_home_tel[2],1);
			$_exp_home_zipcode = explode("-", $mbr[m_home_zipcode]);
			$mbr_form[m_home_zipcode] = input_value($mbr[m_home_zipcode],1);
			$mbr_form[m_home_zipcode_1] = input_value($_exp_home_zipcode[0],1);
			$mbr_form[m_home_zipcode_2] = input_value($_exp_home_zipcode[1],1);
			$mbr_form[m_home_addr1] = input_value($mbr[m_home_addr1],1);
			$mbr_form[m_home_addr2] = input_value($mbr[m_home_addr2],1);
			$mbr_form[m_job] = select_list_value($mbr[m_job], $G[JOB], $G[JOB], "선택", 0, 1);
			$mbr_form[m_office] = input_value($mbr[m_office],1);
			$mbr_form[m_office_subject] = input_value($mbr[m_office_subject],1);
			$_exp_office_tel = explode("-", $mbr[m_office_tel]);
			$mbr_form[m_office_tel_1] = input_value($_exp_office_tel[0],1);
			$mbr_form[m_office_tel_2] = input_value($_exp_office_tel[1],1);
			$mbr_form[m_office_tel_3] = input_value($_exp_office_tel[2],1);
			$_exp_office_fax = explode("-", $mbr[m_office_fax]);
			$mbr_form[m_office_fax_1] = input_value($_exp_office_fax[0],1);
			$mbr_form[m_office_fax_2] = input_value($_exp_office_fax[1],1);
			$mbr_form[m_office_fax_3] = input_value($_exp_office_fax[2],1);
			$_exp_office_zipcode = explode("-", $mbr[m_office_zipcode]);
			$mbr_form[m_office_zipcode] = input_value($mbr[m_office_zipcode],1);
			$mbr_form[m_office_zipcode_1] = input_value($_exp_office_zipcode[0],1);
			$mbr_form[m_office_zipcode_2] = input_value($_exp_office_zipcode[1],1);
			$mbr_form[m_office_addr1] = input_value($mbr[m_office_addr1],1);
			$mbr_form[m_office_addr2] = input_value($mbr[m_office_addr2],1);
			$mbr_form[m_ismarry] = radio_value("m_ismarry", $mbr[m_ismarry], array_values($G[ISMARRY]), array_keys($G[ISMARRY]), "defaultNone", 0, 1);
			$_exp_marrydate = explode("-", $mbr[m_marrydate]);
			$mbr_form[m_marrydate_1] = input_value($_exp_marrydate[0],1);
			$mbr_form[m_marrydate_2] = input_value($_exp_marrydate[1],1);
			$mbr_form[m_marrydate_3] = input_value($_exp_marrydate[2],1);
			$mbr_form[m_isremail] = select_list_value($mbr[m_isremail], array_values($G[ISREMAIL]), array_keys($G[ISREMAIL]), NULL, 0, 1);
			$mbr_form[m_memo] = htmlspecialchars_fix($mbr[m_memo]);
			$mbr_form[m_etc1] = input_value($mbr[m_etc1],1);
			$mbr_form[m_etc2] = input_value($mbr[m_etc2],1);
			$mbr_form[m_etc3] = input_value($mbr[m_etc3],1);
			$mbr_form[m_etc4] = input_value($mbr[m_etc4],1);
			$mbr_form[m_etc5] = input_value($mbr[m_etc5],1);

			$_exp_date1 = explode("-", $mbr[m_date1]);
			$mbr_form[m_date1_1] = input_value($_exp_date1[0],1);
			$mbr_form[m_date1_2] = input_value($_exp_date1[1],1);
			$mbr_form[m_date1_3] = input_value($_exp_date1[2],1);
			$_exp_date2 = explode("-", $mbr[m_date2]);
			$mbr_form[m_date2_1] = input_value($_exp_date2[0],1);
			$mbr_form[m_date2_2] = input_value($_exp_date2[1],1);
			$mbr_form[m_date2_3] = input_value($_exp_date2[2],1);
			$_exp_date3 = explode("-", $mbr[m_date3]);
			$mbr_form[m_date3_1] = input_value($_exp_date3[0],1);
			$mbr_form[m_date3_2] = input_value($_exp_date3[1],1);
			$mbr_form[m_date3_3] = input_value($_exp_date3[2],1);
			$_exp_date4 = explode("-", $mbr[m_date4]);
			$mbr_form[m_date4_1] = input_value($_exp_date4[0],1);
			$mbr_form[m_date4_2] = input_value($_exp_date4[1],1);
			$mbr_form[m_date4_3] = input_value($_exp_date4[2],1);
			$_exp_date5 = explode("-", $mbr[m_date5]);
			$mbr_form[m_date5_1] = input_value($_exp_date5[0],1);
			$mbr_form[m_date5_2] = input_value($_exp_date5[1],1);
			$mbr_form[m_date5_3] = input_value($_exp_date5[2],1);

			if($mbr[m_file1]) $mbr_form[m_file1] = "<a href='" . file_down_url($mbr[m_file1], $mbr[m_no], $UPLOAD_DIR[MEMBER]) . "'>" . $mbr[m_file1] . "</a> -> " . file_size($mbr[m_file1], $mbr[m_no], $UPLOAD_DIR[MEMBER]) . "<br>";
			if($mbr[m_file2]) $mbr_form[m_file2] = "<a href='" . file_down_url($mbr[m_file2], $mbr[m_no], $UPLOAD_DIR[MEMBER]) . "'>" . $mbr[m_file2] . "</a> -> " . file_size($mbr[m_file2], $mbr[m_no], $UPLOAD_DIR[MEMBER]) . "<br>";
			if($mbr[m_file3]) $mbr_form[m_file3] = "<a href='" . file_down_url($mbr[m_file3], $mbr[m_no], $UPLOAD_DIR[MEMBER]) . "'>" . $mbr[m_file3] . "</a> -> " . file_size($mbr[m_file3], $mbr[m_no], $UPLOAD_DIR[MEMBER]) . "<br>";
			if($mbr[m_file4]) $mbr_form[m_file4] = "<a href='" . file_down_url($mbr[m_file4], $mbr[m_no], $UPLOAD_DIR[MEMBER]) . "'>" . $mbr[m_file4] . "</a> -> " . file_size($mbr[m_file4], $mbr[m_no], $UPLOAD_DIR[MEMBER]) . "<br>";
			if($mbr[m_file5]) $mbr_form[m_file5] = "<a href='" . file_down_url($mbr[m_file5], $mbr[m_no], $UPLOAD_DIR[MEMBER]) . "'>" . $mbr[m_file5] . "</a> -> " . file_size($mbr[m_file5], $mbr[m_no], $UPLOAD_DIR[MEMBER]) . "<br>";

			$mbr_form[m_file1_old] = input_value($mbr[m_file1],1);
			$mbr_form[m_file2_old] = input_value($mbr[m_file2],1);
			$mbr_form[m_file3_old] = input_value($mbr[m_file3],1);
			$mbr_form[m_file4_old] = input_value($mbr[m_file4],1);
			$mbr_form[m_file5_old] = input_value($mbr[m_file5],1);

		return $mbr_form;
	}	// function()


###############################################################################


	/**
		현재접속자 정보가져오기

		[2002-06-07]
		ex) $mc = get_mc($AUTH[auth_m_no]);		// 현재접속자 정보가져오기

	*/
	function get_mc($m_no)
	{
		global $db, $G, $G_MB, $TB, $_SERVER;

		$query = "SELECT * FROM $TB[MEMBER_CONNECT] WHERE m_no='$m_no' ORDER BY mc_date DESC LIMIT 1";
		//echo "<HR>" . $query;
		$mc = db_get_row($query);

		return $mc;

	}	// function()


###############################################################################


	/**
		현재접속자 갱신

		[2002-06-07]
		ex) member_connect_update($mc, $AUTH[auth_m_no]);		// 현재접속자 갱신

	*/
	function member_connect_update($mc, $m_no)
	{
		global $db, $G, $G_MB, $TB, $_SERVER;

		if ($mc)
		{
			// 현재접속자 갱신
				$query = "UPDATE $TB[MEMBER_CONNECT] SET mc_date = '" . time() . "', mc_host = '" . $_SERVER["REMOTE_ADDR"] . "' WHERE m_no='$m_no'";
				//echo "<HR>" . $query;
				db_query($query);
		} else
		{
			// 현재접속자 추가
				$query = "INSERT INTO $TB[MEMBER_CONNECT] VALUES ('$m_no', '" . time() . "', '" . $_SERVER["REMOTE_ADDR"] . "')";
				//echo "<HR>" . $query;
				db_query($query);
		}	// if()

	}	// function()


###############################################################################


	/**
		현재접속자 처리

		[2002-06-07]
		ex) member_connect_process($auth_mode);		// 현재접속자 처리

	*/
	function member_connect_process($auth_mode)
	{
		global $db, $G, $G_MB, $TB, $AUTH, $_SERVER;


		// 현재접속자 삭제
			$query = "DELETE FROM $TB[MEMBER_CONNECT] WHERE mc_date < '" . date("Y-m-d H:i:s", time() - $G_MB[CONNECT_LIMIT_TIME]) . "'";
			//echo "<HR>" . $query;
			db_query($query);


		// 로그인한 사용자만 현재접속자에 추가/갱신
			if ($auth_mode == "LOGIN")		// 로그인시
			{
				$mc = get_mc($AUTH[auth_m_no]);		// 현재접속자 정보가져오기
				member_connect_update($mc, $AUTH[auth_m_no]);		// 현재접속자 갱신

			} else if ($AUTH[auth_m_id])		// 로그인이후 페이지접근시
			{
				$mc = get_mc($AUTH[auth_m_no]);		// 현재접속자 정보가져오기

				// 이중로그인 방지 - 현재 호스트와 마지막 접근호스트가 다를 경우 경고후 로그아웃시킴.
					if (($mc)&&($mc[mc_host] != $_SERVER["REMOTE_ADDR"]))
					{
						msg("다른 컴퓨터(" . $mc[mc_host] . ")에서 로그인하였으므로 자동 로그아웃됩니다.\\n\\n비밀번호가 유출된 경우 개인정보란에서 새비밀번호로 변경하시기 바랍니다.\\n\\n다른 컴퓨터에서 사용후 로그아웃하지 않아서 발생한 문제일 수 도 있으니\\n\\n사용후엔 반드시 로그아웃을 해주시기 바랍니다.", 0);
						auth_proc("LOGOUT");
					} else
					{
						member_connect_update($mc, $AUTH[auth_m_no]);		// 현재접속자 갱신
					}		// if()

			}	// if()

	}	// function()


###############################################################################


	/**
		현재접속자 로그아웃

		[2002-06-07]
		ex) member_connect_logout();		// 현재접속자 로그아웃

	*/
	function member_connect_logout()
	{
		global $db, $TB, $AUTH;

		// 현재접속자 삭제
			$query = "DELETE FROM $TB[MEMBER_CONNECT] WHERE m_no='$AUTH[auth_m_no]' AND mc_host = '" . $_SERVER["REMOTE_ADDR"] . "'";
			//echo "<HR>" . $query;
			db_query($query);

	}	// function()


###############################################################################


?>