	function mail_del(mb_id)
	{
		var msg = "";
		var res = true;
		var form = document.list;

 		if (countCheckBox(form, 'cmf[]') < 1)
 		{
			alert("삭제할 메일들을 선택하여 주십시오.");
			return;
 		}

		if (mb_id != 'trash')
		{
			//res = confirm("선택한 메일들을 삭제하시겠습니까?");
		}else
		{
			res = confirm("선택한 메일들을 영구히 삭제하시겠습니까?");
		}
		if (res == true)
		{
			form.action = nmpath + "/mail_del.php?" + get_qs;
			form.method = "post";
			form.submit();
		}
	}	// function

	function mail_move(mb_id)
	{
		var msg = "";
		var res = true;
		var form = document.list;

 		if (countCheckBox(form, 'cmf[]') < 1)
 		{
			alert("이동할 메일들을 선택하여 주십시오.");
			form.sel_mail_box[0].selected = true;
			if (form.sel_mail_box_2[0])
				form.sel_mail_box_2[0].selected = true;
			return;
 		}

		if (mb_id == form.sel_mail_box.value)
		{
			alert("동일한 편지함으로는 이동할 수 없습니다.");
			return;
		}

		//res = confirm("선택한 메일들을 이동하시겠습니까?");
		if (res == true)
		{
			form.action = nmpath + "/mail_move_ok.php?" + get_qs;
			form.method = "post";
			form.submit();
		}
	}	// function

	// [2011-03-29] 계속이동 버튼 추가
	function mail_move2()
	{
		var msg = "";
		var res = true;
		var form = document.list;

 		if (countCheckBox(form, 'cmf[]') < 1)
 		{
			alert("계속이동할 메일들을 선택하여 주십시오.");
			return;
 		}

        // [2025-09-11] 보낸/임시/지운편지함은 제외
        if (['sent', 'draft', 'trash'].indexOf(form.sel_mail_box.value) !== -1) {
            alert("[" + form.sel_mail_box.options[form.sel_mail_box.selectedIndex].text + "](으)로는 계속이동할 수 없습니다.\n\n다른 편지함을 선택해주세요.");
            return;
        }

		if (confirm("선택한 메일들을 [" + form.sel_mail_box.options[form.sel_mail_box.selectedIndex].text + "](으)로 계속이동하시겠습니까?\n\n\n※ 계속이동 안내\n\n  - 앞으로 수신되는 메일들도 보낸사람주소를 기준으로 적용됩니다.\n\n  - 잘못 등록된 주소는 [환경설정 - 메일 자동분류]에서 수정이 가능합니다."))
		{
			form.action = nmpath + "/mail_move_ok.php?cmd=AUTO_FILTER&" + get_qs;
			form.method = "post";
			form.submit();
		}
	}	// function

    // [2020-12] 일괄이동
    function mail_move_batch()
    {
        var form = document.list;

        if(form.s_word.value=='' && (form.s_from.value=='' && form.s_to.value=='' && form.s_cc.value=='' && form.s_subject.value=='' && form.s_body.value=='' && form.s_attach.value=='')) {
            alert("키워드 검색 결과에서만 일괄 이동이 가능합니다.  ");
            return;
        }
        if (countCheckBox(form, 'cmf[]') < 1) {
            alert("일괄 이동할 메일의 일부를 선택하여 주십시오.  ");
            return;
        }
        if (confirm("조회된 메일들을 [" + form.sel_mail_box.options[form.sel_mail_box.selectedIndex].text + "](으)로 일괄이동하시겠습니까?\r\n\r\n※ 일괄이동 안내\r\n  - 현재 조회된 모든 메일들을 지정된 편지함으로 일괄 이동합니다.  \r\n  - 일괄 이동시 반드시 주의해서 진행하시기 바랍니다. "))
        {
            form.action = nmpath + "/mail_move_batch_ok.php?" + get_qs;
			form.method = "post";
			form.submit();
		}
	}	// function

	// [2012-04-18] 편지목록에서 전달 추가
	function mail_multiforward()
	{
		var msg = "";
		var res = true;
		var form = document.list;

		var cmf_cnt = countCheckBox(form, 'cmf[]');
 		if (cmf_cnt < 1)
 		{
			alert("전달할 메일들을 선택하여 주십시오.");
			return;
 		}

		if (cmf_cnt == 1)
		{
			var element = form.elements;
			var cnt = 0;
			var mf_no = 0;
			for (var eCount = 0; eCount < element.length; eCount++)
			{
				if (element[eCount].type == "checkbox" && element[eCount].name == 'cmf[]' && element[eCount].checked)
				{
					mf_no = element[eCount].value;
					break;
				}
			}
			location.href = nmpath + '/mail_write.php?mode=FORWARD&mf_no=' + mf_no + '&' + get_qs;
		} else
		{
			form.action = nmpath + "/mail_write.php?mode=MULTIFORWARD";
			form.method = "post";
			form.submit();
		}
	}	// function

	function mail_search()
	{
		var form = document.list;

		if (form_chk_value(form.s_word, "검색할 단어") == false) return;

		form.sel_mail_box.value = null;
		form.sel_mail_box_2.value = null;
		if (form.pageID)
			form.pageID.value = '';
 		if (countCheckBox(form, 'cmf[]') > 0)
 		{
			checkedCheckBoxClick(form, 'cmf[]');
 		}
		form.sd.value = '0';
		form.action = nmpath + "/mail_list.php";
		form.method = "get";
		form.submit();
	}	// function

	function mail_spam_no()
	{
		var msg = "";
		var res = true;
		var form = document.list;

 		if (countCheckBox(form, 'cmf[]') < 1)
 		{
			alert("메일들을 선택하여 주십시오.");
			return;
 		}

		res = confirm("선택한 메일들을 스팸아님으로 처리하시겠습니까?\n\n처리시 변경되는 내용 : \n\n  ☞ 받은편지함으로 이동.\n\n  ☞ 제목에서 [SPAM], [FAKE] 문구 제거.\n\n  ☞ 보낸사람의 주소를 '수신허용'목록에 추가.");
		if (res == true)
		{
			form.action = nmpath + "/mail_spam_no.php?" + get_qs;
			form.method = "post";
			form.submit();
		}
	}	// function

	function mail_list_cmd(form, cmd)
	{
		switch (cmd)
		{
			case 'MARK_READ':
				var form = document.list;
				if (form_chk_isChecked(form, "cmf[]", "메일") != false)
				{
					form.action = nmpath + "/mail_mark.php?mode=READ&" + get_qs;
					form.method = "post";
					form.submit();
				}
				break;

            case 'MARK_READ_ALL':
                var form = document.list;
                if (confirm("현재 편지함의 메일을 모두 읽음으로 표시하시겠습니까?"))
                {
                    form.action = nmpath + "/mail_mark.php?mode=READ_ALL&" + get_qs;
                    form.method = "post";
                    form.submit();
                }
                break;

			case 'MARK_UNREAD':
				var form = document.list;
				if (form_chk_isChecked(form, "cmf[]", "메일") != false)
				{
					form.action = nmpath + "/mail_mark.php?mode=UNREAD&" + get_qs;
					form.method = "post";
					form.submit();
				}
				break;

			case 'AUTO_FILTER':
				var form = document.list;
				if (form_chk_isChecked(form, "cmf[]", "메일") != false)
				{
					if (confirm("선택한 메일들을 [" + form.sel_mail_box.options[form.sel_mail_box.selectedIndex].text + "](으)로 자동분류(계속이동)하시겠습니까?\n\n\n※ 자동분류 안내\n\n  - 앞으로 수신되는 메일들도 보낸사람주소를 기준으로 적용됩니다.\n\n  - 잘못 등록된 주소는 [환경설정 - 메일 자동분류]에서 수정이 가능합니다."))
					{
						form.action = nmpath + "/mail_move_ok.php?" + get_qs;
						form.method = "post";
						form.submit();
					}
				}
				break;

			case 'MAIL_BACKUP':
				var form = document.list;
                if(form.mb_id.value!=""){
                    if (form_chk_isChecked(form, "cmf[]", "메일") != false)
                    {
                        if (confirm("선택한 메일들을 백업하시겠습니까?\n\n  - zip으로 압축된 파일을 다운로드받을 수 있게 됩니다.\n\n  - 백업파일을 압축하는데 다소 시간이 소요될 수 있습니다."))
                        {
                            form.action = nmpath + "/mail_box_backup_ok.php?" + get_qs;
                            form.method = "post";
                            form.submit();
                        }
                    }
                }else{
                    alert("전체메일 조회시 백업 기능이 지원되지 않습니다.  \n\n대상편지함을 조회후 실행바랍니다.  ");
                }
				break;

			case 'MAIL_BACKUP_2':
				var form = document.list;
				if (form_chk_isChecked(form, "cmf[]", "메일") != false)
				{
					nmail_download_activex('mail_list');
				}
				break;

			case 'MAIL_RESTORE':
                var form = document.list;
                if(form.mb_id.value!=""){
				    window_open(nmpath + '/mail_box_restore.php?' + get_qs, '', 500, 400);
                }else{
                    alert("전체메일 조회시 복구 기능이 지원되지 않습니다.  \n\n대상편지함을 조회후 실행바랍니다.  ");
                }
				break;

			case 'PAGE_20':
				location.href = nmpath + '/mail_list.php?page_size=20&' + get_qs.replace(/page_size\=[0-9]+\&/gi, '');
				break;

			case 'PAGE_50':
				location.href = nmpath + '/mail_list.php?page_size=50&' + get_qs.replace(/page_size\=[0-9]+\&/gi, '');
				break;

			case 'PAGE_100':
				location.href = nmpath + '/mail_list.php?page_size=100&' + get_qs.replace(/page_size\=[0-9]+\&/gi, '');
				break;

            case 'PAGE_200':
                location.href = nmpath + '/mail_list.php?page_size=200&' + get_qs.replace(/page_size\=[0-9]+\&/gi, '');
                break;

            case 'PAGE_500':
                location.href = nmpath + '/mail_list.php?page_size=500&' + get_qs.replace(/page_size\=[0-9]+\&/gi, '');
                break;

            case 'PAGE_1000':
                location.href = nmpath + '/mail_list.php?page_size=1000&' + get_qs.replace(/page_size\=[0-9]+\&/gi, '');
                break;

            case 'PAGE_2000':
                location.href = nmpath + '/mail_list.php?page_size=2000&' + get_qs.replace(/page_size\=[0-9]+\&/gi, '');
                break;



            default:
				//alert("존재하지 않는 부가 기능입니다.");
				break;
		}
		form.cmd[0].selected = true;

		// [2011-03-02] 읽기 창 보여주기
		if (form.cmd_2[0])
			form.cmd_2[0].selected = true;
	}

	// [2007-11-06] 상세검색
	function mail_search_detail()
	{
		var form = document.list;

		if (form_chk_date(form.sd1, "기간") == false) return;
		if (form_chk_date(form.sd2, "기간") == false) return;
		if (form_compare_date(form.sd1, form.sd2, "기간") == false) return;

		form.sel_mail_box.value = null;
		form.sel_mail_box_2.value = null;
		if (form.pageID)
			form.pageID.value = '';
 		if (countCheckBox(form, 'cmf[]') > 0)
 		{
			checkedCheckBoxClick(form, 'cmf[]');
 		}
		form.sd.value = '1';
		form.action = nmpath + "/mail_list.php";
		form.method = "get";
		form.submit();
	}	// function

	function mail_search_detail_click()
	{
		if (document.all.mail_search_detail.style.display == 'none')
		{
			document.all.mail_search.style.display = 'none';
			document.all.mail_search_detail.style.display = '';
		} else
		{
			document.all.mail_search.style.display = '';
			document.all.mail_search_detail.style.display = 'none';
		}	// if()
	}	// function

	// [2011-03-02] 읽기 창 보여주기
	function ml_type_change(ml_type)
	{
		var expDate = new Date();
		expDate.setDate(expDate.getDate() + 3650);
		document.cookie = 'nm_ml_type='+ml_type+';expires='+expDate.toGMTString();
		location.reload();
	}	// function()

	function ml_page_height_sync(cookie_height)
	{
		var _height = 0;
		if (cookie_height > 0 && $("#ml_split").length > 0)
		{
			$("#ml_list").outerHeight(cookie_height);

			_height = $(window).height() - $("#nm_layout_bottom").outerHeight() - $("#ml_list_head").position().top - $("#ml_list_head").outerHeight() - $("#ml_pager").outerHeight() - 20;
			_height = _height - $("#ml_split").outerHeight() - $("#ml_list").outerHeight() - 20;

			$("#ml_read").outerHeight(_height);
		} else
		{
			_height = $(window).height() - $("#nm_layout_bottom").outerHeight() - $("#ml_list_head").position().top - $("#ml_list_head").outerHeight() - $("#ml_pager").outerHeight() - 20;

			if ($("#ml_split"))
				_height = _height - $("#ml_split").outerHeight() - $("#ml_read").outerHeight() - 20;

			$("#ml_list").outerHeight(_height);
		}
	}

	function ml_list_click(mf_no, mf_is_read, ii, url)
	{
		if (mf_is_read == 'N')
		{
			$("#tr"+mf_no).removeClass('main_table_body_N'+ii);
			$("#tr"+mf_no).addClass('main_table_body_Y'+ii);
			$("#ms"+mf_no).html('<img src=img/mail_read.gif border=0 alt="읽은 메일">');
		}
		$("#ml_read_notice").hide();
		ml_read_iframe.location.href = url;
	}

	function ml_list_status_update(mf_no)
	{
		if ($("#tr"+mf_no) && ($("#tr"+mf_no).hasClass('main_table_body_N0') || $("#tr"+mf_no).hasClass('main_table_body_N1')))
		{
			if ($("#tr"+mf_no).hasClass('main_table_body_N0'))
			{
				$("#tr"+mf_no).removeClass('main_table_body_N0');
				$("#tr"+mf_no).addClass('main_table_body_Y0');
			}
			if ($("#tr"+mf_no).hasClass('main_table_body_N1'))
			{
				$("#tr"+mf_no).removeClass('main_table_body_N1');
				$("#tr"+mf_no).addClass('main_table_body_Y1');
			}
			$("#ms"+mf_no).html('<img src=img/mail_read.gif border=0 alt="읽은 메일">');
		}
	}

    /**
     * 중요 메일 체크 기능
     * - 페이지 새로 고침 없이 클릭시 중요메일 지정
     * @param mf_no
     */
    function mail_star_click(mf_no)
    {
        $.ajax({
            url: nmpath + '/mail_star_ok.php',
            type: 'POST',
            data: {
                'mf_no': mf_no,
            },
            success: function (response) {
                var mail_star = document.getElementById('mail_star_' + mf_no);

                var span = document.querySelector('#mail_star_' + mf_no + ' .bi');
                var mail_star_cnt = document.getElementById('mail_star_cnt');
                if (mail_star_cnt) {
                    var count = Number(mail_star_cnt.innerText.replace(/,/g, ''));
                }

                if (mail_star.classList.contains('on')) {
                    mail_star.classList.remove('on');

                    span.classList.remove('bi-star-fill');
                    span.classList.add('bi-star');

                    if (mail_star_cnt) {
                        mail_star_cnt.innerText = (count - 1).toLocaleString();
                    }
                } else {
                    mail_star.classList.add('on');

                    span.classList.remove('bi-star');
                    span.classList.add('bi-star-fill');

                    if (mail_star_cnt) {
                        mail_star_cnt.innerText = (count + 1).toLocaleString();
                    }
                }
            }
        });
    }

    $(function () {
        mail_preview_event();
    })

    /**
     * 메일 목록에서 상태 아이콘 클릭시 읽음/읽지않음 처리
     *
     * @param mf_no
     * @param mb_id
     */
    function mail_list_status_icon_change(mf_no, mb_id) {
        $.ajax({
            url: nmpath + '/mail_list_status_icon_change_ok.php',
            type: 'POST',
            data: {
                'mf_no': mf_no,
            },
            success: function (response) {
                if (response.success === false) {
                    var message = response.message.replace(/\\n/g, '\n');
                    alert(message);
                    return false;
                }

                var $origin = $('#tr' + mf_no),
                    origin = $origin.attr('class'),
                    mail_noread_cnt = document.getElementById('mail_noread_cnt'),
                    inb_body_cnt = document.querySelector('.mail-status-noread .count'),
                    $left_menu = $('.mail-left-menu .navbar-link[data-id="' + mb_id + '"] .mail-unread-count'),
                    change_class,
                    count,
                    inb_count,
                    left_menu_count;

                if (mail_noread_cnt) {
                    count = Number(mail_noread_cnt.innerText.replace(/,/g, ''));
                }

                if (inb_body_cnt) {
                    inb_count = Number(inb_body_cnt.innerText.replace(/,/g, ''));
                }

                if ($left_menu.length > 0) {
                    left_menu_count = Number($left_menu.text().replace(/,/g, ''));
                }

                if (response.mf_is_read === 'N') { // 읽지 않음.
                    // 클래스 수정
                    change_class = origin.replace('_Y', '_N');
                    $origin.removeClass(origin).addClass(change_class);

                    // 아이콘 변경
                    $origin.find('.read-mail').removeClass('read-mail').addClass('unread-mail');
                    $origin.find('.bi.bi-envelope-open').removeClass('bi-envelope-open').addClass('bi-envelope-fill');

                    count++;
                    left_menu_count++;
                    inb_count++;
                } else { // 읽음.
                    // 클래스 수정
                    change_class = origin.replace('_N', '_Y');
                    $origin.removeClass(origin).addClass(change_class);

                    // 아이콘 변경
                    $origin.find('.unread-mail').removeClass('unread-mail').addClass('read-mail');
                    $origin.find('.bi.bi-envelope-fill').removeClass('bi-envelope-fill').addClass('bi-envelope-open');

                    count--;
                    left_menu_count--;
                    inb_count--;
                }

                // 개수 변경
                if (mail_noread_cnt) {
                    mail_noread_cnt.innerText = count.toLocaleString();
                }

                if (inb_body_cnt) {
                    inb_body_cnt.innerText = inb_count.toLocaleString();
                }

                if ($left_menu.length > 0) {
                    // 왼쪽 메뉴 개수가 0일 경우 빈 문자열 넣기
                    if (left_menu_count === 0) {
                        left_menu_count = '';
                    }
                    $left_menu.text(left_menu_count);
                }
            }
        });
    }
