<? if ( !defined("_INCLUDED_GLOBAL") ) exit;		// [Security]Allow_url_fopen = On ?>
<?


$HELP = array();
$HELP['SAFAQ']['MENU'] = array(
	#'MailServerDir' => '메일서버 디렉토리 구성',
	'MailServerScript' => '메일 서비스 시작 및 정지, 사용 포트(방화벽설정)',
	'MailServerConfig' => '메일서버 설정 안내',
	'MultiDomain' => '멀티도메인 추가 안내',
	'Backup' => '데이타 백업 안내',
	'SMTPRelay' => 'SMTP RELAY(외부 메일발송 권한) 설정',
	'blank1' => '',
	'AttachSize' => '편지쓰기시 최대 첨부파일 용량 조절 안내',
	'ClientAuth' => '메일클라이언트(아웃룩 등)사용시 인증방법에 대한 안내',
	'blank2' => '',
	'Sync' => '메일 파일과 디비의 동기화 안내',
	'Firewall' => '방화벽 사용시 유의사항',
	'ServerMove' => '서버 이전시 유의사항',
	'DbUpdate' => '디비에 저장된 데이타를 임의로 수정하고자 할때의 유의사항'
	);

$HELP['SAFAQ']['BODY'] = array(
	'MailServerDir' => '
☞ 메일 루트 디렉토리 : <font color="blue">'.dirname($G_SYS['PAGE_ROOT']).'</font>
<table width=500 cellspacing=1 cellpadding=5>
<tr class=main_table_body>
<td width=120 nowrap class=main_table_body_title>MailRoot/</td>
<td class=main_table_body>메일엔진 루트 디렉토리</td>
</tr>
<tr class=main_table_body>
<td width=120 nowrap class=main_table_body_title>MailRoot/domains/</td>
<td class=main_table_body>추가 프로그램(웹에디터)</td>
</tr>
<tr class=main_table_body>
<td width=120 nowrap class=main_table_body_title>data/</td>
<td class=main_table_body>게시판 첨부파일, 세션, 각종 임시파일저장</td>
</tr>
<tr class=main_table_body>
<td width=120 nowrap class=main_table_body_title>help/</td>
<td class=main_table_body>도움말</td>
</tr>
<tr class=main_table_body>
<td width=120 nowrap class=main_table_body_title>include/</td>
<td class=main_table_body>프로그램 라이브러리</td>
</tr>
</table>
',

	'MailServerScript' => '
<b>☞ 메일 서비스 시작 및 정지 안내</b>
	Rocky 8, CentOS 7)
		systemctl 명령을 통해 상태(status), 정지(stop), 시작(start), 재시작(restart) 이 가능합니다.
			※ 메일 엔진 재시작 : systemctl restart <strong>xmail</strong>
	
		# Nginx + PHP + MariaDB
		systemctl status <strong>nginx php70-php-fpm mariadb</strong>
			※ 서버에 따라 nginx 대신 httpd(apache), mysql 로 구성된 경우도 있습니다.

		# 메일 엔진(SMTP, POP3)
		systemctl status <strong>xmail</strong>

		# 엔메일 에이전트 (발송수 제한, 예약 발송, 스팸 업데이트 등)
		systemctl status <strong>nmailagent</strong>

		# 바이러스 차단 엔진 및 자동 업데이트 (바이러스 차단 모듈 포함시)
		systemctl status <strong>clamd@scan clamav-freshclam</strong>

	CentOS 6) 
		/etc/init.d/xmail start - 시작
			※ 설치할때 부팅시 자동시작되도록 셋팅됩니다.
		/etc/init.d/xmail stop - 종료
		/etc/init.d/xmail restart - 재시작
			※ 종료나 재시작시 처리중인 메일이 있을 경우 수초이상 지연되는 경우도 있습니다.
		/etc/init.d/nmailagent restart - NmailAgent 재시작(업데이트이후 재시작 필요)

<b>☞ 메일서버 실행 프로세스 확인</b>
	ps -ef|grep XMail

<b>☞ 메일서버 사용 포트 확인</b>
	25 - SMTP, 다른 서버에서 메일수신을 위해 사용.
	80, 443 - WWW, 웹메일
	587, 465 - SMTP, 아웃룩 등의 메일 클라이언트에서 메일 보내기시 사용
	110, 995 - POP3, 아웃룩 등의 메일 클라이언트에서 메일 받기시 사용 
	6017 (CTRL) - 메일서버를 웹상에서 컨트롤하기 위한 포트로 내부에서만 접속되므로 방화벽에서 오픈할 필요는 없습니다.
		※ <a href="https://www.passkorea.net/nmail-php-faq/49797" target="_blank">메일 서비스 방화벽 허용 포트 및 보안 연결 포트 상세 안내</a>

<b>☞ 다른 메일서버가 설치되어 있을때의 유의사항</b>
	메일서버들은 정상적인 SMTP/POP3 서비스를 위해 표준으로 25/110번 포트를 사용하게 됩니다.
	이로 인해 다른 postfix, sendmail, qmail 등 메일서버가 동작중일 경우 포트 충돌로 인해 문제가 발생하게 됩니다.
	따라서 기존 메일서버를 종료하고 부팅시 자동실행되지 않도록 조치한 다음 메일서버를 재시작해야 합니다.
	Rocky 8, CentOS 7)
		systemctl disable --now postfix
	
	CentOS 6) 
		# 부팅시 자동실행 방지.(보통 sendmail, ipop3 를 사용함)
		/sbin/chkconfig sendmail off
		/sbin/chkconfig ipop3 off
		/sbin/chkconfig postfix off
		/sbin/chkconfig courier-imap off
		# 기존 메일서비스용 데몬 종료.
		/etc/init.d/sendmail stop
		/etc/init.d/xinetd reload
		/etc/init.d/postfix stop
		/etc/init.d/courier-imap stop
',

	'MailServerConfig' => '
<b>☞ 재전송 시도 횟수 및 간격</b>
	기본값은 <u>120초간격으로 5회동안 재시도</u> 하도록 설정되어 있습니다.
	이 값을 <u>60초간격으로 10회동안 재시도 하도록 변경하려면</u>
	메일서버 실행 스크립트에서 다음처럼 옵션을 변경후 메일서버를 재시작해야 합니다.
	vi /etc/init.d/xmail
		XMAIL_CMD_LINE="-Mr 24 -Pl -Sl -Ql -Qg -Yl -Fl -Cl -Ll <font color=navy><b>-Qt 120 -Qr 5</b></font> -St 300 -Pt 300 -Se 3600 -QT 900 -Qn 16 -Mx 3 -CX 1024 -Pw 10 -SI 0.0.0.0:25 -SI 0.0.0.0:587"
		=>
		XMAIL_CMD_LINE="-Mr 24 -Pl -Sl -Ql -Qg -Yl -Fl -Cl -Ll <font color=red><b>-Qt 60 -Qr 10</b></font> -St 300 -Pt 300 -Se 3600 -QT 900 -Qn 16 -Mx 3 -CX 1024 -Pw 10 -SI 0.0.0.0:25 -SI 0.0.0.0:587"
		
	Rocky 8, CentOS 7)
		systemctl restart xmail	
	
	CentOS 6)	
		/etc/init.d/xmail restart

<b>☞ 메일송수신 최대용량 조절</b>
	<a href="'.$nmpath.'/sserver_config.php">[메일서버관리 - 서버 설정]</a>에서 <u>메일송수신 최대용량</u>을 수정하시면 됩니다.
	<a href="'.$_SERVER['REQUEST_URI'].'#AttachSize">★ "'.$HELP['SAFAQ']['MENU']['AttachSize'].'"와 관련이 있습니다.</a>

<b>☞ 리턴메일에 표시되는 메일서버 관리자 주소 변경</b>
	메일전송에 실패한 경우 사용자에게 리턴메일을 보낼때 보낸 사람주소는
	<a href="'.$nmpath.'/sserver_config.php">[메일서버관리 - 서버 설정]</a>에서 <u>메일서버 관리자 주소</u>를 수정하시면 됩니다.

<b>☞ 메일서버 접속시 보여지는 기본 도메인 변경</b>
	메일서버의 25, 110번 포트에 접속할때 보여지는 도메인은
	<a href="'.$nmpath.'/sserver_config.php">[메일서버관리 - 서버 설정]</a>에서 <u>기본 도메인</u>을 수정하시면 됩니다.
',

	'MultiDomain' => '
1. "서버관리자"레벨로 로그인후 [메일서버관리 - 도메인관리]에서 새로운 도메인을 추가하고,
	[메일서버관리 - 전체회원관리 - 메일계정 추가]에서 새로운 도메인의 "관리자"를 추가합니다.
	일반사용자는 회원가입신청을 받은후 관리자가 "가입승인"을 하거나, "메일계정 추가"를 통해 직접 추가할 수 있습니다.

2. 웹서버의 가상호스트 연결 확인
	Nginx) server_name 이 1개 뿐일 경우, 나머지 도메인들도 모두 동일한 설정을 따르게 됩니다.
		/etc/nginx/conf.d/nmail2.conf
			    server_name mail.yourDomain.com
			    
			        ※ mail. 도메인을 모두 연결할 경우.  "server_name mail.*"

	Apache) 설정에서 가상호스트, 알리아스 설정을 확인합니다.
		엔메일 초기 설치시 다음 2가지 중 하나가 설정된 경우에는 모든 도메인에 적용되므로 추가 작업이 필요없습니다.
		그리고 멀티 도메인의 구분 기준은 사용자가 접속한 웹페이지 주소(http://...)입니다.
			a) <u>Apache 가상호스트.  (http://mail.YourDomain.com)</u>
				&lt;VirtualHost *>
					ServerAdmin postmaster@YourDomain.com
					DocumentRoot /home/nmail2/nmail
					ServerName mail.YourDomain.com
					<b>ServerAlias mail.*</b>
					#ServerAlias mail.MultiDomain1.com mail.MultiDomain2.com
					ErrorLog logs/nmail2.error_log
					TransferLog logs/nmail2.access_log
					&lt;Directory "/home/nmail2/nmail">
						Options MultiViews
						AllowOverride None
						Order allow,deny
						Allow from all
					&lt;/Directory>
				&lt;/VirtualHost>
	
			b) <u>Apache 알리아스.  (http://YourDomain.com/mail/)</u>
				<b>Alias /mail "/home/nmail2/nmail"</b>
				&lt;Directory "/home/nmail2/nmail">
					Options None
					AllowOverride None
					Order allow,deny
					Allow from all
				&lt;/Directory>

3. DNS 서버에서 새로운 도메인의 MX 레코드를 추가한후 IP는 메일서버 IP로 지정합니다.
	MX 레코드 조회방법)
		nslookup -type=MX YourDomain.com
			YourDomain.com   preference = 10, <u>mail exchanger = mail.YourDomain.com</u>
			<u>mail.YourDomain.com      internet address = 111.112.113.114</u>
	주의사항)
		간혹 MX 레코드를 mail.YourDomain.com 처럼 도메인이름 형태가 아닌 IP(111.112.113.114)를 바로 지정하는 경우가 있는데,
		이 경우 일부 Linux/Unix 기반의 메일서버로부터 메일을 받지 못할 가능성이 있습니다.
',

	'Backup' => '
<b>☞ 2.4.0 ~ 2.5.0 버전의 업로드 데이타 백업 안내</b>
	<font color=red>2.4.0 부터 대용량첨부/웹하드/게시판 등의 업로드파일의 저장 경로가 바뀌었습니다.
	이로 인해 2.4.0 부터 2.5.0 버전까지는 업로드파일이 백업스크립트에 포함되어 있지 않습니다.
	따라서 2.4.0 이상 버전인데, 백업 후 nmail2_날짜.upload.tar.gz 가 없다면, 업로드 데이타를 수작업으로 백업해주셔야 합니다.</font>

		<font color=blue>업로드 데이타 저장 경로 - '.$UPLOAD_ROOT.'</font>

<b>☞ 메일 백업 방법</b>
	"디비, 메일데이타, 웹메일소스, 로그, 대용량첨부/웹하드/게시판 등의 업로드파일"로 구분하여 백업을 지원하고 있습니다.
	메일엔진에서 생성된 파일들은 root권한을 가지므로 <u>root권한으로 백업</u>을 하셔야 합니다.

	cd '.dirname($G_SYS['PAGE_ROOT']).'/_backup
	./backup.sh 
		Backup Start...
		DB Backup : nmail2_20060303_115855.sql.gz
		Source, Config Backup : nmail2_20060303_115855.src.tar.gz
		Mail Backup : nmail2_20060303_115855.mails.tar.gz
		Log Backup : nmail2_20060303_115855.logs.tar.gz
		Upload Backup : nmail2_20060303_115855.upload.tar.gz
		Backup Complete!

		<font color=red>주의) 백업 후 nmail2_날짜.upload.tar.gz 가 없다면, 업로드 데이타를 수작업으로 백업해주셔야 합니다.</font>

<b>☞ 메일 백업 저장 디렉토리 이동</b>
만약의 경우를 고려하여 메일이 설치된 파티션이 아닌 백업 전용 파티션으로 옮기는 것을 권장해드립니다.
특히 메일 데이타의 경우 사용량에 따른 백업파일의 크기증가에도 주의하셔야 합니다.

	vi backup.sh 
		# 백업파일을 보관할 디렉토리
		BACKUP_DIR='.dirname($G_SYS['PAGE_ROOT']).'/_backup/

<b>☞ 디비백업시 권한이 없거나 실행명령이 없다고 에러가 나올 경우</b>
	backup.sh 에서 디비 접속 계정 및 디비 클라이언트 경로를 확인해보시기 바랍니다.

<b>☞ 백업된 데이타, 디비의 확인</b>
	- tar.gz 형태의 파일을 압축한 경우 다른 디렉토리에 파일을 풀어서 제대로 풀리는지만 테스트해보시면 됩니다.
	- sql.gz 형태의 디비백업을 한 경우 서버설정에 따라 백업시 한글이 깨지는 경우가 있으므로 꼭 확인해보셔야 합니다.
		a) 파일을 PC로 다운로드받아 editplus, ultraedit 등의 에디터에서 열어서 확인하는 방법.(권장)
		b) 서버의 한글설정이 제대로 되어 있을때 쉘상에서 바로 확인하는 방법.
			# 한글설정 확인.   UTF-8 전용 엔메일이 아닌 경우 아래처럼 결과가 나와야 합니다.
			locale
				LANG=ko_KR.eucKR
			# CentOS 등 일부 시스템은 기본 UTF-8로 된 경우가 있는데 아래처럼 한글로 변경하면 됩니다.
			export LANG=ko_KR.eucKR
			# 압축을 풀어 백업된 파일에서 한글이 들어간 라인을 찾아 제대로 보이는지 확인.
			gunzip -c nmail2_20070402_105744.sql.gz|more

<b>☞ 백업된 디비의 한글이 깨진 경우의 문제해결방법</b>
	- MySQL 4.1 이상에서는 한글이 euckr로 별도 지정되지 않은 경우 백업시 한글이 깨지는 문제가 발생하게 됩니다.
	- 디비백업시 한글이 깨진 경우 아래처럼 백업스크립트를 변경하신후 다시 백업해서 테스트해보시면 됩니다.
		vi backup.sh
			MYSQLDUMP=mysqldump
			=>
			MYSQLDUMP="mysqldump --default-character-set=euckr"
	- 주의) 별도 요청하여 구매하신 UTF-8 용 엔메일의 경우 euckr 대신 utf8 을 입력하셔야 합니다.
',

	'SMTPRelay' => '
메일서버가 스패머들에서 악용되는 것을 방지하고자 <u>외부에서 임의로 메일을 발송할 수 없도록 제한</u>되어 있습니다.
아웃룩등의 메일 클라이언트를 사용하는 경우에는 사용자가 직접 인증을 거치기 때문에 설정할 필요가 없지만
<u>특정 IP에서 메일을 발송하는 툴이 있을 경우에는 인증을 거치지 않도록 해당 IP를 등록해두면 편리합니다.</u>

<a href="'.$nmpath.'/sadmin_ip.php?kind=RELAY">[메일서버관리 - SMTP Relay IP 관리]</a>에서 관리하실 수 있습니다.
',

	'AttachSize' => '
편지쓰기시 첨부파일의 메일용량은 대부분의 대형포털들처럼 <u>10MB로 제한</u>되어 있습니다.
메일의 경우 일반적인 파일 다운로드와는 다르게 별도의 인코딩을 거쳐 메일내에 첨부파일 형태로 붙게됩니다.
이로 인해 10MB짜리 첨부파일을 가진 메일의 실제크기는 약 13~15MB정도의 크기를 가지고 서버에 부하를 주게 됩니다.
이러한 이유로 많은 메일서버들이 첨부파일이 약 10MB를 넘을 경우 받지 않도록 하는 사례가 많으니 수정하지 않는 것이 좋습니다.

<u>특정 메일서버와의 대용량 메일을 주고 받아야 하는 경우에만 용량을 30MB 정도로 변경후 메일서버를 재시작</u>하시면 됩니다.
그러나 메일을 보내는 것은 가능하지만, 실제 메일을 받는 서버에서의 용량 제한에 의해 실패할 가능성도 있습니다.

이 설정은 <a href="'.$nmpath.'/sserver_config.php">[메일서버관리 - 서버 설정]</a>에서 <u>웹메일 첨부 최대용량</u>을 수정하시면 됩니다.

<a href="'.$_SERVER['REQUEST_URI'].'#MailServerConfig">★ "'.$HELP['SAFAQ']['MENU']['MailServerConfig'].'"에서 "메일송수신 최대용량 조절"과 관련이 있습니다.</a>
',

	'ClientAuth' => '
<b>☞ 다른 메일서버와의 차이점</b>
	메일클라이언트에서 <font color=red><u>계정 셋팅시 아이디를 적는 부분에 "id"가 아닌 "id@YourDomain.com"처럼 메일주소를 적으셔야 합니다.</u></font>
	이는 하나의 메일서버에서 멀티도메인을 지원하기 위해 달라진 사항입니다.

<b>☞ 메일발송시의 인증방식</b>
	<b>- SMTP AUTH</b>
		계정 셋팅시 [보내는 메일서버에 인증 필요]옵션을 체크해서 메일을 보낼때 
		입력한 아이디, 비밀번호로 인증을 거쳐서 보내기때문에 <u>가장 정확하고 권장하는 방법입니다.</u>
	<b>- POP3 BEFORE</b>
		계정 셋팅시 [보내는 메일서버에 인증 필요]옵션을 체크하지 않아도 되도록 사용자 편의를 위해 나온 기법입니다.
		메일클라이언트가 메일을 받아가기 위해 메일서버에 접속할때 해당 IP를 15분간 메일서버에서 보관하고 있다가
		해당 IP에서 메일을 보내려할때는 별도의 인증없이 IP로 구분해서 발송을 허용하는 방식입니다.
		<u>단, 일부 사용자의 경우 [X분 간격으로 자동 메일받기]등을 설정하지 않았거나, 받기 간격이 15분을 초과해서</u>
		<u>발송시 "550 Relay denied" 에러가 발생하는 경우가 있어 권장하지 않습니다.</u>
	<b>- RELAY ALLOW (SMTP RELAY)</b>
		등록된 IP 에서는 별도의 인증없이 발송을 허용하는 기법으로 특정 상황에서만 사용됩니다.
		자세한 내용은 [<a href="'.$_SERVER['REQUEST_URI'].'#SMTPRelay">'.$HELP['SAFAQ']['MENU']['SMTPRelay'].'</a>]에 나와 있습니다.

<a href="'.$nmpath.'/help.php?id=POP3">★ 메일클라이언트에서의 <u>계정 셋팅방법</u>과 <u>문제발생시 해결방법</u>은 사용자 도움말에 등록되어 있습니다.</a>
',

	'Sync' => '
웹메일에서의 빠른처리와 성능향상을 위해 <u>메일 데이타는 실제 파일외에 디비에 인덱스정보를 저장</u>하고 있습니다.
디비에서는 첨부파일을 제외한 메일헤더, 제목, 본문의 정보가 저장되어 있어서 향상된 정렬, 검색 기능이 지원됩니다.

웹메일에서 메일을 삭제할 경우 디비와 메일파일이 동시에 삭제되지만, 메일클라이언트에서 POP3 프로토콜을 통해
메일을 가져간 경우에는 메일파일만 삭제됩니다.  이러한 메일 파일과 디비와의 차이를 해결하고자 사용자가 웹메일에
로그인을 할때 디비와 메일파일의 일부비교해 서로 틀린 경우에는 메일파일을 기준으로 동기화작업을 하게 됩니다.

<u>만약 디비 에러 등으로 인해 동기화가 제대로 이루어지지 않았을 경우 아래 스크립트를 root 권한으로 실행하면 됩니다.</u>
	cd '.dirname($G_SYS['PAGE_ROOT']).'/tools/
	a) 도메인내의 모든 계정 동기화
		./mail_box_dbsync.php YourDomain.com
	b) 도메인내의 특정 계정만 동기화
		./mail_box_dbsync.php YourDomain.com userid
',

	'Firewall' => '
서버를 운영하기 위해서는 불필요한 포트에 대한 외부의 접근을 차단하기 위한 방화벽 운영이 필수입니다.
방화벽을 사용중이라면 메일서비스에 사용되는 포트들을 미리 방화벽에서 오픈해두어야 서비스에 문제가 없습니다.

<b>☞ 외부에서 내부로 접근하는 포트</b>
	tcp/25 - 메일 송수신에 사용되는 포트입니다.
	tcp/110 - 아웃룩등의 메일클라이언트에서 메일을 가져갈때 사용하는 포트입니다.
	tcp/80 - 웹메일 접속한 위한 웹서버 포트입니다.(80번이 표준이지만 간혹 다른 포트를 쓰는 경우도 있습니다.)
	tcp/53, udp/53 - 서버에 자체 DNS 서버가 설치되어 있을 경우에 한합니다.

<b>☞ 내부에서 외부로 나가는 포트</b>
	대부분 내부에서 외부로 나가는 포트는 제한하고 있지 않지만 간혹 제한하더라도 다음 포트는 꼭 열어두셔야 합니다.
	tcp/25 - 메일을 발송할때 외부메일서버의 25번 포트에 접속해야 합니다.
	tcp/53, udp/53 - 메일을 발송할때 받는사람의 도메인정보를 알아낼때 필요한 DNS 질의용 포트입니다.
',
	'ServerMove' => '
<b>☞ 이전방법</b>
	내장된 백업스크립트를 이용하면 소스,디비,메일데이타등을 모두 백업받을 수 있습니다.
	이 백업데이타를 가지고 동일한 디비계정 셋팅, Apache 실행그룹, php.ini 를 가진 서버로 옮긴다면 별다른 셋팅이 필요없을 수 도 있습니다.
	단, 새로운 서버의 OS, PHP 버젼이 다른 경우에는 이전 서버에서의 설치과정중 PHP mailparse, ioncube 모듈 설치가 다시 필요할 수 도 있습니다.

<b>☞ 엔메일 전용 계정 추가</b>
	엔메일과 관련된 파일들은 대부분 "nmail2"라는 전용 계정으로 셋팅되어 있습니다.   새로운 서버에서도 미리 해당 계정을 만들어주셔야 합니다.

<b>☞ 메일서버 설치경로</b>
	설치경로는 용량이 많은 파티션을 선택해서 할 수 있지만 프로그램내의 경로 호환을 위해 /home/nmail2 로 심볼릭링크를 걸고 있습니다.
	이로 인해 새로운 서버에서도 원하는 파티션에 설치한후에 심볼릭 링크만 제대로 걸어주시면 됩니다.
	예를 들어 /disk2 에 설치하셨다면 다음 명령을 통해 심볼릭 링크를 걸고 결과를 확인하시면 됩니다.
		ln -s /disk2 /home/nmail2
		ls -l /home/nmail2/nmail/index.php

<b>☞ 메일서버 재컴파일</b>
	메일서버의 경우 컴파일을 할때 Apache(웹서버)의 실행그룹을 헤더파일에 정의해두고 있었습니다.
	이로 인해 만약 서버를 옮긴후 Apache 의 실행그룹이 바뀐다면 재컴파일을 해야 합니다.
		ex) apache -> nobody, nobody -> apache 등...
	따라서 가능하다면 동일한 실행그룹을 가지도록 셋팅하는 것이 좋습니다.
	그리고 OS의 라이브러리 버젼이 호환되지 않아 재컴파일해야하는 경우가 있을 수 도 있습니다.

',
	'DbUpdate' => '
회원정보의 경우 "도메인정보, 아이디, 비밀번호, 메일용량, 포워딩정보, 자동응답"등의 일부정보는 
웹메일과 메일서버에 2중구조로 저장되어 있습니다.  이는 웹메일 자체의 기능을 이용하거나 
외부회원 연동모듈을 통해 제어를 하면 문제가 생기지 않습니다.

단 위 단계를 거치지 않고 바로 디비에서 해당 정보를 수정하게 되면 두 데이터간의 차이로 인해 
시스템에 예기치 못한 오류가 발생할 수 있으며 이에 대해서는 저희가 지원을 해드리기 어렵습니다.
꼭 수정해야 한다면 먼저 데이타를 백업받아둔후 소스를 충분히 검토한후 테스트를 거치시기 바랍니다.
<br style="line-height:200px">
'
	);




$HELP['RETURNMAIL']['MENU'] = array(
	'417' => '일시적인 전송 실패',
	'550_USER_UNKNOWN' => '받는사람이 존재하지 않는 경우',
	'550_USER_SUSPEND' => '받는사람이 사용중지된 경우',
	'552' => '받는사람의 메일용량이 초과된 경우',
	'550_USER_SPAM' => '받는사람의 스팸설정(수신거부)에 의해 차단된 경우',
	'550_RELAY_DENIED' => '메일발송권한이 없거나 상대방 메일서버 설정 문제',
	'MANY_SEND_DENIED' => '대량 메일 발송으로 인해 대형포털로부터 IP가 차단된 경우',
	'RBL' => 'RBL에 의해 차단된 경우',
	'553_SPAM' => '상대방 메일서버에서 스팸으로 인식해서 차단된 경우',
	'550_VIRUS' => '상대방 메일서버에서 바이러스로 인식해서 차단된 경우',
	'552_GOOGLE' => '첨부파일에 실행파일을 첨부할 수 없는 경우 - 구글',
	'LOOP' => '받는사람과 보낸사람에 문제가 있어 리턴메일이 반복되는 경우',
	'SERVER_SIZE_LIMIT' => '받는 메일서버에서 허용하는 최대메일크기를 초과한 경우',
	);

$HELP['RETURNMAIL']['MENU2'] = array(
	'417' => '417 Temporary delivery error|The maximum number of delivery attempts has been reached|End of socket stream data|Invalid server address|Bad server response',
	'550_USER_UNKNOWN' => '550 User unknown|550 Mailbox unavailable|550 5.1.1 No such user|554 delivery error: dd This user doesn\'t have a yahoo.co.kr account (userid@domain.com) [-5] - mta114.mail.krs.yahoo.com',
	'550_USER_SUSPEND' => '550 Account disabled|550 5.1.1 Inactive mbox|550 5.1.1 Suspended user|554 delivery error: dd Sorry your message to userid@domain.com cannot be delivered. This account has been disabled or discontinued [#102]. - mta115.mail.krs.yahoo.com',
	'552' => '552 Requested mail action aborted: exceeded storage allocation - &lt;userid@domain.com&gt;|The recipient\'s mailbox is full',
	'550_USER_SPAM' => '550 You are registered as spammer (by user\'s reject list)|554 5.0.0 Service unavailable (userid: mail is denied, by spam filter)',
	'550_RELAY_DENIED' => '550 Relay denied|554 Relay operation rejected|550 5.7.1 Unable to relay for userid@domain.com',
	'MANY_SEND_DENIED' => '550 5.7.1 &lt;userid@domain.com&gt;... Error.your access was denied.? Since you sent too many e-mails,you are not allowed to send more e-mails within 24 hours.After 24 hours,you can send e-mails as usual.If you did not send any e-mails,which is considered as a spam,you\'d better register|421 4.3.2 Your IP(111.112.113.114) is filtered and this connection will be closed. You must register your IP to http://realip.naver.com|421 4.3.1 You send too many messages.|5.1.0 - Unknown address error 550-\'Transaction failed. (SPAM_SUSPECT:IP_CONTROL) (http://cleanip.paran.com)\'|451 mta113.mail.krs.yahoo.com Resources temporarily unavailable. Please try again later [#4.16.5].',
	'RBL' => '421 4.3.2 Your ip is filtered by RBL (http://realip.naver.com/rbl/rblinfo.html)(IP:111.112.113.114)(Caues:http://dsbl.org/listing?111.112.113.114)|553 5.3.0 ... Rejected - see http://www.mail-abuse.org/rbl/|553-mail rejected because your IP is in DUL. See http://www.mail-abuse.com/enduserinfo.html',
	'553_SPAM' => '553 Blocked for spam|550 5.5.0 Your message was rejected.',
	'550_VIRUS' => '550 Virus in your mail!!!',
	'552_GOOGLE' => '552 5.7.0 Illegal Attachment 36si248323nzk+I9:I15',
	'LOOP' => 'Mail loop detected',
	'SERVER_SIZE_LIMIT' => 'Message size excedes the server limit',
	);

$HELP['RETURNMAIL']['BODY'] = array(
	'417' => '
<u>상대방 메일서버에 연결할 수 없을때 발생하는 에러로 일시적인 현상일 수 도 있습니다.</u>

리턴메일의 에러는 정해진 재전송횟수만큼 모두 실패했다는 의미입니다.
	[<00>] XMail bounce: Rcpt=[touser@to.com];Error=[The maximum number of delivery attempts has been reached]

리턴메일의 자세한 로그중 "ErrString" 항목에 따라 몇가지 원인으로 분류됩니다.
	[<04>] Here is listed the message log file:
	 
	[PeekTime] 1142791127 : Mon, 20 Mar 2006 02:58:47 +0900
	<<
	ErrCode = -162
	ErrString = <b>End of socket stream data</b>
	SMAIL SMTP-Send MX = "mx.to.com." SMTP = "from.com" From = "fromuser@from.com" To = "touser@to.com" Failed !
	SMTP-Error = "417 Temporary delivery error"
	SMTP-Server = "mx.to.com."
	>>

<b>a) End of socket stream data</b>
	DNS 질의를 통해 상대방 메일서버(MX record)를 찾았지만 메일서버에 접속할 수 없다는 의미입니다.

	이 경우 상대방 메일서버가 동작중이 아니거나 과도한 부하로 응답대기시간을 초과한 상태일 가능성이 높습니다.
	상대방 메일서버의 관리자가 조치를 취하지 않으면 별도의 해결방법이 없습니다.

	만약 대형포털등 다른 메일서버에서 상대방 메일서버로 메일이 잘 들어간다면 다음 문제일 가능성이 있습니다.

	-. 상대방 메일서버와의 네트워크 회선 문제.
		: 드물지만 일부 네트워크간에 속도가 아주 느려 문제가 발생하는 경우가 있습니다. 이 때는 메일서버가 설치된 네트워크와 
		  다른 외부 네트워크 두 곳에서 상대방 메일서버의 25번 포트를 열어서 속도를 비교해보면 됩니다.  만약 응답속도가 
		  현저하게 차이가 난다면 네트워크 관리업체에 문의해서 해결하시면 됩니다.

	-. 상대방 메일서버에서 별도의 조치를 취해둔 경우.
		: 드물지만 이 경우 상대방 메일서버 관리자에게 문의하셔서 해결하셔야 합니다.

<b>b) Invalid server address</b>
	받는사람의 도메인이 존재하지 않거나, 상대방 메일서버의 DNS 설정상의 문제가 있어 메일을 보낼 수 없는 상황입니다.
	주로 사용자들이 받는사람의 도메인을 잘못 적어서 발생한 경우가 많습니다.

<b>c) Bad server response</b>
	메일서버에서 인식할 수 없는 응답코드로 원인은 IP가 차단된 경우가 많습니다.
	이때는 "ErrString"대신 "SMTP-Error"항목을 가지고 [<a href="'.$_SERVER['REQUEST_URI'].'#MANY_SEND_DENIED">'.$HELP['RETURNMAIL']['MENU']['MANY_SEND_DENIED'].'</a>]에서 원인을 찾아보시면 됩니다.
',
	'550_USER_UNKNOWN' => '
<u>상대방 메일서버에 받는사람이 존재하지 않습니다.   메일주소를 다시 확인해보시기 바랍니다.</u>
다른 메일서버에서 보냈을때 실제로 존재하는 유저라면 메일서버의 셋팅에 관련된 문제일 수 도 있습니다.
예를 들어 domain.com 이 실제로 A 서버에서 사용하지만, 테스트 혹은 관리자의 실수로 B 서버에도
설정되어 있는 경우가 있습니다.  이때, B 서버에서 userid@domain.com 으로 메일을 보내게되면 
A 서버가 아닌 B 서버 내부로 메일 전송을 시도하기 때문에 받는사림이 존재하지 않는다고 나올 수 있습니다.
',
	'550_USER_SUSPEND' => '
상대방 메일서버에서 받는사람이 사용중지/휴면계정으로 처리된 상태이므로 메일을 보낼 수 없습니다.
',
	'552' => '
상대방 메일서버에서 받는사람의 메일저장용량이 초과되어 메일을 보낼 수 없습니다.
잠시후 다시 시도해보시거나 받는사람에게 다른 방법으로 연락해보시기 바랍니다.
',
	'550_USER_SPAM' => '
받는사람이 스팸설정 혹은 수신거부 목록에 보낸사람의 주소를 등록해두었을 가능성이 높습니다.
받는사람에게 다른 방법으로 연락해보시기 바랍니다.
',
	'550_RELAY_DENIED' => '
<b>☞ 같은 도메인을 제외한 다른 모든 메일서버에서 에러가 발생한 경우.</b>
사용자의 메일클라이언트(아웃룩 등)설정 문제일 가능성이 높습니다.   먼저 계정 셋팅시 [<u>보내는 메일서버에 인증 필요</u>]옵션을
체크했는지 확인해보시기 바랍니다.  자세한 내용은 <a href="'.$nmpath.'/help.php?id=POP3">[POP3 이용안내]</a>에 나와있습니다.

<b>☞ 특정 메일서버에서만 에러가 발생할 경우</b>
상대방 메일서버에서 DNS 설정 혹은 메일서버의 설정 오류로 인해 발생한 문제입니다.
상대방 메일서버의 관리자가 조치를 취하지 않으면 별도의 해결방법이 없습니다.
',
	'MANY_SEND_DENIED' => '
대형포털의 경우 IP를 등록해두지 않고 "1일 1,000통(시간당 100통) 이상의 대량 메일"을 보내면 IP가 차단될 가능성이 있습니다.
관리자가 대량 메일을 발송하지 않더라도 다음 경우에도 차단될 가능성이 높습니다.
1. 사용자가 대형포털로 포워딩을 설정해두면 하루에 1000통의 메일을 받을 경우 대형포털로 똑같이 1000통을 보내게 되므로 차단될 수 있습니다.
2. 사용자가 대형포털로 자동응답을 설정해두면 보낸사람주소를 대형포털로 위장한 스팸의 경우에는 대형포털로 자동응답을 계속 하게되므로 차단될 수 있습니다.

이로 인해 회원수나 사용량이 많은 곳에서는 각 대형포털사이트마다 IP등록을 해두시는것이 유리합니다.
이미 차단된 경우에는 각각 사이트에 방문하셔서 차단해지 신청을 하셔야 합니다.

<b>daum.net/hanmail.net</b> - <a href="http://ipregister.daum.net" target="_blank">http://ipregister.daum.net</a>
	error) 550 5.7.1 &lt;userid@domain.com&gt;... Error.your access was denied.? Since you sent too many e-mails,you are not allowed to send more e-mails within 24 hours.After 24 hours,you can send e-mails as usual.If you did not send any e-mails,which is considered as a spam,you\'d better register
<b>naver.com</b> - <a href="http://realip.naver.com" target="_blank">http://realip.naver.com</a>
	error) 421 4.3.2 Your IP(111.112.113.114) is filtered and this connection will be closed. You must register your IP to http://realip.naver.com
<b>nate.com</b> - <a href="http://antispam.nate.com" target="_blank">http://antispam.nate.com</a>
	error) 421 4.3.1 You send too many messages.
<b>paran.com</b> - <a href="http://cleanip.paran.com" target="_blank">http://cleanip.paran.com</a>
	error) 5.1.0 - Unknown address error 550-\'Transaction failed. (SPAM_SUSPECT:IP_CONTROL) (http://cleanip.paran.com)\'
<b>yahoo.com/yahoo.co.kr</b> - <a href="http://kr.antispam.yahoo.com/bulkmail.html" target="_blank">http://kr.antispam.yahoo.com/bulkmail.html</a>
	error) 451 mta113.mail.krs.yahoo.com Resources temporarily unavailable. Please try again later [#4.16.5]. 
<b>chol.com</b> - <a href="http://regip.chol.com" target="_blank">http://regip.chol.com</a>
<b>korea.com</b> - <a href="http://mail.korea.com/default_whiteip.asp" target="_blank">http://mail.korea.com/default_whiteip.asp</a>
<b>empas.com</b> - <a href="http://help.empas.com/guide/spam_mail02.html" target="_blank">http://help.empas.com/guide/spam_mail02.html</a>
',
	'RBL' => '
RBL(Real-time Black List)은 스팸메일을 발송하는 IP를 수집해 관리하는 리스트입니다.
RBL을 활용해 일부 사이트에서 차단하는 경우가 있는데 이 때는 에러메세지에 나와있는 사이트로 방문하셔서 RBL 해지신청을 진행하셔야 합니다.

해지 신청을 하시기전에 먼저 Reverse DNS (PTR record) 를 설정해두시는게 좋습니다.
대부분의 일반적인 환경에서는 자체적으로 설정이 불가능하며 상위기관에 의뢰를 하셔야 합니다.
서버호스팅일 경우 해당 호스팅업체에 의뢰를 하시면 되고,  임대회선을 사용해서 사무실내에서 운영중이라면 해당 회선업체에 의뢰를 하시면 됩니다.
의뢰방법은 보통 "RBL 해지를 위한 Reverse DNS (PTR record) 등록 요청"정도로 제목을 적으셔서
사용하시는 도메인, IP, 회사명(고객번호 등)을 적으신후 팩스나 메일로 요청하시면 대부분 바로 처리해주고 있습니다.

단, 가정에서 사용되는 초고속인터넷 사용자는 유동IP를 할당받으므로 Reverse DNS (PTR record) 등록이 불가능합니다.
이로 인해 해지신청이 거의 어렵고, 국내 대형 포털들에서도 유동IP로 부터 발송되는 메일은 대부분 차단하고 있습니다.
',
	'553_SPAM' => '
상대방 메일서버에서 스팸으로 인식하여 거부한 것으로 추측됩니다.
단 거부한 원인에 대해 언급되어 있지 않으므로 어떤 조건에 의해 거부되었는지 리턴메일만으로는 알 수 없습니다.
이 경우 제목이나 본문내에 광고,성인등 스팸으로 분류될만한 단어가 있는지 확인해보시고
해결이 안될 경우 상대방 메일서버의 관리자에게 문의해보셔야 합니다.
',
	'550_VIRUS' => '
상대방 메일서버가 메일내에 바이러스를 검출하여 차단한 경우입니다.
그런데 실제 바이러스 메일을 보내지 않았더라도 "보낸 사람"주소가 위조되어 잘못된 리턴메일을 받는 경우가 있는데
이는 무시하시면 됩니다.
',
	'552_GOOGLE' => '
Gmail의 경우 바이러스 차단을 위해 첨부 파일에 실행 파일이 들어간 경우까지 모두 차단하고 있습니다.
실행파일을 압축해서 보내더라도 동일하게 차단되니 꼭 보내야 한다면 실행파일의 확장자를 다른것으로 바꾸는 방법밖에 없습니다.
',
	'LOOP' => '
메일링, 서버내 서비스 안내메일 등 자동툴을 통해 메일을 보낼때 많이 발생하는 문제입니다.
메일을 보낸주소와 받는주소가 모두 잘못 되었을때 반복적으로 송수신이 일어나는데 
이때 서버부하를 방지하기 위해 자동 차단하는 것입니다.

예를 들어 보낸주소가 id@from.com 이고, 받는주소가 no-user@to.com 일 경우
엔메일에서 no-user@to.com 로 메일을 보냈을때 상대방 메일서버에서
존재하지 않는 사용자일땐 보낸주소로 리턴메일을 보내게 됩니다.
이때 보낸주소인 id@from.com 이 없는 주소일때는 다시 상대방 메일서버로
존재하지 않는 사용자라고 리턴메일을 보내게 됩니다.
이처럼 2개의 메일서버간에 동일한 리턴메일을 계속 주고 받는 현상입니다.

이 에러메세지가 안나오게 하려면 메일링 서비스시 다음 사항에 유의해야 합니다.
1. 보낸사람의 주소가 실제로 존재하는지 메일을 받을 수 있는 상태인지 확인합니다.
2. 보낸사람의 메일계정 용량이 리턴메일을 받을 수 있을만큼 충분한지 확인합니다.
',
	'SERVER_SIZE_LIMIT' => '
대부분의 메일서버에서는 부하를 방지하기 위해 메일의 크기가 일정크기 이상일 경우 받지 않도록 조치하고 있습니다.
따라서 첨부파일을 삭제해서 메일의 크기를 줄인뒤 다시 보내보시고 첨부파일은 다른 방법으로 전달하셔야 합니다.
일반적으로 첨부파일은 10MB 정도까지만 허용하고 있습니다.
<br style="line-height:200px">
',
	);


if ((strtoupper(substr(PHP_OS, 0, 3)) === 'WIN' || $_GET['os'] === 'windows' )&& $_GET['os'] !== 'linux')
{
	$HELP['SAFAQ']['BODY']['MailServerScript'] = '
<b>☞ 메일서버 시작과 종료</b>
	[관리도구 - 서비스]에서 "XMail Server"항목을 시작/종료하시면 됩니다.
		※ 종료나 재시작시 처리중인 메일이 있을 경우 수초이상 지연되는 경우도 있습니다.

<b>☞ 메일서버 사용 포트 확인</b>
	25 - SMTP, 다른 서버에서 메일수신을 위해 사용.
	80, 443 - WWW, 웹메일
	587, 465 - SMTP, 아웃룩 등의 메일 클라이언트에서 메일 보내기시 사용
	110, 995 - POP3, 아웃룩 등의 메일 클라이언트에서 메일 받기시 사용 
	6017 (CTRL) - 메일서버를 웹상에서 컨트롤하기 위한 포트로 내부에서만 접속되므로 방화벽에서 오픈할 필요는 없습니다.
		※ <a href="https://www.passkorea.net/nmail-php-faq/49797" target="_blank">메일 서비스 방화벽 허용 포트 및 보안 연결 포트 상세 안내</a>

<b>☞ 다른 메일서버가 설치되어 있을때의 유의사항</b>
	메일서버들은 정상적인 SMTP/POP3 서비스를 위해 표준으로 25/110번 포트를 사용하게 됩니다.
	이로 인해 SMTP 서비스 등의 다른 메일서버가 동작중일 경우 포트 충돌로 인해 문제가 발생하게 됩니다.
	따라서 기존 메일서버를 종료하고 부팅시 자동실행되지 않도록 조치한 다음 메일서버를 재시작해야 합니다.
';
	$HELP['SAFAQ']['BODY']['MailServerConfig'] = '
<b>☞ 재전송 시도 횟수 및 간격</b>
	기본값은 <u>120초간격으로 5회동안 재시도</u> 하도록 설정되어 있습니다.
	이 값을 <u>60초간격으로 10회동안 재시도 하도록 변경하려면</u>
	아래 레지스트리 파일을 열어 다음처럼 옵션을 변경후 레지스트리 파일을 등록하고 메일서버를 재시작해야 합니다.
	'.dirname($G_SYS['PAGE_ROOT']).'/tools/install_config.reg
		"MAIL_CMD_LINE"="-MM -Mr 24 -Pl -Sl -Ql -Qg -Yl -Fl -Cl -Ll <font color=navy><b>-Qt 120 -Qr 5</b></font> -St 300 -Pt 300 -Se 3600 -QT 900 -Qn 16 -Mx 3 -SI 0.0.0.0:25 -SI 0.0.0.0:587 -Pp 110"
		=>
		"MAIL_CMD_LINE"="-MM -Mr 24 -Pl -Sl -Ql -Qg -Yl -Fl -Cl -Ll <font color=red><b>-Qt 60 -Qr 10</b></font> -St 300 -Pt 300 -Se 3600 -QT 900 -Qn 16 -Mx 3 -SI 0.0.0.0:25 -SI 0.0.0.0:587 -Pp 110"

<b>☞ 메일송수신 최대용량 조절</b>
	<a href="'.$nmpath.'/sserver_config.php">[메일서버관리 - 서버 설정]</a>에서 <u>메일송수신 최대용량</u>을 수정하시면 됩니다.
	<a href="'.$_SERVER['REQUEST_URI'].'#AttachSize">★ "'.$HELP['SAFAQ']['MENU']['AttachSize'].'"와 관련이 있습니다.</a>

<b>☞ 리턴메일에 표시되는 메일서버 관리자 주소 변경</b>
	메일전송에 실패한 경우 사용자에게 리턴메일을 보낼때 보낸 사람주소는
	<a href="'.$nmpath.'/sserver_config.php">[메일서버관리 - 서버 설정]</a>에서 <u>메일서버 관리자 주소</u>를 수정하시면 됩니다.

<b>☞ 메일서버 접속시 보여지는 기본 도메인 변경</b>
	메일서버의 25, 110번 포트에 접속할때 보여지는 도메인은
	<a href="'.$nmpath.'/sserver_config.php">[메일서버관리 - 서버 설정]</a>에서 <u>기본 도메인</u>을 수정하시면 됩니다.
';
	$HELP['SAFAQ']['BODY']['Sync'] = '
웹메일에서의 빠른처리와 성능향상을 위해 <u>메일 데이타는 실제 파일외에 디비에 인덱스정보를 저장</u>하고 있습니다.
디비에서는 첨부파일을 제외한 메일헤더, 제목, 본문의 정보가 저장되어 있어서 향상된 정렬, 검색 기능이 지원됩니다.

웹메일에서 메일을 삭제할 경우 디비와 메일파일이 동시에 삭제되지만, 메일클라이언트에서 POP3 프로토콜을 통해
메일을 가져간 경우에는 메일파일만 삭제됩니다.  이러한 메일 파일과 디비와의 차이를 해결하고자 사용자가 웹메일에
로그인을 할때 디비와 메일파일의 일부비교해 서로 틀린 경우에는 메일파일을 기준으로 동기화작업을 하게 됩니다.

<u>만약 디비 에러 등으로 인해 동기화가 제대로 이루어지지 않았을 경우 아래 스크립트를 root 권한으로 실행하면 됩니다.</u>
	'.dirname($G_SYS['PAGE_ROOT']).'/tools/
	a) 도메인내의 모든 계정 동기화
		php mail_box_dbsync.php domain.com
	b) 도메인내의 특정 계정만 동기화
		php mail_box_dbsync.php domain.com userid
';
	unset($HELP['SAFAQ']['MENU']['Backup']);
	unset($HELP['SAFAQ']['MENU']['ServerMove']);
}	// if()







?>