<?

	// Duplicate check
		if ( defined("_INCLUDED_GLOBAL") ) return;
		define("_INCLUDED_GLOBAL", "1");


################################################################################


	// set - include_path
		/*
			* include_path 별 사용용도

				[.] 현재 디렉토리 지정.

				[$_src_root] 소스 루트 디렉토리 지정.
					ex) index.php -> include_once(include/global.php);

				[$_src_root/include/pear] Pear Class 디렉토리 지정.
					ex) Mail.php -> require_once 'PEAR.php';

				[..] 1단계 상위 디렉토리 지정.
					ex) admin/index.php -> include_once(../include/global.php);
		*/
		$_include_path = ini_get('include_path');
		$_src_root = dirname(dirname(__FILE__));
		$_include_path = ".".PATH_SEPARATOR."$_src_root".PATH_SEPARATOR."$_src_root/include/pear".PATH_SEPARATOR."..".PATH_SEPARATOR."" . $_include_path;
		ini_set('include_path', $_include_path);


	// [2007-01-09] IIS에 PHP를 연동한 경우 $_SERVER['REQUEST_URI'] 변수가 선언되지 않는 문제.
		if (!isset($_SERVER['REQUEST_URI']))
		{
			$_SERVER['REQUEST_URI'] = $_SERVER['PHP_SELF'];
			if ($_SERVER['QUERY_STRING'] != '')
				$_SERVER['REQUEST_URI'] .= '?'.$_SERVER['QUERY_STRING'];
		}	// if()

	// [2013-03-13] magic_quotes_gpc = Off 호환
		if (!get_magic_quotes_gpc())
		{
		   function _addslashes_deep($value)
		   {
		       $value = is_array($value) ? array_map('_addslashes_deep', $value) : addslashes($value);
		       return $value;
		   }
		   $_POST = array_map('_addslashes_deep', $_POST);
		   $_GET = array_map('_addslashes_deep', $_GET);
		   $_COOKIE = array_map('_addslashes_deep', $_COOKIE);

		   // [2024-09-11] PHP 5.3 에서 'register_globals = On' 설정인 경우, extract 실행
		   if (ini_get('register_globals')) {
			   extract($_GET, EXTR_OVERWRITE);
			   extract($_POST, EXTR_OVERWRITE);
		   }
		}	// if()

	// [2013-03-13] register_globals = Off 호환
		if (!ini_get('register_globals'))
		{
			extract($_GET, EXTR_SKIP);
			extract($_POST, EXTR_SKIP);
		}	// if()


###############################################################################

	// default
		$db = NULL;
		$AUTH = array();
		$CFG = array();
		$DEBUG = array();
		$TB = array();
		$G_SYS = array();
		$G = array();
		$NSKIN = array();
		$NLANG = array();

	// [2013-07-24] 모바일웹
		$G_SYS['IS_MOBILE'] = preg_match('/iPhone|iPad|Android|Mobile Safari|BlackBerry|SymbianOS|Windows CE|Opera Mini/', $_SERVER['HTTP_USER_AGENT']) ? true : false;

	// [2008-10-10] 다중 언어팩
		$G_SYS['MULTI_LANG'] = array('ko');
		$G_SYS['MULTI_LANG_NAME'] = array('Korean');

	// Include
		require_once("include/global_var.php");		// User's var

		// [2008-03-26] 기본 업로드 디렉토리 변경
			$UPLOAD_ROOT_NEW = dirname($G_SYS[PAGE_ROOT]) . "/upload";
			//$UPLOAD_ROOT_NEW = "/home/nmail2/upload";
			$UPLOAD_ROOT_OLD = $UPLOAD_ROOT;
			$UPLOAD_ROOT = $UPLOAD_ROOT_NEW;

		require_once dirname($G_SYS['PAGE_ROOT']) . '/vendor/autoload.php';     // Composer autoloading
		require_once("include/global_table.php");		// User's table
		require_once("include/func.php");		// Function
		require_once("include/auth.php");		// Auth
		require_once('include/mail_lib.php');
		require_once("include/mail_box_lib.php");
		require_once('include/security_lib.php');       // 통합 보안 모듈
		require_once('include/purifier_lib.php');       // HTML purifier (메일 본문 등 XSS 방어, 소스내 설정 변경 가능)
		require_once('include/2fa_lib.php');            // 2단계 인증

		// [2006-07-28] 관리자모드에서 설정한 내용.  global_var.php 와 중복될 경우 이 내용이 우선 적용됨.
		if (file_exists($UPLOAD_ROOT."/config/nmail_server.php"))
		{
			include($UPLOAD_ROOT."/config/nmail_server.php");
		} else
		{
			// 서버설정 파일이 없을때의 기본값.
			$G_SYS[MBR_ID_DENY] = array('root', 'admin', 'superadmin', 'demo', 'mail', 'nmail', 'webmail', 'master', 'webmaster', 'postmaster', 'abuse', 'service', 'help');		// 회원가입시 제한할 ID 목록.(무제한 버젼에서만 디폴트로 필요할 듯.)
			$UPLOAD_MAX_SIZE = 10485760;	// 업로드 제한용량.  ex) 1024 * 1024 * 1 = 1MB(1048576)
			$G_SYS[UPLOAD_MAIL_MAX_SIZE] = 10485760;	// 메일 첨부파일 제한용량.  기본 - 10MB(10485760)
			$G_SYS[VIRUS_SCAN] = false;		// 바이러스 메일 검사여부.(옵션팩이 설치되어 있어야 함.)
			$G_MB[ID_MIN_LENGTH] = 1;		// 아이디 최소길이 제한.  기본 1자이상.
			$G_SYS[S_SPAM_LEVEL] = 'BASIC';		// 스팸 차단 레벨.  (기본 - BASIC).
			$G_SYS[S_SPAM_RBL] = array('sbl.spamhaus.org', 'xbl.spamhaus.org', 'pbl.spamhaus.org', 'bl.spamcop.net', 'spam.dnsbl.sorbs.net', 'b.barracudacentral.org');		// 스팸 분류 RBL
			$G_SYS[S_DENY_RBL] = array('sbl-xbl.spamhaus.org');		// 스팸 차단 RBL
		}	// if()
		// [2007-03-09]
		if (!isset($G_SYS[FORWARD_DOMAIN_DENY]))
		{
			$G_SYS[FORWARD_DOMAIN_DENY] = array('chol.com', 'daum.net', 'dreamwiz.com', 'empal.com', 'freechal.com', 'gmail.com', 'hanafos.com', 'hanmail.net', 'hanmir.com', 'hotmail.com', 'korea.com', 'msn.com', 'nate.com', 'naver.com', 'netian.com', 'paran.com', 'sayclub.com', 'yahoo.co.kr', 'yahoo.com');		// 메일포워딩 설정시 제한할 도메인 목록
		}	// if()
		if (!isset($G_SYS[VIRUS_RETURN]))
		{
			$G_SYS[VIRUS_RETURN] = 0;		// 바이러스 차단시 리턴메일 발송여부.
		}	// if()

		// [2007-12-24]
		if (!isset($G_SYS[UPLOAD_MAIL_BIGFILE_MAX_SIZE]))
			$G_SYS[UPLOAD_MAIL_BIGFILE_MAX_SIZE] = 104857600;
		if (!isset($G_SYS[UPLOAD_MAIL_BIGFILE_COUNT]))
			$G_SYS[UPLOAD_MAIL_BIGFILE_COUNT] = 20;
		if (!isset($G_SYS[UPLOAD_MAIL_BIGFILE_DAY]))
			$G_SYS[UPLOAD_MAIL_BIGFILE_DAY] = 14;
		if (!isset($G_SYS[UPLOAD_WEBHARD_MAX_SIZE]))
			$G_SYS[UPLOAD_WEBHARD_MAX_SIZE] = 104857600;
		if (!isset($G_SYS[UPLOAD_MAIL_BOX_RESTORE_MAX_SIZE]))
			$G_SYS[UPLOAD_MAIL_BOX_RESTORE_MAX_SIZE] = 104857600;

		// [2025-09-10] 서명 이미지 계정당 할당량. 기본 - 10MB(10485760)
		if (!isset($G_SYS[UPLOAD_MAIL_SIGN_MAX_SIZE]))
			$G_SYS[UPLOAD_MAIL_SIGN_MAX_SIZE] = 10485760;
		// [2025-09-10] 서명 이미지 최대용량. 기본 - 200KB(204800)
		if (!isset($G_SYS[UPLOAD_MAIL_SIGN_FILE_MAX_SIZE]))
			$G_SYS[UPLOAD_MAIL_SIGN_FILE_MAX_SIZE] = 204800;
		// [2025-09-10] 웹메일 주소에 SSL 미적용시 경고 문구 표시
		if (!isset($G_SYS[UPLOAD_MAIL_SIGN_WARNING_NONE_SSL]))
			$G_SYS[UPLOAD_MAIL_SIGN_WARNING_NONE_SSL] = true;

		// [2025-10-27] 개인별로 보내기 자동 적용 인원수
		if (!isset($G_SYS[PERSONAL_AUTO_APPLY_COUNT]))
			$G_SYS[PERSONAL_AUTO_APPLY_COUNT] = 10; // 기본 10명

		// [2025-11-11] 예약발송 사용여부
		if (!isset($G_SYS[MAIL_SEND_RESERVE_ISUSE]))
			$G_SYS[MAIL_SEND_RESERVE_ISUSE] = (int)has_mail_send_reserve();     // 예약 발송 포함시에만 기본 활성화

		// [2025-11-11] 예약발송 가능수(계정당 제한, 이미 발송된 메일은 제외하고 예약중인 메일만 카운트)
		if (!isset($G_SYS[MAIL_SEND_RESERVE_LIMIT_SEND]))
			$G_SYS[MAIL_SEND_RESERVE_LIMIT_SEND] = 100;

		// [2025-11-11] 예약발송 가능일수(서버 부하 방지와 착오 방지를 위해 오늘 날짜로부터 최대 100일간만 예약 허용)
		if (!isset($G_SYS[MAIL_SEND_RESERVE_LIMIT_DAY]))
			$G_SYS[MAIL_SEND_RESERVE_LIMIT_DAY] = 100;

		// [2009-03-23] 내부주소 위조 스팸 차단
		if (!isset($G_SYS[S_SPAM_FROM_FAKE]))
			$G_SYS[S_SPAM_FROM_FAKE] = 'SPAM';

		// [2024-09-11] 메일헤더 보낸주소의 이름이 메일 수신자 도메인과 일치하는 경우, 보낸주소 위조메일 검사
		//   ex) From: "passkorea.net" <info@example.com>  -> 이름에 메일 수신 도메인이 포함된 경우 위조메일 처리
			$G_SYS[S_SPAM_FROM_FAKE_NAME_CHECK] = true;


	// global_var.php default - 아래값은 수정하지 마시고 global_var.php 에서 동일한 변수가 있으므로 수정하시면 됩니다.  없을 경우 적절한 위치에 추가하시면 됩니다.
		if (!$G_MB[ID_MIN_LENGTH])
			$G_MB[ID_MIN_LENGTH] = 1;
		if (!$G_SYS[CHARSET])
			$G_SYS[CHARSET] = 'euc-kr';
		if (!$G_SYS['AUTO_FILTER_MAX'])
			$G_SYS['AUTO_FILTER_MAX'] = 20;
		if (!is_array($G_SYS['MB_SAVEDAY']))
		{
			$G_SYS['MB_SAVEDAY'] = array(
				0=>'제한없음',
				5=>'5일',
				10=>'10일',
				15=>'15일',
				20=>'20일',
				25=>'25일',
				30=>'30일',
				40=>'40일',
				50=>'50일',
				60=>'60일'
				);
		}	// if()
		if (!is_array($G_SYS['MB_SAVEDAY_ID']))
			$G_SYS['MB_SAVEDAY_ID'] = array('trash', 'spam');
		if (!$G_SYS['MBR_GROUP_MAX'])
			$G_SYS['MBR_GROUP_MAX'] = 999999;
		if (!$G_SYS['DEBUG_QUERY_OVER_TIME'])
			$G_SYS['DEBUG_QUERY_OVER_TIME'] = 2;
		// [2006-06-30] 웹에디터 추가(openWYSIWYG)
		if (!$G_SYS['WEBEDITOR'])
			$G_SYS['WEBEDITOR'] = 'TINYMCE5';
		// [2006-06-02] 스킨버젼
		if (!$NSKIN['ver'])
			$NSKIN['ver'] = '2.0';
		if (!$G_SYS['DRAFT_SAVE_AUTO_TIME'])
			$G_SYS['DRAFT_SAVE_AUTO_TIME'] = 120;
		if (!$G_SYS['BOARD_QUOTA_DEFAULT'])
			$G_SYS['BOARD_QUOTA_DEFAULT'] = 2097152;
		// [2006-07-25] 기본 설정 - 편지함마다 보여줄 편지수, 이번주 일정 표시수
		if (!is_array($G_SYS['M_CFG_NEW_CNT']))
		{
			$G_SYS['M_CFG_NEW_CNT'] = array(
				3=>'3개',
				5=>'5개',
				7=>'7개',
				10=>'10개',
				15=>'15개'
				);
		}	// if()
		// [2006-07-25] 기본 설정 - 편지읽기 목록
		if (!is_array($G_SYS['M_CFG_MAIL_LIST_CNT']))
		{
			$G_SYS['M_CFG_MAIL_LIST_CNT'] = array(
				10=>'10개',
				15=>'15개',
				20=>'20개',
				30=>'30개',
				50=>'50개',
				75=>'75개',
				100=>'100개'
				);
		}	// if()

		// 웹하드 설정
		if ($G_SYS['WEBHARD_NAME'] == '')
			$G_SYS['WEBHARD_NAME'] = '웹하드';		// 웹하드 명칭(웹디스크, 파일박스 ...)
		if ($G_SYS['MY_WEBHARD_NAME'] == '')
			$G_SYS['MY_WEBHARD_NAME'] = '내 웹하드';		// 웹하드 명칭(웹디스크, 파일박스 ...)

		$G_SYS['WEBHARD_WS_PERM'] = array(
								'W'=>'업로드',
								'R'=>'다운로드',
								'D'=>'삭제'
								);

		// [2008-10-10] 다중 언어팩
		if ($_COOKIE['nm_lang'])
		{
			$G_SYS['nm_lang'] = $_COOKIE['nm_lang'];
		} else
		{
			$G_SYS['nm_lang'] = $G_SYS['MULTI_LANG'][0];
		}	// if()


###############################################################################

	// 스팸메일 설정
		$G_SYS['SPAM_CONFIG_DEFAULT'] = array(
										"sc_addr_allow"=>"Y",
										"sc_fake_del"=>"N",
										"sc_foreign_spam"=>"N",
										"sc_write_allow_add"=>"Y",
										"sc_from_subj_null_dell"=>"N"
										);

	// db
		if ($G_SYS[DB] == 'oracle')
		{
			if ($G_SYS[DB_VERSION] == '8i')
			{
				$G_SYS['DB_TEXT'] = 2000;
			} else
			{
				$G_SYS['DB_TEXT'] = 4000;
			}	// if()
			$G_SYS['DB_MEDIUMTEXT'] = 16777215;
		} else
		{
			$G_SYS['DB_TEXT'] = 65535;
			// [2008-03-29] 일부 메일 본문의 용량이 16M를 초과해서 에러가 발생하는 문제.
			//$G_SYS['DB_MEDIUMTEXT'] = 16777215;
			$G_SYS['DB_MEDIUMTEXT'] = 15728640;
		}	// if()


	// 회원관리 부가기능
		// [2007-03-07] 서비스 설정 항목 추가
		$G_SYS['MBR_ADMIN_CMD'] = array(
			'MBR_ADD'=>'- 메일계정 추가',
			'MBR_WITHDRAWAL' => '- 메일계정 탈퇴',
			'MBR_DEL'=>'- 메일계정 삭제 (주의)',
			'_1'=>'',
			'SMTP_SET'=>'- SMTP 서비스 허용',
			'SMTP_UNSET'=>'- SMTP 서비스 차단',
			'POP3_SET'=>'- POP3 서비스 허용',
			'POP3_UNSET'=>'- POP3 서비스 차단',
			'FORWARD_UNSET'=>'- 메일 포워딩 사용안함',
			'2FA_REQUIRED_SET' => '- 2단계 인증 필수사용',
			'2FA_REQUIRED_UNSET' => '- 2단계 인증 선택사용',
			'2FA_SET' => '- 2단계 인증 사용',
			'2FA_UNSET' => '- 2단계 인증 생략',
			'_2'=>'',
			'SUSPEND_SET'=>'- 휴면계정 지정',
			'SUSPEND_UNSET'=>'- 휴면계정 해제',
			'USEDATE_SET'=>'- 사용기간 지정',
			'USEDATE_UNSET'=>'- 사용기간 해제',
			'_3'=>'',
			'PAGE_50'=>'- 페이지당 50명씩 출력',
			'PAGE_100'=>'- 페이지당 100명씩 출력'
			);


	// [2006-07-05] 메일목록 부가기능
		// [2007-11-15] 메일 자동분류
		$G_SYS['MAIL_LIST_CMD'] = array(
			// [2011-03-29] 계속이동 버튼 추가
			//'AUTO_FILTER'=>'- 메일 자동분류(계속이동)',
			//'_1'=>'',
			'MARK_READ_ALL'=>'- 모두 읽은 메일로 표시',
			'MARK_READ'=>'- 읽은 메일로 표시',
			'MARK_UNREAD'=>'- 읽지않은 메일로 표시',
			'_2'=>'',
			'MAIL_BACKUP'=>'- 메일 백업하기',
			'MAIL_BACKUP_2'=>'- 메일 백업하기',		// [2010-09-10] 편지목록에서 선택한 메일만 백업할 때, ActiveX 사용여부.(기본값은 false)
			'MAIL_RESTORE'=>'- 메일 복구하기',
			'_3'=>'',
			'PAGE_20'=>'- 페이지당 20건씩 출력',
			'PAGE_50'=>'- 페이지당 50건씩 출력',
			'PAGE_100'=>'- 페이지당 100건씩 출력'
			);
	// [2025-09-23] 메일 목록 페이지당 최대 항목수
		$G_SYS['MAIL_LIST_COUNT'] = 100;
//		$G_SYS['MAIL_LIST_COUNT'] = 200;
//		$G_SYS['MAIL_LIST_COUNT'] = 500;
//		$G_SYS['MAIL_LIST_COUNT'] = 1000;
//		$G_SYS['MAIL_LIST_COUNT'] = 2000;
//		$G_SYS['MAIL_LIST_CMD']['PAGE_200'] = '- 페이지당 200건씩 출력';
//		$G_SYS['MAIL_LIST_CMD']['PAGE_500'] = '- 페이지당 500건씩 출력';
//		$G_SYS['MAIL_LIST_CMD']['PAGE_1000'] = '- 페이지당 1000건씩 출력';
//		$G_SYS['MAIL_LIST_CMD']['PAGE_2000'] = '- 페이지당 2000건씩 출력';

		$G_SYS['AUTO_FILTER_PREFIX'] = '자동분류_';

		// [2025-09-30] 메일 수신 상태
		$G_SYS['EMAIL_STATUS'] = array(
			'RECEIVABLE'             => '수신 가능',
			'UNAVAILABLE_PENDING'    => '수신 불가 (가입대기)',
			'UNAVAILABLE_WITHDRAWN'  => '수신 불가 (탈퇴회원)',
			'UNAVAILABLE_OVER_QUOTA' => '수신 불가 (메일용량 초과)',
			'UNAVAILABLE_NOT_FOUND'  => '수신 불가 (없는 아이디)',
			'EXTERNAL_UNKNOWN'       => '외부 주소 (확인불가)'
		);

	// [2006-07-25] 기본 설정
		$G_SYS['DEFAULT_CONFIG_DEFAULT'] = array(
			"m_cfg_new_mail_box"=>"inbox|spam",
			"m_cfg_new_cnt"=>"7",
			"m_cfg_week_diray_cnt"=>"5",
			"m_cfg_from_name"=>"",
			"m_cfg_mail_list_cnt"=>"20"
			);

	// [2025-09-18] 중요 메일
	$G_SYS['MAIL_STAR_USE'] = true;

	// [2025-09-18] 보낸사람이 지정한 중요도 표시 방법
	//   true: 메일 목록에서 제목 앞에 표시, 중요도 높음만 표시.
	//   false: 메일 목록에서 체크박스 뒤에 별도 컬럼으로 표시, 중요도 높음/낮음 표시.  (v3.3 화면 유지용)
	$G_SYS['MAIL_IMPORTANT_NEW'] = true;

	// [2025-10-14] 메일 목록에서 제목뒤에 미리보기 아이콘 표시
	//    false : 기존처럼 제목에 마우스 오버시 title 항목으로 표시
	$G_SYS['MAIL_BODY_TEXT_PREVIEW'] = true;
	$G_SYS['MAIL_BODY_TEXT_PREVIEW_MAX_BODY'] = 524288;    // 512KB, 메일 본문이 길 경우 속도 향상을 위해 앞부분  만 사용하여 필터링함
	$G_SYS['MAIL_BODY_TEXT_PREVIEW_MAX_TEXT'] = 5000;    // 5000자, 메일 본문에서 추출한 텍스트의 최대 길이
	$G_SYS['MAIL_BODY_TEXT_PREVIEW_IP'] = false;        // 서버관리자 계정에서 IP 표시 여부. (디버깅 용도로 기본 비활성화)

// env
		// [2006-05-15] 일부 시스템에서 한글관련 문제를 해결하기 위함.
		//if (!$G_SYS[LC_CTYPE])
		//	$G_SYS[LC_CTYPE] = "ko_KR.eucKR";
		// [2009-06-23] 윈도우 PHP5 에서 fgetcsv() 함수 오동작 문제 해결
		if (!$G_SYS[LC_CTYPE] || $G_SYS[LC_CTYPE] == "ko_KR.eucKR")
		{
			if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
			{
				$G_SYS[LC_CTYPE] = "korean";
			} else if (strtoupper(substr(PHP_OS, 0, 3)) === 'SUN')
			{
				$G_SYS[LC_CTYPE] = "ko";
			} else if (strtoupper($G_SYS[CHARSET]) == 'UTF-8')		// [2011-09-08] 유니코드 버젼에서 $G_SYS[LC_CTYPE] 기본값이 누락되어 발생하는 오류 해결.
			{
				$G_SYS[LC_CTYPE] = "ko_KR";
			}	// if()
		}	// if()
		setlocale(LC_CTYPE, $G_SYS[LC_CTYPE]);


###############################################################################


	$DEBUG['document']['start'] = getmicrotime();


	// auth now
	if ($_SERVER['DOCUMENT_ROOT'] || $_SERVER['SERVER_SOFTWARE'])		// 쉘모드가 아닌 웹페이지에서 접근할때.
	{
		// header
			// [2007-11-21] 외국어메일 보기에서는 사용하지 않도록 함.
			// [2006-12-11]기본 인코딩이 한글이 아닌 사용자에게 에러문구 등만 출력되는 페이지에서의 깨짐 현상 방지.
			if (basename($_SERVER['PHP_SELF']) != 'mail_foreign.php')
				header('Content-Type: text/html; charset='.$G_SYS[CHARSET]);

		// session
			$DEBUG['session']['start'] = getmicrotime();

			if (!isset($G_SYS[SESSION_GC_MAXLIFETIME_MOBILE]))
				$G_SYS[SESSION_GC_MAXLIFETIME_MOBILE] = 604800;		// 웹메일 로그인 유지 시간, 모바일웹 (세션 유효 시간)  기본 1주일 -> 604800
			// [2025-12-03] 휴대폰 브라우저 닫기후 재실행시 유지.
			//   최초 로그인후 쿠키가 자동 삭제되지 않도록 기본값 1주일에서 1년으로 늘림.
			//   주의) PC처럼 0 으로 둘 경우 브라우저 앱 닫기나 일정 시간이 지나면 로그아웃됨
			if (!isset($G_SYS[SESSION_LIFETIME_MOBILE]))
				$G_SYS[SESSION_LIFETIME_MOBILE] = (86400 * 365);		// 모바일웹 세션 유효시간. ex) 1주일 -> 604800, 2주일 -> 1209600

			$__is_dir_mobile_session = is_dir($UPLOAD_ROOT . "/mobile_session");

			if ($G_SYS['IS_MOBILE'] && $__is_dir_mobile_session)
			{
				ini_set('session.gc_maxlifetime', $G_SYS[SESSION_GC_MAXLIFETIME_MOBILE]);
			} else
			{
				ini_set('session.gc_maxlifetime', $G_SYS[SESSION_GC_MAXLIFETIME]);
			}	// if()

			if (function_exists("session_cache_limiter")) {
				// [2007-03-28] 웹브라우저에 캐쉬를 남기지 않도록 설정함.
				// [2007-04-02] 파일 다운로드시에만 캐쉬를 허용해서 첨부파일 바로 '열기'가 지원되도록 함.
				//session_cache_limiter('nocache, must-revalidate');		// 캐쉬는 허용하지 않지만, form은 재전송할 수 있다.
				if (in_array(basename($_SERVER['PHP_SELF']), array('download.php', 'mail_down.php', 'mail_attach_down.php', 'addr_outlook_export_ok.php', 'spam_allow_export_ok.php', 'spam_reject_export_ok.php', 'file_down.php', 'bigfile_down.php', 'board_down.php', 'mail_box_backup_ok.php')))
				{
					// [2007-05-29]
					//session_cache_limiter('');
					session_cache_limiter('private');		// 캐쉬를 남겨 웹브라우저에서 파일 바로 열기 지원.
					session_cache_expire(0);		// Last-Modified 헤더가 변경되면 즉시 캐쉬를 무시하도록 함.
				} else
				{
					session_cache_limiter('nocache');
				}	// if()
			}	// if()

			// 세션파일 저장위치
			// [2009-06-04] 설정파일에서 변경할 수 있도록 함.
			if ($G_SYS['SESSION_SAVE_PATH'])
			{
				session_save_path($G_SYS['SESSION_SAVE_PATH']);
			} else
			{
				if ($G_SYS['IS_MOBILE'] && $__is_dir_mobile_session)
				{
					session_save_path($UPLOAD_ROOT . "/mobile_session");
				} else
				{
					session_save_path($UPLOAD_ROOT . "/session");
				}	// if()
			}	// if()

			if ($G_SYS['IS_MOBILE'] && $__is_dir_mobile_session)
			{
				$G_SYS[SESSION_LIFETIME_NOW] = $G_SYS[SESSION_LIFETIME_MOBILE];
			} else
			{
				$G_SYS[SESSION_LIFETIME_NOW] = $G_SYS[SESSION_LIFETIME];
			}	// if()

			if ( ! isset($G_SYS['SESSION_COOKIE_SECURE'])) {
				$G_SYS['SESSION_COOKIE_SECURE'] = false;
			}

			if ($G_SYS[SESSION_DOMAIN])		// 세션이 공유될 도메인을 지정할 수 있음.
			{
                // [2020-04] reflect xss 취약점 개선
                #session_set_cookie_params($G_SYS[SESSION_LIFETIME_NOW], $G_SYS[SESSION_PATH], $G_SYS[SESSION_DOMAIN]);
				session_set_cookie_params($G_SYS[SESSION_LIFETIME_NOW], $G_SYS[SESSION_PATH], $G_SYS[SESSION_DOMAIN], $G_SYS['SESSION_COOKIE_SECURE'], true);
			} else
			{
                // [2020-04] reflect xss 취약점 개선
				#session_set_cookie_params($G_SYS[SESSION_LIFETIME_NOW], $G_SYS[SESSION_PATH]);
                session_set_cookie_params($G_SYS[SESSION_LIFETIME_NOW], $G_SYS[SESSION_PATH], '', $G_SYS['SESSION_COOKIE_SECURE'], true);
			}	// if()

			session_start();		// 이 함수보다 먼저 $_SESSION  을 사용할 경우 페이지 오류발생함.  function 내에서 실행시 세션값을 찾을 수 없음.

			// [2009-09-24] 일부 세션 중복 문제 보완
			while (1)
			{
				if (session_id() == 'deleted')
				{
					if (function_exists('session_regenerate_id'))
					{
						session_regenerate_id(true);
					} else
					{
						session_id(md5(uniqid(microtime()).mt_rand()));
					}	// if()
				} else
				{
					break;
				}	// if()
			}	// while()

			$DEBUG['session']['exec'] = getmicrotime() - $DEBUG['session']['start'];

		// mapping
			$AUTH = $_SESSION;

		#if($auth_mode == true) auth_proc($auth_mode);
		if($AUTH[auth_m_level] == NULL) $AUTH[auth_m_level] = 0;		// 로그인하지 않았을때.
	}	// if()


################################################################################


// db connect
	set_db();


// 멀티도메인 구분
	if ($_SERVER['DOCUMENT_ROOT'] || $_SERVER['SERVER_SOFTWARE'])		// 쉘모드가 아닌 웹페이지에서 접근할때.
	{
		// 접속한 주소를 기준으로 메일 도메인 알아내고, 도메인 정보 가져오기.
		set_mail_domain();
		$G['DINFO'] = get_domain($G_SYS['MAIL_DOMAIN']);

		// 도메인별 스킨 적용.
		set_nskin();
		if ($G_SYS['MAIL_DOMAIN'] == 'nbuilder.net' || $G_SYS['MAIL_DOMAIN'] == 'nm3.passkorea.net')
			require_once('include/_demo_limit.inc.php');

		// 메인디자인 좌측메뉴 스킨 파일 선언.
		$G['THISPAGE'] = basename($_SERVER['PHP_SELF']);
		$G['THISPAGETYPE'] = 'USER';
		if ($G['THISPAGE'] == 'help.php')
		{
			if (!(version_compare(NM_SKIN_MAIN_VER, '2.5.0', '>=') && in_array($_GET['id'], array('POP3', 'POP3_CHK', 'RETURNMAIL'))))
				$G['THISPAGETYPE'] = 'HELP';
		} else if (
			($G['THISPAGE'] == 'member.php' && (strpos($_GET['mode'], 'ADMIN_') === 0 || $_GET['mode_admin']))
			|| ($G['THISPAGE'] == 'board.php' && strpos($_GET['mode'], 'ADMIN_') === 0)
		)
		{
			if ($_GET['mode_sadmin'])
			{
				$G['THISPAGETYPE'] = 'SADMIN';
			} else
			{
				$G['THISPAGETYPE'] = 'ADMIN';
			}	// if()
		} else if (in_array($G['THISPAGE'], array('admin_mbr_list.php', 'admin_mbr_add.php', 'admin_mbr_mod.php')) && $_GET['mode_sadmin'])
		{
			$G['THISPAGETYPE'] = 'SADMIN';
		} else if (strpos($G['THISPAGE'], 'addr_group') === 0 && $_GET['isadmin'])
		{
			$G['THISPAGETYPE'] = 'ADMIN';
		} else if (in_array($G['THISPAGE'], array('admin.php', 'admin_mbr_list.php', 'admin_mbr_add.php', 'admin_mbr_mod.php', 'admin_mbr_group.php', 'admin_mbr_group_field.php', 'admin_mbr_group_mod.php', 'admin_mbr_class.php', 'admin_mbr_class_mod.php', 'admin_board_menu.php', 'admin_board_menu_mod.php', 'notice.php', 'board_cate.php')))
		{
			$G['THISPAGETYPE'] = 'ADMIN';
		} else if (in_array($G['THISPAGE'], array('sadmin.php', 'sdomain_list.php', 'sdomain_add.php', 'sdomain_mod.php', 'admin_mailing_list.php', 'admin_mailing_add.php', 'admin_mailing_mod.php', 'admin_mailing_addr.php', 'sadmin_ip.php', 'sadmin_ip_mod.php', 'snmail.php', 'snmail_reg.php', 'snmail_reg2.php', 'sserver_config.php', 'sspam_config.php', 'ssendmail_test.php', 'sadmin_spam_addr.php', 'sadmin_spam_word.php', 'sdomain_alias_list.php', 'sdomain_alias_add.php', 'sdomain_alias_mod.php', 'admin_mbr_login.php', 'admin_mbr_log.php', 'admin_security_list.php', 'admin_forward_list.php', 'admin_login_device_list.php', 'admin_trusted_device_list.php', 'sadmin_holiday_list.php', 'sadmin_holiday_list_add.php', 'sadmin_holiday_list_mod.php', 'antivirus_test.php', 'cache_busting.php', 'sadmin_monitor_list.php', 'sadmin_monitor_show.php')) || strpos($G['THISPAGE'], 'admin_') === 0)
		{
			if ($_GET['isadmin'])
			{
				$G['THISPAGETYPE'] = 'ADMIN';
			} else
			{
				$G['THISPAGETYPE'] = 'SADMIN';
			}	// if()
		}	// if()

		if ($G['THISPAGETYPE'] == 'USER')
		{
			// [2008-01-04] 웹하드 스킨
			// [2008-08-21] 주소록(조직도추가)
			if (strpos($_SERVER['PHP_SELF'], '/webhard/') !== false || $G['THISPAGE'] == 'address.php')
			{
				//define('NMAIL_SKIN_MAIN_LEFTMENU_FILE', nskindir('webhard').'/webhard_layout_leftmenu.inc.html');
				$G_SYS['SKIN_LEFT_MENU_HIDDEN'] = true;
			} else
			{
				define('NMAIL_SKIN_MAIN_LEFTMENU_FILE', nskindir('main').'/layout_leftmenu.inc.html');
			}	// if()

			// [2008-08-21] 환경설정 구분
			if (in_array($G['THISPAGE'], array('mail_config.php', 'default_config.php', 'mail_box.php', 'mail_box_mod.php', 'sign.php', 'sign_mod.php', 'auto_reply.php', 'mail_forward.php', 'pop3.php', 'pop3_mod.php', 'spam_config.php', 'auto_filter_list.php', 'auto_filter_add.php', 'auto_filter_mod.php', 'spam_allow.php', 'spam_reject.php', 'member.php', '2fa_config.php')))
				$G['THISPAGETYPE2'] = 'CONFIG';

		} else if ($G['THISPAGETYPE'] == 'HELP')
		{
			define('NMAIL_SKIN_MAIN_LEFTMENU_FILE', nskindir('main').'/help_layout_leftmenu.inc.html');
		} else if ($G['THISPAGETYPE'] == 'ADMIN')
		{
			define('NMAIL_SKIN_MAIN_LEFTMENU_FILE', nskindir('main').'/admin_layout_leftmenu.inc.html');
		} else if ($G['THISPAGETYPE'] == 'SADMIN')
		{
			define('NMAIL_SKIN_MAIN_LEFTMENU_FILE', nskindir('main').'/sadmin_layout_leftmenu.inc.html');
		}	// if()
	}	// if()


// [2006-08-04] 웹사이트 정보
	$G_SYS[SITE_NAME] = ($G['DINFO']['d_site_name'] != '') ? $G['DINFO']['d_site_name'] : "웹메일";
	$G_SYS[SITE_OWNER] = ($G['DINFO']['d_site_owner'] != '') ? $G['DINFO']['d_site_owner'] : "회사/단체명 입력";
	// [2025-03-17] 웹브라우저 타이틀, 웹사이트 저작권 미입력시 직접 수정을 유도하도록 패스코리아넷 대신 '회사/단체명'으로 표시
	$G_SYS[SITE_TITLE] = ($G['DINFO']['d_site_title'] != '') ? $G['DINFO']['d_site_title'] : "웹메일/스팸차단/바이러스차단 서비스 - 회사/단체명 웹메일";
	$G_SYS[SITE_LICENSE] = ($G['DINFO']['d_site_license'] != '') ? $G['DINFO']['d_site_license'] : '<a href="http://' . $_SERVER['HTTP_HOST'] . '" target="_blank" style="color:#272727; font-family:tahoma; text-decoration:none;">ⓒ 회사/단체명. All rights reserved</a>';
    // [2025-08-26] 로그인 상단, 로그인 하단 안내 추가
	$G_SYS[SITE_TOP_NOTICE] = ($G['DINFO']['d_site_top_notice'] != '') ? $G['DINFO']['d_site_top_notice'] : '';
	$G_SYS[SITE_BOTTOM_NOTICE] = ($G['DINFO']['d_site_bottom_notice'] != '') ? $G['DINFO']['d_site_bottom_notice'] : '';

// URL 주소 변수명 앨리어스.
	$nmpath = $G_SYS['URL_ROOT'];


// 사용자 메일 첨부파일 임시저장 디렉토리.  - 로그인이후에 선언가능하므로 global_var.inc.php 대신 이곳에 위치함.
	$UPLOAD_DIR[MAILTEMP] = 'mailtemp/'.$G_SYS[MAIL_DOMAIN].'/'.$AUTH[auth_m_mail_file_group].'/'.$AUTH[auth_m_id];


// [2008-01-23] 웹하드, 대용량첨부 저장 디렉토리
	$UPLOAD_DIR[WEBHARD] = 'webhard/'.$G_SYS[MAIL_DOMAIN].'/'.$AUTH[auth_m_mail_file_group].'/'.$AUTH[auth_m_id];
	$UPLOAD_DIR[BIGFILE] = 'bigfile/'.$G_SYS[MAIL_DOMAIN].'/'.$AUTH[auth_m_mail_file_group].'/'.$AUTH[auth_m_id];
	$UPLOAD_DIR[BIGFILE_TMP] = $UPLOAD_DIR[BIGFILE].'/tmp';
	$G_SYS['BIGFILE_UPLOAD_TMP_DEL_HOUR'] = 3;		// 임시 업로드 디렉토리에서 3시간이 지난 파일은 자동 삭제.

// [2008-03-26] 웹사이트 로고
	$UPLOAD_DIR[LOGO] = 'logo/'.$G_SYS[MAIL_DOMAIN];
	$G_SYS[UPLOAD_LOGO_MAX_SIZE] = 2097152;		// 2MB

// [2008-02-04] ActiveX
		$G_SYS['NM_UPLOADER_TITLE_UP'] = 'Nmail Upload';
		$G_SYS['NM_UPLOADER_TITLE_DN'] = 'Nmail Download';
		$G_SYS['NM_UPLOADER_VER'] = '1,0,0,15';
		$G_SYS['NM_UPLOADER_CLSID_UP'] = '9558C641-079A-43E0-991C-AF7326582B27';
		$G_SYS['NM_UPLOADER_CLSID_DN'] = 'AD098E7B-447C-4AF9-8868-B0337CC42E6C';
		//$G_SYS['NM_UPLOADER_CODEBASE'] = 'http://www.passkorea.net/NMailUploader'.$G_SYS['NM_UPLOADER_VER'].'.cab';
		$G_SYS['NM_UPLOADER_CODEBASE'] = $G_SYS['URL_ROOT'].'/include/NMailUploader'.$G_SYS['NM_UPLOADER_VER'].'.cab';
		$G_SYS['NM_UPLOADER_CHARSET'] = 'UTF-8';

// [2008-03-10] Test...
		$G_SYS['NM_MAILBOX_SIZE_CHECK_BYDB'] = false;

// [2008-04-03] 파일 다운로드 시간 제한
		$G_SYS['DOWNLOAD_TIME_LIMIT'] = 43200;		// 43200초 = 12시간

// [2008-06-03] 편지함 백업
		// [2009-05-06] 서버 설정에서 선택
		//$G_SYS['MAIL_BOX_BACKUP_USE'] = true;		// 편지함 백업/복구기능 사용여부
		$G_SYS['MAIL_BOX_BACKUP_LIMIT'] = 1000;		// 한번에 백업가능한 메일갯수.(최대 2000개)
		$G_SYS['MAIL_BOX_BACKUP_PREFIX'] = 'NmailBackup_';		// 백업파일명 앞에 붙을 문자열

		if (!$G_SYS['MAIL_BOX_BACKUP_USE'])
		{
			unset($G_SYS['MAIL_LIST_CMD']['_2']);
			unset($G_SYS['MAIL_LIST_CMD']['MAIL_BACKUP']);
			unset($G_SYS['MAIL_LIST_CMD']['MAIL_BACKUP_2']);
			unset($G_SYS['MAIL_LIST_CMD']['MAIL_RESTORE']);
		}	// if()



// [2008-06-11] 게시판 Active업로드 디렉토리
		$UPLOAD_DIR[BOARD_NEW] = 'board/'.$G_SYS[MAIL_DOMAIN];

// [2008-09-25] 메일로그의 DB 저장기간 제한(일 단위).   디비부하및 용량초과 고려.
	$G_SYS['MAIL_LOG_ANALYZE_LIMIT_DAY']	 = 30;

// [2009-02-09] 편지지
	$G_SYS['NM_LETTER_USE'] = false;		// 편지지기능 사용여부

// [2009-04-02] 주소록에서 추가/수정/아웃룩가져오기 처리시 그룹내에 메일주소 중복검사를 생략함.
	$G_SYS['ADDR_DUPLICATE_CHK_SKIP'] = true;

// [2011-01-10] SSL 지원
//if ($_SERVER['HTTPS'] == 'on')
// [2023-01-11] proxy https 지원
if ($_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https' || $_SERVER['HTTPS'] == 'on')
	$G_SYS['HTTP_URL_ROOT'] = str_replace('http://', 'https://', $G_SYS['HTTP_URL_ROOT']);

// [2012-09-27] 메일용량 부족시 알림 메일.
	// 24시간동안 1회만 발송하고, 이후에는 메일 용량이 85% 이하로 줄어든 경우에만 재 안내함. (즉 메일 용량이 90%를 초과된 상태로 계속 유지된다면, 알림 메일이 다시 발송되지 않음)
	if (!isset($G_SYS['MAIL_QUOTA_ALERT_ISUSE']))
	{
		$G_SYS['MAIL_QUOTA_ALERT_ISUSE'] = true;
		$G_SYS['MAIL_QUOTA_ALERT_RATE'] = 90;		// 메일 용량이 90% 이상 사용되었을 때 알림.
		$G_SYS['MAIL_QUOTA_ALERT_RATE2'] = 85;		// 알림 메일이 발송된 경우, 메일 용량이 85% 이하로 줄어든 경우에만 재발송함.
		$G_SYS['MAIL_QUOTA_ALERT_SUBJECT_LACK'] = '[경고]메일 용량이 부족합니다.';
		$G_SYS['MAIL_QUOTA_ALERT_SUBJECT_OVER'] = '[경고]메일 용량이 초과되었습니다. 새로운 메일을 받을 수 없습니다.';
	}	// if()

// [2024-09-04] 제품 저작권
	if (file_exists($UPLOAD_ROOT.'/config/product_license.html')) {
		$G_SYS['PRODUCT_LICENSE'] = file_get_contents($UPLOAD_ROOT.'/config/product_license.html');
	} else {
        $G_SYS['PRODUCT_LICENSE'] = "<a href=\"https://passkorea.net\" target=\"_blank\" style=\"color:#272727; font-family:tahoma; text-decoration:none;\">Powered by Nmail</a>";
    }

// [2025-11-17] 사용자 정의 스타일(CSS)
	if (file_exists($UPLOAD_ROOT.'/config/user_define_css.html')) {
		$G_SYS['USER_DEFINE_CSS'] = file_get_contents($UPLOAD_ROOT.'/config/user_define_css.html');
	} else {
		$G_SYS['USER_DEFINE_CSS'] = "";
	}

// [2024-09-10] POP3 이용안내 추가 안내
if (file_exists($UPLOAD_ROOT.'/config/help_pop3.html')) {
    $G_SYS['HELP_POP3'] = file_get_contents($UPLOAD_ROOT.'/config/help_pop3.html');
} else {
    $G_SYS['HELP_POP3'] = "";
}

// [2012-09-27] 예약발송
	$UPLOAD_DIR[MAILRESERVE] = 'mailreserve/'.$G_SYS[MAIL_DOMAIN].'/'.$AUTH[auth_m_mail_file_group].'/'.$AUTH[auth_m_id];

// [2012-10-16] 메일링 리스트 개수 제한
	$G_SYS['MAILING_USER_LIMIT'] = 50;		// 도메인내에서 등록 가능한 메일링 리스트 주소 개수
	$G_SYS['MAILING_ADDR_LIMIT'] = 1000;		// 1개 메일링리스트에서 등록 가능한 메일주소 개수

// [2013-07-01] 웹메일 로그인 시도 횟수 제한.  (오늘 날짜를 기준으로 처리되며, 0시가 되면 제한 수가 초기화됨)
	if (!isset($G_SYS['NM_LOGIN_LIMIT_IP_PER_10M']))
	{
		$G_SYS['NM_LOGIN_LIMIT_IP_PER_10M'] = 20;		// 특정 IP에서 10분동안 허용 횟수
		$G_SYS['NM_LOGIN_LIMIT_IP_PER_HOUR'] = 50;		// 특정 IP에서 1시간동안 허용 횟수
		$G_SYS['NM_LOGIN_LIMIT_IP_PER_DAY'] = 200;		// 특정 IP에서 하루동안 허용 횟수
		$G_SYS['NM_LOGIN_LIMIT_EXCLUDE_IP'] = array();		// 로그인 시도를 제한하지 않는 IP - 공유기 환경처럼 모든 PC들의 공인 IP가 동일 할때, 여기에 공인 IP를 선언해두면 해당 IP에서는 로그인 시도 제한을 하지 않습니다.  ex) array('1.2.3.4', '1.2.3.5');

		$G_SYS['NM_LOGIN_LIMIT_MBR_PER_10M'] = 10;		// 특정 아이디로 10분동안 허용 횟수
		$G_SYS['NM_LOGIN_LIMIT_MBR_PER_HOUR'] = 30;		// 특정 아이디로 1시간동안 허용 횟수
		$G_SYS['NM_LOGIN_LIMIT_MBR_PER_DAY'] = 100;		// 특정 아이디로 하루동안 허용 횟수
	}	// if()
	$G_SYS['NM_LOGIN_LOG_LIMIT_DAY'] = 366;		// 웹메일 로그인 로그(DB)는 1년(366일)이 지나면 자동 삭제.

// [2013-07-08] 비밀번호 안전 레벨
	if (!isset($G_SYS['S_PASS_EVEL']))
	{
		$G_SYS['S_PASS_EVEL'] = 4;		// [메일서버관리 - 서버 설정 - 보안설정] 비밀번호 안전 레벨
	}	// if()

// [2024-09-03] 비밀번호 최소 길이
    if (!isset($G_SYS['S_PASS_MIN_LENGTH']))
    {
        $G_SYS['S_PASS_MIN_LENGTH'] = 9;		// [메일서버관리 - 서버 설정 - 보안설정] 비밀번호 최소
    }	// if()

// [2013-10-11] 웹메일 접근 IP
	$G_SYS['NM_WEB_ALLOW_IP_USUSE'] = true;		// 사용함


// [2013-08-05] 모바일웹
	mobile_web_check();

// [2015-11-05] 메일서버관리 > 스팸 단어관리, 스팸 주소관리 기능셋팅
	$G_SYS['NM_SPAM_WORD_ISUSE'] = true;
	$G_SYS['NM_SPAM_WORD_INPUT_MIN_LENGTH'] = 3;                    // 스팸 단어 입력시 최소 3자 이상 입력(유니코드 기준)
	$G_SYS['NM_SPAM_WORD_CHECK_MAX_FILE'] = 1048576000;                 // 메일 크기가 1GB 이상일 경우 스팸 단어 검사 생략
// [2015-11-05] 메일서버관리 > 메일 발송 상태 기능셋팅
// [2024-09-03] server_config에 선언되지 않았을 경우에만 선언해야 하므로 조건 추가
    if (!isset($G_SYS['NM_SMTP_SEND_LIMIT'])) {
        $G_SYS['NM_SMTP_SEND_LIMIT'] = true;
    }
    if (!isset($G_SYS['NM_SMTP_SEND_LIMIT_MBR_PER_HOUR'])) {
        $G_SYS['NM_SMTP_SEND_LIMIT_MBR_PER_HOUR'] = 100;                // 특정 계정에서 시간당 발송가능수.
    }
    if (!isset($G_SYS['NM_SMTP_SEND_LIMIT_MBR_PER_DAY'])) {
        $G_SYS['NM_SMTP_SEND_LIMIT_MBR_PER_DAY'] = 500;                 // 특정 계정에서 1일당 발송가능수.
    }
    if (!isset($G_SYS['NM_SMTP_SEND_LIMIT_IP_PER_HOUR'])) {
        $G_SYS['NM_SMTP_SEND_LIMIT_IP_PER_HOUR'] = 2000;                  // 특정 IP에서 시간당 발송가능수.
    }
    if (!isset($G_SYS['NM_SMTP_SEND_LIMIT_IP_PER_DAY'])) {
        $G_SYS['NM_SMTP_SEND_LIMIT_IP_PER_DAY'] = 5000;                     // 특정 IP에서 1일당 발송가능수.
    }
    if (!isset($G_SYS['NM_SMTP_SEND_LIMIT_LEVEL'])) {
        $G_SYS['NM_SMTP_SEND_LIMIT_LEVEL'] = $G['LEVEL']['serveradmin'];        // 발송수 제한 레벨.  기본 - 일반회원, 관리자, 서버관리자 모두 적용
        #$G_SYS['NM_SMTP_SEND_LIMIT_LEVEL'] = $G['LEVEL']['user'];		// 발송수 제한 레벨.  기본 - 일반회원에게 모두 적용.
    }
	if (!isset($G_SYS['NM_SMTP_SEND_LIMIT_LEVEL_EXCLUDE_EMAILS'])) {
		$G_SYS['NM_SMTP_SEND_LIMIT_LEVEL_EXCLUDE_EMAILS'] = array();
	}

// [2016-12-29] ActiveX 비활성화
	$G_SYS['NM_ACTIVEX_HIDDEN'] = false;
// [2016-12-29] ActiveX 비활성화
	$G_SYS['NM_ACTIVEX_USE'] = false;
// 대용량 첨부시 메일본문에 링크 위치조정(선언시 본문 최상단표시)
    $G_SYS['BIGFILE_DOWNLOAD_LINK_POSITION']="TOP";
// [2020-10] 편지쓰기 답장/전달시 원문과 구분시 수평선 구분사용(false시 기존 들여쓰기 형태)
    $G_SYS['NM_MAIL_WRITE_RELAY_LINE'] = true;
// [2020-10] 도메인관리 "디스크 사용량" 연관 파티션 출력
    $G_SYS['NM_PRINT_REF_HDD_RATE'] = array('/var/lib/mysql/nmail2', '/backup');

    // 비밀번호 변경알림 기능
    // [2024-09-03] 기존 비밀번호 변경알림 기능 관련 설정이 없을 경우에만 쓰도록 조건 추가
    if (!isset($G_SYS['NM_PWDCHANGE_POPUP_USE'])) {
        $G_SYS['NM_PWDCHANGE_POPUP_USE'] = true;                // 비밀번호 변경알림 기능 사용유무
    }
    if (!isset($G_SYS['NM_PWDCHANGE_POPUP_MONTH'])) {
        $G_SYS['NM_PWDCHANGE_POPUP_MONTH'] = 3;                 // 비밀번호 변경알림 주기(월 단위)
    }
    if (!isset($G_SYS['NM_PWDCHANGE_POPUP_AGAIN_ALLOW'])) {
        $G_SYS['NM_PWDCHANGE_POPUP_AGAIN_ALLOW'] = true;        // 비밀번호 변경알림 "나중에 변경" 허용유무
    }
    if (!isset($G_SYS['NM_PWDCHANGE_POPUP_AGAIN_DAY'])) {
        $G_SYS['NM_PWDCHANGE_POPUP_AGAIN_DAY'] = 7;             // 비밀번호 변경알림 "나중에 변경" 지연일자(일 단위)
    }

// [2023-02-21] 편지읽기에서 받는사람이 일정수 이상일 경우만 '더보기' 버튼으로 줄여서 보여주기
	$G_SYS['NM_MAIL_READ_MORE_COUNT'] = 100;

// [2023-06-21] 회원 엑셀 내보내기 사용여부
	$G_SYS['NM_ADMIN_MBR_EXCEL_DOWN'] = true;

// [2024-03-19] 검색 기간 목록
	$G_SYS['NM_SEARCH_DATE_LIST'] = array(
		7    => "1주일",
		31   => "1개월",
		91   => "3개월",
		182  => "6개월",
		365  => "1년",
		730  => "2년",
		1095 => "3년",
		1825 => "5년",
		0    => "전체",
	);

// [2024-09-03] 비밀번호 변경 알림 나중에 변경을 사용하기 위해 추가
$G['ALLOW'] =  array(
    "Y" => "허용함",
    "N" => "허용안함"
);

// [2025-06-26] User Agent OS
$G['USER_AGENT_OS'] = array(
	'Windows'        => 'Windows',     // Windows 10, 11
//	'Windows 8.1'    => 'Windows 8.1',
//	'Windows 8'      => 'Windows 8',
//	'Windows 7'      => 'Windows 7',
//	'Windows Vista'  => 'Windows Vista',
//	'Windows XP'     => 'Windows XP',
	'macOS'          => 'macOS',
//	'Mac OS 9'       => 'Mac OS 9',
	'Android'        => 'Android',
	'iOS (iPhone)'   => 'iOS (iPhone)',
	'iOS (iPad)'     => 'iOS (iPad)',
	'Linux'          => 'Linux',
	'Ubuntu'         => 'Ubuntu',
//	'BlackBerry'     => 'BlackBerry',
//	'Mobile (WebOS)' => 'Mobile (WebOS)',
);

// [2025-10-01] 용량 설정
$G_SYS['QUOTA'] = array(
	'0'       => '초기화',
	'100'     => '100M',
	'500'     => '500M',
	'1024'    => '1G',
	'5120'    => '5G',
	'10240'   => '10G',
	'102400'  => '100G',
	'1048576' => '1TB',
);

// [2025-11-05] 편지읽기 개인 정보 보호를 위한 'HTML 제한' 강제 활성화
$G_SYS['NM_MAIL_READ_HTML_LIMIT'] = array('spam', 'trash');        // 스팸편지함, 지운편지함에서는 HTML 제한 필수로 변경 불가

// [2025-11-11] XMail 엔진 빌드일 (업데이트 확인용
$G_SYS['XMAIL_BUILD_DATE'] = '250930';

// [2025-11-12] 편지함 백업 타입
$G_SYS['MAIL_BOX_BACKUP_TYPE'] = array(
	'filename' => '원본 파일명 유지',
	'subject'  => '메일 날짜 및 제목',
);

// [2025-11-14] 2단계 인증 라벨 (OTP 앱에 등록될 라벨)
$G_SYS['2FA_OTP_LABEL'] = 'Nmail: ';        // 예시) Nmail: id@domain.com

// [2025-11-14] 2단계 인증 필수여부
$G_SYS['IS_2FA_REQUIRED'] = array(
	"Y" => "필수사용",
	"N" => "선택사용",
);
$G_SYS['M_2FA_ISUSE'] = array(
	'Y' => '2단계 인증 사용',
	'N' => '2단계 인증 생략',
);

// [2025-11-24] 편지함 트리 최대 깊이 지정
$G_SYS['NM_MAIL_BOX_MAX_DEPTH'] = 10;      // 기본 10단계

// [2025-11-24] 하위 편지함 추가 제한 - 스팸편지함, 지운편지함, 임시보관함
$G_SYS['NM_MAIL_BOX_CHILD_LIMIT'] = array('spam', 'trash', 'draft');

// [2025-11-25] 전체메일에서 스팸편지함, 지운편지함, 임시보관함 제외
$G_SYS['NM_ALL_MAIL_EXCLUDE'] = array('spam', 'trash', 'draft');

// [2025-11-25] 왼쪽 메뉴 너비 조정 관련 (디자인 수정시 변경 필요)
$G_SYS['NM_SIDEBAR_WIDTH_MIN'] = 210;        // 왼쪽 메뉴 최소 너비(px)
$G_SYS['NM_SIDEBAR_WIDTH_MAX'] = 400;        // 왼쪽 메뉴 최대 너비(px)
$G_SYS['NM_SIDEBAR_DIVIDER_WIDTH'] = 0;      // 리사이즈 구분선 너비 (4px 좌우 마이너스 마진으로 0)

// [2025-11-25] 스팸신고 제외
$G_SYS['NM_SPAM_REPORT_EXCLUDE'] = array('sent', 'spam', 'trash', 'draft');

// [2025-12-01] 대표 계정 사용 여부
if (!isset($G_SYS['NM_TEAM_MAIL'])) {
	$G_SYS['NM_TEAM_MAIL'] = true;
}

// [2025-12-02] 스팸메일 신고하기 사용여부
if (!isset($G_SYS['IS_SPAM_REPORT'])) {
	$G_SYS['IS_SPAM_REPORT'] = false;
}

// [2026-01-05] 스팸메일 오탐지 신고하기 사용여부
if (!isset($G_SYS['IS_NOT_SPAM_REPORT'])) {
	$G_SYS['IS_NOT_SPAM_REPORT'] = false;
}

// [2025-12-10] 프리미엄 안티스팸 자동 업데이트
if (!isset($G_SYS['S_SPAM_UPDATE_AUTO'])) {
	$G_SYS['S_SPAM_UPDATE_AUTO'] = false;
}

// [2025-12-10] 프리미엄 안티스팸 버전
if (!isset($G_SYS['S_SPAM_UPDATE_VERSION_SELECT']) || $G_SYS['S_SPAM_UPDATE_VERSION_SELECT'] == '') {
	$G_SYS['S_SPAM_UPDATE_VERSION_SELECT'] = 'DEFAULT';
}

// [2025-12-22] 아이디 / 비밀번호 찾기 제한
if (!isset($G_SYS['SEARCH_LOST_LIMIT_LEVEL'])) {
	$G_SYS['SEARCH_LOST_LIMIT_LEVEL'] = 'ALL';
}

################################################################################
// [2025-05-20] 2단계 인증, 브라우저 인식용 쿠키 추가
tfa_cookie_add();

// [2022-09-27] 정규 표현식 최대 길이를 메일 본문만큼 지원.  PHP 기본값) 5.3.7 이하 100KB, 이상 1MB
ini_set('pcre.backtrack_limit', $G_SYS['DB_MEDIUMTEXT']);		//  MySQL 16.7MB
################################################################################


	// [2008-01-10] 사용자 정의 루틴을 별도 파일에서 사용할 수 있도록 함.
	require_once('include/global_user_define.inc.php');


################################################################################

// [2010-09-10] 편지목록에서 선택한 메일만 백업할 때, ActiveX 사용여부.(기본값은 false)
if (!$G_SYS['MAIL_BOX_BACKUP_ACTIVEX_USE'])
	unset($G_SYS['MAIL_LIST_CMD']['MAIL_BACKUP_2']);
else
	unset($G_SYS['MAIL_LIST_CMD']['MAIL_BACKUP']);

// [2012-10-22] IE 10 fix
// [2013-10-28] IE 11 fix
//if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE 10') !== false)
//if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE 10') !== false || (strpos($_SERVER['HTTP_USER_AGENT'], 'Trident') !== false && strpos($_SERVER['HTTP_USER_AGENT'], 'rv:11') !== false))
//	$G_SYS['NM_HTML_HEAD_FIRST'] .= '<meta http-equiv="X-UA-Compatible" content="IE=EmulateIE11">';


// [2013-10-11] 웹메일 접근 IP - 비밀번호찾기/회원가입 등 제한.
	if ($G_SYS['NM_WEB_ALLOW_IP_USUSE'] && $G['THISPAGE'] == 'member.php')
	{
		if (in_array($_GET['mode'], array('ID_CHECK', 'JOIN', 'JOIN_OK', 'LOST1', 'LOST2', 'LOST_OK', 'NOTICE', 'ZIPCODE_SEARCH')) ||
			in_array($_POST['mode'], array('ID_CHECK', 'JOIN', 'JOIN_OK', 'LOST1', 'LOST2', 'LOST_OK', 'NOTICE', 'ZIPCODE_SEARCH')))
		{
			require_once('include/admin_web_allow_ip_lib.php');
			if (web_allow_ip_active($G['DINFO']['d_no']) && !web_allow_ip_check($G['DINFO']['d_no'], $_SERVER[REMOTE_ADDR]))
			{
				msg("접근한 IP(".$_SERVER['REMOTE_ADDR'].")에서는 웹메일에 접근할 수 없습니다.\\n\\n관리자가 접근 할 수 있는 IP를 제한 해두었습니다.\\n\\n관리자에게 문의하여 주십시오.");
			}	// if()
		}	// if()
	}	// if()

