
	/**
		마우스 오른쪽버튼 제한
	*/
	function click() {
		if ((event.button==2) || (event.button==3)) {
			alert('보안상 마우스 오른쪽 버튼은 사용할수 없습니다.');
		}
	}

	//document.onmousedown=click;


	/**
		하단 상태바 문구 지정

	*/
	var status_text = '상태바고정문구';
	function showstatus()
	{
	window.status = status_text;
	timerID= setTimeout('showstatus()', 0);
	}
	//showstatus();


	function window_open(url, target, width, height)
	{
        // [2024-04-19] IE 에서만 세로 스크롤 생기지 않도록 5px 추가하고, 하단 status=no 로 변경
        if (navigator.appVersion.indexOf("MSIE") != -1 || navigator.appVersion.indexOf("Trident") != -1) {
            height = height + 5;
        }

		window.open(url, target, 'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,copyhistory=no,width=' + width + ',height=' + height);
	}	// function


	function window_open_menu(url, target, width, height)
	{
		window.open(url, target, 'toolbar=yes,location=no,status=yes,menubar=yes,scrollbars=yes,resizable=yes,copyhistory=no,width=' + width + ',height=' + height);
	}	// function


	function flashView(s,w,h,d,t){
			var _wh;
			if (w != '')
				_wh += " width=\""+w+"\" ";
			if (h != '')
				_wh += " height=\""+h+"\" ";

			var _loc = new String(document.location);
			var _http = 'http';
			if (_loc.indexOf("https://") != -1)
				_http = 'https';

			// [2011-01-10] SSL 지원
			//document.writeln("<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0\" "+_wh+" id="+d+"><param name=wmode value="+t+" /><param name=movie value="+s+" /><param name=quality value=high /><embed src="+s+" quality=high wmode="+t+" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/shockwave/download/index.cgi?p1_prod_version=shockwaveflash\"  "+_wh+" ></embed></object>");
			document.writeln("<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" codebase=\"" + _http + "://fpdownload.adobe.com/pub/shockwave/cabs/flash/swflash.cab\" "+_wh+" id="+d+"><param name=wmode value="+t+" /><param name=movie value="+s+" /><param name=quality value=high /><embed src="+s+" quality=high wmode="+t+" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.adobe.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\"  "+_wh+" ></embed></object>");
	}	// function

	function objectView(src){
			document.writeln(src);
	}	// function

	function MM_preloadImages() { //v3.0
		var d=document;
		if(d.images){
			if(!d.MM_p)
				d.MM_p=new Array();
			var i, j=d.MM_p.length, a= MM_preloadImages.arguments;
			for(i=0; i<a.length; i++)
				if (a[i].indexOf("#")!=0){
					d.MM_p[j]=new Image;
					d.MM_p[j++].src=a[i];
				}
		}
	}

	// [2012-10-22] IE 10 fix
	function get_activex_use_support() {
		var isSupported = false;
		try {
			new ActiveXObject('');
		}
		catch (e) {
			if (e.name === 'TypeError' || e.name === 'Error') {
				isSupported = true;
				try {
					isSupported = !!new ActiveXObject("htmlfile");
				} catch (e2) {
					isSupported = false;
				}
			}
		}
		return isSupported;
	}

	// [2013-10-28] IE 11 fix
	function get_activex_agent_support() {
		var isSupported = false;
		if (navigator.appVersion.indexOf("MSIE") != -1 || navigator.appVersion.indexOf("Trident") != -1)
			isSupported = true;
		return isSupported;
	}

    /**
     * 멀티 업로드 - Ajax 응답 에러 확인
     *   - 서버 응답 상태가 200이 아니거나, error 값이 있을 경우  경고창 표시
     *
     * @param statusErrorPrefix
     * @param html
     * @param textStatus
     * @param xhr
     * @param $  FileAPI
     * @returns {boolean}
     */
    function fileapi_ajax_error_check(statusErrorPrefix, html, textStatus, xhr, $) {
        var data;
        try {
            if (xhr.getResponseHeader('Content-Type').indexOf('json') > -1) {
                data = $.parseJSON(xhr.responseText);
            } else {
                data = xhr.responseText;
            }
        } catch (e) {
            data = e.toString();
        }
        if (xhr.status === 200 && data.hasOwnProperty('error')) {
            if (data.error !== null && data.error !== '') {
                alert(statusErrorPrefix + "\n\n" + data.error);

                return false;
            }
        } else {
            alert(statusErrorPrefix + "\n\n"
                + "서버 응답 : " + xhr.status + ' ' + xhr.statusText + '\n'
                + "오류 내용 : " + xhr.responseText);

            return false;
        }

        return true;
    }

    /**
     * 메일 미리보기 이벤트
     */
    function mail_preview_event() {
        /**
         * 메일 미리보기 여닫기
         */
        $('.btn-icon-preview').on('click', function () {
            var $this = $(this),
                preview_box = $('#preview_box'),
                report_box = $('#report_box');

            // 임시보관함/지운편지함/스팸편지함 이면 열지 않아야 함.
            if ($this.data('mb_id') === 'spam' || $this.data('mb_id') === 'draft' || $this.data('mb_id') === 'trash' ) {
                $('.btn-preview-box-mail-spam-report').hide();
            } else {
                $('.btn-preview-box-mail-spam-report').show();
            }

            // 미리보기 한번 더 누르면 닫기
            if (preview_box.data('mf_no') !== undefined && preview_box.data('mf_no') === $this.data('mf_no')) {
                $this.removeClass('active');
                preview_box.removeClass('active');
                preview_box.removeData('mf_no');
                return false;
            }

            // 스팸신고가 열려있을 경우 닫도록 추가
            if (report_box.hasClass('active')) {
                report_box.removeClass('active');
                report_box.removeData('mf_no');
            }

            // 클릭한 미리보기 링크 활성화
            $('.btn-icon-preview.active').removeClass('active');
            $this.addClass('active');

            if (preview_box.hasClass('active')) {
                preview_box.removeClass('active');
            }

            var ip = $this.data('mf_send_ip'),
                from = $this.data('from'),
                to = $this.data('to'),
                cc = $this.data('cc'),
                content = $this.data('preview');

            if (cc !== '') {
                $('#preview_box_cc').show();
            } else {
                $('#preview_box_cc').hide();
            }

            if (ip) {
                // var ip_view = ip + ' <a class="btn btn-default btn-xs" href="' + nmpath + '/admin_mail_log.php?s_field=s_ip&s_word=' + ip + '" target="_blank">메일 로그</a>';
                var ip_view = ' <a href="' + nmpath + '/admin_mail_log.php?s_field=s_ip&s_word=' + ip + '" target="_blank">' + ip + ' <i class="bi bi-box-arrow-up-right" style="font-size: 12px"></i></a>';
                preview_box.find('.preview-box-ip').html(ip_view);
            }

            preview_box.find('.preview-box-from').text(from);
            preview_box.find('.preview-box-to').text(to);
            preview_box.find('.preview-box-cc').text(cc);

            var htmlContent = content.replace(/&/g, "&amp;")
                .replace(/</g, "&lt;")
                .replace(/>/g, "&gt;")
                .replace(/"/g, "&quot;")
                .replace(/'/g, "&#39;")
                .replace(/\n/g, '<br>');
            preview_box.find('.preview-box-content').html(htmlContent);


            // 위치 이동
            var viewportHeight = window.innerHeight; // 현재 회면 높이

            var rect = $this[0].getBoundingClientRect();

            var position = $this.parent().position(); // 클릭된 요소의 위치

            var subject = '';
            if ($('.mail-list-subject').length > 0) {
                subject = $('.mail-list-subject');
            } else if ($('.mail-list-subject-title').length > 0) {
                subject = $('.mail-list-subject-title');
            }

            var subject_position = 0;
            if (subject !== '') {
                subject_position = subject.position(); // 제목 위치
            }

            var top = position.top + 18;
            // 화면 아래로 나가지 않도록 높이 계산하여 미리보기를 위로 보여주도록 조건 추가
            if (viewportHeight < rect.top + preview_box.height()) {
                top = position.top - preview_box.height() - 80;
            }

            preview_box.css({
                top: top,
                left: subject_position.left,
            });

            preview_box.toggleClass('active');

            // 강제로 스크롤 초기화
            preview_box.find('.preview-box-content').scrollTop(0);

            $('.btn-preview-box-read').data('mf_no', $this.data('mf_no'));
            $('.btn-preview-box-delete').data('mf_no', $this.data('mf_no'));
            preview_box.data('mf_no', $this.data('mf_no'));
        });


        /**
         * 미리보기 닫기
         */
        $('.btn-preview-box-close').on('click', function () {
            var preview_box = $('#preview_box');

            preview_box.removeData('mf_no');
            preview_box.removeClass('active');

            // 클릭한 미리보기 링크 비활성화
            $('.btn-icon-preview.active').removeClass('active');
        });

        /**
         * 미리보기 읽음
         */
        $('.btn-preview-box-read').on('click', function () {
            var mf_no = $(this).data('mf_no'),
                url = nmpath + "/mail_mark.php?mode=READ&mf_no=" + mf_no;

            if (typeof get_qs !== 'undefined' && get_qs !== '') {
                url += '&' + get_qs;
            }

            $.ajax({
                url: url,
                type: 'POST',
                success: function (response) {
                    location.reload();
                }
            });
        });

        /**
         * 미리보기 삭제
         */
        $('.btn-preview-box-delete').on('click', function () {
            var $this = $(this),
                mf_no = $this.data('mf_no'),
                mb_id = $this.data('mb_id'),
                res = true;

            if (mb_id === 'trash') {
                res = confirm("선택한 메일을 영구히 삭제하시겠습니까?");
            }

            if (res === true) {
                $.ajax({
                    url: nmpath + '/mail_del.php',
                    type: 'POST',
                    data: {
                        'mf_no': mf_no,
                    },
                    success: function (response) {
                        location.reload();
                    }
                });
            }
        });
    }


    /**
     * 중요 메일 별표 아이콘 클릭시 설정 및 해제
     *
     * @param mf_no
     */
    function mail_star_click(mf_no)
    {
        $.ajax({
            url: nmpath + '/mail_star_ok.php',
            type: 'POST',
            data: {
                'mf_no': mf_no,
            },
            success: function (response) {
                var mail_star = document.getElementById('mail_star');

                var span = document.querySelector('#mail_star > .bi');

                if (mail_star.classList.contains('on')) {
                    mail_star.classList.remove('on');

                    span.classList.remove('bi-star-fill');
                    span.classList.add('bi-star');
                } else {
                    mail_star.classList.add('on');

                    span.classList.remove('bi-star');
                    span.classList.add('bi-star-fill');
                }
            }
        });
    }

    /**
     * 메일 읽기 - 새창에서 열기
     *
     * @param mb_id 편지함 이름
     * @param mf_no 편지번호
     */
    function mail_list_new_window(mb_id, mf_no)
    {
        var windowWidth = $(window).width();

        window_open(nmpath + '/mail_read.php?mb_id=' + mb_id + '&mf_no=' + mf_no + '&window_open=1', '', windowWidth, 900);
    }

    // [2025-09-26] bfcache 사용하지 않도록 unload 이벤트 추가
    window.addEventListener("unload", function () {
    });

    // [2025-09-26] 뒤로가기시 bfcache 에서 복원되는 캐싱 페이지일 경우 강제 새로고침
    //   모바일 및 2026년 8월 unload 이벤트 지원 중단 보완 https://developer.chrome.com/docs/web-platform/deprecating-unload?hl=ko
    window.addEventListener('pageshow', function (event) {
        if (event.persisted) {
            window.location.reload();
        }
    });

    /**
     * HTML 원본 보기
     */
    function mail_html_origin_view()
    {
        if (confirm("주의) 안전하지 않은 메일에서는 원본 보기를 하시면 안됩니다.\n\n"
            + "원본내 악성 코드 등 이 잘못 실행될 위험이 있습니다.\n\n"
            + "HTML 원본을 보시겠습니까?")) {
            window.location.href = nmpath + "/mail_read.php?ov=1&" + get_qs;
        }
    }

    /**
     * HTML 보기
     */
    function mail_html_purifier_view()
    {
        if (confirm("주의) 안전하지 않은 메일에서는 HTML 보기를 하시면 안됩니다.\n\n"
            + "원본내 악성 코드 등 이 잘못 실행될 위험이 있습니다.\n\n"
            + "HTML을 보시겠습니까?")) {
            window.location.href = nmpath + "/mail_read.php?hv=1&" + get_qs;
        }
    }

    /**
     * AUTO LINK 활성화
     */
    function mail_auto_link_view()
    {
        if (confirm("주의) 안전하지 않은 메일에서는 링크 활성화를 하시면 안됩니다.\n\n"
            + "링크 활성화를 하시겠습니까?")) {
            window.location.href = nmpath + "/mail_read.php?hv=1&" + get_qs;
        }
    }

    /**
     * 로그인 폼 이벤트
     */
    function form_login_event()
    {
        window.onload = function () {
            if (document.getElementById('m_id').value !== '') {
                document.getElementById('m_pwd').focus();
            } else {
                document.getElementById('m_id').focus();
            }
        }

        // 인증 실패후 뒤로가기로 되돌아온 경우 비밀번호 입력으로 포커스
        window.addEventListener("pageshow", function (event) {
            if (document.getElementById('m_id').value !== '') {
                document.getElementById('m_pwd').focus();
            } else {
                document.getElementById('m_id').focus();
            }
        });
    }

    /**
     * 로그인 폼 검사
     *
     * @returns {boolean}
     */
    function chk_login()
    {
        var form = document.login;

        if (form_chk_value(form.m_id, "아이디") == false) return false;
        if (form_chk_value(form.m_pwd, "비밀번호") == false) return false;

        if (form_chk_minLen(form.m_id, "아이디", m_id_min_length) == false) return false;
        if (form_chk_minLen(form.m_pwd, "비밀번호", 4) == false) return false;

        if (form_chk_onlyEngNum(form.m_id, "아이디") == false) return false;
    }

    /**
     * IP 보안 체크 확인
     *
     * @param obj
     */
    function is_ip_check_click(obj)
    {
        if (obj.checked == false)
        {
            if (!confirm("[IP보안]을 사용하지 않겠습니까?\n\n\n※ IP보안 안내\n\n  로그인한 IP와 접근하는 IP가 일치하는지 체크하여 보안을 강화시키는 기능입니다.\n\n  단, IP가 자주 변경되는 특수한 환경에서는 사용하지 않는 것이 좋습니다."))
                obj.checked = true;
        }	// if()
    }

    /**
     * 2단계 인증, OTP 입력폼 이벤트
     */
    function form_otp_event()
    {
        window.onload = function () {
            document.getElementById('m_otp').focus();
        }

        // 인증 실패후 뒤로가기로 되돌아온 경우 입력된 코드 초기화
        window.addEventListener("pageshow", function (event) {
            document.getElementById('m_otp').value = '';
        });
    }

    /**
     * 2단계 인증, OTP 입력폼 검사
     */
    function form_chk_otp()
    {
        var m_otp = document.getElementById('m_otp');

        if (!/^[0-9]{6}$/.test(m_otp.value)) {
            alert("인증 코드는 6자리 숫자로만 입력하세요.");
            m_otp.focus();
            m_otp.select();

            return false;
        }
    }

    /**
     * 2단계 인증, 다음에 등록
     */
    function otp_save_for_later()
    {
        var form = document.login;

        var input = document.createElement("input");
        input.type = "hidden";
        input.name = "save_for_later";
        input.value = "1";
        form.appendChild(input);

        form.submit();
    }


    /**
     * 편지함 트리 이벤트
     */
    function mail_box_tree_event() {
        var $ = jQuery;
        const $menu = $(".mail-left-menu");

        // 하위 편지함 열기/닫기 이벤트
        $menu.on("click", ".btn-toggle-child", function(e) {
            e.stopPropagation();
            e.preventDefault();
            const $this = $(this).closest("li");
            const isOpen = $this.hasClass("child-open");

            if (isOpen) {
                $this.removeClass("child-open")
                    .addClass("child-close");
            } else {
                $this.removeClass("child-close")
                    .addClass("child-open");
            }

            // 편지함 펼침 여부 저장
            $.ajax({
                url: nmpath + '/mail_box_open_ok.php',
                type: 'POST',
                data: {
                    'mb_id': $this.data('mb-id'),
                    'open':isOpen,
                    'open':isOpen,
                },
                success: function (response) {

                }
            });
        });

        // [2025-11-25] 왼쪽 메뉴 너비 조정
        var affix_sidebar_divider = document.getElementById("affix_sidebar_divider");

        if (affix_sidebar_divider) {
            var affix_sidebar = document.getElementById("affix_sidebar");
            var affix_content = document.getElementById("affix_content");
            var affix_sidebar_divider_dragging = false;

            affix_sidebar_divider.addEventListener("mousedown", function (e) {
                affix_sidebar_divider_dragging = true;
            });

            document.addEventListener("mousemove", function (e) {
                if (affix_sidebar_divider_dragging) {
                    var clientX = e.clientX;

                    // 최소, 최대 너비 제한
                    if (clientX <= nm_sidebar_width_min) {
                        clientX = nm_sidebar_width_min;
                    } else if (clientX >= nm_sidebar_width_max) {
                        clientX = nm_sidebar_width_max;
                    }

                    affix_sidebar.style.width = clientX + "px";
                    // affix_content.style.width = (document.documentElement.clientWidth - clientX - 4) + "px";
                    affix_content.style.width = 'calc(100% - ' + (clientX + nm_sidebar_divider_width) + "px)";

                    // 쿠키 저장
                    var expDate = new Date();
                    expDate.setDate(expDate.getDate() + 3650);
                    document.cookie = 'nm_sidebar_width=' + clientX + ';expires=' + expDate.toGMTString();
                }
            });

            document.addEventListener("mouseup", function (e) {
                affix_sidebar_divider_dragging = false;
            });
        }
    }

    /**
     * 하위 편지함 선택 이벤트
     */
    function include_child_change(form)
    {
        form.submit();
    }

    /**
     * 스팸 신고 창 이벤트
     */
    function mail_spam_report(form, $this, is_preview) {
        if (is_preview === undefined) {
            is_preview = false;
        }

        if (!is_preview) {
            if (countCheckBox(form, 'cmf[]') < 1) {
                alert("신고할 메일을 선택하여 주십시오.");
                return;
            }
        }

        var report_box = $('#report_box'),
            preview_box = $('#preview_box');

        report_box.removeClass('active');

        // 미리보기가 있을 경우에만 삭제
        if (preview_box.length > 0) {
            report_box.removeData('mf_no');
        }

        // 위치 이동
        var viewportHeight = window.innerHeight; // 현재 회면 높이
        var viewportWidth = window.innerWidth; // 현재 화면 넓이
        if (! is_preview) { // 기본 스팸 신고 버튼
            var rect = $this.getBoundingClientRect();
            var position = $($this).position();

            var top = rect.top - 35;
            var left = position.left - (report_box.outerWidth() / 2);
            // 화면 아래로 나가지 않도록 높이 계산하여 미리보기를 위로 보여주도록 조건 추가
            if (viewportHeight < rect.top + report_box.height()) {
                top = position.top - report_box.height() - 80;
            }

            report_box.css({
                top: top,
                left: left,
            });
        } else { // 미리보기에서 열 때
            var el = document.getElementById('preview_box');
            if (el) {
                var rect = el.getBoundingClientRect();

                report_box.css({
                    top: rect.top + document.documentElement.scrollTop - 65,
                    left: rect.left + document.documentElement.scrollLeft - 225,
                });
            } else {
                var rect = $this.getBoundingClientRect(),
                    position = $($this).position();

                var top = rect.top - 35;
                var left = position.left - (report_box.outerWidth() / 2);
                // 화면 아래로 나가지 않도록 높이 계산하여 미리보기를 위로 보여주도록 조건 추가
                if (viewportHeight < rect.top + report_box.height()) {
                    top = position.top - report_box.height() - 80;
                }

                report_box.css({
                    top: top,
                    left: left,
                });
            }

            // 미리보기가 있을 경우에만 추가
            if (preview_box.length > 0) {
                report_box.data('mf_no', preview_box.data('mf_no'));
            }
        }

        if (preview_box.hasClass('active')) {
            preview_box.removeData('mf_no');
            preview_box.removeClass('active');
        }

        report_box.addClass('active');
    }

    /**
     * 스팸 신고 창 닫기
     */
    function report_box_close()
    {
        $('#report_box').removeClass('active');
        $('#report_box').removeData('mf_no');
    }

    /**
     * 스팸 신고 - 여러건
     *
     * @param form
     */
    function mail_spam_report_all_ok(form)
    {
        var report_box = $('#report_box');

        if (countCheckBox(form, 'cmf[]') < 1 && report_box.data('mf_no') === undefined)
        {
            alert("신고할 메일을 선택하여 주십시오.");
            return;
        }

        // 미리보기에서 스팸 신고시 mf_no 넘기기
        if (countCheckBox(form, 'cmf[]') < 1 && report_box.data('mf_no') !== undefined) {
            let input = document.createElement("input");
            input.type = "hidden";
            input.name = "mf_no";
            input.value = report_box.data('mf_no');
            form.appendChild(input);
        }

        var message = '선택한 메일을 스팸으로 신고하시겠습니까?';

        // 라디오 버튼 선택
        var selected = document.querySelector('input[name="mail_report_select"]:checked').value;

        if (selected !== 'spam') {
            message += '\n\n신고 후 메일은 지운편지함으로 이동합니다.';
        } else {
            message += '\n\n신고 후 메일은 스팸편지함으로 이동합니다.';
        }

        var isChecked = document.getElementById('mail_spam_reject').checked;

        if (isChecked) {
            message += '\n\n신고 후 보낸사람 주소를 수신거부에 추가합니다.'
        }

        res = confirm(message);

        if (res == true)
        {
            form.action = nmpath + "/mail_spam_report.php?" + get_qs;
            form.method = "post";
            form.submit();
        }
    }

    /**
     * 스팸 신고 - 1건
     * @param $page
     */
    function mail_spam_report_ok($page)
    {
        var message = '메일을 스팸으로 신고하시겠습니까?';

        // 라디오 버튼 선택
        var selected = document.querySelector('input[name="mail_report_select"]:checked').value;

        if (selected !== 'spam') {
            message += '\n\n신고 후 메일은 지운편지함으로 이동합니다.';
        } else {
            message += '\n\n신고 후 메일은 스팸편지함으로 이동합니다.';
        }

        var isChecked = document.getElementById('mail_spam_reject').checked;

        if (isChecked) {
            message += '\n\n신고 후 보낸사람 주소를 수신거부에 추가합니다.'
        }

        res = confirm(message);

        if (res == true)
        {
            var url = nmpath + "/mail_spam_report.php";

            var data = {
                    'mail_report_select': selected,
                    'mail_spam_reject': Number(isChecked),
                    'page': $page,
                };

            if ($page !== 'mail_read.php') {
                data['type'] = 'json';
                data['mf_no'] = $('#report_box').data('mf_no');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: data,
                    success: function (response) {
                        location.reload();
                    }
                });
            } else {
                // mf_no 넘기기
                if (typeof get_qs !== 'undefined' && get_qs !== '') {
                    url += '?' + get_qs;
                    url += '&';
                } else {
                    url += '?';
                }

                var queryString = '';
                for (var key in data) {
                    if (data.hasOwnProperty(key)) {
                        if (queryString.length > 0) {
                            queryString += '&';
                        }
                        queryString += encodeURIComponent(key) + '=' + encodeURIComponent(data[key]);
                    }
                }
                url += queryString;
                window.location.href = url;
            }
        }
    }