<?


###############################################################################




###############################################################################


	/** 게시판 관리정보 가져오기

		ex) $ba = board_admin_info($ba_no);		// array

	*/
	function board_admin_info($ba_no, $ismsg="Y")
	{
		global $db, $TB, $AUTH, $G;

		#$q = "SELECT ba.*, m.m_id FROM $TB[BOARD_ADMIN] ba, $TB[MEMBER] m WHERE ba.ba_no='$ba_no' AND ba.m_no=m.m_no";
		// [2008-03-21] 로그인하지 않았을 경우의 예외처리 추가.
		//$q = "SELECT ba.* FROM $TB[BOARD_ADMIN] ba WHERE ba.ba_no='$ba_no' AND ba.d_no='" . $AUTH['auth_d_no'] ."'";
		$q = "SELECT ba.* FROM $TB[BOARD_ADMIN] ba WHERE ba.ba_no='$ba_no' AND ba.d_no='" . $G['DINFO']['d_no'] ."'";
		//echo "<HR>" . $q;
		$ba = db_get_row($q);		

		if (($ismsg == "Y")&&($ba == NULL)) msg("존재하지 않는 게시판입니다.");

		return $ba;
	}	// function()


###############################################################################


	/** 게시판 내용 가져오기

		ex) $board = board_info($ba_no, $b_no);		// array

		[2002-06-07]
		ex) $board = board_info($ba_no, $b_no[$i], "N");		// array

	*/
	function board_info($ba_no, $b_no, $ismsg="Y")
	{
		global $db, $TB;

		$q = "SELECT * FROM $TB[BOARD] WHERE b_no='$b_no' AND ba_no='$ba_no'";
		$board = db_get_row($q);		

		if (($ismsg == "Y")&&($board == NULL)) msg("존재하지 않는 게시물입니다.");

		return $board;
	}	// function()



###############################################################################


	/** 게시판 덧말 내용 가져오기

		ex) $bc = board_comment_info($ba_no, $b_no, $bc_no);		// array

	*/
	function board_comment_info($ba_no, $b_no, $bc_no)
	{
		global $db, $TB;

		$q = "SELECT * FROM $TB[BOARD_COMMENT] WHERE bc_no='$bc_no' AND b_no='$b_no' AND ba_no='$ba_no'";
		$bc = db_get_row($q);		

		if($bc == NULL) msg("존재하지 않는 덧말입니다.");

		return $bc;
	}	// function()


###############################################################################


	/** 게시판 관리자 확인하기

		ex) $ba[is_admin] = board_is_admin($ba[m_no]);		// true|false

	*/
	function board_is_admin($ba_m_no='NOTUSE')
	{
		global $AUTH, $G;

		if ( ($AUTH[auth_m_no] == $ba_m_no) || ($AUTH[auth_m_level] >= $G[LEVEL][admin]) )		// 게시판 지정 관리자이거나 컨텐츠관리자일때
		{
			return true;
		}else
		{
			return false;
		}	// if()

	}	// function()


###############################################################################


	/** 게시판 추가/답변/수정/삭제시 회원여부 확인하기

		ex) $board[is_member] = board_is_member($board[m_no], $ba[ba_perm_modify]);		// true|false

	*/
	function board_is_member($m_no, $perm=0)
	{
		global $AUTH;

		if($perm == 0)
		{
			$is_member = ($AUTH[auth_m_id]) ? true : false;
		}else
		{
			// 로그인하고 자신의 글일때, 수정권한(관리자)이 있을때만 회원용폼으로 처리함.
			if(  ( ($AUTH[auth_m_id]) && ($m_no == $AUTH[auth_m_no]) ) || ($AUTH[auth_m_level] >= $perm)  )
				$is_member = true;
		}	// if()

		//echo ">>>" . $m_no . " - " . $perm . " - " . $is_member;

		return $is_member;

	}	// function()


###############################################################################


	/** 게시판 글추가시 도배방지
		- 3분이내에 같은 IP로 동일한 제목의 글을 올릴경우 제한함.

		ex) board_loop_limit($b_subject);

	*/
	function board_loop_limit($b_subject)
	{
		global $TB, $db, $_SERVER;

		// [2011-01-03] 대부분 내부 게시판 용도로 사용되므로, 제한 시간을 180초에서 10초로 변경함.
		
		$q = "SELECT count(*) AS cnt FROM $TB[BOARD] WHERE b_regdate > '" . date("Y-m-d H:i:s", time() - 10) . "' AND b_reghost='" . $_SERVER["REMOTE_ADDR"] . "' AND b_subject='$b_subject'";
		$chk_loop = db_get_row($q);		

		if ($chk_loop[cnt] > 0) msg("도배방지를 위해 하나의 IP에서 10초 이내에 동일한 제목의 글을 올릴 수 없습니다.");

	}	// function()


###############################################################################


	/** 게시판 답변 최대개수 제한
		- db file type 참조.

		ex) board_reply_limit($ba_no, $b_no);

	*/
	function board_reply_limit($ba_no, $b_no)
	{
		global $db, $TB, $G_SYS;

		$max_reply = 65535;		// smallint(5)

		$q = "SELECT count(*) AS cnt FROM $TB[BOARD] WHERE b_ref='$b_no' AND ba_no='$ba_no'";
		$board_reply = db_get_row($q);		

		//echo "관련 게시물수 : " . $board_reply[cnt];


		if ( $board_reply[cnt] >= $max_reply )
		{
			msg("최대 답변갯수인 " . $max_reply . "번을 초과하였습니다.\\n\\n현재 게시물에 더 이상 답변을 달 수 없습니다.");
		}	// if()
	}	// function()


###############################################################################


	/** 게시판 답변 삭제 제한

		ex) board_reply_del_limit($ba_no, $b_no, $board[b_re_level]);

	*/
	function board_reply_del_limit($ba_no, $b_no, $b_re_level)
	{
		global $db, $TB;

		$q = "SELECT count(*) AS cnt FROM $TB[BOARD] WHERE b_ref='$b_no' AND b_re_level > '$b_re_level' AND ba_no='$ba_no'";
		$board_reply = db_get_row($q);

		//echo "관련 게시물수 : " . $board_reply[cnt];

		if ( $board_reply[cnt] >= 1 )
		{
			msg("답변이 있는 글은 삭제할 수 없습니다.");
		}	// if()
	}	// function()


###############################################################################


	/** 게시판 조회수 증가

		ex) board_refer_plus($ba_no, $b_no);

	*/
	function board_refer_plus($ba_no, $b_no)
	{
		global $TB, $db, $AUTH, $ba;
		
		$q = "UPDATE $TB[BOARD] SET b_refer=b_refer+1 WHERE b_no='$b_no' AND ba_no='$ba_no'";
		//echo "<HR>" . $q;
		db_query($q);


		// [2010-12-22] 조회기록 추가
		if ($ba[ba_isuse_read_log] == "Y")
		{
			$q = "SELECT COUNT(*) FROM ".$TB['BOARD_READ_LOG']." WHERE b_no='".$b_no."' AND ba_no='".$ba_no."' AND m_no='".$AUTH['auth_m_no']."'";
			$read_log_cnt = db_get_one($q);
			if ($read_log_cnt == 0)
			{
				$q = "INSERT INTO ".$TB['BOARD_READ_LOG']." (br_no, ba_no, b_no, m_no, br_regdate, br_reghost) VALUES (".db_sqc_next($TB['BOARD_COMMENT']).", '$ba_no', '$b_no', '".$AUTH['auth_m_no']."', '".date('Y-m-d H:i:s')."', '".$_SERVER["REMOTE_ADDR"]."')";
				//echo "<HR>" . $q;
				db_query($q);	
			}	// if()
		}	// if()		
	}	// function()



###############################################################################


	/** 게시판 추천수 증가

		ex) board_vote_plus($ba_no, $b_no);

	*/
	function board_vote_plus($ba_no, $b_no)
	{
		global $TB, $db;
		
		$q = "UPDATE $TB[BOARD] SET b_vote=b_vote+1 WHERE b_no='$b_no' AND ba_no='$ba_no'";
		//echo "<HR>" . $q;
		db_query($q);
		
	}	// function()


###############################################################################


	/** 게시판 덧말 내용 가져오기

		ex) board_comment_update($ba_no, $b_no);

	*/
	function board_comment_update($ba_no, $b_no)
	{
		global $db, $TB;

		// count - comment
			$q = "SELECT count(*) AS cnt FROM $TB[BOARD_COMMENT] WHERE b_no='$b_no' AND ba_no='$ba_no'";
			$bc = db_get_row($q);

		// update
			$q = "UPDATE $TB[BOARD] SET b_comment='" . $bc[cnt] . "' WHERE b_no='$b_no' AND ba_no='$ba_no'";
			//echo "<HR>" . $q;
			db_query($q);
				

	}	// function()



###############################################################################

	/** 게시판 덧말 내용 가져오기

		ex) $ba = set_admin_form($ba);

	*/

	function set_admin_form($ba)
	{
		global $G, $TB;

		// [2011-01-05] 메뉴관리
		$q = "SELECT bm_no, bm_name FROM ".$TB['BOARD_MENU']." WHERE d_no='".$G['DINFO']['d_no']."' ORDER BY bm_sort, bm_name";
		$_bm = db_get_rows($q, true);
		if (!$_bm)
		{
			msg("게시판이 보여질 메뉴를 먼저 만들어 주십시오.", 0);
			movepage("admin_board_menu.php?bm_name=".urlencode("게시판"));					
		}	// if()
		$ba[select_bm_no] = select_list_value($ba[bm_no], $_bm['bm_name'], $_bm['bm_no'], NULL, 0, 1);

		$ba[v_ba_name] = input_value($ba[ba_name],1);
		$ba[v_ba_sort] = input_value($ba[ba_sort],1);
		$ba[select_ba_isuse_link] = select_list_value($ba[ba_isuse_link], array_values($G[ISUSE]), array_keys($G[ISUSE]), NULL, 0, 1);
		$ba[select_ba_isuse_file] = select_list_value($ba[ba_isuse_file], array_values($G[ISUSE]), array_keys($G[ISUSE]), NULL, 0, 1);
		$ba[select_ba_isuse_comment] = select_list_value($ba[ba_isuse_comment], array_values($G[ISUSE]), array_keys($G[ISUSE]), NULL, 0, 1);
		$ba[select_ba_isuse_reply] = select_list_value($ba[ba_isuse_reply], array_values($G[ISUSE]), array_keys($G[ISUSE]), NULL, 0, 1);
		$ba[select_ba_isuse_rewrite] = select_list_value($ba[ba_isuse_rewrite], array_values($G[ISUSE]), array_keys($G[ISUSE]), NULL, 0, 1);
		$ba[select_ba_isuse_read_log] = select_list_value($ba[ba_isuse_read_log], array_values($G[ISUSE]), array_keys($G[ISUSE]), NULL, 0, 1);
		$ba[select_ba_isuse_category] = select_list_value($ba[ba_isuse_category], array_values($G[ISUSE]), array_keys($G[ISUSE]), NULL, 0, 1);
		$ba[v_ba_page] = input_value($ba[ba_page],1);
		$ba[radio_ba_header_html] = radio_value("ba_header_html", $ba[ba_header_html], array_values($G[HTML]), array_keys($G[HTML]), 0, 0, 1);
		$ba[v_ba_header] = text_view($ba[ba_header]);
		$ba[radio_ba_footer_html] = radio_value("ba_footer_html", $ba[ba_footer_html], array_values($G[HTML]), array_keys($G[HTML]), 0, 0, 1);
		$ba[v_ba_footer] = text_view($ba[ba_footer]);
		$ba[v_ba_inc_header] = input_value($ba[ba_inc_header],1);
		$ba[v_ba_inc_footer] = input_value($ba[ba_inc_footer],1);
		$ba[select_ba_perm_access] = select_list_value($ba[ba_perm_access], array_values($G[LEVEL_NAME]), array_keys($G[LEVEL_NAME]), NULL, 0, 1);
		$ba[select_ba_perm_register] = select_list_value($ba[ba_perm_register], array_values($G[LEVEL_NAME]), array_keys($G[LEVEL_NAME]), NULL, 0, 1);
		$ba[select_ba_perm_reply] = select_list_value($ba[ba_perm_reply], array_values($G[LEVEL_NAME]), array_keys($G[LEVEL_NAME]), NULL, 0, 1);
		$ba[select_ba_perm_rewrite] = select_list_value($ba[ba_perm_rewrite], array_values($G[LEVEL_NAME]), array_keys($G[LEVEL_NAME]), NULL, 0, 1);
		$ba[select_ba_perm_read_log] = select_list_value($ba[ba_perm_read_log], array_values($G[LEVEL_NAME]), array_keys($G[LEVEL_NAME]), NULL, 0, 1);
		$ba[select_ba_perm_read] = select_list_value($ba[ba_perm_read], array_values($G[LEVEL_NAME]), array_keys($G[LEVEL_NAME]), NULL, 0, 1);
		$ba[select_ba_perm_down] = select_list_value($ba[ba_perm_down], array_values($G[LEVEL_NAME]), array_keys($G[LEVEL_NAME]), NULL, 0, 1);
		$ba[select_ba_perm_modify] = select_list_value($ba[ba_perm_modify], array_values($G[LEVEL_NAME]), array_keys($G[LEVEL_NAME]), NULL, 0, 1);
		$ba[select_ba_perm_cmt_register] = select_list_value($ba[ba_perm_cmt_register], array_values($G[LEVEL_NAME]), array_keys($G[LEVEL_NAME]), NULL, 0, 1);
		$ba[select_ba_perm_cmt_read] = select_list_value($ba[ba_perm_cmt_read], array_values($G[LEVEL_NAME]), array_keys($G[LEVEL_NAME]), NULL, 0, 1);
		$ba[select_ba_perm_cmt_del] = select_list_value($ba[ba_perm_cmt_del], array_values($G[LEVEL_NAME]), array_keys($G[LEVEL_NAME]), NULL, 0, 1);

		$ba[v_ba_mbronly_register] = text_view($ba[ba_mbronly_register]);
		$ba[v_ba_mbronly_reply] = text_view($ba[ba_mbronly_reply]);

		// [2008-03-19] 사용그룹제한 추가
		// 회원그룹
		$q = "SELECT COUNT(*) FROM ".$TB['MEMBER_GROUP']." WHERE d_no='".$G['DINFO']['d_no']."'";
		$ba['mg_cnt'] = db_get_one($q);
		$_ba_mg_no = db_str_explode('|', $ba['ba_mg_no']);
		$ba['ba_mg_no_text'] = '';
		for ($i=0; $i<sizeof($_ba_mg_no); $i++)
		{
			$q = "SELECT mg_name FROM ".$TB['MEMBER_GROUP']." WHERE d_no='".$G['DINFO']['d_no']."' AND mg_no='".$_ba_mg_no[$i]."'";			
			$_mg_name = db_get_one($q);
			if ($_mg_name != '')
			{
				if ($ba['ba_mg_no_text'] != '')
					$ba['ba_mg_no_text'] .= ', ';
				$ba['ba_mg_no_text'] .= $_mg_name;
			}	// if()
		}	// for()
		$ba['ba_mg_no_text'] = htmlspecialchars_fix($ba['ba_mg_no_text']);
		$ba['ba_mg_no'] = input_value(implode(',', $_ba_mg_no), 1);

		$ba['ba_use_id'] = htmlspecialchars_fix(implode(',', db_str_explode('|', $ba['ba_use_id'])));

		return $ba;

	}	// function()


###############################################################################

	/** 게시판 목록 가져오기

		ex)
			// set_board_list
				$pageSize = $ba[ba_page];
				$strTrans = "&mode=$mode&" . $b_qs["LIST"];
				$subject_url = "&" . $b_qs["LIST"];

				$board = set_board_list($q_where, $pageSize, $strTrans, $subject_url, $subject_maxlength);		// array

	*/
	function set_board_list($q_where, $pageSize, $strTrans, $subject_url, $subject_maxlength, $prefix=NULL)
	{
		global $db, $TB, $G_BOARD;		// global
		global $limitOffset, $limitRows, $pageMaxNo, $rowCount;		// paging
		global $nmpath;

		// paging
			include_once("include/page.php");

			$q_count = "SELECT count(*) FROM $TB[BOARD] " . $q_where;
			disPgProc($q_count, $pageSize, $strTrans, "DESC");


		// get
			// [2011-06-01] 튜닝 - b_memo 필드 제외
			//$q = "SELECT * FROM $TB[BOARD] " . $q_where . " ORDER BY b_ref desc, b_re_step";
			$q = "SELECT b_no,ba_no,bca_no,m_no,b_name,b_pwd,b_email,b_homepage,b_isuse_reply_mail,b_subject,b_html,b_link,b_file,b_files,b_file_size,b_refer,b_down,b_vote,b_comment,b_ref,b_re_step,b_re_level,b_regdate,b_reghost,b_last_modifydate,b_last_modifyhost FROM $TB[BOARD] " . $q_where . " ORDER BY b_ref desc, b_re_step";		
			//echo $q;
			$board = db_get_rows($q, $limitOffset, $limitRows);

			if($board)
			{
				for($i=0; $i<sizeof($board); $i++)
				{
					$board[$i][i] = $i;
					$board[$i][v_b_no] = $pageMaxNo - $i;
					$board[$i][v_b_name] = get_mailto_url($board[$i][b_email], $board[$i][b_name]);
					$board[$i][v_b_re_level] = "<img width='" . $board[$i][b_re_level] * 10 . "' height='0'>";

					if($prefix)
					{
						//$board[$i][v_b_subject] .= "[<b>" . $prefix[$board[$i][ba_no]] . "</b>] ";
						$board[$i][v_b_subject] .= "[<b><a href='".$nmpath."/board.php?mode=LIST&ba_no=" . $board[$i][ba_no] . "'>" . $prefix[$board[$i][ba_no]] . "</a></b>] ";
					}

					$board[$i][v_b_subject] .= "<a href='".$nmpath."/board.php?mode=READ&ba_no=" . $board[$i][ba_no] . "&b_no=" . $board[$i][b_no] . $subject_url . "'>" . text_view(han_substr_view($board[$i][b_subject], $subject_maxlength)) . "</a>";
					$board[$i][v_b_regdate] = substr($board[$i][b_regdate], 0, 10);

					// new
					if ( strtotime($board[$i][b_regdate]) >= (time()-$G_BOARD[NEW_TIME]) )
					{
						$board[$i][isnew] = "Y";						
					}	// if()
					//echo "<HR>[$i] - " . $board[$i][b_regdate_ut] . " >= " . (time()-$G_BOARD[NEW_TIME]) . " => " . $board[$i][isnew];

					// [2008-06-10] ActiveX 파일 첨부
					if ($board[$i][b_files] != '')
						$board[$i][b_file] = true;

				}	// for()
			}	// if()

		return $board;
	}	// function()


###############################################################################


	/** 입력된 회원ID중 존재하는 회원ID만으로 재구성하기

		ex)
				// mbronly		
					$error_msg = NULL;

					$mo1 = set_ba_mbronly($ba_mbronly_register);		// array()
					$ba_mbronly_register = $mo1['true'];
					if ($mo1['false']) $error_msg .= "\\n\\n=> 글쓰기가능회원ID중 비회원 : " . $mo1['false'];

		// [2007-05-07] 제대로 체크되지 않던 오류 수정.

	*/
	function set_ba_mbronly($id)
	{
		global $db, $TB, $AUTH;

		$exp = explode(",", $id);
		$id_true = array();
		$id_false = array();

		for($i=0; $i<sizeof($exp); $i++)
		{
			$chk_id = trim($exp[$i]);
			$q = "
				SELECT
					COUNT(*)
				FROM
					$TB[MEMBER] 
				WHERE
					m_id = '$chk_id'
					AND d_no='" . $AUTH['auth_d_no'] ."'
				";
			//echo "<HR>" . $q;
			$m_chk = db_get_one($q);
				
			if ($m_chk > 0)		// true
			{
				$id_true[] = $chk_id;
			}else		// false
			{
				$id_false[] = $chk_id;
			}	// if()
		}	// for()

		$return['true'] = set_array2comma(NULL, NULL, $id_true, NULL);
		$return['false'] = set_array2comma(NULL, NULL, $id_false, NULL);

		return $return;

	}	// function()


###############################################################################


	/** 지정된 회원만 이용(추가/답변)가능하도록 설정함.

		ex)
			// check - mbronly
				if ($ba[ba_mbronly_register]) limit_mbronly($ba[ba_mbronly_register], "글쓰기권한이 없습니다.");

	*/
	function limit_mbronly($id, $msg)
	{
		global $AUTH, $G;

		$exp = explode(",", $id);

		// 배열원소들에 trim()함수 적용하기
		function array_trim(&$value, $key)
		{
			$value = trim($value);
		}
		array_walk($exp, "array_trim");
		reset($exp);

		//echo "<hr>" . $AUTH[auth_m_id] . " | " . $exp[0] . " | " . in_array($AUTH[auth_m_id], $exp);

		// [2008-01-18] 글쓰기가능회원ID, 답변가능회원ID 기능이 제대로 동작하지 않던 오류 수정
		//if ( (!in_array($AUTH[auth_m_id], $exp)) && !($AUTH[auth_m_level] >= $G[LEVEL][master]) )		// error
		if ( (!in_array($AUTH[auth_m_id], $exp)) && !($AUTH[auth_m_level] >= $G[LEVEL][admin]) )		// error
		{
			msg($msg);
		}	// if()
	}	// function()



###############################################################################


	/**
		분류 정보 가져오기

		ex) $bca = get_bca($bca_no);		// array

	*/
	function get_bca($bca_no, $q_where=NULL)
	{
		global $db, $TB;

		$q = "
			SELECT
				*
			FROM
				$TB[BOARD_CATEGORY]
			WHERE
				bca_no='$bca_no'
				$q_where
			";
		//echo "<HR>" . $q;
		$bca = db_get_row($q);		

		if($bca == NULL) msg("존재하지 않는 분류입니다.");

		return $bca;
	}


###############################################################################


	/**
		분류 가져오기

		[2002-06-10]
		ex) $board_category = get_board_category($ba_no, NULL, "N");		// array

	*/
	function get_board_category($ba_no, $q_where=NULL, $ismsg="Y")
	{
		global $db, $TB;

		$q = "
			SELECT
				*
			FROM
				$TB[BOARD_CATEGORY]
			WHERE
				ba_no='$ba_no'
				$q_where
			ORDER BY
				bca_order DESC, bca_name
			";
		//echo "<HR>" . $q;
		$bca = db_get_rows($q, true);

		if (($ismsg == "Y")&&($bca == NULL)) msg("존재하지 않는 분류입니다.");

		return $bca;
	}


###############################################################################


	/**
		폼 설정하기

		ex) $bca_form = set_form_bca($bca);		// array

	*/
	function set_form_bca($bca)
	{
		global $G, $TB, $db, $mode, $ba_no, $AUTH, $G_SYS;

		$bca_form = $bca;

		if ($mode == "ADMIN_REGISTER")
		{
			if ($_GET['ba_no'])
			{
				$bca[ba_no] = $ba_no;
				//$q = "SELECT MAX(bca_order)+1 FROM ".$TB[BOARD_CATEGORY]." WHERE ba_no='".$_GET['ba_no']."'";
				//$bca[bca_order] = db_get_one($q);
				$bca[bca_order] = 0;
			} else 
			{
				$bca[bca_order] = 0;
			}	// if()
		}	// if()

		if ($G_SYS[DB] == 'oracle') 
		{
			$q = "
				SELECT 
					ba.ba_no key, CONCAT(CONCAT(ba.ba_no, '. '), ba.ba_name) value
				FROM
					$TB[BOARD_ADMIN] ba
				WHERE
					ba.d_no = '" . $AUTH['auth_d_no'] . "'
					AND ba.d_no='" . $AUTH['auth_d_no'] ."'
				ORDER BY
					ba.ba_no
				";
		} else 
		{
			$q = "
				SELECT
					ba.ba_no AS 'key', CONCAT(ba.ba_no, '. ', ba.ba_name) AS 'value'
				FROM
					$TB[BOARD_ADMIN] ba
				WHERE
					ba.d_no = '" . $AUTH['auth_d_no'] . "'
					AND ba.d_no='" . $AUTH['auth_d_no'] ."'
				ORDER BY
					ba.ba_no
				";
		}	// if()
		$ba = db_get_rows($q, true);

		$bca_form[ba_no] = select_list_value($bca[ba_no], $ba['value'], $ba['key'], "선택하세요", 0, 1);
		$bca_form[bca_name] = input_value($bca[bca_name], 1);
		$bca_form[bca_order] = input_value($bca[bca_order], 1);

		return $bca_form;
	}


###############################################################################


	/**
		분류 사용횟수 가져오기

		ex) $b_cnt = get_b_count($bca_no);		// int

	*/
	function get_b_count($bca_no, $q_where=NULL)
	{
		global $db, $TB;

		$q = "
			SELECT
				COUNT(*) b_cnt
			FROM
				$TB[BOARD]
			WHERE
				bca_no = '$bca_no'
				$q_where
			";
		//echo "<HR>" . $q;
		$b = db_get_row($q);	

		return $b[b_cnt];
	}


###############################################################################


	// [2006-07-20] 사용량 체크
	function get_board_size_sum($d_no, $d_quota_board)
	{
		global $TB;
		$q = " 
			SELECT 
				SUM(b.b_file_size  + b.b_image_size)
			FROM 
				".$TB['BOARD_ADMIN']." ba,
				".$TB['BOARD']." b
			WHERE
				ba.d_no='".$d_no."'
				AND ba.ba_no=b.ba_no
				AND (b.b_file_size > 0 or b.b_image_size > 0) 
			";
		$b_file_size_sum = db_get_one($q);
		$fsize = array();
		$fsize['rate'] = ($b_file_size_sum == 0) ? 0 : ceil($b_file_size_sum / ($d_quota_board * 1024) * 100);
		$fsize['sum'] = filesize_human($b_file_size_sum, 1);
		$fsize['sum_b'] = $b_file_size_sum;
		$fsize['quota'] = filesize_human($d_quota_board * 1024, 1);
		$fsize['quota_b'] = $d_quota_board * 1024;
		return $fsize;
	}	// function()


################################################################################


	// [2010-12-23] 임시보관 추가
	function board_draft_del($m_no, $bd_no)
	{
		global $db, $TB;

		$q = "DELETE FROM $TB[BOARD_DRAFT] WHERE bd_no='".$bd_no."' AND m_no='".$m_no."'";
		//echo "<HR>" . $q;
		db_query($q);
	}	// function()
	
	function board_draft_count($m_no)
	{
		global $db, $TB;

		$q = "SELECT COUNT(*) FROM $TB[BOARD_DRAFT] WHERE m_no='".$m_no."'";
		//echo "<HR>" . $q;
		return db_get_one($q);
	}	// function()

	function board_rewrite_files($content, $url, $original_files, $ba_no, $b_no)
	{
		global $G_SYS, $UPLOAD_ROOT, $UPLOAD_ROOT_NEW, $UPLOAD_DIR;

		$upload_new_dir = $UPLOAD_DIR[BOARD_NEW] . "/" . $ba_no;

		$size = 0;
		// 이전 사용한 이미지 파일 확인
		$_cid_url = $G_SYS['HTTP_URL_ROOT']. '/' . $url;

		$pattern = "/" . preg_quote("src=\"" . $_cid_url, '/')
			. "(&|" . preg_quote('&amp;') . ")+cid\="
			. "([a-zA-Z0-9\.]+)/i";

		// 패턴으로 매칭
		preg_match_all($pattern, $content, $matches);

		$_cid = $matches[2];

		$_ex = explode('||', $original_files);

		// $files 다시 가져오기
		$change_files = array();
		for ($i = 0; $i < sizeof($_ex); $i++) {
			$files = explode('|', $_ex[$i]);
			if (in_array($files[1], $_cid)) {
				$size += (int)$files[2];
				$change_files[] = $_ex[$i];
			}
		}
		$change_files = implode('||', $change_files);

		$_ex = explode("||", $change_files);
		for ($i = 0; $i < sizeof($_ex); $i++) {
			if ($_ex[$i]) {
				$files = explode("|", $_ex[$i]);

				// [2010-12-31]원본 이미지의 첨부파일을 임시디렉토리로 저장함.
				$file_ori = $UPLOAD_ROOT . '/' . $upload_new_dir . '/' . file_name_fix($files[1], '');
				if (file_exists($file_ori)) {
					$UPLOAD_ROOT = $UPLOAD_ROOT_NEW;
					mkdir_parent($UPLOAD_DIR[BIGFILE_TMP]);
					$file_new_name = getmicrotime();
					$file_new = $UPLOAD_ROOT.'/'.$UPLOAD_DIR[BIGFILE_TMP].'/'.$file_new_name;
					if (!file_exists($file_new))
						copy($file_ori, $file_new);

					// 기존 file_image 이름도 변경 필요
					$change_files = str_replace($files[1], $file_new_name , $change_files);

					// 기존 CID 주소 수정 필요
					$content = board_content_cid_tmp_replace($content, "board_image.php?b_no=". $b_no, "board_image_tmp.php?cid=", $files[1], $file_new_name);
				}
			}
		}

		return array($size, $change_files, $content);
	}

	function board_content_cid_tmp_replace($content, $tmp_url, $url, $file_name, $file_new_name)
	{
		global $G_SYS;

		$_cid_tmp_url = $G_SYS['HTTP_URL_ROOT'] . '/' . $tmp_url;
		$_cid_url     = $G_SYS['HTTP_URL_ROOT'] . '/' . $url;
		// <img src=\"http://pc.mail.passkorea.net/board_image_tmp.php?cid=1758176985.7311&amp;name=mceu_42454805411758176985690.gif\" />
		//					$pattern = "/src=\"".preg_quote($_cid_tmp_url, '/')."([a-zA-Z0-9\.]+)/i";
		$pattern = "/" . preg_quote("src=\"" . $_cid_tmp_url, '/')
			. "(&|" . preg_quote('&amp;') . ")+cid\="
			. $file_name . "/i";

		return preg_replace_callback($pattern, function ($matches) use ($_cid_url, $file_new_name) {
			$data = "src=\"" . $_cid_url . $file_new_name;
			if (isset($matches[2]) && $matches[2] === '&amp;') {
				$data .= "&";
			}

			return $data;
		}, $content);
	}


?>