<?


###############################################################################

	// Auth - Session
		function auth_proc($auth_mode, $is_pwd_enc=false)
		{
			global $db, $TB, $G, $G_SYS, $AUTH, $G_MB, $_POST, $nmpath;

			set_db();

			switch($auth_mode)
			{
				case "LOGIN":
				case "LOGIN_ONCE":
					if(!$_SESSION["auth_m_no"] || $auth_mode == 'LOGIN_ONCE')		// 리프레쉬로 인해 로그인 처리가 중복되는 것을 방지함.  SSO에서 인증할때는 체크안함.
					{
						$m_id = strtolower($_POST['m_id']);

						// check - auth
							// get
							$d_no = db_get_one("SELECT d_no FROM " . $TB['DOMAIN'] . " WHERE d_name = '" . $G_SYS['MAIL_DOMAIN'] . "'");
							if (!$d_no)
								msg("존재하지 않는 도메인입니다.");

							// [2013-07-01] 웹메일 로그인 시도 횟수 제한 - IP
							$_today = time();
							if (!in_array($_SERVER['REMOTE_ADDR'], $G_SYS['NM_LOGIN_LIMIT_EXCLUDE_IP']))		// 제한 예외 IP가 아닐때만 제한.
							{
								// 특정 IP에서 하루동안 허용 횟수
								$q = "SELECT COUNT(*) FROM ".$TB['LOG_LOGIN']." WHERE l_date='".date('Y-m-d')."' AND l_ip='".$_SERVER['REMOTE_ADDR']."' AND l_status != 'OK'";
								$log_login_fail_day_cnt = db_get_one($q);
								if ($log_login_fail_day_cnt > $G_SYS['NM_LOGIN_LIMIT_IP_PER_DAY'])
								{
									// 대량 시도를 대비하여 생략 auth_log($d_no, (int)$mbr['m_no'], $m_id, 'LIP');
									sleep(1);
									msg("접근한 IP(".$_SERVER['REMOTE_ADDR'].")에서 로그인이 일시 제한되었습니다.\\n\\n- 제한 사유 : 하루 동안 ".$G_SYS['NM_LOGIN_LIMIT_IP_PER_DAY']."회 이상 시도\\n\\n내일 다시 시도하여 주십시오.");
								}	// if()

								// 특정 IP에서 1시간동안 허용 횟수.  하루동안 로그인 실패수가 1시간동안 허용 횟수 이상일때만 검사.
								if ($log_login_fail_day_cnt >= $G_SYS['NM_LOGIN_LIMIT_IP_PER_HOUR'])
								{
									$q = "SELECT COUNT(*) FROM ".$TB['LOG_LOGIN']." WHERE l_date='".date('Y-m-d')."' AND l_ip='".$_SERVER['REMOTE_ADDR']."' AND l_status != 'OK' AND l_time >= '".auth_login_limit_time($_today, 3600)."'";
									$log_login_fail_cnt = db_get_one($q);
									if ($log_login_fail_cnt > $G_SYS['NM_LOGIN_LIMIT_IP_PER_HOUR'])
									{
										auth_log($d_no, (int)$mbr['m_no'], $m_id, 'LIP');
										sleep(1);
										msg("접근한 IP(".$_SERVER['REMOTE_ADDR'].")에서 로그인이 일시 제한되었습니다.\\n\\n- 제한 사유 : 1시간 동안 ".$G_SYS['NM_LOGIN_LIMIT_IP_PER_HOUR']."회 이상 시도\\n\\n1시간 후 다시 시도하여 주십시오.");
									}	// if()
								}	// if()

								// 특정 IP에서 10분동안 허용 횟수.  하루동안 로그인 실패수가 10분동안 허용 횟수 이상일때만 검사.
								if ($log_login_fail_day_cnt >= $G_SYS['NM_LOGIN_LIMIT_IP_PER_10M'])
								{
									$q = "SELECT COUNT(*) FROM ".$TB['LOG_LOGIN']." WHERE l_date='".date('Y-m-d')."' AND l_ip='".$_SERVER['REMOTE_ADDR']."' AND l_status != 'OK' AND l_time >= '".auth_login_limit_time($_today, 600)."'";
									$log_login_fail_cnt = db_get_one($q);
									if ($log_login_fail_cnt > $G_SYS['NM_LOGIN_LIMIT_IP_PER_10M'])
									{
										auth_log($d_no, (int)$mbr['m_no'], $m_id, 'LIP');
										sleep(1);
										msg("접근한 IP(".$_SERVER['REMOTE_ADDR'].")에서 로그인이 일시 제한되었습니다.\\n\\n- 제한 사유 : 10분 동안 ".$G_SYS['NM_LOGIN_LIMIT_IP_PER_10M']."회 이상 시도\\n\\n잠시후 다시 시도하여 주십시오.");
									}	// if()
								}	// if()
							}	// if()


							// [2007-07-21] 메일링 리스트 계정은 제외
							//$mbr = db_get_row("SELECT * FROM " . $TB['MEMBER'] . " WHERE m_id='$m_id' AND d_no='$d_no'");
							#$mbr = db_get_row("SELECT * FROM " . $TB['MEMBER'] . " WHERE m_id='$m_id' AND d_no='$d_no' AND m_usertype IS NULL");
							// [2008-09-11] 웹하드 Guest 계정 로그인 지원
							$mbr = db_get_row("SELECT * FROM " . $TB['MEMBER'] . " WHERE m_id=? AND d_no=?", array($m_id, $d_no));
							if (!$mbr[m_id] || ($mbr['m_usertype'] != NULL && $mbr['m_usertype'] != 'W'))
							{
								auth_log($d_no, 0, $m_id, 'FI');
								sleep(1);
								msg("가입되지 않은 ID입니다.\\n\\n확인후 다시 입력하여 주시기 바랍니다.");
							}


							// [2013-10-11] 웹메일 접근 IP
							// 비밀번호 일치 여부를 알 수 없도록, 비밀번호 검사보다 앞서 실행함.
							//  [웹하드 Guest 계정]은 지정된 공용웹하드에만 접근할 수 있으므로 제한하지 않습니다.
							if ($G_SYS['NM_WEB_ALLOW_IP_USUSE'] && $mbr['m_usertype'] != 'W')
							{
								require_once('include/admin_web_allow_ip_lib.php');
								// [2025-07-15] 기존 웹메일 접근 IP 관리에 아이디 추가
								if (web_allow_ip_id_active($d_no, $mbr['m_id'])) {
									if (web_allow_ip_id_active($d_no, $mbr['m_id']) && ! web_allow_ip_id_check($d_no, $_SERVER['REMOTE_ADDR'], $mbr['m_id'])) {
										auth_log($d_no, (int)$mbr['m_no'], $m_id, 'DID');
										sleep(1);
										msg(
											$mbr['m_id'] . " 아이디는 접근한 IP(" . $_SERVER['REMOTE_ADDR']
											. ")에서 로그인 할 수 없습니다.\\n\\n관리자가 로그인 할 수 있는 IP를 제한 해두었습니다.\\n\\n관리자에게 문의하여 주십시오."
										);
									}
								} elseif (web_allow_ip_active($d_no)) {
									if (web_allow_ip_active($d_no) && !web_allow_ip_check($d_no, $_SERVER['REMOTE_ADDR'])) {
										auth_log($d_no, (int)$mbr['m_no'], $m_id, 'DIP');
										sleep(1);
										msg("접근한 IP(".$_SERVER['REMOTE_ADDR'].")에서는 로그인 할 수 없습니다.\\n\\n관리자가 로그인 할 수 있는 IP를 제한 해두었습니다.\\n\\n관리자에게 문의하여 주십시오.");
									}
								}
							}	// if()

							// [2013-07-01] 웹메일 로그인 시도 횟수 제한 - 아이디
							//if (!in_array($_SERVER['REMOTE_ADDR'], $G_SYS['NM_LOGIN_LIMIT_EXCLUDE_IP']))		// 제한 예외 IP가 아닐때만 제한. -> 아이디 기준이므로 제외시킴.
							//{
								// 특정 아이디에서 하루동안 허용 횟수
								$q = "SELECT COUNT(*) FROM ".$TB['LOG_LOGIN']." WHERE l_date='".date('Y-m-d')."' AND m_no='".$mbr['m_no']."' AND l_status != 'OK'";
								$log_login_fail_day_cnt = db_get_one($q);
								if ($log_login_fail_day_cnt > $G_SYS['NM_LOGIN_LIMIT_MBR_PER_DAY'])
								{
									// 대량 시도를 대비하여 생략 auth_log($d_no, (int)$mbr['m_no'], $m_id, 'LID');
									sleep(1);
									msg("입력한 아이디의 로그인이 일시 제한되었습니다.\\n\\n- 제한 사유 : 하루 동안 ".$G_SYS['NM_LOGIN_LIMIT_MBR_PER_DAY']."회 이상 시도\\n\\n내일 다시 시도하여 주십시오.");
								}	// if()

								// 특정 아이디에서 1시간동안 허용 횟수.  하루동안 로그인 실패수가 1시간동안 허용 횟수 이상일때만 검사.
								if ($log_login_fail_day_cnt >= $G_SYS['NM_LOGIN_LIMIT_MBR_PER_HOUR'])
								{
									$q = "SELECT COUNT(*) FROM ".$TB['LOG_LOGIN']." WHERE l_date='".date('Y-m-d')."' AND m_no='".$mbr['m_no']."' AND l_status != 'OK' AND l_time >= '".auth_login_limit_time($_today, 3600)."'";
									$log_login_fail_cnt = db_get_one($q);
									if ($log_login_fail_cnt > $G_SYS['NM_LOGIN_LIMIT_MBR_PER_HOUR'])
									{
										auth_log($d_no, (int)$mbr['m_no'], $m_id, 'LID');
										sleep(1);
										msg("입력한 아이디의 로그인이 일시 제한되었습니다.\\n\\n- 제한 사유 : 1시간 동안 ".$G_SYS['NM_LOGIN_LIMIT_MBR_PER_HOUR']."회 이상 시도\\n\\n1시간 후 다시 시도하여 주십시오.");
									}	// if()
								}	// if()

								// 특정 아이디에서 10분동안 허용 횟수.  하루동안 로그인 실패수가 10분동안 허용 횟수 이상일때만 검사.
								if ($log_login_fail_day_cnt >= $G_SYS['NM_LOGIN_LIMIT_MBR_PER_10M'])
								{
									$q = "SELECT COUNT(*) FROM ".$TB['LOG_LOGIN']." WHERE l_date='".date('Y-m-d')."' AND m_no='".$mbr['m_no']."' AND l_status != 'OK' AND l_time >= '".auth_login_limit_time($_today, 600)."'";
									$log_login_fail_cnt = db_get_one($q);
									if ($log_login_fail_cnt > $G_SYS['NM_LOGIN_LIMIT_MBR_PER_10M'])
									{
										auth_log($d_no, (int)$mbr['m_no'], $m_id, 'LID');
										sleep(1);
										msg("입력한 아이디의 로그인이 일시 제한되었습니다.\\n\\n- 제한 사유 : 10분 동안 ".$G_SYS['NM_LOGIN_LIMIT_MBR_PER_10M']."회 이상 시도\\n\\n잠시후 다시 시도하여 주십시오.");
									}	// if()
								}	// if()
							//}	// if()


							// m_pwd
//							$pwd_enc = ($is_pwd_enc) ? stripslashes($_POST['m_pwd']) : pwd_enc(stripslashes($_POST['m_pwd']), stripslashes($_POST['m_id']), $mbr[m_pwd]);
//							if (strcmp($mbr[m_pwd], $pwd_enc))
							// [2025-11-15] 비밀번호 해시 개선
							if ($is_pwd_enc) {
								// SSO, 대표 계정 등에서 비밀번호 해시가 전달된 경우
								if (stripslashes($_POST['m_pwd']) !== $mbr['m_pwd']) {
									auth_log($d_no, (int)$mbr['m_no'], $m_id, 'FP');
									sleep(1);
									msg("비밀번호가 해시가 일치하지 않습니다.\\n\\n확인후 재시도하거나, 문제가 계속될 경우 비밀번호를 변경후 재시도 해주시기 바랍니다.");
								}
							} else if ( ! nmail_password_verify(stripslashes($_POST['m_pwd']), $mbr['m_pwd'], $mbr['m_id'], $mbr['m_no']))
							{
								auth_log($d_no, (int)$mbr['m_no'], $m_id, 'FP');
								sleep(1);
								msg("아이디 또는 비밀번호가 일치하지 않습니다.\\n\\n확인후 다시 입력하여 주시기 바랍니다.");
							}

							// [2008-09-11] 웹하드 Guest 계정 로그인 지원
							if ($mbr['m_usertype'] == 'W')
							{
								// 사용기간 제한
									$today = date('Y-m-d');
									if (strlen($mbr['m_use_start']) == 10 && $mbr['m_use_start'] != '0000-00-00' && $mbr['m_use_end'] != '0000-00-00' && !($mbr['m_use_start'] <= $today && $mbr['m_use_end'] >= $today))
									{
										msg("웹하드 Guest 계정의 사용기간이 만료되어 로그인 할 수 없습니다.\\n\\n관리자에게 문의하시기 바랍니다.\\n\\n사용기간 : ".$mbr['m_use_start']." ~ ".$mbr['m_use_end']);
									}	// if()

								// 웹하드 Guest 계정 구분용 세션
									$auth_webhard_guest = true;
									// [2015-04] PHP5.4.x session_register제거로 주석
									//session_register("auth_webhard_guest");
									$_SESSION["auth_webhard_guest"] = true;

								// 웹하드 용량제한 회피용
									$mbr[m_webhard_quota] = 1;

								// 로그인후 웹하드로 강제이동
									$_POST['back_url'] = $nmpath.'/webhard/';
							} else		// 메일 계정
							{
								// [2006-08-07] 가입대기, 휴면계정, 사용기간 제한 및 해제처리.
								mbr_limit_check($mbr);

								// [2008-03-19] 사용그룹제한 추가
								$q = "SELECT mg_name FROM " . $TB['MEMBER_GROUP'] . " WHERE mg_no='".$mbr['mg_no']."' AND d_no='$d_no'";
								$mbr[mg_name] = db_get_one($q);
							}	// if()


						// set
							$mbr[m_level_name] = $G[LEVEL_NAME][$mbr[m_level]];
							$mbr[m_login_cnt]++;
							if ($mbr[m_last_logindate] == "0000-00-00 00:00:00")
								$mbr[m_last_logindate] = '';

							$auth_d_no = $d_no;
							$auth_m_no = $mbr[m_no];
							$auth_m_id = $mbr[m_id];
							$auth_m_name = $mbr[m_name];
							$auth_m_level = $mbr[m_level];
							$auth_m_level_name = $mbr[m_level_name];
							#$auth_m_email = $mbr[m_email];
							$auth_m_email = $mbr[m_id] . '@' . $G_SYS['MAIL_DOMAIN'];
							$auth_m_login_cnt = $mbr[m_login_cnt];
							$auth_m_last_logindate = $mbr[m_last_logindate];
							$auth_m_last_loginhost = $mbr[m_last_loginhost];
							$auth_mg_name = $mbr[mg_name];
							$auth_m_mail_file_group = $mbr[m_mail_file_group];
							$auth_m_mf_table = $G_SYS[PRE_FIX] . 'mail_file_' . $d_no . '_' . $mbr['m_mail_file_group'];
							$auth_m_loginhost = $_SERVER[REMOTE_ADDR];
							$auth_m_checkhost = $_SERVER[REMOTE_ADDR];
							$auth_is_ip_check = $_POST['is_ip_check'];
							$auth_m_bigfile_quota = $mbr[m_bigfile_quota];
							$auth_m_webhard_quota = $mbr[m_webhard_quota];

							// [2015-04] PHP5.4.x session_register제거로 주석
							//session_register("auth_d_no");
							//session_register("auth_m_no");
							//session_register("auth_m_id");
							//session_register("auth_m_name");
							//session_register("auth_m_level");
							//session_register("auth_m_level_name");
							//session_register("auth_m_email");
							//session_register("auth_m_login_cnt");
							//session_register("auth_m_last_logindate");
							//session_register("auth_m_last_loginhost");
							//session_register("auth_mg_name");
							//session_register("auth_m_mail_file_group");
							//session_register("auth_m_mf_table");
							//session_register("auth_m_loginhost");
							//session_register("auth_m_checkhost");
							//session_register("auth_is_ip_check");
							//session_register("auth_m_bigfile_quota");
							//session_register("auth_m_webhard_quota");

							// 현재페이지에서 세션값을 바로 적용시킴.
							$_SESSION["auth_d_no"] = $d_no;
							$_SESSION["auth_m_no"] = $mbr[m_no];
							$_SESSION["auth_m_id"] = $mbr[m_id];
							$_SESSION["auth_m_name"] = $mbr[m_name];
							$_SESSION["auth_m_level"] = $mbr[m_level];
							$_SESSION["auth_m_level_name"] = $mbr[m_level_name];
							$_SESSION["auth_m_email"] = $auth_m_email;
							$_SESSION["auth_m_login_cnt"] = $mbr[m_login_cnt];
							$_SESSION["auth_m_last_logindate"] = $mbr[m_last_logindate];
							$_SESSION["auth_m_last_loginhost"] = $mbr[m_last_loginhost];
							$_SESSION["auth_mg_name"] = $mbr[mg_name];
							$_SESSION["auth_m_mail_file_group"] = $mbr[m_mail_file_group];
							$_SESSION["auth_m_mf_table"] = $auth_m_mf_table;
							$_SESSION["auth_m_loginhost"] = $_SERVER[REMOTE_ADDR];
							$_SESSION["auth_m_checkhost"] = $_SERVER[REMOTE_ADDR];
							$_SESSION["auth_is_ip_check"] = $_POST['is_ip_check'];
							$_SESSION["auth_m_bigfile_quota"] = $mbr[m_bigfile_quota];
							$_SESSION["auth_m_webhard_quota"] = $mbr[m_webhard_quota];

						// mapping
							$AUTH = $_SESSION;


						// 최초 로그인시 메일엔진의 비밀번호를 입력한 비밀번호로 갱신함.   암호화된 데이타를 변환했을 경우를 대비.
						// [2024-02-17] SSO 최초 로그인시 암호화된 비밀번호가 전달될 경우, 메일엔진 비밀번호 변경 생략
							if (! $is_pwd_enc && $mbr['m_usertype'] == NULL && !$mbr[m_last_logindate])
							{
								require_once('include/admin_lib.php');
								mbr_mod($mbr[m_id], $_POST['m_pwd']);
							}	// if()


						// update - member
							$_m_last_logindate = date("Y-m-d H:i:s");
							$_m_last_loginhost = $_SERVER[REMOTE_ADDR];
							db_query("UPDATE $TB[MEMBER] SET m_login_cnt=m_login_cnt+1, m_last_logindate=?, m_last_loginhost=?  WHERE m_no=?", array(
								$_m_last_logindate,
								$_m_last_loginhost,
								$AUTH[auth_m_no],
							));


						// login log
							auth_log($d_no, (int)$mbr['m_no'], $m_id, 'OK');
							/*
							// insert
								$q = "INSERT INTO $TB[MEMBER_LOGIN_LOG] VALUES (".db_sqc_next($TB['MEMBER_LOGIN_LOG']).", '" . $AUTH[auth_m_no] . "', '$_m_last_logindate', '" . $_SERVER["REMOTE_ADDR"] . "')";
								//echo "<HR>" . $q;
								$db->parseExec($q);
								$db->parseFree();

							// select - latest mll_no
								$q = "SELECT mll_no FROM $TB[MEMBER_LOGIN_LOG] WHERE m_no='" . $AUTH[auth_m_no] . "' ORDER BY mll_no DESC LIMIT " . $G_MB[LOGIN_LOG_LIMIT];
								//echo "<HR>" . $q;
								$db->parseExec($q);
								$db->fetchStatement($latest_mll);
								$latest_mll_cnt = $db->rowCount();
								$db->parseFree();

							// set - latest mll_no
								$q_mll_no = "";
								for ($mll_i=0; $mll_i<$latest_mll_cnt; $mll_i++)
								{
									$q_mll_no .= $latest_mll[mll_no][$mll_i];
									if ($mll_i != ($latest_mll_cnt-1)) $q_mll_no .=", ";
								}	// for()

							// delete
								$q = "DELETE FROM $TB[MEMBER_LOGIN_LOG] WHERE m_no='" . $AUTH[auth_m_no] . "' AND mll_no NOT IN ($q_mll_no)";
								//echo "<HR>" . $q;
								$db->parseExec($q);
								$db->parseFree();
							*/
					}	// if()

					break;

				case "LOGOUT":
					// member connect
						#include_once("../member/member.inc.php");
						#member_connect_logout();		// 현재접속자 로그아웃

					// db del
					// [2025-05-20] 2단계 인증 기기 정보 갱신 및 삭제
					tfa_logout_device_change();

					// session
						@session_unset();
						@session_destroy();
						// [2006-02-15] 일부 환경에서 쿠키가 남아있는 문제를 해결하기 위함.
                        // [2020-04] reflect xss 취약점 개선
						#setcookie('PHPSESSID', "", 1, $G_SYS[SESSION_PATH], $G_SYS[SESSION_DOMAIN]);
						setcookie('PHPSESSID', "", 1, $G_SYS[SESSION_PATH], $G_SYS[SESSION_DOMAIN],false,true);

					// mapping
						$AUTH = $_SESSION;

					break;

			}	// switch()


		}	// function()


###############################################################################


		function auth_limit($level_key, $type="NORMAL")
		{
			global $G, $_SESSION, $tpl;
			global $_SERVER, $AUTH, $G_SYS, $G_CM, $G_MB, $G_BOARD, $CFG;
			global $nmpath;

			// set - level_key, level 두가지 모두 사용가능. ex) user, 0
			if(!strcmp($G[LEVEL][$level_key], NULL))
			{
				if(!strcmp($G[LEVEL_NAME][$level_key], NULL))
				{
					system_msg("level_key 에서 다음 항목은 존재하지 않습니다.<br>=> " .  $level_key);		// guest 가 0이므로 strcmp() 로 비교함.
				}else
				{
					$level = $level_key;
				}	// if()
			}else
			{
				$level = $G[LEVEL][$level_key];
			}	// if()

			if($_SESSION["auth_m_no"])		// 로그인했을때 레벨확인
			{
				// check
				switch($type)
				{

					case "NORMAL":		// 사용자레벨이 제한레벨보다 높아야 접근가능
						if($_SESSION["auth_m_level"] < $level)
							msg("현재 페이지에 접근 권한이 없습니다.\\n\\n다음 레벨이상만 접근이 가능합니다.\\n\\n=> " . $G[LEVEL_NAME][$level]);
						break;

					case "REVERSE":		// 사용자레벨이 제한레벨보다 낮아야 접근가능
						if($_SESSION["auth_m_level"] > $level)
							msg("현재 페이지에 접근 권한이 없습니다.\\n\\n다음 레벨이하만 접근이 가능합니다.\\n\\n=> " . $G[LEVEL_NAME][$level]);
						break;

					case "ONLY":		// 사용자레벨이 제한레벨과 같아야 접근가능
						if($_SESSION["auth_m_level"] != $level)
							msg("현재 페이지에 접근 권한이 없습니다.\\n\\n다음 레벨일때만 접근이 가능합니다.\\n\\n=> " . $G[LEVEL_NAME][$level]);
						break;

					default:
						// debug
						system_msg("레벨제한모드에서 다음 항목은 존재하지 않습니다.<br>=> " . $type);
						break;

				}	// switch()

				// [2007-05-29]보안 - 쿠키에 저장된 세션ID가 사고로 유출되더라도 다른 IP에서 불법적인 접근을 할 수 없도록 제한함.
				// 패치를 적용할때 접속중인 사용자가 로그아웃되는 것을 방지하기 위해 auth_m_loginhost 세션이 생성되었을때만 체크함.
				// [2008-02-28]IP보안 사용자 선택
				//if ($_SESSION["auth_m_loginhost"] && $_SESSION["auth_m_loginhost"] != $_SERVER["REMOTE_ADDR"])
				if ($_SESSION["auth_is_ip_check"] == '1' && $_SESSION["auth_m_loginhost"] && $_SESSION["auth_m_loginhost"] != $_SERVER["REMOTE_ADDR"])
				{
					// [2007-09-19] 경고 문구 및 에러로그 남김.
					$msg = "[보안경고]\\n\\n접근하신 IP(".$_SERVER["REMOTE_ADDR"].")가 로그인한 IP와 다릅니다.\\n\\n보안을 위한 안전조치이니 다시 로그인하여 주시기 바랍니다.\\n\\n\\n※ IP가 자주 변경되는 환경일 경우,\\n\\n    로그인화면에서 \"IP보안\"항목의 체크를 해지하시면 됩니다.";
					//errorlog("[".$_SESSION["auth_m_id"]. "]님의 로그인한 IP(".$_SESSION["auth_m_loginhost"].")와 접근한 IP(".$_SERVER["REMOTE_ADDR"].")가 다르므로 강제 로그아웃되었습니다.", "SECURE");
					errorlog("[".$_SESSION["auth_m_id"]. "]님의 로그인한 IP(".$_SESSION["auth_m_loginhost"].")와 접근한 IP(".$_SERVER["REMOTE_ADDR"].")가 다르므로 강제 로그아웃되었습니다.", "DEBUG");

					auth_proc('LOGOUT');
					msg($msg, 0);
					movepage($nmpath.'/login.php?back_url=' . urlencode($_SERVER['REQUEST_URI']));
				}	// if()


				// [2013-10-11] 웹메일 접근 IP - 로그인시나 마지막으로 검사한 IP와 현재 IP가 다를 경우, 재검사
				if ($G_SYS['NM_WEB_ALLOW_IP_USUSE'] && !$_SESSION["auth_webhard_guest"] && $_SESSION["auth_m_checkhost"] != $_SERVER[REMOTE_ADDR])
				{
					require_once('include/admin_web_allow_ip_lib.php');
					if (web_allow_ip_id_active($_SESSION["auth_d_no"], $_SESSION['auth_m_id'])) {
						if (web_allow_ip_id_active($_SESSION["auth_d_no"], $_SESSION['auth_m_id']) && !web_allow_ip_id_check($_SESSION["auth_d_no"], $_SERVER[REMOTE_ADDR], $_SESSION['auth_m_id']))
						{
							errorlog("[".$_SESSION["auth_m_id"]. "]님의 접근한 IP(".$_SERVER["REMOTE_ADDR"].")가 [웹메일 접근 IP 관리]에 등록되지 않았으므로 강제 로그아웃되었습니다.", "DEBUG");

							auth_proc('LOGOUT');
							msg("접근한 IP(".$_SERVER['REMOTE_ADDR'].")에서는 웹메일에 접근할 수 없습니다.\\n\\n관리자가 접근 할 수 있는 아이디를 제한 해두었습니다.\\n\\n관리자에게 문의하여 주십시오.", 0);
							movepage($nmpath.'/login.php?back_url=' . urlencode($_SERVER['REQUEST_URI']));
						} else
						{
							$_SESSION["auth_m_checkhost"] = $_SERVER[REMOTE_ADDR];		// 마지막으로 검사한 IP 기록.
						}	// if()
					} else if (web_allow_ip_active($_SESSION["auth_d_no"])) {
						if (web_allow_ip_active($_SESSION["auth_d_no"])	&& ! web_allow_ip_check($_SESSION["auth_d_no"], $_SERVER[REMOTE_ADDR])) {
							errorlog("[" . $_SESSION["auth_m_id"] . "]님의 접근한 IP(" . $_SERVER["REMOTE_ADDR"]	. ")가 [웹메일 접근 IP 관리]에 등록되지 않았으므로 강제 로그아웃되었습니다.", "DEBUG");

							auth_proc('LOGOUT');
							msg("접근한 IP(" . $_SERVER['REMOTE_ADDR'] . ")에서는 웹메일에 접근할 수 없습니다.\\n\\n관리자가 접근 할 수 있는 IP를 제한 해두었습니다.\\n\\n관리자에게 문의하여 주십시오.", 0);
							movepage($nmpath . '/login.php?back_url=' . urlencode($_SERVER['REQUEST_URI']));
						} else {
							$_SESSION["auth_m_checkhost"] = $_SERVER[REMOTE_ADDR];        // 마지막으로 검사한 IP 기록.
						}    // if()
					} else {
						$_SESSION["auth_m_checkhost"] = $_SERVER[REMOTE_ADDR];        // 마지막으로 검사한 IP 기록.
					}    // if()
				}	// if()

			}else if($level != $G[LEVEL][guest])		// 로그인 하지 않았고 제한레벨이 손님이상이 아닐때 전체로그인창 출력
			{
				movepage($nmpath.'/login.php?back_url=' . urlencode($_SERVER['REQUEST_URI']));
			}	// if()

		}	// function()


###############################################################################


		// [2013-07-01] 웹메일 로그인 로그
		function auth_log($d_no, $m_no, $m_id, $l_status)
		{
			global $db, $TB;

			$_t = time();
			$l_date = date('Y-m-d', $_t);
			$l_time = date('H:i:s', $_t);

			// db
			$q = "INSERT INTO ".$TB['LOG_LOGIN']." (d_no, d_name, m_no, m_id, l_date, l_time, l_ip, l_status) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
			db_query($q, array($d_no, get_d_name($d_no, true), $m_no, $m_id, $l_date, $l_time, $_SERVER['REMOTE_ADDR'], $l_status));

			// file
			errorlog("[LOGIN_".$l_status. "]".$m_id.'@'.get_d_name($d_no, true), "MEMBER");
		}	// function()

		function auth_login_limit_time($_today, $minus)
		{
			$_minus_time = $_today - $minus;
			if (date('Y-m-d', $_today) != date('Y-m-d', $_minus_time))
			{
				$time = '00:00:00';
			} else
			{
				$time = date('H:i:s', $_minus_time);
			}	// if()
			return $time;
		}	// function()


################################################################################


?>