/**
 * 토글 열기
 * @param m_id
 */
function toggleDropdown(m_no) {
    $('#dropdown_' + m_no).click();
}

/**
 * 레이아웃 메뉴 클릭시 이벤트
 *
 * @param form
 * @param cmd
 * @param m_no
 * @param m_name
 */
function layout_click(form, cmd, m_no, m_name) {
    $('input[name="chk_m_no[]"]').each(function () {
        if (m_no === $(this).val()) {
            $(this).prop('checked', true);
        }
    });

    switch (cmd)
    {
        case 'SMTP_SET':
            msg = "선택된 회원 [" + m_name + "]의 [SMTP 서비스]를 허용하시겠습니까?\n\n허용시 아웃룩 등의 메일클라이언트를 통한 메일보내기를 사용할 수 있게 됩니다.";
            break;
        case 'SMTP_UNSET':
            msg = "선택된 회원 [" + m_name + "]의 [SMTP 서비스]를 차단하시겠습니까?\n\n차단시 아웃룩 등의 메일클라이언트를 통한 메일보내기를 사용할 수 없게 됩니다.\n\n(웹메일만 사용시 허용 불필요)";
            break;
        case 'POP3_SET':
            msg = "선택된 회원 [" + m_name + "]의 [POP3 서비스]를 허용하시겠습니까?\n\n허용시 아웃룩 등의 메일클라이언트를 통한 메일받기를 사용할 수 있게 됩니다.";
            break;
        case 'POP3_UNSET':
            msg = "선택된 회원 [" + m_name + "]의 [POP3 서비스]를 차단하시겠습니까?\n\n차단시 아웃룩 등의 메일클라이언트를 통한 메일받기를 사용할 수 없게 됩니다.\n\n(웹메일만 사용시 허용 불필요)";
            break;
        case 'FORWARD_UNSET':
            msg = "선택된 회원 [" + m_name + "]의 [메일 포워딩]을 '사용안함'으로 변경하시겠습니까?\n\n대형포털이나 외부에 존재하는 메일서버로 메일 포워딩을 설정해둔 경우\n스팸메일까지 함께 포워딩이 되어 메일서버의 IP가 스팸서버로 등록될 가능성이 있습니다.\n\n따라서 가급적 메일 포워딩은 내부 사용자끼리만 설정하도록 제한하는 것이 좋습니다.";
            break;
        case '2FA_SET':
            msg = "선택된 회원 [" + m_name + "]의 '사용함'으로 변경하시겠습니까?\n\n사용함으로 변경시 로그인을 할 때 2단계 인증을 사용하게 됩니다.";
            break;
        case '2FA_UNSET':
            msg = "선택된 회원 [" + m_name + "]의 [2단계 인증]을 '사용안함'으로 변경하시겠습니까?\n\n사용안함으로 변경시 로그인을 할 때 2단계 인증을 사용하지 않게 됩니다.";
            break;
        case '2FA_REQUIRED_SET':
            msg = "선택된 회원 [" + m_name + "]의 [2단계 인증]을 '필수'로 변경하시겠습니까?\n\n필수로 변경시 로그인을 할 때 2단계 인증을 등록해야 메일을 사용할 수 있게 됩니다.";
            break;
        case '2FA_REQUIRED_UNSET':
            msg = "선택된 회원 [" + m_name + "의 [2단계 인증]을 '선택'으로 변경하시겠습니까?\n\n선택으로 변경시 로그인을 할 때 2단계 인증을 등록하지 않아도 메일을 사용할 수 있게 됩니다.";
            break;
    }	// switch()

    if (confirm(msg))
    {
        form.action = nmpath + '/admin_mbr_proc_ok.php?cmd='+cmd;
        form.submit();
    }
}

/**
 * 용량 더하기
 *
 * @param quota
 * @param name
 */
function quota_plus(quota, name) {
    var element = document.getElementsByName(name)[0];

    if (Number(quota) === 0) {
        element.value = '';
    } else {
        element.value = Number(quota) + Number(element.value);
    }
}

/**
 * 계정 보안 관리 도움말 보여주기
 */
function mbr_security_help() {
    var mbr_security_help = document.getElementById('mbr_security_help');
    var btn = document.getElementById('btn_mbr_security_help');

    if (mbr_security_help.style.display === 'none' || mbr_security_help.style.display === '') {
        mbr_security_help.style.display = 'block';
    } else {
        mbr_security_help.style.display = 'none';
    }

    var position = jQuery('#btn_mbr_security_help').position();

    var top = position.top + 20;
    var left = position.left;

    mbr_security_help.style.left = left + 'px';  // 버튼의 좌측 위치
    mbr_security_help.style.top = top + 'px';  // 버튼 바로 아래 위치 (5px 여백 추가)
}

/**
 * 계정 보안 관리 도움말 닫기
 */
function mbr_security_help_close() {
    var mbr_security_help = document.getElementById('mbr_security_help');

    mbr_security_help.style.display = 'none';
}
