<?
require_once('include/global.php');
require_once('include/admin_lib.php');
require_once("include/member_lib.php");
require_once('include/member_group_lib.php');
#require_once('sadmin_conf.inc.php');

mail_server_check_limit();		// 메일서버가 동작중인지 확인

// set
	if ($_GET['isadmin'])
	{
		auth_limit('admin');
		$CFG['TITLE'] = '<b>관리자메뉴</b> >> <b>회원 관리</b> >> <b>메일계정 일괄 추가 결과</b>';
		$_GET['d_no'] = $G['DINFO']['d_no'];
	} else
	{
		auth_limit('serveradmin');
		$CFG['TITLE'] = '<b>메일서버관리</b> >> <b>전체 회원 관리</b> >> <b>메일계정 일괄 추가 결과</b>';
	}	// if()

nskinset('sadmin', 'admin_mbr_csv_add_ok.html');
set_time_limit(1200);
page_loading_view("메일계정 파일(CSV)을 분석하고 있습니다.");


// check
	if ($_GET['isadmin'])
	{
		auth_limit('admin');
		$_POST['sa_d_no'] = $G['DINFO']['d_no'];
	} else
	{
		auth_limit('serveradmin');

		// 사용가능한 도메인인지 확인.
			$sql = "SELECT d_name FROM ".$TB['DOMAIN']." WHERE d_no='". $_POST['sa_d_no'] . "' AND d_is_use='Y' ";
			$G_SYS['MAIL_DOMAIN'] = db_get_one($sql);
			if ($G_SYS['MAIL_DOMAIN'] == '')
				msg("존재하지 않거나 사용할 수 없는 도메인입니다.\\n\\n확인후 다시 시도하여 주십시오.");
	}	// if()



// data
	$DEBUG['getcsv']['start'] = getmicrotime();
	$i = 0;
	$rows = array();
	$fp = fopen ($_FILES['mbr_csv_file']['tmp_name'],"r");
	while ($rows[$i] = fgetcsv ($fp, 2048, ","))
	{
		// [2007-01-02] UTF-8
		if (strtoupper($G_SYS[CHARSET]) == 'UTF-8')
		{
			foreach ($rows[$i] as $key=>$val)
			{
				$rows[$i][$key] = iconv_fix('EUC-KR', $val, 'UTF-8');
			}	// foreach()
		}	// if()

	   $num = count ($rows[$i]);
	   $i++;
	}	// while()
	fclose ($fp);
	$rows_cnt = sizeof($rows);
	$DEBUG['getcsv']['exec'] += getmicrotime() - $DEBUG['getcsv']['start'];


	if (!is_array($rows[0]) || sizeof($rows[0]) < 1)
		msg("메일계정 파일(CSV)에 데이타가 없습니다.\n\n예제 파일(admin_mbr_csv_add_sample.zip)을 다운로드하여 비교해보시기 바랍니다.");


	$DEBUG['getaddr']['start'] = getmicrotime();
	$insert_cnt = 0;
	$result = array();
	$result_cnt = 0;
	$input2 = array();
	for ($i=0; $i<$rows_cnt; $i++)
	{
		if (trim($rows[$i][1]) == '아이디(*)')
			continue;

		// input data
			$input = array();
			$input['m_name'] = addslashes(trim($rows[$i][0]));
			$input['m_id'] = addslashes(trim(strtolower($rows[$i][1])));
			$input['m_pwd'] = addslashes(trim($rows[$i][2]));
			$input['m_quota'] = addslashes(trim($rows[$i][3]));
			$input['m_bigfile_quota'] = addslashes(trim($rows[$i][4]));
			$input['m_webhard_quota'] = addslashes(trim($rows[$i][5]));
			$input['mg_name'] = addslashes(trim($rows[$i][6]));
			$input['mc_name'] = addslashes(trim($rows[$i][7]));

			// check
			$error = "";
			$res_code = 'FAILED';
			if (!$input['m_name'] && !$input['m_pwd'] && !$input['m_id'])		// 형식 검사.
			{
				continue;
			} else if (!$input['m_id'])		// 이메일 입력여부 검사.
			{
				$error = "아이디가 누락되었습니다.";
			} else if (strlen($input['m_id']) >= 20)
			{
				$error = "아이디가 50자를 초과하였습니다.";
			} else if (!is_member_id($input['m_id']))
			{
				$error = "올바른 아이디가 아닙니다.";
			} else
			{
				// [2013-07-08] 비밀번호 안전 레벨
				$password_security_alert = member_password_security($input['m_pwd'], $input['m_id']);
				if ($password_security_alert != '')
				{
					$error = "비밀번호 입력 오류 : ".$password_security_alert;
				} else
				{
					// 중복여부 체크
					$q = "SELECT COUNT(*) FROM ".$TB['MEMBER']." WHERE m_id='".$input['m_id']."' AND d_no='" . $_POST['sa_d_no'] . "'";
					$id_check_cnt = db_get_one($q);
					if ($id_check_cnt > 0)
					{
						#$error = "이미 추가된 아이디입니다.";
						$res_code = 'DUPLICATE';
					} else
					{
						$input2[] = $input;
						$insert_cnt++;
						$res_code = 'ADD';
					}	// if()
				}	// if()
			}	// if()

			$result[] = array(
				'm_name'=>stripslashes($input['m_name']),
				'm_id'=>stripslashes($input['m_id']),
				'mg_name'=>stripslashes($input['mg_name']),
				'mc_name'=>stripslashes($input['mc_name']),
				'error'=>$error,
				'res_code'=>$res_code
				);
			$result_cnt++;
	}	// for()
	$DEBUG['getaddr']['exec'] += getmicrotime() - $DEBUG['getaddr']['start'];


	// 추가
	$dm = get_domain($G_SYS['MAIL_DOMAIN']);

	$input_sum = array();
	for ($i=0; $i<sizeof($input2); $i++)
	{
		// domain default
		if ($input2[$i]['m_quota'] == '')
			$input2[$i]['m_quota'] = $dm['d_quota_mbr_default'];
		else
			$input2[$i]['m_quota'] = $input2[$i]['m_quota'] * 1024;

		if ($input2[$i]['m_bigfile_quota'] == '')
			$input2[$i]['m_bigfile_quota'] = $dm['d_bigfile_quota_default'];
		else
			$input2[$i]['m_bigfile_quota'] = $input2[$i]['m_bigfile_quota'] * 1024;

		if ($input2[$i]['m_webhard_quota'] == '')
			$input2[$i]['m_webhard_quota'] = $dm['d_webhard_quota_default'];
		else
			$input2[$i]['m_webhard_quota'] = $input2[$i]['m_webhard_quota'] * 1024;


		// 추가할 모든 계정의 메일용량 할당량, 메일계정 할당수 제한
		mbr_add_limit($input2[$i]['m_quota'], $input2[$i]['m_bigfile_quota'], $input2[$i]['m_webhard_quota']);

		// set
		$m_pwd_enc = pwd_enc(stripslashes($input2[$i]['m_pwd']), stripslashes($input2[$i]['m_id']));
		$m_level = $G_MB[DEFAULT_JOIN_LEVEL_BYADMIN];
		$m_regdate = date("Y-m-d H:i:s");
		$m_reghost = $_SERVER[REMOTE_ADDR];
		$m_login_cnt = 0;

		$m_is_use = 'Y';
		$m_forwarding_type = 'N';
		$m_mail_file_group = get_mail_file_group_now($dm['d_no']);

		// [2008-06-07] 회원 그룹
		$mg_no = NULL;
		$q_insert_fields = '';
		$q_insert_values = '';
		if (trim($input2[$i]['mg_name']) != '')
		{
			// [2010-09-30] 단계별 조직 입력 지원.  단계별 구분자는 | 임.
			// [2011-01-13] 기존처럼 단계별 구분자가 없는 경우는 단계별로 이름과 일치하는 것을 찾도록 함.
			if (strpos($input2[$i]['mg_name'], '|') === false)
			{
				$mg_no= db_get_one("SELECT mg_no FROM " . $TB['MEMBER_GROUP'] . " WHERE d_no='" . $dm['d_no'] . "' AND mg_name='" . $input2[$i]['mg_name'] . "' ORDER BY mg_depth, mg_sort");
				if (!$mg_no)
				{
					$input2[$i]['mg_name'] = to_db_str($input2[$i]['mg_name'], 50);

					$sql = "
						INSERT INTO
							" . $TB['MEMBER_GROUP'] . "
							(mg_no, d_no, mg_name, mg_quota_default)
						VALUES
							(".db_sqc_next($TB['MEMBER_GROUP']).", '" . $dm['d_no'] . "', '" . $input2[$i]['mg_name'] . "', '" . $dm['d_quota_mbr_default'] . "')
						";
					db_query($sql);

					$mg_no = db_sqc_curr($TB['MEMBER_GROUP']);
				}	// if()
			} else
			{
				$mg_parent = 0;
				$_ex = explode('|', trim($input2[$i]['mg_name']));
				for ($j=0; $j<sizeof($_ex); $j++)
				{
					$_mg_name = addslashes(trim($_ex[$j]));
					if ($_mg_name != '')
					{
						$mg_no= db_get_one("SELECT mg_no FROM " . $TB['MEMBER_GROUP'] . " WHERE d_no='" . $dm['d_no'] . "' AND mg_parent='" . $mg_parent . "' AND mg_depth='" . ($j+1) . "' AND mg_name='" . $_mg_name . "'");
						if (!$mg_no)
						{
							$_mg_name = to_db_str($_mg_name, 50);

							$sql = "
								INSERT INTO
									" . $TB['MEMBER_GROUP'] . "
									(mg_no, d_no, mg_parent, mg_depth, mg_name, mg_quota_default)
								VALUES
									(".db_sqc_next($TB['MEMBER_GROUP']).", '" . $dm['d_no'] . "', '" . $mg_parent . "', '" . ($j+1) . "', '" . $_mg_name . "', '" . $dm['d_quota_mbr_default'] . "')
								";
							db_query($sql);

							$mg_no = db_sqc_curr($TB['MEMBER_GROUP']);
						}	// if()
						$mg_parent = $mg_no;
					}	// if()
				}	// for()
			}	// if()

			if (is_numeric($mg_no))
			{
				$q_insert_fields .= ", mg_no";
				$q_insert_values .= ", '".$mg_no."'";
			}	// if()
		}	// if()


		// [2008-10-09] 회원직위
		if (trim($input2[$i]['mc_name']) != '')
		{
			$mc_no= db_get_one("SELECT mc_no FROM " . $TB['MEMBER_CLASS'] . " WHERE d_no='" . $dm['d_no'] . "' AND mc_name='" . $input2[$i]['mc_name'] . "'");
			if (!$mc_no)
			{
				$input2[$i]['mc_name'] = to_db_str($input2[$i]['mc_name'], 50);

				$sql = "
					INSERT INTO
						" . $TB['MEMBER_CLASS'] . "
						(mc_no, d_no, mc_name, mc_sort)
					VALUES
						(".db_sqc_next($TB['MEMBER_CLASS']).", '" . $dm['d_no'] . "', '" . $input2[$i]['mc_name'] . "', '1')
					";
				db_query($sql);

				$mc_no = db_sqc_curr($TB['MEMBER_CLASS']);
			}	// if()

			if (is_numeric($mc_no))
			{
				$q_insert_fields .= ", mc_no";
				$q_insert_values .= ", '".$mc_no."'";
			}	// if()
		}	// if()

        $q_insert_fields .= ", m_last_pwdchgdate";
        $q_insert_values .= ", '".$m_regdate."'";

		$q = "
			INSERT INTO
				$TB[MEMBER]
				(m_no, m_id, m_pwd, m_level, m_name, m_regdate, m_reghost, m_login_cnt, d_no, m_is_use, m_mail_file_group, m_quota, m_bigfile_quota, m_webhard_quota, m_forwarding_type, m_forwarding ".$q_insert_fields.")
			VALUES
				(".db_sqc_next($TB['MEMBER']).", '".$input2[$i]['m_id']."', '".$m_pwd_enc."', '".$m_level."', '".$input2[$i]['m_name']."', '".$m_regdate."', '".$m_reghost."', '".$m_login_cnt."', '" . $dm['d_no'] . "', '".$m_is_use."', '".$m_mail_file_group."', '".$input2[$i]['m_quota']."', '".$input2[$i]['m_bigfile_quota']."', '".$input2[$i]['m_webhard_quota']."', '".$m_forwarding_type."', '".$m_forwarding."' ".$q_insert_values.")
			";
		#echo "\n" . $q;
		db_query($q);
		$curr_m_no = db_sqc_curr($TB['MEMBER']);		// 삽입된 데이타 키

		// [2010-09-30] 조직 갱신
		if ($mg_no)
			$mg_no = member_group_rel_update($curr_m_no, $mg_no, $isReset=false);


		// 웹메일용 처리.
			mbr_add($curr_m_no, $input2[$i]['m_id'], $input2[$i]['m_pwd'], $input2[$i]['m_quota'], $m_mail_file_group);

	}	// for()


// skin view
	page_loading_view_hidden();
	include($NSKIN['view_layout']);

require_once('include/global_end.php');
?>