
#include "SysInclude.h"
#include "SysDep.h"
#include <stdio.h>
#include <string.h>
#include <malloc.h>
//#include "stdafx.h"

#include "POP3linklist.h"

#define null 0


class_pop3list::class_pop3list()
{
	first = NULL;
	last = NULL;
	count = 0;
}

class_pop3list::~class_pop3list()
{
	Freeall();
}

int class_pop3list::Getsize(void)
{
	return count;		
}

//int class_link::Add(void *SetData, int datasize , char *SetKey, int keysize)
int class_pop3list::Add(char  *szMsgname, SYS_OFF_T  ulSize, unsigned ulFlags, time_t t_ctime)
{
	Pop3MsgList * pItem = new Pop3MsgList;

	// [2012-02-28]filename error fix
	//sprintf(pItem->szMsgName, szMsgname);
	sprintf(pItem->szMsgName, "%s", szMsgname);
	pItem->t_MsgCreateTime = t_ctime;
	pItem->ulFlags = ulFlags;
	pItem->ulMsgSize = ulSize;

	if(first == NULL)
	{
		first = last = pItem;
		pItem->next = pItem->pre = NULL;
	}
	else
	{
		last->next = pItem;
		pItem->pre = last;
		last = pItem;
		pItem->next = NULL;
	}
	count++;
	return 0;
}

void class_pop3list::Freeall(void)
{
	Pop3MsgList *pDel, *pItem = first;
	while(pItem != NULL)
	{
		pDel = pItem;
		pItem = pItem->next;
		delete pDel;
	}
	first = last = NULL;
	count = 0;
}
int class_pop3list::QuickSorting4(void * pLeft, void * pRight)
{
	Pop3MsgList * pSrc = (Pop3MsgList *)pLeft;
	Pop3MsgList * pDes = (Pop3MsgList *)pRight;
	
	return 0;
}
void class_pop3list::QuickSorting2(Pop3MsgList *pLeft, Pop3MsgList *pRight)
{
	Pop3MsgList *key_node, *left_node, *right_node;
	
	int nTotal = GetListCount(pLeft, pRight);
	int nLeft = 1;
	int nRight = nTotal-1;

	if(nRight <= 0)
		return;

	key_node = pRight;
	left_node = pLeft;
	right_node = pRight->pre;


	while(1)
	{
		while(left_node->t_MsgCreateTime < key_node->t_MsgCreateTime)
		{
			left_node = left_node->next;
			nLeft++;
		}

		while(right_node->t_MsgCreateTime > key_node->t_MsgCreateTime)
		{
			if(nRight<=1 || right_node->pre == NULL)
				break;

			right_node = right_node->pre;
			nRight--;
		}

		if(nLeft >= nRight)
			break;
	
		///swap node
		swap_list(left_node, right_node);

		left_node = left_node->next;
		nLeft++;
		right_node = right_node->pre;
		nRight--;
	}

	swap_list(key_node, left_node);


	if(left_node->pre != NULL && nLeft-1>0)
	{
		if(left_node->next != pLeft && pLeft->pre != left_node)
			QuickSorting2(pLeft, left_node->pre);
	}

	if(left_node->next != NULL && nLeft< nTotal)
	{
		if((left_node->pre != pRight) &&(pRight->next != left_node))
			QuickSorting2(left_node->next, pRight);
	}
}
void class_pop3list::swap_list(Pop3MsgList *psrc, Pop3MsgList *pdes)
{

	char szfilename[256]="";
	SYS_OFF_T  ulSize;
	unsigned long ulFlags;
	time_t file_time;

	sprintf(szfilename, "%s", psrc->szMsgName);
	ulSize = psrc->ulMsgSize;
	ulFlags = psrc->ulFlags;
	file_time = psrc->t_MsgCreateTime;

	sprintf(psrc->szMsgName, "%s",  pdes->szMsgName);
	psrc->t_MsgCreateTime = pdes->t_MsgCreateTime;
	psrc->ulFlags = pdes->ulFlags;
	psrc->ulMsgSize = pdes->ulMsgSize;

	sprintf(pdes->szMsgName,"%s", szfilename);
	pdes->t_MsgCreateTime = file_time;
	pdes->ulFlags = ulFlags;
	pdes->ulMsgSize = ulSize;
}
int class_pop3list::GetListCount(Pop3MsgList *pLeft, Pop3MsgList *pRight)
{
	Pop3MsgList * pItem = pLeft;
	int tmpcount = 0;

	while(1)
	{
		tmpcount++;
		if(pItem == NULL)
		{
			tmpcount--;
			break;
		}

		if(pItem == pRight)
			break;

		pItem = pItem->next;
	}

	return tmpcount;

}
void class_pop3list::QuickSorting3(Pop3MsgList *pLeft, Pop3MsgList *pRight)
{

}
void class_pop3list::QuickSorting(Pop3MsgList *pLeft, Pop3MsgList *pRight)
{
	Pop3MsgList *pStart;
	Pop3MsgList *pCurr;

	char szfilename[256]="";
	SYS_OFF_T  ulSize;
	unsigned long ulFlags;
	time_t file_time;
	
	if(pLeft == pRight)
		return;


	pStart = pLeft;
	pCurr = pStart->next;

	memset(szfilename, 0, 256);
	while(1)
	{
		if(pStart->t_MsgCreateTime < pCurr->t_MsgCreateTime)
		{///swap
			memset(szfilename, 0, 256);

			//sprintf(szfilename,"%s", pCurr->szMsgName);
			strcpy(szfilename, pCurr->szMsgName);
			ulSize = pCurr->ulMsgSize;
			ulFlags = pCurr->ulFlags;
			file_time = pCurr->t_MsgCreateTime;

		//	sprintf(pCurr->szMsgName,"%s", pStart->szMsgName);
			strcpy(pCurr->szMsgName, pStart->szMsgName);
			pCurr->ulFlags = pStart->ulFlags;
			pCurr->ulMsgSize = pStart->ulMsgSize;
			pCurr->t_MsgCreateTime = pStart->t_MsgCreateTime;

		//	sprintf(pStart->szMsgName,"%s", szfilename);
			strcpy(pStart->szMsgName, szfilename);
			pStart->t_MsgCreateTime = file_time;
			pStart->ulFlags = ulFlags;
			pStart->ulMsgSize = ulSize;
		}

		if(pCurr == pRight)
			break;

		pCurr = pCurr->next;
	}

	memset(szfilename, 0, 256);
//	sprintf(szfilename,"%s", pLeft->szMsgName);
	strcpy(szfilename,  pLeft->szMsgName);
	ulSize = pLeft->ulMsgSize;
	ulFlags = pLeft->ulFlags;
	file_time = pLeft->t_MsgCreateTime;

//	sprintf(pLeft->szMsgName,"%s", pCurr->szMsgName);
	strcpy(pLeft->szMsgName, pCurr->szMsgName);
	pLeft->t_MsgCreateTime = pCurr->t_MsgCreateTime;
	pLeft->ulFlags = pCurr->ulFlags;
	pLeft->ulMsgSize = pCurr->ulMsgSize;

//	sprintf(pCurr->szMsgName,"%s", szfilename);
	strcpy(pCurr->szMsgName, szfilename);
	pCurr->t_MsgCreateTime = file_time;
	pCurr->ulFlags = ulFlags;
	pCurr->ulMsgSize = ulSize;

	Pop3MsgList * pOldCur = pCurr;
	pCurr = pCurr->pre;

	if(pCurr != NULL)
	{
		if((pLeft->pre != pCurr)&&(pCurr->next != pLeft))
		{
			QuickSorting(pLeft, pCurr);
		}
	}

//	pCurr = pOldCur;
//	pCurr = pCurr->next;

	pOldCur = pOldCur->next;

	if(pOldCur != NULL)
	{
		if((pOldCur->pre != pRight)&&(pRight->next != pOldCur))
			QuickSorting(pOldCur, pRight);
	}
}
