<?

	// Duplicate check
		if ( defined("_INCLUDED_FUNC") ) return;
		define("_INCLUDED_FUNC", "1");


// [2010-09-15] 편지함 백업시 파일명 변경 지원.
function get_mail_box_backup_filename($mf_arrival_date, $mf_subject, $mf_from, $mf_to, $mb_id)
{
	$filename = '';

	// 받은날짜
	$filename .= date('Ymd_Hi', strtotime($mf_arrival_date));
	$filename .= '_';

	// 보낸이름/받는이름
	if (in_array($mb_id, array('sent', 'draft')))
	{
		$address = $mf_to;
	} else
	{
		$address = $mf_from;
	}	// if()
	$_ap = mime_address_parse($address);
	$filename .= $_ap['display'];
	$filename .= '_';

	// 제목
	$filename .= $mf_subject;

	// 파일명 길이는 100자로 제한하고, 파일명으로 사용불가한 문자는 제거함.
	$filename = han_substr(file_name_char_limit($filename), 100);

	return $filename;
}	// function()


// [2009-03-27] White IP 에서는 RBL 체크 생략
function netmask2bitmask($ipaddr, $netmask)
{
	$bitmask = strlen(str_replace('0', '', decbin(ip2long($netmask))));
	return $ipaddr.'/'.$bitmask;
}

function bitmask2netmask($ipaddr)
{
	$_ex = explode('/', trim($ipaddr));
	$_ex[1] = long2ip(0xffffffff << (32 - $_ex[1]));
	return $_ex;
}


// [2008-10-10] 다중 언어팩
function lang_conv($str)
{
	global $G_SYS, $NLANG;
	if ($G_SYS['MULTI_LANG_SUPPORT'] && $G_SYS['nm_lang'] != 'ko')
	{
		$_as = array_search(trim($str), $NLANG['ko']);
		if ($_as !== false)
			$str = $NLANG[$G_SYS['nm_lang']][$_as];
	}	// if()

	return $str;
}	// function()


// [2008-08-22] 주소록 그룹이 좌측에 보여지는 스킨일때
function nm_iframe_sync($frame_name, $height=true, $width=false)
{
	?>
		<script type="text/javascript">
			<!--
				function nm_iframe_sync(obj)
				{
					try
					{
						<? if ($height) { ?>
							if (parent.document.getElementById(obj).height < document.body.scrollHeight || (parseInt(parent.document.getElementById(obj).height, 10) >= 500 && parent.document.getElementById(obj).height > document.body.scrollHeight))
								parent.document.getElementById(obj).height = document.body.scrollHeight;
						<? }	// if() ?>

						<? if ($height) { ?>
							if (parent.document.getElementById(obj).width < document.body.scrollWidth)
								parent.document.getElementById(obj).width = document.body.scrollWidth;
						<? }	// if() ?>
					}
					catch (e) {}
				}	// function()

				nm_iframe_sync('<?= $frame_name ?>');

				if(typeof window.addEventListener != 'undefined')
				{
					window.addEventListener("load", function() { nm_iframe_sync('<?= $frame_name ?>'); }, false);
				} else if(typeof window.attachEvent != 'undefined')
				{
					window.attachEvent( "onload", function () { nm_iframe_sync('<?= $frame_name ?>'); } );
				}
		   //-->
		</script>
	<?
}	// function()

function nm_iframe_load($frame_name, $title_name='', $title='')
{
	nm_iframe_sync($frame_name, 1, 1);

	if ($title_name != '' && $title != '')
	{
		?>
			<script type="text/javascript">
				<!--
					try
					{
						parent.document.getElementById('<?= $title_name ?>').innerHTML = '<?= $title ?>';
					}
					catch (e) {}
			   //-->
			</script>
		<?
	}	// if()
}	// function()


// [2008-02-21] 에러메세지를 ActiveX 로 전달
function errorview($msg, $code)
{
	global $G_SYS;

	@header("HTTP/1.1 500");

	/*
	if ($G_SYS['NM_UPLOADER_CHARSET'] != 'UTF-8' && strtoupper($G_SYS[CHARSET]) == 'UTF-8')
	{
		echo str_replace("\\n", "\n", iconv_fix('UTF-8', $msg, 'EUC-KR'));
	} else
	{
		echo str_replace("\\n", "\n", $msg);
	}	// if()
	*/
	if (strtoupper($G_SYS[CHARSET]) != 'UTF-8')
		echo str_replace("\\n", "\n", iconv_fix($G_SYS[CHARSET], $msg, 'UTF-8'));
	else
		echo str_replace("\\n", "\n", $msg);

	error($msg, $code, $isexit=true, $isback=false, $isview=false);
}	// function()


// [2008-02-19] 웹하드 용량
function get_webhard_quota($m_no)
{
	global $G_SYS, $TB;

	if ($m_no > 0)
	{
		if (!isset($_SESSION["auth_m_webhard_quota"]))
		{
			$q = "SELECT m_webhard_quota, m_bigfile_quota FROM ".$TB['MEMBER']." WHERE m_no='".$m_no."'";
			$row = db_get_row($q);
			$_SESSION["auth_m_webhard_quota"] = $row['m_webhard_quota'];
			$_SESSION["auth_m_bigfile_quota"] = $row['m_bigfile_quota'];
		}	// if()

		return $_SESSION["auth_m_webhard_quota"];
	}	// if()
}	// function()


// [2008-02-19] 대용량첨부 용량
function get_bigfile_quota($m_no)
{
	global $G_SYS, $TB;

	if ($m_no > 0)
	{
		if (!isset($_SESSION["auth_m_bigfile_quota"]))
		{
			$q = "SELECT m_webhard_quota, m_bigfile_quota FROM ".$TB['MEMBER']." WHERE m_no='".$m_no."'";
			$row = db_get_row($q);
			$_SESSION["auth_m_webhard_quota"] = $row['m_webhard_quota'];
			$_SESSION["auth_m_bigfile_quota"] = $row['m_bigfile_quota'];
		}	// if()

		return $_SESSION["auth_m_bigfile_quota"];
	}	// if()
}	// function()


// [2008-02-15] ActiveX 사용여부
function get_activex_use()
{
	global $G_SYS;

	if (!isset($G_SYS['NM_ACTIVEX_USE']))
	{
		// [2013-10-28] IE 11 fix
		//if (strpos($_SERVER['HTTP_USER_AGENT'],"MSIE") !== false)
		if (strpos($_SERVER['HTTP_USER_AGENT'],"MSIE") !== false || strpos($_SERVER['HTTP_USER_AGENT'], 'Trident') !== false)
		{
			if ($_COOKIE['nm_upmode'] == 'T')
			{
				$G_SYS['NM_ACTIVEX_USE'] = false;
			} else if ($_COOKIE['nm_upmode'] == 'M')
			{
				$G_SYS['NM_ACTIVEX_USE'] = false;
			} else
			{
				$G_SYS['NM_ACTIVEX_USE'] = true;
				// [2012-04-30] 모바일웹
				if ($_COOKIE['nm_mobile'])
					$G_SYS['NM_ACTIVEX_USE'] = false;
			}	// if()
		} else
		{
			$G_SYS['NM_ACTIVEX_USE'] = false;
		}	// if()
	}	// if()

	return $G_SYS['NM_ACTIVEX_USE'];
}	// function()

// [2012-10-22] IE 10 fix
function is_not_default_webeditor()
{
	return preg_match('/iPhone|iPad|Android|Mobile Safari|BlackBerry|SymbianOS|Windows CE|Opera Mini|ARM/', $_SERVER['HTTP_USER_AGENT']);
}	// function()


// [2008-01-30] 키값 배열을 검색이 쉬운 문자열로 변환.  ex)  "|16|17|18|15|"
function db_str_implode($sp, $ar)
{
	if (is_array($ar) && sizeof($ar) > 0)
	{
		$return = $sp.implode($sp, $ar).$sp;
	} else
	{
		$return = "";
	}	// if()
	return $return;
}	// function()

// [2008-01-30] 검색이 쉬운 문자열로 키값 배열로 복원.
function db_str_explode($sp, $str)
{
	$return = array();
	if (strpos($str, $sp) !== false)
	{
		$ex = explode($sp, $str);
		for ($i=0; $i<sizeof($ex); $i++)
		{
			if (trim($ex[$i]) != '')
			{
				$return[] = $ex[$i];
			}	// if()

		}	// for()
	} else if (trim($str) != '')
	{
		$return[] = $str;
	}	// if()
	return $return;
}	// function()


// [2007-01-18] HTTP_HOST 에서 포트를 제외한 도메인만 가져오기
function get_http_host_domain($host)
{
	$__http_host = $host;
	if (strpos($host, ':') !== false)
	{
		$__url = parse_url($host);
		$__http_host = $__url['host'];
	}	// if()
	return $__http_host;
}	// function()


// [2006-07-25] 기본 설정 가져오기
function get_default_config($m_no)
{
	global $TB, $AUTH, $G_SYS;
	// [2010-10-06] 보낸주소 선택
	if ($G_SYS['NM_MAIL_FROM_SEL_ISUSE'])
	{
		$row = db_get_row("SELECT m_cfg_new_mail_box, m_cfg_new_cnt, m_cfg_week_diray_cnt, m_cfg_from_name, m_cfg_from_addr, m_cfg_mail_list_cnt FROM ".$TB['MEMBER']." WHERE m_no='".$m_no."'");
	} else
	{
		$row = db_get_row("SELECT m_cfg_new_mail_box, m_cfg_new_cnt, m_cfg_week_diray_cnt, m_cfg_from_name, m_cfg_mail_list_cnt FROM ".$TB['MEMBER']." WHERE m_no='".$m_no."'");
	}	// if()
	if (!$row)
	{
		$row = $G_SYS['DEFAULT_CONFIG_DEFAULT'];
	} else
	{
		foreach ($G_SYS['DEFAULT_CONFIG_DEFAULT'] as $key=>$val)
		{
			if ($key == 'm_cfg_from_name' && $row[$key] == '')
			{
				$row[$key] = $AUTH['auth_m_name'];
			}	// if()
			if (!$row[$key])
			{
				$row[$key] = $val;
			}	// if()
		}	// foreach()
	}	// if()

	return $row;
}	// function()


// [2006-07-04] 현재 메뉴에서 '환경설정, 관리자메뉴'의 경우 첫번째 메뉴에 자동링크를 걸어줌.
function title_autolink($title, $islink=true)
{
	global $nmpath, $G_SYS;

	if ($G_SYS['TITLE_AUTOLINK_SKIP'])
		return $title;

	$thispage = basename($_SERVER['PHP_SELF']);
	$viewmenu = '';
	#if (!in_array($thispage, array('board.php', 'mail_list.php', 'mail_read.php', 'mail_header_view.php')))
	preg_match_all('/\<b>([^<]+)\<\/b>/', $title, $mc);
	$cnt = sizeof($mc[1]);

	if ($cnt >= 2)
	{
		for ($i=0; $i<$cnt; $i++)
		{
			switch ($mc[1][$i])
			{
				case '주소록':
					$mc[2][$i] = $nmpath.'/addr_list.php';
					break;

				case '일정관리':
					$mc[2][$i] = $nmpath.'/diary_month.php';
					break;

				case '환경설정':
					$mc[2][$i] = $nmpath.'/mail_config.php';
					break;

				case '관리자메뉴':
					$mc[2][$i] = $nmpath.'/admin.php';
					break;

				case '메일서버관리':
					$mc[2][$i] = $nmpath.'/sadmin.php';
					break;

				case '공용게시판관리':
					$mc[2][$i] = $nmpath.'/board.php?mode=ADMIN_LIST';
					break;
			}	// switch()

			if ($viewmenu != '')
				$viewmenu .= ' >> ';

			if ($i < $cnt-1 && $mc[2][$i] != '')
			{
				if ($islink)
				{
					$viewmenu .= '<a href="'.lang_conv($mc[2][$i]).'"><b><u>'.lang_conv($mc[1][$i]).'</u></b></a>';
				} else
				{
					$viewmenu .= '<b>'.lang_conv($mc[1][$i]).'</b>';
				}	// if()
			} else
			{
				$viewmenu .= '<b>'.lang_conv($mc[1][$i]).'</b>';
			}	// if()
		}	// for()
	} else if ($mc[1][0] != '')
	{
		$viewmenu = str_replace($mc[1][0], lang_conv($mc[1][0]), $mc[0][0]);
	}	// if()

	if ($viewmenu == '')
		$viewmenu = $title;

	return $viewmenu;
}	// function()

// 도메인별 스킨 적용.
function set_nskin()
{
	global $NSKIN, $NLANG, $G_SYS, $G, $G_BOARD;

	// [2006-07-07] global.php 에서 미리 가져옴.
	//$G['DINFO'] = get_domain($G_SYS['MAIL_DOMAIN']);
	$NSKIN['main'] = $G['DINFO']['d_skin_main'];
	$NSKIN['webmail'] = $G['DINFO']['d_skin_webmail'];
	$NSKIN['member'] = $G['DINFO']['d_skin_member'];
	$NSKIN['board'] = $G['DINFO']['d_skin_board'];
	$NSKIN['webhard'] = $G['DINFO']['d_skin_webhard'];
	$NSKIN['mailer'] = 'bootstrap';
	// [2011-12-26] mobile
	$NSKIN['mobile'] = 'bootstrap';

	if (!$NSKIN['main'])
		$NSKIN['main'] = 'bootstrap';
	if (!$NSKIN['webmail'])
		$NSKIN['webmail'] = 'bootstrap';
	if (!$NSKIN['member'])
		$NSKIN['member'] = 'bootstrap';
	if (!$NSKIN['board'])
		$NSKIN['board'] = 'bootstrap';
	if (!$NSKIN['webhard'])
		$NSKIN['webhard'] = 'bootstrap';

	// [2008-10-10] 다중 언어팩
	if ($G_SYS['MULTI_LANG_SUPPORT'] && $G_SYS['nm_lang'] != 'ko')
	{
		$NSKIN['main'] .= '.'.$G_SYS['nm_lang'];
		$NSKIN['webmail'] .= '.'.$G_SYS['nm_lang'];
		$NSKIN['member'] .= '.'.$G_SYS['nm_lang'];
		$NSKIN['board'] .= '.'.$G_SYS['nm_lang'];
		$NSKIN['webhard'] .= '.'.$G_SYS['nm_lang'];

		require_once('include/lang.ko.php');
		require_once('include/lang.'.$G_SYS['nm_lang'].'.php');
	}	// if()

	// [2008-08-19] 스킨버젼 구분
	@include_once(nskindir('main').'/skin_version.php');		// 2.5 이전스킨에는 해당 파일이 없음.
}	// function()

function nskindir($kind, $isroot=false)
{
	global $NSKIN, $G_SYS;

	if (version_compare($NSKIN['ver'], '1.0', 'eq'))
	{
		$path = $kind.'_skin';
		// [2006-06-22] 스킨 1.0을 그대로 유지할때의 조치.
		if ($isroot)
			$path = $G_SYS['URL_ROOT'];
	} else
	{
		if ($kind == 'sadmin' || $kind == 'help')
		{
			$path = $kind;
		} else
		{
			$path = 'skin/'.$kind;
		}	// if()

		if ($NSKIN[$kind] != '')
			$path .= '/'.$NSKIN[$kind];

		if ($isroot)
			$path = $G_SYS['URL_ROOT'].'/'.$path;
	}	// if()

	return $path;
}	// function()

function nskindirroot($kind)
{
	return nskindir($kind, true);
}	// function()

function nskinset($kind, $file, $layout='self', $this_file=NULL)
{
	global $NSKIN, $G_SYS;

	if ($kind == 'sadmin')
	{
		define('NMAIL_SKIN_MAIN_CONTENTS_FILE', 'sadmin/'.$file);		// 컨텐츠
		$NSKIN['view_kind'] = $kind;
	} else if ($kind == 'help')
	{
		define('NMAIL_SKIN_MAIN_CONTENTS_FILE', 'help/'.$file);		// 컨텐츠
		$NSKIN['view_kind'] = $kind;
	} else if ($kind == 'current_dir')
	{
		// [2014-05-19] 현재 폴더아래에 skin 폴더가 오도록 변경.
		$_kind = basename(dirname($this_file));
		define('NMAIL_SKIN_MAIN_CONTENTS_FILE', $_kind.'/skin/'.$file);		// 컨텐츠
		$NSKIN['view_kind'] = '../'.$_kind.'/skin';
	} else
	{
		define('NMAIL_SKIN_MAIN_CONTENTS_FILE', nskindir($kind).'/'.$file);		// 컨텐츠
		$NSKIN['view_kind'] = $kind;
	}	// if()

	// [2011-12-26] mobile
	if ($kind == 'mobile')
	{
		$NSKIN['view_layout'] = nskindir('mobile').'/layout.inc.html';
	} else
	{
		if ($layout == 'self')
		{
			$NSKIN['view_layout'] = nskindir('main').'/layout.inc.html';
		} else if ($layout == 'window_open')
		{
			$NSKIN['view_layout'] = nskindir('main').'/layout_window_open.inc.html';
		} else if ($layout == 'iframe')
		{
			$NSKIN['view_layout'] = nskindir('main').'/layout_iframe.inc.html';
		} else
		{
			error("nskinset() 함수에서 세번째 입력값인 layout 에는 'self, window_open, iframe'값만 입력할 수 있습니다.   입력된 값 : ".$layout , $code='INPUT');
		}	// if()
	}	// if()
}	// function()

function nskinopendir($kind)
{
	$dirs = array();
	$skindir = 'skin/'.$kind;
	if ($dh = opendir($skindir)) {
		while (($file = readdir($dh)) !== false) {
			if ($file!="." && $file!=".." && is_dir($skindir.'/'.$file))
			{
				$dirs[] = $file;
			}
		}
		closedir($dh);
	}
	sort($dirs);
	return $dirs;
}	// function()


// [2006-05-29] PHP5에서 한글로 시작되는 파일명에서 발생하는 문제해결.
function basename_fix($filename)
{
	$basename = preg_replace('/^.+[\\\\\\/]/', '', $filename );
	return $basename;
}	// function()


function get_php_ini_path()
{
	ob_start();
	phpinfo(INFO_GENERAL);
	$php_info = ob_get_contents();
	ob_end_clean();

	// [2015-04] PHP5.4.x대응 대체함수 적용
	#foreach (split("\n",$php_info) as $line) {
	foreach (explode("\n",$php_info) as $line) {
		// [2015-04] PHP5.4.x대응 대체함수 적용
		#if (eregi('command',$line)) {
		if (preg_match('/command/i',$line)) {
		  continue;
		}

		if (preg_match('/thread safety.*(enabled|yes)/Ui',$line)) {
		  $thread_safe = true;
		}

		if (preg_match('/debug.*(enabled|yes)/Ui',$line)) {
		  $debug_build = true;
		}

		// [2015-04] PHP5.4.x대응 대체함수 적용
		//if (eregi("configuration file.*(</B></td><TD ALIGN=\"left\">| => |v\">)([^ <]*)(.*</td.*)?",$line,$match)) {
		if (preg_match("/loaded configuration file.*(<\/B><\/td><TD ALIGN=\"left\">| => |v\">)([^ <]*)(.*<\/td.*)?/i",$line,$match)) {
			$php_ini_path = $match[2];
		}
	}

	return $php_ini_path;
}	// function()


function get_mail_dir($m_mail_file_group=NULL, $m_id=NULL, $d_name=NULL)
{
	global $G_SYS, $AUTH;
	if ($m_id === NULL)
	{
		$m_id = $AUTH[auth_m_id];
		$m_mail_file_group = $AUTH[auth_m_mail_file_group];
	}	// if()

	// [2007-05-29]
	if ($d_name === NULL)
		$d_name = $G_SYS[MAIL_DOMAIN];

	if ($m_mail_file_group === '0000' || strlen($m_mail_file_group) != 4)
	{
		$mail_dir = $G_SYS[MAIL_ROOT].'/'.$d_name.'/'.$m_id.'/Maildir';
	} else
	{
		$mail_dir = $G_SYS[MAIL_ROOT].'/'.$d_name.'/'.$m_mail_file_group.'/'.$m_id.'/Maildir';
	}	// if()

	return $mail_dir;
}	// function()


function get_short_date($date)
{
	#if (substr($date, 0, 10) == date('Y-m-d'))		// 동일한 날짜일때만 시간을 표시.
	if (strtotime($date) >= time() - 43200)		// 날짜와 관계없이 12시간 이내는 시간을 표시.
	{
		$return = substr($date, 11, 5);
	} else
	{
		$return = substr($date, 5, 5);
	}	// if()
	return $return;
}	// function()


function get_board_list()
{
	global $db, $TB, $AUTH, $G_SYS, $DEBUG;

	if (!$G_SYS['BOARD_LIST'] && $AUTH['auth_m_no'])
	{
		$q_where = "";
		if ($_GET['bm_no'])
			$q_where = " AND ba.bm_no='".$_GET['bm_no']."' ";


		// [2008-09-12] 회원그룹(단일) -> 회원조직(다중)
			$q = "SELECT mg_no FROM ".$TB['MEMBER_GROUP_REL']." WHERE m_no='".$AUTH['auth_m_no']."'";
			$mgr = db_get_rows($q);
			$mgr_cnt = sizeof($mgr);
			$q_mgr = '';
			if ($mgr_cnt > 0)
			{
				for ($i=0; $i<$mgr_cnt; $i++)
				{
					$q_mgr .= " OR ba.ba_mg_no LIKE '%|".$mgr[$i]['mg_no']."|%' ";
				}	// for()
			}	// if()

		// [2008-03-19] 사용그룹제한 추가
		if ($G_SYS['NM_BOARD_PERM_LIMIT_VIEW'])		// 게시판에 사용권한이 없더라도 목록에서 보여주도록 함.(기본값은 보여주지 않음.)
		{
			$q = "SELECT ba.ba_no, ba.ba_name, ba.bm_no FROM " . $TB['BOARD_ADMIN'] . " ba WHERE ba.d_no='" . $AUTH['auth_d_no'] . "' ".$q_where." ORDER BY ba.ba_sort, ba.ba_name";
			$G_SYS['BOARD_LIST'] = db_get_rows($q);

			$q = "
					SELECT
						ba.ba_no
					FROM
						" . $TB['BOARD_ADMIN'] . " ba
					WHERE
						ba.d_no='" . $AUTH['auth_d_no'] . "'
						AND
							(
								(ba.ba_mg_no IS NULL OR ba.ba_mg_no = '')
								OR ( ba.ba_use_id LIKE '%|".$AUTH['auth_m_id']."|%' ".$q_mgr." )
							)
					";
			$ba_no = db_get_rows($q, true);
			if ($ba_no)
			{
				for ($i=0; $i<sizeof($G_SYS['BOARD_LIST']); $i++)
				{
					if (in_array($G_SYS['BOARD_LIST'][$i]['ba_no'], $ba_no['ba_no']))		// 권한이 있을때
						$G_SYS['BOARD_LIST'][$i]['ba_name'] = '<b>'.$G_SYS['BOARD_LIST'][$i]['ba_name'].'</b>';
				}	// for()
			}	// if()
		} else
		{
			$q = "
					SELECT
						ba.ba_no, ba.ba_name, ba.bm_no
					FROM
						" . $TB['BOARD_ADMIN'] . " ba
					WHERE
						ba.d_no='" . $AUTH['auth_d_no'] . "'
						AND
							(
								(ba.ba_mg_no IS NULL OR ba.ba_mg_no = '')
								OR ( ba.ba_use_id LIKE '%|".$AUTH['auth_m_id']."|%' ".$q_mgr." )
							)
						".$q_where."
					ORDER BY
						ba.ba_sort, ba.ba_name
					";
			$G_SYS['BOARD_LIST'] = db_get_rows($q);
		}	// if()

		// [2013-07-08] 메뉴에 속한 게시판중 권한이 하나도 없을 경우, 메뉴까지 보여주지 않도록 함.   bm_no 가 적용되는 $q_where 는 제외시킴.
		// [2011-01-05] 메뉴관리
		// [2013-08-28] Oracle 예외 처리
		if ($G_SYS[DB] == 'oracle')
		{
			$q = "SELECT bm.bm_no, bm.bm_name, ROW_NUMBER() OVER(PARTITION BY bm.bm_no ORDER BY bm.bm_no) rn FROM ".$TB['BOARD_MENU']." bm, ".$TB['BOARD_ADMIN']." ba 
				WHERE bm.d_no='".$AUTH['auth_d_no']."' AND bm.bm_no=ba.bm_no
							AND
								(
									(ba.ba_mg_no IS NULL OR ba.ba_mg_no = '')
									OR ( ba.ba_use_id LIKE '%|".$AUTH['auth_m_id']."|%' ".$q_mgr." )
								)
				ORDER BY bm.bm_sort, bm.bm_name";
			$q = "SELECT * FROM (".$q.") WHERE rn = 1";
		} else 
		{
			$q = "SELECT DISTINCT bm.bm_no, bm.bm_name FROM ".$TB['BOARD_MENU']." bm, ".$TB['BOARD_ADMIN']." ba 
				WHERE bm.d_no='".$AUTH['auth_d_no']."' AND bm.bm_no=ba.bm_no
							AND
								(
									(ba.ba_mg_no IS NULL OR ba.ba_mg_no = '')
									OR ( ba.ba_use_id LIKE '%|".$AUTH['auth_m_id']."|%' ".$q_mgr." )
								)
				ORDER BY bm.bm_sort, bm.bm_name";
		}	// if()


		$G_SYS['BOARD_MENU'] = db_get_rows($q);
	}	// if()

	return $G_SYS['BOARD_LIST'];
}	// function()


function get_bm_name($bm_no)
{
	global $G_SYS, $TB, $AUTH;

	$bm_name = "게시판";
	if ($bm_no)
	{
		if ($G_SYS['BOARD_MENU'])
		{
			for ($i=0; $i<sizeof($G_SYS['BOARD_MENU']); $i++)
			{
				if ($G_SYS['BOARD_MENU'][$i]['bm_no'] == $bm_no)
				{
					$bm_name = $G_SYS['BOARD_MENU'][$i]['bm_name'];
				}	// if()
			}	// for()
		} else
		{
			$q = "SELECT bm_name FROM ".$TB['BOARD_MENU']." WHERE bm_no='".$bm_no."' AND d_no='".$AUTH['auth_d_no']."'";
			$bm_name = db_get_one($q);
		}	// if()
	}	// if()

	return $bm_name;
}	// function()


function pwd_enc($pwd, $id='', $pwd_enc='')
{
	global $db, $G_SYS;
	if ($G_SYS[PWD_ENC] == 'MYSQL')
	{
		$q = "SELECT PASSWORD('".addslashes($pwd)."')";
		$pwd = db_get_one($q);
	} else if ($G_SYS[PWD_ENC] == 'MYSQL_OLD')
	{
		$q = "SELECT OLD_PASSWORD('".addslashes($pwd)."')";
		$pwd = db_get_one($q);
	} else if ($G_SYS[PWD_ENC] == 'ORACLE_FUNC_ENCRYPT')
	{
		if (!$id)
			$id = 'NULL';
		$q = "SELECT ENCRYPT('".addslashes($id)."', '".addslashes($pwd)."') FROM DUAL";
		$pwd = db_get_one($q);
	} else if ($G_SYS[PWD_ENC] == 'CRYPT')
	{
		if ($pwd_enc)
		{
			$pwd = crypt($pwd, $pwd_enc);
		} else
		{
			$pwd = crypt($pwd);
		}	// if()
	} else if ($G_SYS[PWD_ENC] == 'CRYPT2')
	{
		if (strlen($pwd) <= 8)
		{
			$pwd = crypt($pwd, $id);
		} else if (strlen($pwd) <= 16)
		{
			$pwd = crypt(substr($pwd, 0, 8), $id).crypt(substr($pwd, 8), $id);
		} else
		{
			$pwd = crypt(substr($pwd, 0, 8), $id).crypt(substr($pwd, 8, 8), $id).crypt(substr($pwd, 16), $id);
		}	// if()
	} else
	{
		$pwd = md5($pwd);
	}	// if()
	return $pwd;
}	// function()


/**
	페이지 로딩 화면 출력하기
		: 클라이언트에서 서버로 데이타 전송이 끝난뒤 실제 프로그램을 처리하는 시점부터 표시됨.

	ex)
		page_loading_view("메일을 발송하고 있습니다.");
*/
function page_loading_view($msg)
{
	global $G_SYS, $NSKIN;

	// [2012-04-30] 모바일웹
	if (!$_COOKIE['nm_mobile'])
	{
		include(nskindir('webmail').'/page_loading_view.inc.html');

		// [2013-10-10] output_buffering
		$output_buffering = ini_get('output_buffering');
		if ($output_buffering > 0 && is_numeric($output_buffering))
			echo str_repeat(" ", $output_buffering);

		flush();
		$G_SYS['PAGE_LOADING_VIEW_EXEC'] = true;
	}	// if()
}	// function()


/**
	페이지 로딩 화면 숨기기

	ex)
		page_loading_view_hidden();
*/
function page_loading_view_hidden()
{
	global $G_SYS;
	if ($G_SYS['PAGE_LOADING_VIEW_EXEC'])
	{
		?>
			<script language="JavaScript">
			<!--
				nm_page_loading_view_isoff = 1;
				document.all.nm_page_loading_view.style.display = 'none';
			//-->
			</script>
		<?
	}	// if()
}	// function()


/**
	파일크기를 읽기쉽게 변환하기

	[2005-04-28]
*/
function filesize_human($byte, $sosu=2, $zero_string=NULL)
{
	/*
	if ($byte  < 1024)
	{
		$h1 = $byte;
		$h2 = "";
	} else
	*/
	if ($byte == 0 && $zero_string != NULL)
	{
		return $zero_string;
	} else if ($byte < 1048576)
	{
		$h1 = $byte / 1024;
		$h2 = "K";
	} else if ($byte < 1073741824)
	{
		$h1 = $byte / 1048576;
		$h2 = "M";
	} else
	{
		$h1 = $byte / 1073741824;
		$h2 = "G";
	}	// if()

	return number_format(ceil($h1*100)/100, $sosu).$h2;
}	// function()





###############################################################################
# Pear - DataBase
###############################################################################


function set_db()
{
	global $db, $G_SYS, $DEBUG;

	if ($db != NULL) return;

	require_once("DB.php");

	$DEBUG['db_connetion']['start'] = getmicrotime();

	$db = DB::connect($G_SYS[DB_DSN]);

	if (DB::isError($db)) {
		// [2012-05-24] 디비 연결 오류도 로그에 남김
		error("디비에 연결할 수 없습니다.<br><br>디비 계정정보를 확인해보시기 바랍니다.<br><br>" . $db->getMessage() . $db->backtrace[0]['args'][4], 'DB');
		//die ("디비에 연결할 수 없습니다.<br><br>디비 계정정보를 확인해보시기 바랍니다.<br><br>" . $db->getMessage() . $db->backtrace[0]['args'][4]);
	}


	// fetch 후 결과값을 $row['id'] 형식으로 필드이름을 키값으로 가지게 함.
	$db->setFetchMode(DB_FETCHMODE_ASSOC);

	// 테이블, 필드명을 소문자로 반환함.
	$db->setOption('portability', DB_PORTABILITY_LOWERCASE);

	// [2006-08-18] 디비 언어셋이 지정되었을때는 접속시마다 선언함.
	if ($G_SYS[DB_CHARSET] != '')
		db_query("SET NAMES ".$G_SYS[DB_CHARSET]);
}	// function()


function unset_db()
{
	global $db, $DEBUG;

	if ($db == NULL) return;

	$db->disconnect();
	unset($db);

	$DEBUG['db_connetion']['exec'] = getmicrotime() - $DEBUG['db_connetion']['start'];

}	// function()


function db_sqc_next($table)
{
	global $G_SYS;
	if ($G_SYS[DB] == 'oracle')
	{
		$return = 'sqc_'.$table.'.NEXTVAL';
	} else
	{
		// [2007-08-23] MySQL 5.X 에서 경고 예방.
		//$return = "''";
		$return = "NULL";
	}	// if()
	return $return;
}	// function()


function db_sqc_curr($table)
{
	global $G_SYS;
	if ($G_SYS[DB] == 'oracle')
	{
		$return = db_get_one("SELECT sqc_".$table.".CURRVAL FROM dual");		// 삽입된 데이타 키
	} else
	{
		$return = db_get_one("SELECT LAST_INSERT_ID()");		// 삽입된 데이타 키
	}	// if()
	return $return;
}	// function()


/**
	[DB] addslashes() 된 상태의 쿼리문을 Oracle 용에 맞게 변환.
		php.ini) magic_quotes_gpc = On
*/
function db_query_quote($query, $is_prepare=false)
{
	global $G_SYS;
	if ($G_SYS[DB] == 'oracle')
	{
		// [2006-03-10] oracle 에서 메일 데이타 저장시에만 쿼터가 붙던 오류 해결.
		#$query = stripslashes(str_replace("\\'", "''", $query));
		if ($is_prepare)
		{
			$query = stripslashes($query);
		} else
		{
			// [2010-03-09] TIBERO
			if ($G_SYS[DB_ODBC] == 'tibero')
			{
				$query = stripslashes(str_replace("\\'", "''", $query));
			} else
			{
				// [2009-10-30] \ 가 포함된 경우 예외처리 추가
				//$query = stripslashes(str_replace("\\'", "''", $query));
				//$query = stripslashes(str_replace(array("\\\\", "\\'"), array("''", "\\"), $query));
				// [2011-11-09] Oracle 버젼에서 문제 발생하여 원상복구.
				$query = stripslashes(str_replace("\\'", "''", $query));
			}	// if()
		}	// if()
	}	// if()
	return $query;
}	// function()


// [2005-06-28] 디비 쿼리후 결과값에서 에러발생시 실행중단.
function db_result_check($res, $is_error_exit=true)
{
	$bt = $res->backtrace[sizeof($res->backtrace)-1];
	// [2007-08-21] 디비쿼리시 에러로그를 남길때 쿼리문이 너무 길 경우 잘라서 남기도록 함.
	if (DB::isError($res))
	{
		if (strlen($res->userinfo) > 2048)
			$res->userinfo = substr($res->userinfo, 0, 1024).'...'.substr($res->userinfo, (strlen($res->userinfo)-1024));

		// [2014-05-28] 에러 발생시 중단하지 않고, 에러 메세지를 리턴하도록 함수 인자값 추가.  리턴값이 true 가 아닐 경우, 에러임.
		if ($is_error_exit)
		{
			error("Message : ".$res->getMessage().", Source : ".$bt['file']." ( ".number_format($bt['line'])." line ), Return messages : ".$res->userinfo, 'ERROR');
		} else
		{
			return $res->userinfo;
		}
	} else{
		return true;
	}	// if()
}	// function()


// [2005-08-19]
function db_get_one($sql)
{
	global $db, $G_SYS;
	$_start = getmicrotime();

	$one = $db->getOne(db_query_quote($sql));
	db_result_check($one);

	$exec_time += getmicrotime() - $_start;
	if ($G_SYS['DEBUG_QUERY'] == 'VIEW')
		echo '<xmp>db_get_one(' . round($exec_time, 4) . 'sec) : ' . $sql . '</xmp>';
	if ($exec_time > $G_SYS['DEBUG_QUERY_OVER_TIME'])
		errorlog("[db_get_one]Time : " . round($exec_time, 4) . "sec, Query : ".$sql."", 'DEBUG');
	return $one;
}	// function()

function db_get_row($sql)
{
	global $db, $G_SYS;
	$_start = getmicrotime();

	$res = $db->Query(db_query_quote($sql));
	db_result_check($res);
	$res->fetchInto($row);
	$res->free();

	// [2009-05-13] Oracle 에서 값이 없을때 반환값을 NULL 대신 false 로 처리
	if ($row === NULL || (is_array($row) && sizeof($row) == 0))
		$row = false;

	$exec_time += getmicrotime() - $_start;
	if ($G_SYS['DEBUG_QUERY'] == 'VIEW')
		echo '<xmp>db_get_row(' . round($exec_time, 4) . 'sec) : ' . $sql . '</xmp>';
	if ($exec_time > $G_SYS['DEBUG_QUERY_OVER_TIME'])
		errorlog("[db_get_row]Time : " . round($exec_time, 4) . "sec, Query : ".$sql."", 'DEBUG');
	return $row;
}	// function()

function db_get_rows($sql, $from=0, $count=0, $is_fieldtokey=false)
{
	global $db, $G_SYS;
	$_start = getmicrotime();

	if ($count > 0)
	{
		$res = $db->limitQuery(db_query_quote($sql), $from, $count);
		$sql = $db->last_query;
	} else
	{
		$res = $db->Query(db_query_quote($sql));
		// 함수 입력값이 바뀌는 과정에서 db_get_rows($q, true) 와의 호환을 위함.
		if ($from === true)
		{
			$is_fieldtokey = true;
		}	// if()
	}	// if()
	db_result_check($res);
	$rows = array();
	while ($res->fetchInto($row))
	{
		$rows[] = $row;
	}	// while()
	$res->free();

	if ($is_fieldtokey)
	{
		$rows = db_rows_fieldtokey($rows);
	}	// if()

	$exec_time += getmicrotime() - $_start;
	if ($G_SYS['DEBUG_QUERY'] == 'VIEW')
		echo '<xmp>db_get_rows(' . round($exec_time, 4) . 'sec) : ' . $sql . '</xmp>';
	if ($exec_time > $G_SYS['DEBUG_QUERY_OVER_TIME'])
		errorlog("[db_get_rows]Time : " . round($exec_time, 4) . "sec, Query : ".$sql."", 'DEBUG');
	return $rows;
}	// function()

function db_query_limit($sql, $limit)
{
	if (!is_numeric($limit))
		errorlog("[db_query_limit]limit is null, Query : ".$sql."", 'INPUT');

	return db_query($sql, array(), $limit);
}	// function()
function db_query($sql, $data=array(), $limit=NULL, $is_error_exit=true)
{
	global $db, $G_SYS;
	$_start = getmicrotime();

	// [2013-10-29] DELETE/UPDATE 시 MySQL 에서만 LIMIT 1 사용 가능하도록 함.
	if ($limit != NULL && is_numeric($limit) && $G_SYS[DB] != 'oracle')
		$sql .= " LIMIT ".$limit;

	if (sizeof($data) > 0)
	{
		$sth = $db->prepare($sql);
		for ($i=0; $i<sizeof($data); $i++)
		{
			// [2014-05-22] mysql 에서도 prepare 구문 지원.
			if ($G_SYS[DB] == 'oracle')
			{
				// [2006-03-10] oracle 에서 메일 데이타 저장시에만 쿼터가 붙던 오류 해결.
				$data[$i] = db_query_quote($data[$i], true);
			} else
			{
				$data[$i] = stripcslashes($data[$i]);
			}
		}	// for()
		// [2006-09-29] TIBERO
		if ($G_SYS[DB_ODBC] == 'tibero')
		{
		   $db->stmt = odbc_prepare($db->connection, $sql);
		   // [2007-03-22] 시작과 끝이 작은 따옴표(')로 둘러쌓인 경우 "odbc_execute(): Can't open file" 에러가 발생하므로 마지막라인에 빈 공백을 하나 추가해주어야 함.
		   if (is_array($data))
		   {
				foreach ($data as $key=>$val)
				{
					if (strlen($val) > 1 and $val{0} == "'" and $val{strlen($val)-1} == "'")
						$data[$key] .= ' ';
				}	// foreach()
		   }	// if()
		   $result = odbc_execute($db->stmt,$data);

			if (!$result) {
				$result = $db->odbcRaiseError(); // XXX ERRORMSG
			}
			// Determine which queries that should return data, and which
			// should return an error code only.
			if (DB::isManip($sql)) {
				$db->affected = $result; // For affectedRows()
				$result = DB_OK;
			}
			$db->affected = 0;
			//$result = $result;

			if ($result === DB_OK || DB::isError($result)) {
				$res = $result;
			} else {
				// [2016-01-11] PHP 5버전대에서 Ampersand가 DEPRECATED처리되어 &삭제
				#$tmp =& new DB_result($this, $result);
				$tmp = new DB_result($this, $result);
				$res = $tmp;
			}
		} else
		{
			$res = $db->execute($sth, $data);
		}	// if()
	} else
	{
		$res = $db->Query(db_query_quote($sql));
	}	// if()

	// [2014-05-28] 에러 발생시 중단하지 않고, 에러 메세지를 리턴하도록 함수 인자값 추가.  리턴값이 true 가 아닐 경우, 에러임.
	$result_check = db_result_check($res, $is_error_exit);

	// [2006-09-15] TIBERO
	if ($G_SYS[DB_ODBC] == 'tibero')
		$db->commit();

	$exec_time += getmicrotime() - $_start;
	if ($G_SYS['DEBUG_QUERY'] == 'VIEW')
		echo '<xmp>db_query(' . round($exec_time, 4) . 'sec) : ' . $sql . '</xmp>';
	if ($exec_time > $G_SYS['DEBUG_QUERY_OVER_TIME'])
		errorlog("[db_query]Time : " . round($exec_time, 4) . "sec, Query : ".$sql."", 'DEBUG');

	return $result_check;
}	// function()

// [2013-10-30] 마지막으로 실행된 쿼리문에서 INSERT/UPDATE/DELTE 가 적용된 데이타 수를 반환.  없을 땐 0
function db_query_row_count()
{
	global $db;
	return $db->affectedRows();
}	// function()


###############################################################################



	// [2005-07-16] 널,빈문자열,빈배열일때 true 값 반환.  ["0", 0 은 false]
		/*
			ex)
				NULL => bool(true)
				string(0) "" => bool(true)
				string(1) " " => bool(false)
				string(1) "0" => bool(false)
				int(0) => bool(false)
				int(1) => bool(false)
				bool(true) => bool(false)
				bool(false) => bool(true)
				string(1) "" => bool(false)
				array(0) { } => bool(true)
				array(1) { [0]=> string(1) "a" } => bool(false)
		*/
		function isblank($str)
		{
			if (is_array($str))
			{
				if (sizeof($str) > 0)
				{
					return false;
				} else
				{
					return true;
				}	// if()
			} else
			{
				if ($str == '' && !is_numeric($str))
				{
					return true;
				} else
				{
					return false;
				}	// if()
			}	// if()
		}	// function()


	// [2005-07-13] 디비질의후 결과데이터의 배열을 필드명을 키값으로 지정함.
		function db_rows_fieldtokey($rows)
		{
			$return = array();
			for ($i=0; $i<sizeof($rows); $i++)
			{
				foreach ($rows[$i] as $key=>$val)
				{
					$return[$key][$i] = $val;
				}	// foreach()
			}	// for()

			return $return;
		}	// function()

		function db_rows_keytofield($rows)
		{
			$return = array();
			foreach ($rows as $key1=>$val1)
			{
				foreach ($rows[$key1] as $key=>$val)
				{
					$return[$key][$key1] = $val;
				}	// foreach()
			}	// foreach()

			return $return;
		}	// function()

	// [2005-07-13] 쿼리스트링에서 특정 값 제거후 반환.(문자열 형태)
		// 'chk_mf_no[] => chk_mf_no%5B%5D'형태의 배열때문에 키값 비교시 urldecode()처리 필요함.
		function get_qs()
		{
			$args= func_get_args();

			$qs = array();
			$qs_ex = array();

			if (!empty($_SERVER['QUERY_STRING']))
			{
				$qs_ex = explode('&', $_SERVER['QUERY_STRING']);
				for ($i=0; $i<sizeof($qs_ex); $i++)
				{
					list($key, $val) = explode('=', $qs_ex[$i]);
					$_as = array_search(urldecode($key), $args);
					if (($_as === false || $_as === NULL) && $val != '')
					{
						$qs[] = $key.'='.$val;
					}	// if()
				}
			}	// if()

			$result = implode('&', $qs);

			if (empty($result))
				$result = 'tmp=tmp';

			return $result;
		}	// function()


	// [2005-07-13] 쿼리스트링에서 특정 값 제거후 반환.(hidden input 폼태그 형태)
		function get_qs_input_hidden()
		{
			$args= func_get_args();

			$qs = '';
			$qs_ex = array();

			if (!empty($_SERVER['QUERY_STRING']))
			{
				$qs_ex = explode('&', $_SERVER['QUERY_STRING']);
				for ($i=0; $i<sizeof($qs_ex); $i++)
				{
					list($key, $val) = explode('=', $qs_ex[$i]);
					$_as = array_search(urldecode($key), $args);
					if (($_as === false || $_as === NULL) && $val != '')
					{
						// [2005-08-04] get방식의 폼에서 두번째 검색시부터 데이타가 중복 urlencode()되는 문제해결.
						#$qs .= '<input type=hidden name='.$key.' value="'.htmlspecialchars_fix($val).'">'."\n";
						// [2008-11-20] PHP 5.2.6AnNyung-51928 에서 urldecode 사용시 mb_id=1 을 mb_id=11 로 해석하는 문제가 발생하는 것 보완
						//$qs .= '<input type=hidden name='.$key.' value="'.htmlspecialchars_fix(urldecode($val)).'">'."\n";
						if (strpos($val, '%') !== false)
							$val = urldecode($val);
						// [2010-10-04] 대량메일발송시 name 값이 배열인 경우 처리
						if (strpos($key, '%') !== false)
							$key = urldecode($key);
						$qs .= '<input type=hidden name='.$key.' value="'.htmlspecialchars_fix($val).'">'."\n";
					}	// if()
				}
			}	// if()

			return $qs;
		}	// function()


	// [2006-01-04] 쿼리스트링에서 특정 값을 영구히 제거함.
		function cut_qs()
		{
			$args= func_get_args();
			if (!empty($_SERVER['QUERY_STRING']))
			{
				$cut = '('.implode('|', $args).')';
				$_SERVER['QUERY_STRING'] = preg_replace("/(^".$cut."\=|&".$cut."\=)+([^&]+)/i", "", $_SERVER['QUERY_STRING']);
				if (strpos($_SERVER['QUERY_STRING'], '&') === 0)
					$_SERVER['QUERY_STRING'] = substr($_SERVER['QUERY_STRING'], 1, strlen($_SERVER['QUERY_STRING'])-1);
			}	// if()
		}	// function()


	// [2005-07-13] 에러처리
		/*
			-. code
				INPUT
				DB
				FILE
				MAILPARSE
				MAILSERVER

			-. 시스템설정에 따라 사용자에게 보여주는 부분은 생략할 수 있도록 함.
		*/
		function error($msg, $code='INPUT', $isexit=true, $isback=false, $isview=true)
		{
			global $G_SYS, $AUTH;

			// file func only
			$msg = str_replace("\\n", "\n", $msg);

			if ($isview)
			{
				// 웹상일때와 쉘상일때 에러 구분 표시
				if ($_SERVER['DOCUMENT_ROOT'] || $_SERVER['SERVER_SOFTWARE'])
				{
					page_loading_view_hidden();
					echo ("<br><font color=red>[<b>Nmail Error - " . $code . "</b>]<br>" . nl2br($msg) . "</font><br>");
				} else
				{
					echo ("\n[Nmail Error - " . $code . "]\n" . $msg . "\n");
				}	// if()
			}	// if()

			// [2008-02-26] 로그에 로그인한 아이디 추가.
			//$message = '[' . date('Y-m-d H:i:s') . '] "' . $_SERVER['REMOTE_ADDR'] . '" "' . $_SERVER['REQUEST_URI'] . '" [' . $code . '] "' . str_replace("\n", '  ', str_replace("\r", '', $msg)) . "\"\n";
			$message = '[' . date('Y-m-d H:i:s') . '] "' . $_SERVER['REMOTE_ADDR'] . '" "' . $_SERVER['REQUEST_URI'] . '" [' . $code . '] "' . str_replace("\n", '  ', str_replace("\r", '', $msg)) . '" "' . $G_SYS['MAIL_DOMAIN'] . '" "' . $AUTH['auth_m_id'] . "\"\n";
			if ($code == 'FILTER_SPAM')
			{
				$logfile_pre = 'spam';
			} else if ($code == 'FILTER_VIRUS')
			{
				$logfile_pre = 'virus';
			} else if ($code == 'DEBUG')
			{
				$logfile_pre = 'debug';
			} else if ($code == 'TEST')
			{
				$logfile_pre = 'test';
			} else if ($code == 'AUTO_FILTER')
			{
				$logfile_pre = 'autosort';
			} else if ($code == 'AUTO_REPLY')
			{
				$logfile_pre = 'autoreply';
			} else if ($code == 'AUTO_DEL')
			{
				$logfile_pre = 'autodel';
			} else if ($code == 'MEMBER')
			{
				$logfile_pre = 'member';
			} else if ($code == 'MAILDEL')
			{
				$logfile_pre = 'maildel';
			} else if ($code == 'WEBMAILSEND')
			{
				$logfile_pre = 'webmailsend';
			} else
			{
				$logfile_pre = 'error';
			}	// if()
			#$destination = $G_SYS[PAGE_ROOT] . '/data/logs/'.$logfile_pre.'-' . date('Ymd') . '.txt';
			$destination = $G_SYS['WEBLOGS_DIR'] . '/'.$logfile_pre.'-' . date('Ymd') . '.txt';
			$fe = file_exists($destination);
			error_log($message, 3, $destination);
			// 로그파일이 처음 생성될때 퍼미션 변경.
			if (!$fe && !$_SERVER['DOCUMENT_ROOT'] && !$_SERVER['SERVER_SOFTWARE'])
			{
				chmod($destination, 0666);
			}	// if()
			if ($isback == true)
			{
				echo "<script language=\"JavaScript\"> <!-- history.back(); //--> </script>";
			}	// if()
			if ($isexit == true)
			{
				exit;
			}	// if()
		}	// function()

		function errorlog($msg, $code)
		{
			return error($msg, $code, false, false, false);
		}	// function()


	// [2005-05-27] 변수 출력용
		function vd($var, $title = ''){
			if ($title)
			{
				echo '<b><font color=blue>[' . htmlspecialchars_fix($title) . ']</font></b>';
			}	// if()
			echo '<xmp>';
			var_dump($var);
			echo '</xmp>';
		}


	// [2004-02-19] htmlspecialchars_fix() 사용시 "햏", "쀍"등 일부 한글이 깨지는 현상방지.
		function htmlspecialchars_fix($str)
		{
			#$trans = array("&" => "&amp;", "\"" => "&quot;", "＇" => "&#039;", "<"=>"&lt;", ">"=>"&gt;");
			// [2005-08-05] 작은따옴표 수정
			#$trans = array("\"" => "&quot;", "＇" => "&#039;", "<"=>"&lt;", ">"=>"&gt;");
			// [2005-08-19] textarea 내에 값을 넣을 경우를 위해 '&'추가.

			// [2005-10-06] &#48577; 형태에서 "&"는 변환하지 않음.  (08-19일자 수정전으로 되돌림)
			#$trans = array("&" => "&amp;", "\"" => "&quot;", "'" => "&#039;", "<"=>"&lt;", ">"=>"&gt;");
			$trans = array("\"" => "&quot;", "＇" => "&#039;", "<"=>"&lt;", ">"=>"&gt;");
			$str = strtr($str, $trans);
			return $str;
		}	// function()


	// [2003-10-09] 배열갯수가져오기 - 배열이 아닌 일반 변수일때 '1'이 반환되는 점은 방지하기 위함.
		function getarraycount($array){
			return is_array($array) ? sizeof($array) : 0;
		}



	// Debugging
		// [2003-05-30]
		function getmicrotime(){
			list($usec, $sec) = explode(" ",microtime());
			return ((float)$usec + (float)$sec);
		}



	// [2005-07-18] 정렬용 데이타 가져오기
		/*
			ex)
				$order_set = get_order($_GET['s_key'], $_GET['s_key2']);
				$order_img = get_order_img(array_keys($CFG['MAIL_LIST_FIELD']), $_GET['s_key'], $_GET['s_key2'], false, 'common_skin');		// array
		*/
		function get_order($s_key_list, $s_key_default, $s_key, $s_key2)
		{
			global $G_SYS;

			if ($s_key)
			{
				$_as = array_search($s_key, $s_key_list);
				if ($_as !== false && $_as !== NULL)
				{
					$s_key_set = $s_key;
				} else
				{
					error("다음은 정렬할 수 없는 필드명입니다. => [" . $s_key . "]", "INPUT");
				}	// if()
			} else
			{
				$s_key_set = $s_key_default;
				// [2005-10-13] 기본값일때도 정렬 아이콘 표시.
				$G_SYS['__GET_ORDER_S_KEY_DEFAULT'] =$s_key_default;
				$s_key2 = ($s_key2) ? $s_key2 : 'DESC';
			}	// if()
			$q_order = $s_key_set;

			if($s_key2)
			{
				$q_order .= ' ' . $s_key2;
				if($s_key2 == 'ASC')
				{
					$s_key2_set = 'DESC';
				}else
				{
					$s_key2_set = 'ASC';
				}
			}else
			{
				$q_order .=  ' DESC';
				$s_key2_set = 'ASC';
			}
			return array('query' => $q_order, 'key' => $s_key_set, 'set' => $s_key2_set);
		}	// function()


		/**
			정렬이미지 가져오기

			ex)
					$order_field = array(
							"sc2.sc2_no",
							"sc2.sc2_name",
							"sc2.sc2_regdate"
							);
					$order_img = get_order_img($order_field, $s_key, $s_key2);		// array
		*/
		function get_order_img($field, $s_key, $s_key2, $idx_is_no=false, $img_dir='img')
		{
			global $G_SYS;

			// [2006-03-22] 이미지 디렉토리 통합
			if ($img_dir == 'common_skin')
				$img_dir = 'img';

			// [2005-10-13] 기본값일때도 정렬 아이콘 표시.
			if (!$s_key)
			{
				$s_key = $G_SYS['__GET_ORDER_S_KEY_DEFAULT'];
				$s_key2 = 'DESC';
			}	// if()

			for($i=0; $i<sizeof($field); $i++)
			{
				$idx = ($idx_is_no) ? $i : $field[$i];

				if($s_key == $field[$i])
				{
					if($s_key2 == "DESC")
					{
						$return[$idx] = ' <img src='.nskindirroot('webmail').'/' . $img_dir . '/order_desc.gif align=absmiddle border=0 alt="오름차순으로 정렬하기">';
					}else
					{
						$return[$idx] = ' <img src='.nskindirroot('webmail').'/' . $img_dir . '/order_asc.gif align=absmiddle border=0 alt="내림차순으로 정렬하기">';
					}
				}else
				{
					$return[$idx] = NULL;
				}
				//echo "<HR>" . $idx . " - " . $s_key . " - " . $s_key2 . " - " . $return[$idx];
			}

			return $return;

		} // end func



		/**
			배열값들을 콤마로 구분하여 나열하기
			ex)
				$q_where = set_array2comma(" WHERE ba_no in (", ") ", array_keys($prefix));

		*/
		function set_array2comma($prefix, $suffix, $array_key, $fix="'", $comma=",")
		{
			$return = $prefix;
			for($i=0; $i<sizeof($array_key); $i++)
			{
				$return .= $fix . $array_key[$i] . $fix;
				if(($i+1) != sizeof($array_key)) $return .= $comma;
			}
			$return .= $suffix;

			return $return;
		}


		function set_text_fetch($text)
		{
			global $_SERVER, $AUTH, $G, $G_SYS, $G_CM, $G_MB, $G_BOARD, $CFG;

			$text = text_fetch("_SERVER", $_SERVER, $text);
			$text = text_fetch("AUTH", $AUTH, $text);
			$text = text_fetch("G", $G, $text);
			$text = text_fetch("G_SYS", $G_SYS, $text);
			$text = text_fetch("G_CM", $G_CM, $text);
			$text = text_fetch("G_MB", $G_MB, $text);
			$text = text_fetch("G_BOARD", $G_BOARD, $text);
			$text = text_fetch("CFG", $CFG, $text);

			return $text;
		}	// function()


		/**
			string text_fetch (string var_name, array var, string text )

			[2002-05-24]
			ex) $body = text_fetch("rm", $rm, $body);
		*/
		function text_fetch($var_name, $var, $text)
		{
			if (!is_array($var)||(sizeof($var) < 1)) return $text;

			$_var_source = array();
			$_var_dest = array();
			$_var_cnt = 0;
			while( list($_key_, $_val_) = each($var) )
			{
				$_var_source[$_var_cnt] = preg_quote("/<?= \$" . $var_name . "[" . $_key_ . "] ?>/");		// <?
				$_var_dest[$_var_cnt] = $_val_;
				//echo "<hr><xmp>[$_var_cnt] " . $_var_source[$_var_cnt] . "</xmp>";
				//echo "<hr><xmp>[$_var_cnt] " . $_var_dest[$_var_cnt] . "</xmp>";
				$_var_cnt++;
			}	// while()

			$text = preg_replace($_var_source, $_var_dest, $text);
			//echo "<hr><xmp>" . $text . "</xmp>";
			return $text;
		} // end func


		function system_msg($msg)
		{
			global $_SERVER;

			echo "<HR><H4>[System error] <a href='" . $_SERVER["REQUEST_URI"] . "' target='_blank'>" . $_SERVER["REQUEST_URI"] . "</a></H4>";
			echo "<font color=red>" . $msg . "</font><br><HR>";
			unset_db();
			exit;
		}	// function();


		function set_q_search(&$word)
		{
			$word = str_replace("%", "", trim($word));		// % 기호 삭제
			// [2005-07-18] magic_quotes_runtime 을 켜두므로 괜찮음.
			//$word = str_replace("'", "", $word);		// ' 기호 삭제
			return $word;
		}	// function()


		/** mailto url
			- 이메일이 없을 경우 링크를 걸지 않음.
			- 이름이 없을 경우 이름대신 이메일로 표시함.
			[2005-08-04] 이름대신 이메일을 표시하는 옵션추가.
		*/
		function get_mailto_url($email, $name=NULL, $is_view_email=false, $is_view_name=NULL, $opt=NULL)
		{
			global $G_SYS;
			#$target = 'target=_nm_hidden_frame';
			if ($name == NULL) $name = $email;

			if ($email)
			{
				// [2005-10-14] 웹메일은 회원전용이며 대부분의 자신의 메일목록만 관리하므로 인코딩 필요없음.
				#$return = "<a href='include/email.php?email=" . base64_encode($email) . "' " . $target . ">";
				// [2006-06-23] 메일주소 클릭시 이름도 같이 들어가도록 함.
				if ($name != '')
				{
					if ($is_view_name != '')
					{
						// [2009-08-07] 이름에 콤마(,)가 들어간 경우의 예외처리
						//$mailto = $is_view_name.' <'.$email.'>';
						$mailto = '"'.$is_view_name.'" <'.$email.'>';
					} else
					{
						// [2009-08-07] 이름에 콤마(,)가 들어간 경우의 예외처리
						//$mailto = $name.' <'.$email.'>';
						$mailto = '"'.$name.'" <'.$email.'>';
					}	// if()
				} else
				{
					$mailto = $email;
				}	// if()
				#$return = '<a href="'.$G_SYS[URL_ROOT].'/'.$G_SYS[MAILTO].urlencode($email).'" '.$target.'>';
				$return = '<a href="'.$G_SYS[URL_ROOT].'/'.$G_SYS[MAILTO].urlencode($mailto).'" '.$opt.'>';
				if (!$is_view_email)
				{
					$return .= $name;
				} else
				{
					$return .= $email;
				}	// if()
				$return .= "</a>";
			}else
			{
				$return = $name;
			}	// if()

			return $return;
		}	// function()


		/** Mail header 생성
			ex) $header = get_mail_header($mbr[m_email], $mbr[m_name], "HTML");

		*/
		function get_mail_header($email, $name=NULL, $type="HTML")
		{
			global $G_SYS;
			if ($name == NULL) $name = $email;

			$header = "From: $name<$email>\r\n";
			$header .= "MIME-Version : 1.0\r\n";
			$header .= "X-Sender: <$email>\n";
			$header .= "X-Mailer: PHP\n";
			$header .= "Return-Path: <$email>\n";  // Return path for errors

			switch($type)
			{
				case "HTML":
					$header .= "Content-Type: text/html; charset=".$G_SYS[CHARSET];
					break;

				case "TEXT":
					break;
			}	// switch()

			return $header;
		}	// function()


		/** 내용 html 처리
			- 게시판에서 사용시 등록한 형식(Y,M,N)에 맞게 내용을 처리함

			ex) $board[v_b_memo] = text_view($board[b_memo], $board[b_html]);

		*/
		function text_view($text, $type=NULL, $isadmin="N")
		{
			switch($type)
			{
				case "Y":		// HTML
					$value = ($isadmin == "Y") ? $text : del_tag($text);
					break;

				case "N":		// TEXT + <BR>
					$value = nl2br(htmlspecialchars_fix($text));
					break;

				case "M":		// HTML + <BR>
					$value = ($isadmin == "Y") ? nl2br($text) : nl2br(del_tag($text));
					break;

				case "REPLY":		// >> 내용
					// [2015-04] PHP5.4.x대응 대체함수 적용
					#$value = chr(10) . chr(10) . chr(10) . ">> " . ereg_replace(chr(10), chr(10).">> ", htmlspecialchars_fix($text));
					$value = chr(10) . chr(10) . chr(10) . ">> " . preg_replace("/".chr(10)."/", chr(10).">> ", htmlspecialchars_fix($text));
					break;

				default:		// TEXT
					$value = htmlspecialchars_fix($text);
					break;
			}	// switch()

			return $value;

		}	// function()




	// E-mail 주소가 올바른지 검사

		function isemail( $str ) {
			//if( eregi("([a-z0-9\_\-\.]+)@([a-z0-9\_\-\.]+)", $str) ) return $str;
			// [2004-04-21] -id-@hanmail.net 의 예외처리
			//if( eregi("([\-]*)([a-z0-9\_\-\.]+)([\-]*)@([a-z0-9\_\-\.]+)", $str) ) return $str;
			// [2004-05-27] ㅣ-id-@hanmail.net 등 주소앞에 한글이 들어간 경우의 예외처리
			// [2006-02-17] mail=ibin2.passkorea.net@sqlite.org
			// [2007-02-07] userid+test@gmail.com
			// [2009-03-16] girl\'s@sdaklfj.com
			//if (ereg("^[a-zA-Z0-9_\.\=\-]+@[a-zA-Z0-9\.-]+$", trim($str))) return true;
			//if (ereg("^[a-zA-Z0-9\+_\.\=\-]+@[a-zA-Z0-9\.-]+$", trim($str))) return true;
			$str = trim($str);
			// [2015-04] PHP5.4.x대응 대체함수 적용
			#if (     ereg("^[a-zA-Z0-9\!#\$%&'\*\+-/\=\?\^_`\.\{\|\}~]+@[a-zA-Z0-9\.-]+$", trim($str)))
			if (preg_match("/^[a-zA-Z0-9\!#\$%&'\*\+-\/\=\?\^_`\.\{\|\}~]+@[a-zA-Z0-9\.-]+$/", trim($str)))
			{
				$_ex = explode('@', $str);
				if (strpos($_ex[1], '..') === false && strpos($_ex[1], '.') !== 0 && substr($_ex[1], strlen($_ex[1])-1) != '.')
				{
					return true;
				}	// if()
			}	// if()
			return false;
		}

		// test
		/*
		$__emails = array(
			'-id-@hanmail.net',
			'mail=ibin2.passkorea.net@sqlite.org',
			'userid+test@gmail.com',
			'girl\'s@sdaklfj.com',
			'dsafads.D\'saffd@passkorea.net',

			'userid@.domain.com.',
			'userid@domain.com.',
			'userid@domain..com',
			'userid@domain..com.',
			'userid@.domain.com',
			);
		foreach ($__emails as $key=>$val)
		{
			echo "<HR>".$val; vd(isemail($val));
		}	// foreach()
		*/


	// 도메인 주소가 올바른지 검사

		function isdomain( $str ) {
			// [2009-11-30]
			// [2015-04] PHP5.4.x대응 대체함수 적용
			#if( ereg("^[a-zA-Z0-9\.-]+$", trim($str)) ) return true;
			if( preg_match("/^[a-zA-Z0-9\.\-\_]+$/s", trim($str)) ) return true;
			else return false;
		}


	// [2013-07-17] 올바른 아이디인지 검사
	function is_member_id( $str )
	{
		if ( preg_match("/^[a-z0-9\.\-\_]+$/", trim($str)) )
			return true;
		else
			return false;		
	}	// function()


	// E-mail 의 MX를 검색하여 실제 존재하는 메일인지 검사

		function mail_mx_check($email) {
			if(!isemail($email)) return false;
			list($user, $host) = explode("@", $email);
			if (checkdnsrr($host, "MX") or checkdnsrr($host, "A")) return true;
			else $return = false;
		}



	/** URL이동 (meta tag)
	*/
	// [2007-01-18] 타겟 지정 가능하게 함.
		function movepage($src, $time=0, $target='') {

			// [2011-01-14] 커스터마이징용
			global $G_SYS, $nmpath;
			if (file_exists($G_SYS[PAGE_ROOT].'/include/global_user_define_before_end.inc.php'))
				include('include/global_user_define_before_end.inc.php');

			// [2005-08-30] src 가 없을때는 / 로 간주함.
			if (!$src)
				$src = '/';


			// [2012-04-30] 모바일웹
			if ($_COOKIE['nm_mobile'])
			{
				if (is_string($src) && $src[0] != '/' && substr($src, 0, 2) != '..' && strpos($src, 'http://') !== 0 && strpos($src, 'https://') !== 0)
				{
					if (strpos($src, '/'.$G_SYS['MOBILE_PATH'].'/') === false)
					{
						// [2014-03-20] /mail/ 주소 사용시 오류 수정
						//$src = '/'.$G_SYS['MOBILE_PATH'].'/'.$src;
						$src = $nmpath.'/'.$G_SYS['MOBILE_PATH'].'/'.$src;
					}	// if()
				}	// if()
			}	// if()

			// [2010-05-27] WebKit 기반의 Chrome/Safari 웹브라우저에서 이동이 제대로 되지 않던 오류 수정.
			if (strpos($_SERVER['HTTP_USER_AGENT'], 'AppleWebKit') !== false)
			{
				if (is_string($src) && $src[0] != '/' && substr($src, 0, 2) != '..' && strpos($src, 'http://') !== 0 && strpos($src, 'https://') !== 0)
				{
					// [2013-07-17] Windows Server 일 경우, 예외 처리.
					//$_dir = dirname($_SERVER["PHP_SELF"]);
					$_dir = str_replace('\\', '/', dirname($_SERVER["PHP_SELF"]));
					if ($_dir == '/')
						$_dir = '';
					$src = $_dir.'/'.$src;
				}	// if()
			}	// if()

			if (!$target)
			{
			echo('<meta http-equiv="REFRESH" content="' . $time . '; url=' . $src . '">');
			} else
			{
			  ?>
				  <script type="text/javascript">
					  <!--
						<?= $target ?>.location.replace('<?= $src ?>');
					 // -->
				  </script>
			  <?
		  } // if()
			exit;
		}




	// Message - Javascript
		/*
			설정에 따라 메시지만 보여줄수도 있고, 뒤로 돌아가게 할 수 도 있도록 함.
		*/
		function msg($message, $go=-1, $close=false) {
			global $db;

			// [2008-01-31] 메세지에 '가 들어가 있을 경우의 에러 방지.
			$message = str_replace("'", "", $message);

			if(!$close)		// 현재창
			{
				$go = abs($go);
				$js = "\n<SCRIPT language=\"javascript\">\n\twindow.alert('$message');";
				if ($go > 0) $js .= "\n\thistory.go(" . -($go) . ")";
				$js .= "\n</SCRIPT>";
				if ($go > 0)		// 뒤로 돌아갈때만 종료함.
				{
					unset_db();
					echo $js;
					exit;
				}else
				{
					echo $js;
				}	// if()
			}else		//  새창일때 닫기
			{
				$js = "\n<SCRIPT language=\"javascript\">\n\twindow.alert('$message');\n\tself.window.close();";
				$js .= "\n</SCRIPT>";

				unset_db();
				echo $js;
				exit;

			}	// if()

		}	// function()



	/** ////////////////////////////////////////////////////////////////////////////
	String To DB data

	1. [MySQL] [ ' ] 의 경우 PHP4 에서는 폼으로 넘길때 자동으로 슬래시를 덧붙여주므로 별도 처리가 필요없음.
	2. 지정된 길이만큼 잘라줌(한글지원)
	3. 태그제거

	[2005-08-04]
	-. 대부분 필드의 경우 HTML을 제한하므로 strip_tags 디폴트값을 'false'에서 'true'로 변경.
		ex)
			to_db_str($_POST['sg_name'], 50);
			to_db_str($_POST['sg_content'], $G_SYS['DB_TEXT'], false);

	[2006-01-27]
	-. addslashes() 후에 문자열을 자를때 마지막에 '\'가 붙어서 쿼리가 깨지는 오류 보완.
	[2006-02-04]
	-. '\'가 여러개 붙을 경우를 대비해 정규표현식으로 처리.
	*/

	function to_db_str($str, $substr=false, $strip_tags=true, $istrim=true)
	{
		// [2007-01-24] trim() 을 사용하지 않아아야할 곳 도 있음.
		if ($istrim)
			$str = trim($str);
		if ($strip_tags) $str = htmlspecialchars_fix($str);
		if ($substr)
		{
			// [2009-05-26] to_db_str()에서 호출된 경우에만 slashes 삭제/추가 처리함
			//$str = han_substr($str, $substr, true);
			$str = han_substr($str, $substr, true, true);
			// [2009-04-02] 일부 문자열에서 Segmentation fault 발생 오류 방지
			// $str = preg_replace("/(\\\)+$/", "", $str);
		}	// if()
		return $str;
	}		// function()

	/* ex)
		to_db_str(String, [hanSubstr_length], [strip_tags]);
		to_db_str($str, 50, "STRIP_TAGS");

		input) [하하] '슬\래\\시..'<B></B>' 넘ㅇ!@@#$@#$%#$^%..'"
		db__) [하하] \'슬\래\\시..'''' 넘ㅇ!@@#$@#$%#$^%..''&quot;

	*/


	/** ////////////////////////////////////////////////////////////////////////////
	한글 완벽하게 자르기
		- han_substr($string, $limit_length, "noPoint");  로 사용할경우 반환값 뒤에 "..."을 붙이지 않도록함.
		- 세번째 인수인 "noPoint" 자체 생략가능

	*/
	function han_substr($string, $limit_length, $isNoPoint=false, $is_slashes=false, $is_strimwidth=false)
	{
		global $G_SYS;

		// $isNoPoint=TRUE - 문자열을 자른뒤 뒤 "..."를 붙일지 않음.
		// [2009-05-12] 마지막 문자열이 \로 잘리면서 발생하는 구문 오류 방지.
		// [2009-05-26] to_db_str()에서 호출된 경우에만 slashes 삭제/추가 처리함
		// [2013-07-04] UTF-8 버전을 위해 mb_strcut() 으로 변경
		if ($is_slashes)
			$string = stripslashes($string);

		if (strtoupper($G_SYS[CHARSET]) == 'EUC-KR')
		{
			$encoding = 'CP949';
		} else
		{
			$encoding = $G_SYS[CHARSET];
		}	// if()

		if ($is_strimwidth)		// 화면상에 보여지는 글자 사이즈로 자르기
		{
			$string_return = mb_strimwidth($string, 0, $limit_length, NULL, $encoding);
		} else		// 실제 DB에 저장되는 글자 길이(byte)로 자르기
		{
			$string_return = mb_strcut($string, 0, $limit_length, $encoding);
		}	// if()

		if (!$isNoPoint && strlen($string_return) != strlen($string))		// 문자열이 잘렸고, 마침표를 뒤에 붙여야 하는 경우.
			$string_return .= '...';

		if ($is_slashes)
			$string_return = addslashes($string_return);
		return $string_return;
	}	// function

	function han_substr_view($string, $limit_length)
	{
		global $G_SYS;

		return han_substr($string, $limit_length, false, false, true);
	}	// function


	### [String] 올바른 형식의 URL인지 확인
		function urlCheck($url)
		{
			// [2015-04] PHP5.4.x대응 대체함수 적용
			#if(ereg("([^[:space:]]+)", $url) && (!ereg("http://([0-9a-zA-Z./@~?&=_]+)", $url)) )
			if(preg_match("/([^[:space:]]+)/", $url) && (!preg_match("/http:\/\/([0-9a-zA-Z.\/@~?&=_]+)/", $url)) )
			{
				return false;
			}else
			{
				return true;
			}
		}

	### [Text] 검색된 단어를 강조시켜서 출력 ###
		function searchWordColor($searchword, $text, $color)
		{
			if ( (strlen($searchword) > 0) && (strlen($text) > 0) )		// 값이 존재할때만 변환함.
			{
				// [2015-04] PHP5.4.x대응 대체함수 적용
				#$text = eregi_replace($searchword, "<FONT color=$color>$searchword</FONT>", $text);		// 대소문자 무시함.
				$text = preg_replace("/".$searchword."/i", "<FONT color=$color>$searchword</FONT>", $text);		// 대소문자 무시함.
			}	// if()

			return $text;
		}	// function


	### [Form] input Value 채워넣기 -  ###
		// 2001/03/28/WED -차계부-
		// 값이 존재할때만 출력함. 큰따옴표로 인한 값 잘림방지

		function input_value($value, $return=0)
		{
			// [2015-04] PHP5.4.x대응 대체함수 적용
			#$value = ereg_replace(chr(34), "&#34;", $value);		// 큰따옴표(")일때 VALUE값이 잘리는것을 방지하기위해 아스키코드로 변경함.
			$value = preg_replace("/".chr(34)."/", "&#34;", $value);		// 큰따옴표(")일때 VALUE값이 잘리는것을 방지하기위해 아스키코드로 변경함.
			if($value != null) $value = "VALUE=\"$value\"";		// SUBMIT()후 에러가 나서 HISTORY.BACK()할때 value값을 사용자가 입력한채로 유지하기 위함.
			if ($return)
			{
				return($value);
			}else
			{
				echo($value);
			}	// if()
		}


	### [Form] Checkbox 채워넣기 및 선택하기 ###
		// 2001/05/29/TUE

		function checkbox_value($objName, $objCheckedArray, $objTextArray, $objValueArray, $objArrayUseNo)
		{
			$Gy_return;

			// Checkbox Add&Selected Process
				for ($i=$objArrayUseNo; $i<sizeof($objTextArray); $i++)
				{
					$isChecked = "N";
					for ($j=0; $j<sizeof($objCheckedArray); $j++)
					{
						if ($objValueArray[$i] == $objCheckedArray[$j])
						{
							$isChecked = "Y";
							break;
						}
					}	// for()

					// [2007-12-12]
					$objId = str_replace('[]', '', $objName)."_".$i;
					$Gy_return[$i] = '<INPUT TYPE=checkbox NAME="' . $objName . '" id="' . $objId . '" VALUE="' . $objValueArray[$i] . '"';
					if ( $isChecked == "Y" )		// 선택된 항목일경우 체크함
						$Gy_return[$i] .= ' checked';
					$Gy_return[$i] .= '><LABEL for=' . $objId . '>'.$objTextArray[$i].'</LABEL>';
				}	// for()

			return($Gy_return);

		}	// function()


	### [Form] Radio 단추 채워넣기 및 선택하기 ###
		// 2001/05/29/TUE

		function radio_value($objName, $objValue, $objTextArray, $objValueArray, $objDefaultNo, $objArrayUseNo, $return=0, $option=NULL, $is_htmlspecialchars=true)
		{

			// radio Add&Selected Process
				$value = NULL;
				for ($i=$objArrayUseNo; $i<sizeof($objTextArray); $i++)
				{
					if ( ( $objValueArray[$i] == $objValue ) || ( (string)$i == (string)$objDefaultNo ) )		// 선택된 항목일경우 체크함
					{
						$ischecked = true;
					} else {
						$ischecked = false;
					}	// if()

					// [2007-12-12]
					$objId = str_replace('[]', '', $objName)."_".$i;
					$value .= '<INPUT TYPE=radio class=inputbutton NAME="' . $objName . '" id="' . $objId . '" VALUE="' . $objValueArray[$i] . '"';
					if ($ischecked)
						$value .= ' checked';
					if ($is_htmlspecialchars)
					{
						$value .= '><LABEL for=' . $objId . '>'.htmlspecialchars_fix($objTextArray[$i]).'</LABEL>';
					} else
					{
						$value .= '><LABEL for=' . $objId . '>'.$objTextArray[$i].'</LABEL>';
					}	// if()
					$value .= ' ';
				}	// for()

			// return
				if ($return)
				{
					return($value);
				}else
				{
					echo($value);
				}	// if()

		}	// function()


	### [Form] SELECT Option 채워넣기 및 선택하기  ###
		//  Option Add&Selected (선택될 전달값, 객채의 문자열 배열, 객채의 전달값 배열, 객채의 첫번째 문자열[안내문구], 배열중 사용될 시작번호)

		function select_list_value ($objValue, $objTextArray, $objValueArray="ValueIsNumber", $objTextFirst="선택하세요", $objArrayUseNo=0, $return=0) {
			$value = "";

			// 배열시작번호가 없을경우 0
				if ( ! $objArrayUseNo ) $objArrayUseNo=0;

			// 안내문구가 있을때만 출력함.
				if ( $objTextFirst )
				{
					$value .= "\n<OPTION VALUE=\"\">$objTextFirst</OPTION>";
					$value .= "\n<OPTION VALUE=\"\">";		for ($i=0; $i<strlen($objTextFirst); $i++) {$value .= "-";}		$value .= "</OPTION>";
				}

			// 객채의 전달값 배열이 0부터시작되는 숫자일때 숫자배열 자동생성해줌.
				if ( $objValueArray == "ValueIsNumber" )
				{
					$objValueArray = "";
					for ($i=0; $i<sizeof($objTextArray); $i++)
					{
						$objValueArray[$i] = $i;
					}
				}

			// Option Add&Selected Process
				for ($i=$objArrayUseNo; $i<sizeof($objTextArray); $i++) {
					//if ( $objValueArray[$i] != $objValue ) {
					if ( strcmp($objValueArray[$i], $objValue) ) {		// 0, "" 과 null 값을 구분해냄.
						$value .= "\n<OPTION VALUE=\"" . htmlspecialchars_fix($objValueArray[$i]) . "\">$objTextArray[$i]</OPTION>";
					} else {
						$value .= "\n<OPTION VALUE=\"" . htmlspecialchars_fix($objValueArray[$i]) . "\" selected>$objTextArray[$i]</OPTION>";		// 선택된 항목일경우 체크함
					}
				}

			// view
				if ($return)
				{
					return($value);
				}else
				{
					echo($value);
				}	// if()

		}	// function()


	### [String] URL 자동링크 ###
		function auto_link($str)
		{
			return preg_replace("/(http|https|ftp|mms)(:\/\/[^ \n\r\t<>]+)/i", "<a href=\"\\1\\2\" target=\"_blank\">\\1\\2</a>", $str);
		}	// function()


	### [Tag] 특정 HTML 제거 - 화면깨짐방지 ###
		function del_tag($text) {
		  //$text = eregi_replace("<html(.*)<body([^>]*)>","",$text);
		  //$text = eregi_replace("</body(.*)</html>","",$text);
		  //$text = eregi_replace("<(\/)*(table|tr|td|body|html|head|meta|form|input|select|div|span|layer|textarea)[^>]*>","",$text);
		  //$text = eregi_replace("<(style|script|title)(.*)</(style|script|title)>","",$text);
		  //$text = eregi_replace("<[/]*(script|style|title)>","",$text);
		  //$text = preg_replace('/<!--(.*?)-->/is',"",$text);
		  //$text = preg_replace('/\/\*(.*?)\*\//is', '', $text);
		  $text = preg_replace("!<html(.*)<body([^>]*)>!is","",$text);
		  $text = preg_replace("!<\/body(.*)<\/html>!is","",$text);
		  $text = preg_replace("!<(\/)*(table|tr|td|body|html|head|meta|form|input|select|div|span|layer|textarea|link|base)[^>]*>!is","",$text);
		  $text = preg_replace("!<(style|script|title)(.*)<\/(style|script|title)>!is","",$text);
		  $text = preg_replace("!<\/*(script|style|title)>!is","",$text);
		  $text = trim($text);

		  return $text;
		}

?>